/* GSequencer - Advanced GTK Sequencer
 * Copyright (C) 2005-2025 Joël Krähemann
 *
 * This file is part of GSequencer.
 *
 * GSequencer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GSequencer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GSequencer.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __AGS_MODULAR_SYNTH_CALLBACKS_H__
#define __AGS_MODULAR_SYNTH_CALLBACKS_H__

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtk.h>

#include <ags/libags.h>
#include <ags/libags-audio.h>

#include <ags/libags-gui.h>

#include <ags/app/machine/ags_modular_synth.h>

G_BEGIN_DECLS

void ags_modular_synth_env_0_attack_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_env_0_decay_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_env_0_sustain_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_env_0_release_callback(AgsDial *dial, AgsModularSynth *modular_synth);

void ags_modular_synth_env_0_gain_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_env_0_frequency_callback(AgsDial *dial, AgsModularSynth *modular_synth);

void ags_modular_synth_env_1_attack_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_env_1_decay_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_env_1_sustain_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_env_1_release_callback(AgsDial *dial, AgsModularSynth *modular_synth);

void ags_modular_synth_env_1_gain_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_env_1_frequency_callback(AgsDial *dial, AgsModularSynth *modular_synth);

void ags_modular_synth_noise_frequency_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_noise_gain_callback(AgsDial *dial, AgsModularSynth *modular_synth);

void ags_modular_synth_lfo_0_oscillator_callback(GObject *gobject,
						 GParamSpec *pspec,
						 AgsModularSynth *modular_synth);

void ags_modular_synth_lfo_0_frequency_callback(GtkSpinButton *spin_button, AgsModularSynth *modular_synth);
void ags_modular_synth_lfo_0_depth_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_lfo_0_tuning_callback(AgsDial *dial, AgsModularSynth *modular_synth);

void ags_modular_synth_lfo_1_oscillator_callback(GObject *gobject,
						 GParamSpec *pspec,
						 AgsModularSynth *modular_synth);

void ags_modular_synth_lfo_1_frequency_callback(GtkSpinButton *spin_button, AgsModularSynth *modular_synth);
void ags_modular_synth_lfo_1_depth_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_lfo_1_tuning_callback(AgsDial *dial, AgsModularSynth *modular_synth);

void ags_modular_synth_modulation_matrix_callback(AgsModulationMatrix *modulation_matrix,
						  gint x, gint y,
						  AgsModularSynth *modular_synth);

void ags_modular_synth_osc_0_oscillator_callback(GObject *gobject,
						 GParamSpec *pspec,
						 AgsModularSynth *modular_synth);

void ags_modular_synth_osc_0_octave_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_osc_0_key_callback(AgsDial *dial, AgsModularSynth *modular_synth);

void ags_modular_synth_osc_0_phase_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_osc_0_volume_callback(AgsDial *dial, AgsModularSynth *modular_synth);

void ags_modular_synth_osc_1_oscillator_callback(GObject *gobject,
						 GParamSpec *pspec,
						 AgsModularSynth *modular_synth);

void ags_modular_synth_osc_1_octave_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_osc_1_key_callback(AgsDial *dial, AgsModularSynth *modular_synth);

void ags_modular_synth_osc_1_phase_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_osc_1_volume_callback(AgsDial *dial, AgsModularSynth *modular_synth);

void ags_modular_synth_pitch_tuning_callback(AgsDial *dial, AgsModularSynth *modular_synth);

void ags_modular_synth_volume_callback(AgsDial *dial, AgsModularSynth *modular_synth);

void ags_modular_synth_low_pass_0_cut_off_frequency_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_low_pass_0_filter_gain_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_low_pass_0_no_clip_callback(AgsDial *dial, AgsModularSynth *modular_synth);

void ags_modular_synth_amplifier_0_amp_0_gain_callback(GtkRange *range, AgsModularSynth *modular_synth);
void ags_modular_synth_amplifier_0_amp_1_gain_callback(GtkRange *range, AgsModularSynth *modular_synth);
void ags_modular_synth_amplifier_0_amp_2_gain_callback(GtkRange *range, AgsModularSynth *modular_synth);
void ags_modular_synth_amplifier_0_amp_3_gain_callback(GtkRange *range, AgsModularSynth *modular_synth);

void ags_modular_synth_amplifier_0_filter_gain_callback(GtkRange *range, AgsModularSynth *modular_synth);

void ags_modular_synth_chorus_enabled_callback(GtkButton *button, AgsModularSynth *modular_synth);

void ags_modular_synth_chorus_input_volume_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_chorus_output_volume_callback(AgsDial *dial, AgsModularSynth *modular_synth);

void ags_modular_synth_chorus_lfo_oscillator_callback(GObject *gobject,
						      GParamSpec *pspec,
						      AgsModularSynth *modular_synth);
void ags_modular_synth_chorus_lfo_frequency_callback(GtkSpinButton *spin_button, AgsModularSynth *modular_synth);

void ags_modular_synth_chorus_depth_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_chorus_mix_callback(AgsDial *dial, AgsModularSynth *modular_synth);
void ags_modular_synth_chorus_delay_callback(AgsDial *dial, AgsModularSynth *modular_synth);

G_END_DECLS

#endif /*__AGS_MODULAR_SYNTH_CALLBACKS_H__*/
