.TH pdfroff @MAN7EXT@ "@MDATE@" "groff-pdfmark @VERSION@"
.
.SH Name
pdfroff \- a macro for in-document control of pdfroff program features
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2024, Free Software Foundation, Inc.
.\"
.\" This file is part of groff-pdfmark, an independently maintained
.\" add-on for the GNU roff type-setting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, no Front-Cover Texts,
.\" and no Back-Cover Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called fdl-v1.3.txt, in the fdl directory of the groff-pdfmark
.\" source package, whence it is programmatically marked up, to be
.\" processed by groff -m pdfmark, for inclusion as an appendix to
.\" the pdfmark.pdf document.
.
.\" ====================================================================
.
.\" Save and disable compatibility mode (e.g., for Solaris 10/11).
.nr _? \n(.C
.do rnn _? *pdfroff_7_man_C
.cp 0
.
.\" ====================================================================
.\" Local macro definitions
.\" ====================================================================
.
.\" @IMPORT_LOCAL_FALLBACK_MACROS@
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.P
.B \%pdfroff
is a wrapper program for the GNU text processing system,
.MR groff @MAN1EXT@ ;
its operation is supported by an accompanying macro,
also named
.BR \%pdfroff ,
which provides capabilities for manipulation of a number of the
.MR pdfroff @MAN1EXT@
program's feature control options,
from within
.MR groff @MAN7EXT@
document source.
.
.P
The
.MR pdfroff @MAN1EXT@
program is designed to facilitate the publication of PDF documents,
and incorporates features which offer specific support for
the use of special PDF \%mark-up attributes.
For documentation of the
.B \%pdfroff
program, see
.MR pdfroff @MAN1EXT@ ;
the remainder of this manual page documents the use of the
.B \%pdfroff
macro.
.
.
.\" ====================================================================
.SH Usage
.\" ====================================================================
.
.P
The
.MR pdfroff @MAN1EXT@
program requests loading of the
.B \%pdfroff
macro,
from its macro library file,
when it runs each of its
.MR groff @MAN1EXT@
processing passes;
thus,
provided the program,
and its requisite macro files,
have been correctly installed,
no specific user action is necessary,
to make the macro available for use.
.
On the other hand, the
.B \%pdfroff
macro is not intended to be loaded,
.I unless
requested by the
.MR pdfroff @MAN1EXT@
program;
thus,
testing for an available definition of the
.B \%pdfroff
macro is an effective method of confirming that
a given document is being processed by the
.MR pdfroff @MAN1EXT@
program.
.
.P
In addition to supporting the majority of
.MR groff @MAN1EXT@
options\|\(em\|which are simply passed on to
.MR groff @MAN1EXT@
itself\|\(em\|the
.MR pdfroff @MAN1EXT@
program also supports a number of extra options,
each of which is specific to the control of its own operation.
Although any of these
.MR pdfroff @MAN1EXT@
specific options may be specified on the command line,
it may often be convenient to specify some of them
from within the document source;
this may be achieved by using the
.B \%pdfroff
macro:
.RS 3n
.SY .pdfroff\ option
.RI \%< equivalent-variable-name >[=< option-setting >]
.YS
.RE
.P
As currently implemented,
this macro supports control of only a few of the
.MR pdfroff @MAN1EXT@
optional features.
Those which
.I are
supported are limited to:
.RS 3n
.SY .pdfroff\ option\ preserve_blank_pages\c
.RI [= all \^|\^ toc \^|\^ body ]
.SY .pdfroff\ option\ toc_relocation\c
.RI [= auto \^|\^ disabled \^|\^ enabled ]
.SY .pdfroff\ option\ toc_file\c
.RI =<\h'-\w"\^"u' file-name >
.YS
.RE
.P
The first of these is a direct analogue of the
.MR pdfroff @MAN1EXT@
.RS 3n
.SY \-\-no\-kill\-null\-pages\c
.RI [= all \^|\^ toc \^|\^ body ]
.YS
.RE
.P
command line option,
which may be found useful to modify the default
behaviour of removing
.I all
entirely blank pages from the document output stream;
when preparing the document for printing
on a duplex-capable device,
it may be desireable to retain such pages,
particularly within the document's
.I \%body
context.
.
.P
The other forms of
.B \%pdfroff
macro usage relate to table of contents collation;
the form:
.RS 3n
.SY .pdfroff\ option\ toc_relocation=auto
.YS
.RE
.P
is a reflection of the default
.MR pdfroff @MAN1EXT@
initial state,
with respect to the pending operation of 
the traditional \(lqprint-at-end and collate manually\(rq technique.
.
In early (now obsolete) versions of
.MR pdfroff @MAN1EXT@
this initial default state was equivalent to:
.RS 3n
.SY .pdfroff\ option\ toc_relocation=enabled
.YS
.RE
.P
and it needed to be disabled,
by invoking
.MR pdfroff @MAN1EXT@
with its
.B \%\-\-no\-toc\-relocation
command line option,
when formatting documents which were not specifically
engineered to make use of this collation technique.
.
More recent (current) versions of
.MR pdfroff @MAN1EXT@
now start in an initial default state which is equivalent to:
.RS 3n
.SY .pdfroff\ option\ toc_relocation=disabled
.YS
.RE
.P
which is analogous to the state established by the
.B \%\-\-no\-toc\-relocation
option,
(thus making this option effectively redundant).
The
.B \%enabled
state
.I must
now be requested,
.IR explicitly ,
for any document wishing to avail itself of the
.MR pdfroff @MAN1EXT@
emulation of the \(lqprint-at-end and collate manually\(rq technique;
the designation of the initial
.B \%disabled
state as
.B \%auto
is indicative that the enabling request:
'ne 3v
.RS 3n
.SY .pdfroff\ option\ toc_relocation=enabled
.YS
.RE
.P
is expected to originate in some macro,
(possibly itself originating in a standardized package),
which is associated with this collation technique.
.
.P
Also associated with collation of tables of contents,
but intended to facilitate the implementation of
a\|\(em\|potentially more effective\|\(em\|alternative to the default
.MR pdfroff @MAN1EXT@
\(lqprint-at-end\(rq collation technique,
a request in the form:
.RS 3n
.SY .pdfroff\ option\ toc_file=\c
.RI <\h'-\w"\^"u' file-name >
.YS
.RE
.P
instructs
.MR pdfroff @MAN1EXT@
to filter all single-line records of the form:
.P
.RS 3n
.I .toc anything .\|.\|.
.RE
.P
from its standard error data stream,
and to write copies of these collected records into the named file;
this may then be included within the
.MR groff @MAN7EXT@
document input data stream,
(using the
.I .so
request, for example),
whence its content may be interpreted as a sequence of macro calls,
to lay out a table of contents,
at the point where the file is included.
.
.P
The content of the named
.IR \%toc \h'-\w"\^"u'_ file
may be written by inserting
.B .tm
requests, at appropriate points within the
document source, in the form:
.P
.RS 3n
.B .tm .toc
.I record content .\|.\|.
.RE
.P
In this case,
the record
.I must
begin with the
.B \%.toc
request keyword, but the remainder of the
.RI \(lq record\ content\ .\|.\|. \(rq
is at the discretion of the document author,
who must also assume responsibility for defining the
.B \%.toc
macro, which will subsequently interpret that record content,
when it is read back from the document source input stream.
.
.P
Alternatively,
the document author may elect to adopt a macro package,
such as a derivative of the
.MR groff_toc @MAN7EXT@
framework,
both to write the content of the named
.IR \%toc \h'-\w"\^"u'_ file ,
and to interpret that content,
when it is read back,
(although it may still be necessary to write additional macros,
to facilitate the interpretation);
in this case,
the form of the content will be dictated by
the chosen macro implementation.
.
.
.\" ====================================================================
.SH Control Registers
.\" ====================================================================
.
.P
While processing any
.MR groff @MAN7EXT@
input data stream,
.MR pdfroff @MAN1EXT@
initializes a register named
.BR \%PHASE ,
and passes it to each invocation of
.MR groff @MAN1EXT@
which it initiates;
the particular value passed to each invocation
depends on the particular phase of
.MR pdfroff @MAN1EXT@
processing in which the invocation occurs:
.
.RS 2n
.ll -2n
.IP 0. 3n
.MR pdfroff @MAN1EXT@
is analysing the document layout,
compiling a reference dictionary,
and optionally,
collecting table of contents records; the
.B \%pdfroff
macro will produce output
.I only
when the
.B \%PHASE
register is in this state,
(or is undefined).
.
.IP 1. 3n
.MR pdfroff @MAN1EXT@
is compiling a table of contents section,
emulating the \(lqprint-at-end with manual collation\(rq technique,
for eventual inclusion in the finished document.
.
.IP 2. 3n
.MR pdfroff @MAN1EXT@
is formatting the body of the document,
which will ultimately be combined with any front-matter,
which may have been compiled as directed by the
.B \%\-\-stylesheet
option, and with any separately compiled table of contents,
to produce the finished document.
.ll +2n
.RE
.
.P
When running
.MR pdfroff @MAN1EXT@ ,
the definition of the
.B \%pdfroff
macro is accompanied by
.I \%two
mnemonic register definitions, namely
.BR \%PDF-TOC-ONLY ,
and
.BR \%PDF-BODY-ONLY .
These may used in any context where a mnemonic representation of the
.B \%PHASE
value for phases 1, and 2 respectively, is desired;
each of these, together with the
.B \%PHASE
register itself,
should be considered to be
.IR "constant valued" .
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP 3n
.I @SITE_TMACDIR@/pdfroff.tmac
This implements the
.B \%pdfroff
macro,
and defines the mnemonic registers,
.BR \%PDF-TOC-ONLY ,
and
.BR \%PDF-BODY-ONLY ;
it is loaded
.IR automatically ,
when
.MR pdfroff @MAN1EXT@
invokes
.MR groff @MAN1EXT@ .
.
.
.\" ====================================================================
.SH Caveats and Bugs
.\" ====================================================================
.
.P
The
.B \%pdfroff
macro is an experimental feature,
which was introduced in the
.I \%20030406.1
release of
.IR \%groff-pdfmark ;
it is
.I not
supported in any version of
.MR pdfroff @MAN1EXT@
from any earlier release,
(including the obsolete version which continues to be
distributed by the GNU Troff project).
.
.P
.ne 2v
Only a few of the
.MR pdfroff @MAN1EXT@
command line options may be controlled using the
.B \%pdfroff
macro;
the subset for which this is possible is limited
to those described in the
.SR 1 \%Usage
section, above.
.
.P
There is (currently) no
.MR pdfroff @MAN1EXT@
command line equivalent for the macro assignment:
.P
.RS 3n
.IR \%.pdfroff\ option\ toc_ \& file =<\h'-\w"\^"u' file-name >
.RE
.P
consequently, if such an assignment is required, it may
.I only
be assigned by use of the
.B \%pdfroff
macro.
.
.P
Only minimal validation of
.B \%pdfroff
macro arguments is performed.
A warning diagnostic will be issued,
if the first argument is not a valid keyword,
(with only
.B \%option
being considered as valid, at present).
Beyond this,
any arbitrary text will be accepted for the
.RI \%< equivalent-variable-name >
and its associated
.RI \%< option-setting >
arguments; however,
the assignment will be silently ignored,
if the
.RI \%< equivalent-variable-name >
does not match one of those documented in the
.SR 1 \%Usage
section,
while the behaviour will be undefined if the
.RI \%< equivalent-variable-name >
does match one of those documented,
but the associated
.RI \%< option-setting >
does not match any of the expected values.
.
.P
Although it is stipulated above, in the
.SR 1 "Control\ Registers"
section,
that each of the
.BR \%PHASE ,
.BR \%PDF-TOC-ONLY ,
and
.BR \%PDF-BODY-ONLY
registers should be considered to be
.IR "constant valued" ,
the
.MR groff @MAN7EXT@
language provides no mechanism to enforce this;
consequently, users are cautioned that they should
avoid changing the value of any of these registers,
as the effect of doing so may result in undefined behaviour.
.
.
.\" ====================================================================
.SH Examples
.\" ====================================================================
.
To verify that a particular document is being processed by
.MR pdfroff @MAN1EXT@ :
.P
.RS 3n
.EX
\&.if !d pdfroff \(rs
\&.   ab "Please use pdfroff to format this document."
.EE
.RE
.P
To maintain correct recto/verso pagination,
by insertion of, and non-removal of entirely blank pages,
when printing hard-copy using both sides of the paper,
(i.e.\& duplex printing),
follow the preceding verification check with:
.P
.RS 3n
.EX
\&.if duplex .pdfroff option preserve_blank_pages=all
.EE
.RE
.P
and specify
.I \%\-duplex
as a command line option,
when invoking
.MR pdfroff @MAN1EXT@ .
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
The
.B \%pdfroff
macros are provided by the
.I \%groff-pdfmark
package,
which was written by
.MT @AUTHOR_MT_ADDRESS@
Keith\ Marshall
.ME ;
it is independently maintained at
.UR @PROJECT_HOSTING_SITE@
Keith's
.I \%groff-pdfmark
project hosting \%web-site
.UE ,
whence the latest version may
.I always
be obtained.
.
.
.\" ====================================================================
.SH See Also
.\" ====================================================================
.
.\" @ENUMERATE_MR_REFERENCES@
.
.P
More comprehensive documentation,
on the use of
.BR \%pdfroff ,
and the
.I \%groff-pdfmark
macro suite may be found,
in PDF format,
in the reference guide
.RI \[lq] "Portable Document Format Publishing with GNU Troff" \[rq],
which has also been written by Keith Marshall;
the most recently published version of this guide may be read online,
by following the appropriate document reference link on
.UR @PROJECT_HOSTING_SITE@
the
.I \%groff-pdfmark
project hosting \%web-site
.UE ,
whence a copy may also be downloaded.
.
.\" ====================================================================
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*pdfroff_7_man_C]
.do rr *pdfroff_7_man_C
.
.\" ====================================================================
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
