/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock.normalizer.processor;

import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.datablock.normalizer.processor.AbstractProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RedundantDataBlocksProcessor
extends AbstractProcessor<DataBlock> {
    private static final boolean DEBUG = false;
    private Map<String, ProcessBlockType> typeMap = new HashMap<String, ProcessBlockType>();

    @Override
    public void preprocess(DataBlock block) {
        if (!(block instanceof DataBlock)) {
            return;
        }
        String type = this.getType(block);
        if (!this.typeMap.containsKey(type)) {
            this.typeMap.put(type, new ProcessBlockType());
        }
        this.typeMap.get(type).preprocess(block);
    }

    private String getType(DataBlock block) {
        return block.getClass().getSimpleName();
    }

    @Override
    void preprocessFinished() {
        int countAll = 0;
        int redundantAll = 0;
        for (Map.Entry<String, ProcessBlockType> entry : this.typeMap.entrySet()) {
            String type = entry.getKey();
            ProcessBlockType blockType = entry.getValue();
            countAll += blockType.getCount();
            redundantAll += blockType.getNumberOfRedundantBlocks();
            this.printRedundantBlocks(type, blockType.getCount(), blockType.getNumberOfRedundantBlocks());
        }
        this.printRedundantBlocks("TOTAL", countAll, redundantAll);
    }

    private void printRedundantBlocks(String type, int totalBlocks, int redundantBlocks) {
    }

    @Override
    public boolean isBad(DataBlock block) {
        String type = this.getType(block);
        if (!this.typeMap.containsKey(type)) {
            return false;
        }
        return this.typeMap.get(type).isRedundantBlock(block);
    }

    @Override
    public Class<? extends DataBlock> getClassOfDataBlock() {
        return DataBlock.class;
    }

    private class ProcessBlockType {
        private DataBlock lastBlock;
        private boolean lastStateEquals;
        private List<DataBlock> redundantBlocks = new ArrayList<DataBlock>();
        private int count = 0;
        private int currentPos = 0;

        private ProcessBlockType() {
        }

        public void preprocess(DataBlock block) {
            ++this.count;
            if (this.lastBlock != null) {
                boolean currentStateEquals = block.areValuesEquals(this.lastBlock);
                if (currentStateEquals && this.lastStateEquals) {
                    this.redundantBlocks.add(this.lastBlock);
                }
                this.lastStateEquals = currentStateEquals;
            }
            this.lastBlock = block;
        }

        public int getCount() {
            return this.count;
        }

        public int getNumberOfRedundantBlocks() {
            return this.redundantBlocks.size();
        }

        /*
         * Unable to fully structure code
         */
        public boolean isRedundantBlock(DataBlock block) {
            if (this.currentPos < this.redundantBlocks.size()) ** GOTO lbl6
            return false;
lbl-1000:
            // 1 sources

            {
                ++this.currentPos;
                if (this.currentPos < this.redundantBlocks.size()) continue;
                return false;
lbl6:
                // 2 sources

                ** while (this.redundantBlocks.get((int)this.currentPos).getSequence() < block.getSequence())
            }
lbl7:
            // 1 sources

            return this.redundantBlocks.get(this.currentPos).getSequence() == block.getSequence();
        }
    }
}

