/*
 * Decompiled with CFR 0.152.
 */
package gde.io;

import com.google.gson.Gson;
import gde.device.CheckSumTypes;
import gde.device.FormatTypes;
import gde.exception.DevicePropertiesInconsistenceException;
import gde.io.DataParser;
import gde.io.IDataParser;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class JsonDataParser
extends DataParser
implements IDataParser {
    public static void main(String[] args) {
        String jsonLine = "{\"dsn\":1,\"st\":2,\"tm\":1000,\"data\":[1000,1001,1002,1003,1004,1005,1006,1007],\"crc\":0}";
        ArrayList<Integer> measurements = new ArrayList<Integer>(8);
        int val = 1000;
        for (int i = 0; i < 8; ++i) {
            measurements.add(val++);
        }
        Data data = new Data(1, 2, 1000L, measurements, 0);
        System.out.println(new Gson().toJson((Object)data, Data.class));
        Data jsonData = (Data)new Gson().fromJson(jsonLine, Data.class);
        System.out.println(jsonData);
    }

    public JsonDataParser(int useTimeFactor, String useLeaderChar, String useSeparator, CheckSumTypes useCheckSumType, int useDataSize) {
        super(useTimeFactor, useLeaderChar, useSeparator, useCheckSumType, useDataSize);
        log.log(Level.FINE, useTimeFactor + ", " + useLeaderChar + ", " + useSeparator + ", " + String.valueOf((Object)useCheckSumType) + ", " + useDataSize + ", " + this.isMultiply1000);
    }

    @Override
    public void parse(String jsonLine, int lineNum) throws DevicePropertiesInconsistenceException, Exception {
        Data jsonData = (Data)new Gson().fromJson(jsonLine, Data.class);
        String[] strValues = jsonData.toStringArray();
        this.valueSize = this.dataFormatType != null && this.dataFormatType == FormatTypes.BINARY ? strValues.length - 4 : (this.dataFormatType != null && this.dataFormatType == FormatTypes.VALUE && this.dataBlockSize != 0 ? (Math.abs(this.dataBlockSize) > this.device.getNumberOfMeasurements(this.channelConfigNumber) ? this.device.getNumberOfMeasurements(this.channelConfigNumber) : Math.abs(this.dataBlockSize)) : strValues.length - 4);
        this.parse(jsonLine, strValues);
    }

    public static class Data {
        int dsn;
        int st;
        long tm;
        List<Integer> data;
        byte crc;

        Data(int dsn, int st, long t, ArrayList<Integer> l, byte q) {
            this.setDataSetNumber(dsn);
            this.setState(st);
            this.setTime(t);
            this.setMeasurements(l);
            this.setChecksum(q);
        }

        public String toString() {
            return "Data [dsn=" + this.dsn + ", st=" + this.st + ", tm=" + this.tm + ", data=" + String.valueOf(this.data) + ", crc=" + this.crc + "]";
        }

        public String[] toStringArray() {
            ArrayList<CallSite> strArray = new ArrayList<CallSite>();
            strArray.add((CallSite)((Object)("$" + this.dsn)));
            strArray.add((CallSite)((Object)("" + this.st)));
            strArray.add((CallSite)((Object)("" + this.tm)));
            for (int i : this.data) {
                strArray.add((CallSite)((Object)("" + i)));
            }
            strArray.add((CallSite)((Object)("" + this.crc)));
            return strArray.toArray(new String[0]);
        }

        public int getDataSetNumber() {
            return this.dsn;
        }

        public void setDataSetNumber(int dataSetNumber) {
            this.dsn = dataSetNumber;
        }

        public int getState() {
            return this.st;
        }

        public void setState(int state) {
            this.st = state;
        }

        public long getTime() {
            return this.tm;
        }

        public void setTime(long time) {
            this.tm = time;
        }

        public List<Integer> getMeasurements() {
            return this.data;
        }

        public void setMeasurements(List<Integer> measurements) {
            this.data = measurements;
        }

        public byte getChecksum() {
            return this.crc;
        }

        public void setChecksum(byte checksum) {
            this.crc = checksum;
        }
    }
}

