/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.qrcode;

import com.itextpdf.text.pdf.qrcode.GF256;
import com.itextpdf.text.pdf.qrcode.GF256Poly;
import java.util.ArrayList;

public final class ReedSolomonEncoder {
    private final GF256 field;
    private final ArrayList<GF256Poly> cachedGenerators;

    public ReedSolomonEncoder(GF256 field2) {
        if (!GF256.QR_CODE_FIELD.equals(field2)) {
            throw new IllegalArgumentException("Only QR Code is supported at this time");
        }
        this.field = field2;
        this.cachedGenerators = new ArrayList();
        this.cachedGenerators.add(new GF256Poly(field2, new int[]{1}));
    }

    private GF256Poly buildGenerator(int degree) {
        if (degree >= this.cachedGenerators.size()) {
            GF256Poly lastGenerator = this.cachedGenerators.get(this.cachedGenerators.size() - 1);
            for (int d2 = this.cachedGenerators.size(); d2 <= degree; ++d2) {
                GF256Poly nextGenerator = lastGenerator.multiply(new GF256Poly(this.field, new int[]{1, this.field.exp(d2 - 1)}));
                this.cachedGenerators.add(nextGenerator);
                lastGenerator = nextGenerator;
            }
        }
        return this.cachedGenerators.get(degree);
    }

    public void encode(int[] toEncode, int ecBytes) {
        if (ecBytes == 0) {
            throw new IllegalArgumentException("No error correction bytes");
        }
        int dataBytes = toEncode.length - ecBytes;
        if (dataBytes <= 0) {
            throw new IllegalArgumentException("No data bytes provided");
        }
        GF256Poly generator = this.buildGenerator(ecBytes);
        int[] infoCoefficients = new int[dataBytes];
        System.arraycopy(toEncode, 0, infoCoefficients, 0, dataBytes);
        GF256Poly info = new GF256Poly(this.field, infoCoefficients);
        info = info.multiplyByMonomial(ecBytes, 1);
        GF256Poly remainder = info.divide(generator)[1];
        int[] coefficients = remainder.getCoefficients();
        int numZeroCoefficients = ecBytes - coefficients.length;
        for (int i2 = 0; i2 < numZeroCoefficients; ++i2) {
            toEncode[dataBytes + i2] = 0;
        }
        System.arraycopy(coefficients, 0, toEncode, dataBytes + numZeroCoefficients, coefficients.length);
    }
}

