/*
 * Decompiled with CFR 0.152.
 */
package gde.device.elprog;

import gde.comm.DeviceCommPort;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.ui.DataExplorer;
import java.io.IOException;
import java.util.logging.Logger;

public class PulsarSerialPort
extends DeviceCommPort {
    static final String $CLASS_NAME = PulsarSerialPort.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    final byte startByte;
    final byte endByte;
    final byte endByte_1;
    final byte[] tmpByte = new byte[1];
    final int timeout;
    final int stableIndex;
    final int tmpDataLength;
    byte[] answer;
    byte[] tmpData;
    byte[] data = new byte[]{0};
    long time = 0L;
    int index = 0;
    boolean isEndByte_1 = false;

    public PulsarSerialPort(IDevice currentDevice, DataExplorer currentApplication) {
        super(currentDevice, currentApplication);
        this.startByte = (byte)this.device.getDataBlockLeader().charAt(0);
        this.endByte = this.device.getDataBlockEnding()[this.device.getDataBlockEnding().length - 1];
        this.endByte_1 = this.device.getDataBlockEnding().length == 2 ? this.device.getDataBlockEnding()[0] : (byte)0;
        this.tmpDataLength = Math.abs(this.device.getDataBlockSize(InputTypes.SERIAL_IO));
        this.timeout = this.device.getDeviceConfiguration().getReadTimeOut();
        this.stableIndex = this.device.getDeviceConfiguration().getReadStableIndex();
        this.tmpData = new byte[0];
    }

    public PulsarSerialPort(DeviceConfiguration deviceConfiguration) {
        super(deviceConfiguration);
        this.startByte = (byte)this.device.getDataBlockLeader().charAt(0);
        this.endByte = this.device.getDataBlockEnding()[this.device.getDataBlockEnding().length - 1];
        this.endByte_1 = this.device.getDataBlockEnding().length == 2 ? this.device.getDataBlockEnding()[0] : (byte)0;
        this.tmpDataLength = Math.abs(this.device.getDataBlockSize(InputTypes.SERIAL_IO));
        this.timeout = this.device.getDeviceConfiguration().getReadTimeOut();
        this.stableIndex = this.device.getDeviceConfiguration().getReadStableIndex();
        this.tmpData = new byte[0];
    }

    public synchronized byte[] getData() throws Exception {
        String $METHOD_NAME = "getData";
        this.index = 0;
        try {
            this.answer = new byte[this.tmpDataLength];
            this.answer = this.read(this.answer, this.timeout, this.stableIndex);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, new String(this.answer));
            }
        }
        catch (Exception e) {
            if (!(e instanceof TimeOutException)) {
                log.logp(Level.SEVERE, $CLASS_NAME, "getData", e.getMessage(), e);
            }
            throw e;
        }
        return this.answer;
    }

    protected byte[] findDataEnd(int startIndex) throws IOException, TimeOutException {
        String $METHOD_NAME = "findDataEnd";
        int endIndex = 0;
        while (this.index < this.answer.length && (this.endByte_1 == 0 && this.answer[this.index - 1] != this.endByte_1 && !this.isEndByte_1 || this.answer[this.index] != this.endByte)) {
            ++this.index;
        }
        if (this.endByte_1 != 0 || this.answer[this.index - 1] == this.endByte_1) {
            this.isEndByte_1 = true;
        }
        if (this.index < this.answer.length && this.tmpData.length + this.index - startIndex > 8) {
            endIndex = this.index;
            this.isEndByte_1 = false;
            this.data = new byte[this.tmpData.length + endIndex - startIndex];
            System.arraycopy(this.tmpData, 0, this.data, 0, this.tmpData.length);
            System.arraycopy(this.answer, startIndex, this.data, this.tmpData.length, endIndex - startIndex);
            if (log.isLoggable(Level.FINE)) {
                StringBuilder sb = new StringBuilder();
                for (byte b : this.data) {
                    sb.append((char)b);
                }
                while (sb.length() > 5 && (sb.charAt(sb.length() - 1) == '\n' || sb.charAt(sb.length() - 1) == '\r')) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                if (log.isLoggable(Level.FINER)) {
                    log.logp(Level.FINER, $CLASS_NAME, "findDataEnd", sb.toString());
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "1" + new String(this.data));
            }
            return this.data;
        }
        this.data = new byte[this.tmpData.length];
        System.arraycopy(this.tmpData, 0, this.data, 0, this.data.length);
        this.tmpData = new byte[this.answer.length - startIndex + this.data.length];
        System.arraycopy(this.data, 0, this.tmpData, 0, this.data.length);
        System.arraycopy(this.answer, startIndex, this.tmpData, this.data.length, this.answer.length - startIndex);
        this.readNewData();
        this.index = 0;
        this.findDataEnd(0);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "2" + new String(this.data));
        }
        return this.data;
    }

    protected void readNewData() throws IOException, TimeOutException {
        this.answer = new byte[this.tmpDataLength];
        this.answer = this.read(this.answer, this.timeout, this.stableIndex);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, new String(this.answer));
        }
    }

    protected int getArrayLengthByCheckEnding() {
        int lenght;
        for (lenght = this.tmpData.length; lenght > 0 && (this.endByte_1 == 0 && this.tmpData[lenght - 2] != this.endByte_1 || this.tmpData[lenght - 1] != this.endByte); --lenght) {
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, $CLASS_NAME, "getArrayLengthByCheckEnding", "array length = " + lenght);
        }
        return lenght;
    }
}

