/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.IFileDialog;
import org.eclipse.swt.internal.ole.win32.IShellItem;
import org.eclipse.swt.internal.win32.BROWSEINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";
    String directoryPath;

    public DirectoryDialog(Shell parent) {
        this(parent, 65536);
    }

    public DirectoryDialog(Shell parent, int style) {
        super(parent, DirectoryDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    long BrowseCallbackProc(long hwnd, long uMsg, long lParam, long lpData) {
        switch ((int)uMsg) {
            case 1: {
                TCHAR buffer;
                if (this.filterPath != null && this.filterPath.length() != 0) {
                    buffer = new TCHAR(0, this.filterPath.replace('/', '\\'), true);
                    OS.SendMessage(hwnd, 1127, 1L, buffer);
                }
                if (this.title == null || this.title.length() == 0) break;
                buffer = new TCHAR(0, this.title, true);
                OS.SetWindowText(hwnd, buffer);
                break;
            }
            case 4: {
                int length = OS.wcslen(lParam);
                TCHAR buffer = new TCHAR(0, length);
                int byteCount = buffer.length() * 2;
                OS.MoveMemory(buffer, lParam, byteCount);
                this.directoryPath = buffer.toString(0, length);
            }
        }
        return 0L;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        if (OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            return this.openCommonItemDialog();
        }
        return this.openCommonFileDialog();
    }

    private String openCommonFileDialog() {
        long[] ppMalloc;
        TCHAR buffer;
        boolean success;
        Callback callback;
        long lpfn;
        long hHeap = OS.GetProcessHeap();
        long hwndOwner = 0L;
        if (this.parent != null) {
            hwndOwner = this.parent.handle;
        }
        long lpszTitle = 0L;
        if (this.message.length() != 0) {
            String string2 = this.message;
            if (string2.indexOf(38) != -1) {
                int length = string2.length();
                char[] buffer2 = new char[length * 2];
                int index = 0;
                int i2 = 0;
                while (i2 < length) {
                    char ch = string2.charAt(i2);
                    if (ch == '&') {
                        buffer2[index++] = 38;
                    }
                    buffer2[index++] = ch;
                    ++i2;
                }
                string2 = new String(buffer2, 0, index);
            }
            TCHAR buffer3 = new TCHAR(0, string2, true);
            int byteCount = buffer3.length() * 2;
            lpszTitle = OS.HeapAlloc(hHeap, 8, byteCount);
            OS.MoveMemory(lpszTitle, buffer3, byteCount);
        }
        if ((lpfn = (callback = new Callback(this, "BrowseCallbackProc", 4)).getAddress()) == 0L) {
            this.error(3);
        }
        Dialog oldModal = null;
        Display display = this.parent.getDisplay();
        if ((this.style & 0x30000) != 0) {
            oldModal = display.getModalDialog();
            display.setModalDialog(this);
        }
        this.directoryPath = null;
        BROWSEINFO lpbi = new BROWSEINFO();
        lpbi.hwndOwner = hwndOwner;
        lpbi.lpszTitle = lpszTitle;
        lpbi.ulFlags = 113;
        lpbi.lpfn = lpfn;
        int oldErrorMode = OS.SetErrorMode(1);
        display.sendPreExternalEventDispatchEvent();
        long lpItemIdList = OS.SHBrowseForFolder(lpbi);
        display.sendPostExternalEventDispatchEvent();
        OS.SetErrorMode(oldErrorMode);
        if ((this.style & 0x30000) != 0) {
            display.setModalDialog(oldModal);
        }
        boolean bl = success = lpItemIdList != 0L;
        if (success && OS.SHGetPathFromIDList(lpItemIdList, buffer = new TCHAR(0, 260))) {
            this.filterPath = this.directoryPath = buffer.toString(0, buffer.strlen());
        }
        callback.dispose();
        if (lpszTitle != 0L) {
            OS.HeapFree(hHeap, 0, lpszTitle);
        }
        if (OS.SHGetMalloc(ppMalloc = new long[1]) == 0) {
            COM.VtblCall(5, ppMalloc[0], lpItemIdList);
        }
        if (!success) {
            return null;
        }
        return this.directoryPath;
    }

    private String openCommonItemDialog() {
        this.directoryPath = null;
        long[] ppv = new long[1];
        if (COM.CoCreateInstance(COM.CLSID_FileOpenDialog, 0L, 1, COM.IID_IFileOpenDialog, ppv) == 0) {
            long hwndOwner;
            IShellItem psi;
            IFileDialog fileDialog = new IFileDialog(ppv[0]);
            int[] options = new int[1];
            if (fileDialog.GetOptions(options) == 0) {
                options[0] = options[0] | 0x68;
                fileDialog.SetOptions(options[0]);
            }
            if (this.title == null) {
                this.title = "";
            }
            if (this.title.length() > 0) {
                char[] buffer = new char[this.title.length() + 1];
                this.title.getChars(0, this.title.length(), buffer, 0);
                fileDialog.SetTitle(buffer);
            }
            if (this.filterPath != null && this.filterPath.length() > 0) {
                String path2 = this.filterPath.replace('/', '\\');
                char[] buffer = new char[path2.length() + 1];
                path2.getChars(0, path2.length(), buffer, 0);
                if (COM.SHCreateItemFromParsingName(buffer, 0L, COM.IID_IShellItem, ppv) == 0) {
                    psi = new IShellItem(ppv[0]);
                    fileDialog.ClearClientData();
                    fileDialog.SetDefaultFolder(psi);
                    psi.Release();
                }
            }
            if (fileDialog.Show(hwndOwner = this.parent.handle) == 0 && fileDialog.GetResult(ppv) == 0) {
                psi = new IShellItem(ppv[0]);
                if (psi.GetDisplayName(-2147123200, ppv) == 0) {
                    long wstr = ppv[0];
                    int length = OS.wcslen(wstr);
                    char[] buffer = new char[length];
                    OS.MoveMemory(buffer, wstr, length * 2);
                    OS.CoTaskMemFree(wstr);
                    this.directoryPath = new String(buffer);
                }
                psi.Release();
            }
            fileDialog.Release();
        }
        return this.directoryPath;
    }

    public void setFilterPath(String string2) {
        this.filterPath = string2;
    }

    public void setMessage(String string2) {
        if (string2 == null) {
            this.error(4);
        }
        this.message = string2;
    }
}

