// Dezyne --- Dezyne command line tools
//
// Copyright © 2024 Rutger van Beusekom <rutger@dezyne.org>
//
// This file is part of Dezyne.
//
// Dezyne is free software: you can redistribute it and/or modify it
// under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// Dezyne is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public
// License along with Dezyne.  If not, see <http://www.gnu.org/licenses/>.
//
// Commentary:
//
// Code:

#include "foreign_trivial_proxied.hh"

#include <dzn/pump.hh>

struct foreign_timer: public skel::foreign_timer
{
  dzn::pump& pump;
  foreign_timer (dzn::locator const& l)
    : skel::foreign_timer (l)
    , pump (l.get<dzn::pump>())
  {
    std::cout << "foreign_timer " << this << std::endl;
  }
  void timer_set ()
  {
    pump.handle (reinterpret_cast<size_t>(this), 0, timer.out.timeout);
  }
};
