/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.commons.math3.util.Combinations;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CombinatoricsUtils {
    static final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    static final AtomicReference<long[][]> STIRLING_S2 = new AtomicReference<Object>(null);

    private CombinatoricsUtils() {
    }

    public static long binomialCoefficient(int n2, int k2) throws NotPositiveException, NumberIsTooLargeException, MathArithmeticException {
        CombinatoricsUtils.checkBinomial(n2, k2);
        if (n2 == k2 || k2 == 0) {
            return 1L;
        }
        if (k2 == 1 || k2 == n2 - 1) {
            return n2;
        }
        if (k2 > n2 / 2) {
            return CombinatoricsUtils.binomialCoefficient(n2, n2 - k2);
        }
        long result2 = 1L;
        if (n2 <= 61) {
            int i2 = n2 - k2 + 1;
            for (int j2 = 1; j2 <= k2; ++j2) {
                result2 = result2 * (long)i2 / (long)j2;
                ++i2;
            }
        } else if (n2 <= 66) {
            int i3 = n2 - k2 + 1;
            for (int j3 = 1; j3 <= k2; ++j3) {
                long d2 = ArithmeticUtils.gcd(i3, j3);
                result2 = result2 / ((long)j3 / d2) * ((long)i3 / d2);
                ++i3;
            }
        } else {
            int i4 = n2 - k2 + 1;
            for (int j4 = 1; j4 <= k2; ++j4) {
                long d3 = ArithmeticUtils.gcd(i4, j4);
                result2 = ArithmeticUtils.mulAndCheck(result2 / ((long)j4 / d3), (long)i4 / d3);
                ++i4;
            }
        }
        return result2;
    }

    public static double binomialCoefficientDouble(int n2, int k2) throws NotPositiveException, NumberIsTooLargeException, MathArithmeticException {
        CombinatoricsUtils.checkBinomial(n2, k2);
        if (n2 == k2 || k2 == 0) {
            return 1.0;
        }
        if (k2 == 1 || k2 == n2 - 1) {
            return n2;
        }
        if (k2 > n2 / 2) {
            return CombinatoricsUtils.binomialCoefficientDouble(n2, n2 - k2);
        }
        if (n2 < 67) {
            return CombinatoricsUtils.binomialCoefficient(n2, k2);
        }
        double result2 = 1.0;
        for (int i2 = 1; i2 <= k2; ++i2) {
            result2 *= (double)(n2 - k2 + i2) / (double)i2;
        }
        return FastMath.floor(result2 + 0.5);
    }

    public static double binomialCoefficientLog(int n2, int k2) throws NotPositiveException, NumberIsTooLargeException, MathArithmeticException {
        int i2;
        CombinatoricsUtils.checkBinomial(n2, k2);
        if (n2 == k2 || k2 == 0) {
            return 0.0;
        }
        if (k2 == 1 || k2 == n2 - 1) {
            return FastMath.log(n2);
        }
        if (n2 < 67) {
            return FastMath.log(CombinatoricsUtils.binomialCoefficient(n2, k2));
        }
        if (n2 < 1030) {
            return FastMath.log(CombinatoricsUtils.binomialCoefficientDouble(n2, k2));
        }
        if (k2 > n2 / 2) {
            return CombinatoricsUtils.binomialCoefficientLog(n2, n2 - k2);
        }
        double logSum = 0.0;
        for (i2 = n2 - k2 + 1; i2 <= n2; ++i2) {
            logSum += FastMath.log(i2);
        }
        for (i2 = 2; i2 <= k2; ++i2) {
            logSum -= FastMath.log(i2);
        }
        return logSum;
    }

    public static long factorial(int n2) throws NotPositiveException, MathArithmeticException {
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n2);
        }
        if (n2 > 20) {
            throw new MathArithmeticException();
        }
        return FACTORIALS[n2];
    }

    public static double factorialDouble(int n2) throws NotPositiveException {
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n2);
        }
        if (n2 < 21) {
            return FACTORIALS[n2];
        }
        return FastMath.floor(FastMath.exp(CombinatoricsUtils.factorialLog(n2)) + 0.5);
    }

    public static double factorialLog(int n2) throws NotPositiveException {
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n2);
        }
        if (n2 < 21) {
            return FastMath.log(FACTORIALS[n2]);
        }
        double logSum = 0.0;
        for (int i2 = 2; i2 <= n2; ++i2) {
            logSum += FastMath.log(i2);
        }
        return logSum;
    }

    public static long stirlingS2(int n2, int k2) throws NotPositiveException, NumberIsTooLargeException, MathArithmeticException {
        if (k2 < 0) {
            throw new NotPositiveException(k2);
        }
        if (k2 > n2) {
            throw new NumberIsTooLargeException(k2, (Number)n2, true);
        }
        Object stirlingS2 = STIRLING_S2.get();
        if (stirlingS2 == null) {
            int maxIndex = 26;
            stirlingS2 = new long[26][];
            stirlingS2[0] = new long[]{1L};
            for (int i2 = 1; i2 < ((long[][])stirlingS2).length; ++i2) {
                stirlingS2[i2] = new long[i2 + 1];
                stirlingS2[i2][0] = 0L;
                stirlingS2[i2][1] = 1L;
                stirlingS2[i2][i2] = 1L;
                for (int j2 = 2; j2 < i2; ++j2) {
                    stirlingS2[i2][j2] = (long)j2 * stirlingS2[i2 - 1][j2] + stirlingS2[i2 - 1][j2 - 1];
                }
            }
            STIRLING_S2.compareAndSet((long[][])null, (long[][])stirlingS2);
        }
        if (n2 < ((long[][])stirlingS2).length) {
            return stirlingS2[n2][k2];
        }
        if (k2 == 0) {
            return 0L;
        }
        if (k2 == 1 || k2 == n2) {
            return 1L;
        }
        if (k2 == 2) {
            return (1L << n2 - 1) - 1L;
        }
        if (k2 == n2 - 1) {
            return CombinatoricsUtils.binomialCoefficient(n2, 2);
        }
        long sum = 0L;
        long sign = (k2 & 1) == 0 ? 1L : -1L;
        for (int j3 = 1; j3 <= k2; ++j3) {
            if ((sum += (sign = -sign) * CombinatoricsUtils.binomialCoefficient(k2, j3) * (long)ArithmeticUtils.pow(j3, n2)) >= 0L) continue;
            throw new MathArithmeticException(LocalizedFormats.ARGUMENT_OUTSIDE_DOMAIN, n2, 0, ((long[][])stirlingS2).length - 1);
        }
        return sum / CombinatoricsUtils.factorial(k2);
    }

    public static Iterator<int[]> combinationsIterator(int n2, int k2) {
        return new Combinations(n2, k2).iterator();
    }

    public static void checkBinomial(int n2, int k2) throws NumberIsTooLargeException, NotPositiveException {
        if (n2 < k2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.BINOMIAL_INVALID_PARAMETERS_ORDER, (Number)k2, n2, true);
        }
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.BINOMIAL_NEGATIVE_PARAMETER, n2);
        }
    }
}

