/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.direct;

import java.util.Comparator;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.optimization.PointValuePair;
import org.apache.commons.math3.optimization.direct.AbstractSimplex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class NelderMeadSimplex
extends AbstractSimplex {
    private static final double DEFAULT_RHO = 1.0;
    private static final double DEFAULT_KHI = 2.0;
    private static final double DEFAULT_GAMMA = 0.5;
    private static final double DEFAULT_SIGMA = 0.5;
    private final double rho;
    private final double khi;
    private final double gamma;
    private final double sigma;

    public NelderMeadSimplex(int n2) {
        this(n2, 1.0);
    }

    public NelderMeadSimplex(int n2, double sideLength) {
        this(n2, sideLength, 1.0, 2.0, 0.5, 0.5);
    }

    public NelderMeadSimplex(int n2, double sideLength, double rho, double khi, double gamma, double sigma) {
        super(n2, sideLength);
        this.rho = rho;
        this.khi = khi;
        this.gamma = gamma;
        this.sigma = sigma;
    }

    public NelderMeadSimplex(int n2, double rho, double khi, double gamma, double sigma) {
        this(n2, 1.0, rho, khi, gamma, sigma);
    }

    public NelderMeadSimplex(double[] steps) {
        this(steps, 1.0, 2.0, 0.5, 0.5);
    }

    public NelderMeadSimplex(double[] steps, double rho, double khi, double gamma, double sigma) {
        super(steps);
        this.rho = rho;
        this.khi = khi;
        this.gamma = gamma;
        this.sigma = sigma;
    }

    public NelderMeadSimplex(double[][] referenceSimplex) {
        this(referenceSimplex, 1.0, 2.0, 0.5, 0.5);
    }

    public NelderMeadSimplex(double[][] referenceSimplex, double rho, double khi, double gamma, double sigma) {
        super(referenceSimplex);
        this.rho = rho;
        this.khi = khi;
        this.gamma = gamma;
        this.sigma = sigma;
    }

    @Override
    public void iterate(MultivariateFunction evaluationFunction, Comparator<PointValuePair> comparator) {
        int j2;
        int n2 = this.getDimension();
        PointValuePair best = this.getPoint(0);
        PointValuePair secondBest = this.getPoint(n2 - 1);
        PointValuePair worst = this.getPoint(n2);
        double[] xWorst = worst.getPointRef();
        double[] centroid = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            double[] x2 = this.getPoint(i2).getPointRef();
            for (j2 = 0; j2 < n2; ++j2) {
                int n3 = j2;
                centroid[n3] = centroid[n3] + x2[j2];
            }
        }
        double scaling = 1.0 / (double)n2;
        j2 = 0;
        while (j2 < n2) {
            int n4 = j2++;
            centroid[n4] = centroid[n4] * scaling;
        }
        double[] xR = new double[n2];
        for (int j3 = 0; j3 < n2; ++j3) {
            xR[j3] = centroid[j3] + this.rho * (centroid[j3] - xWorst[j3]);
        }
        PointValuePair reflected = new PointValuePair(xR, evaluationFunction.value(xR), false);
        if (comparator.compare(best, reflected) <= 0 && comparator.compare(reflected, secondBest) < 0) {
            this.replaceWorstPoint(reflected, comparator);
        } else if (comparator.compare(reflected, best) < 0) {
            double[] xE = new double[n2];
            for (int j4 = 0; j4 < n2; ++j4) {
                xE[j4] = centroid[j4] + this.khi * (xR[j4] - centroid[j4]);
            }
            PointValuePair expanded = new PointValuePair(xE, evaluationFunction.value(xE), false);
            if (comparator.compare(expanded, reflected) < 0) {
                this.replaceWorstPoint(expanded, comparator);
            } else {
                this.replaceWorstPoint(reflected, comparator);
            }
        } else {
            double[] xC;
            if (comparator.compare(reflected, worst) < 0) {
                xC = new double[n2];
                for (int j5 = 0; j5 < n2; ++j5) {
                    xC[j5] = centroid[j5] + this.gamma * (xR[j5] - centroid[j5]);
                }
                PointValuePair outContracted = new PointValuePair(xC, evaluationFunction.value(xC), false);
                if (comparator.compare(outContracted, reflected) <= 0) {
                    this.replaceWorstPoint(outContracted, comparator);
                    return;
                }
            } else {
                xC = new double[n2];
                for (int j6 = 0; j6 < n2; ++j6) {
                    xC[j6] = centroid[j6] - this.gamma * (centroid[j6] - xWorst[j6]);
                }
                PointValuePair inContracted = new PointValuePair(xC, evaluationFunction.value(xC), false);
                if (comparator.compare(inContracted, worst) < 0) {
                    this.replaceWorstPoint(inContracted, comparator);
                    return;
                }
            }
            double[] xSmallest = this.getPoint(0).getPointRef();
            for (int i3 = 1; i3 <= n2; ++i3) {
                double[] x3 = this.getPoint(i3).getPoint();
                for (int j7 = 0; j7 < n2; ++j7) {
                    x3[j7] = xSmallest[j7] + this.sigma * (x3[j7] - xSmallest[j7]);
                }
                this.setPoint(i3, new PointValuePair(x3, Double.NaN, false));
            }
            this.evaluate(evaluationFunction, comparator);
        }
    }
}

