/*
 * Decompiled with CFR 0.152.
 */
package gde.device.skyrc;

import gde.GDE;
import gde.config.Settings;
import gde.device.DeviceDialog;
import gde.device.skyrc.MC3000;
import gde.device.skyrc.MC3000GathererThread;
import gde.device.skyrc.MC3000Type;
import gde.device.skyrc.MC3000UsbPort;
import gde.device.skyrc.ObjectFactory;
import gde.device.skyrc.ProgramType;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import javax.usb.UsbException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class MC3000Dialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(MC3000Dialog.class.getName());
    static final int NUMBER_PROGRAM_ENTRIES = 30;
    static final int SIZE_PROGRAM_NAME = 35;
    static final String NEW_PROG_NAME = "NEW-PROG-NAME";
    static final String STRING_FORMAT_02d_s = "[%02d] - %s";
    static final String STRING_FORMAT_02d = "[%02d] - ";
    static final String STRING_35_BLANK = "                                   ";
    static final String DEVICE_JAR_NAME = "SkyRC";
    static final int DIALOG_WIDTH = 355;
    Composite tabFolder;
    final List<CTabItem> configurations = new ArrayList<CTabItem>();
    CTabItem chargeTabItem;
    Group slotsViewGroup;
    Clipboard clipboard;
    int parameterSelectHeight = 25;
    int chargeSelectHeight = 17 * this.parameterSelectHeight;
    String[] programmNames = new String[30];
    int[] lastSelectionIndex = new int[]{0, 0, 0, 0};
    CCombo[] programmNameCombos = new CCombo[4];
    CLabel[] programLables = new CLabel[4];
    Schema schema;
    JAXBContext jc;
    MC3000Type mc3000Setup;
    static final String MC3000_XSD = "MC3000_V01.xsd";
    Button saveButton;
    Button helpButton;
    Button resetAllButton;
    Button closeButton;
    MC3000GathererThread dataGatherThread;
    final MC3000 device;
    final MC3000UsbPort usbPort;
    final Settings settings;
    MC3000.SystemSettings systemSettings;
    MC3000.SlotSettings slotSettings_0;
    MC3000.SlotSettings slotSettings_1;
    MC3000.SlotSettings slotSettings_2;
    MC3000.SlotSettings slotSettings_3;
    MC3000.SlotSettings slotInitialSettings_0;
    MC3000.SlotSettings slotInitialSettings_1;
    MC3000.SlotSettings slotInitialSettings_2;
    MC3000.SlotSettings slotInitialSettings_3;
    int measurementsCount = 0;
    int tabFolderSelectionIndex = 0;
    protected static final int USB_QUERY_DELAY = GDE.IS_WINDOWS ? 70 : 160;
    boolean isConnectedByDialog = false;
    boolean isConnectedByButton = false;

    public MC3000Dialog(Shell parent, MC3000 useDevice) {
        super(parent);
        this.device = useDevice;
        this.usbPort = useDevice.getCommunicationPort();
        this.settings = Settings.getInstance();
        for (int i = 0; i < 30; ++i) {
            this.programmNames[i] = String.format(STRING_FORMAT_02d_s, i + 1, NEW_PROG_NAME);
        }
    }

    private void updateSystemParameter(MC3000.SystemSettings sysSettings) {
        if (sysSettings != null) {
            int actualFirmware = sysSettings.getFirmwareVersionAsInt();
            if (actualFirmware < 104) {
                this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW3600", (Object[])new String[]{sysSettings.getFirmwareVersion()}));
            } else if (sysSettings.getFirmwareVersionAsInt() == 111) {
                this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGT3650", (Object[])new String[]{sysSettings.getFirmwareVersion()}));
            }
        }
    }

    public void open() {
        if (!this.usbPort.isConnected()) {
            block17: {
                try {
                    this.usbPort.openUsbPort();
                }
                catch (UsbException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
                try {
                    this.jc = JAXBContext.newInstance((String)"gde.device.skyrc");
                    this.schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(MC3000Dialog.class.getClassLoader().getResourceAsStream("resource/MC3000_V01.xsd")));
                    Unmarshaller unmarshaller = this.jc.createUnmarshaller();
                    unmarshaller.setSchema(this.schema);
                    this.mc3000Setup = (MC3000Type)unmarshaller.unmarshal(new File(Settings.getApplHomePath() + "/MC3000_Slot_Programs.xml"));
                    int index = 0;
                    for (ProgramType prog : this.mc3000Setup.program) {
                        if (!prog.getName().contains(NEW_PROG_NAME)) {
                            this.programmNames[index++] = String.format(STRING_FORMAT_02d_s, index, prog.getName());
                            continue;
                        }
                        this.programmNames[index++] = prog.getName();
                    }
                }
                catch (UnmarshalException e) {
                    log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                    this.createMC3000Setup();
                }
                catch (Exception e) {
                    if (!(e.getCause() instanceof FileNotFoundException)) break block17;
                    this.createMC3000Setup();
                }
            }
            String busyMessage = this.readInitialSlotPrograms();
            if (busyMessage != null) {
                this.application.openMessageDialog(busyMessage);
                return;
            }
        } else {
            this.application.openMessageDialog(Messages.getString((String)"GDE_MSGW3601"));
            return;
        }
        try {
            this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
            this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
            log.log(java.util.logging.Level.FINE, "dialogShell.isDisposed() " + String.valueOf(this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
            if (this.dialogShell == null || this.dialogShell.isDisposed()) {
                this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
                SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
                if (this.isAlphaEnabled) {
                    this.dialogShell.setAlpha(254);
                }
                FormLayout dialogShellLayout = new FormLayout();
                this.dialogShell.setLayout((Layout)dialogShellLayout);
                this.dialogShell.layout();
                this.dialogShell.pack();
                this.dialogShell.setSize(355, (GDE.IS_WINDOWS ? 85 : 75) + this.chargeSelectHeight);
                this.dialogShell.setText(this.device.getName() + Messages.getString((String)"GDE_MSGT0273"));
                this.dialogShell.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
                this.dialogShell.addListener(31, new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.detail) {
                            case 2: {
                                MC3000Dialog.this.dialogShell.close();
                                event.detail = 0;
                                event.doit = false;
                            }
                        }
                    }
                });
                this.dialogShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "dialogShell.widgetDisposed, event=" + String.valueOf(evt));
                        if (MC3000Dialog.this.device.isChangePropery()) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{MC3000Dialog.this.device.getPropertiesFileName()});
                            if (MC3000Dialog.this.application.openYesNoMessageDialog(MC3000Dialog.this.getDialogShell(), msg) == 64) {
                                log.log(java.util.logging.Level.FINE, "SWT.YES");
                                MC3000Dialog.this.device.storeDeviceProperties();
                                MC3000Dialog.this.setClosePossible(true);
                            }
                        }
                        if (MC3000Dialog.this.usbPort.isConnected()) {
                            try {
                                MC3000Dialog.this.usbPort.closeUsbPort(false);
                            }
                            catch (UsbException e) {
                                log.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        MC3000Dialog.this.clipboard.dispose();
                        MC3000Dialog.this.dispose();
                    }
                });
                this.dialogShell.addHelpListener(new HelpListener(){

                    public void helpRequested(HelpEvent evt) {
                        log.log(java.util.logging.Level.FINER, "dialogShell.helpRequested, event=" + String.valueOf(evt));
                        MC3000Dialog.this.application.openHelpDialog(MC3000Dialog.DEVICE_JAR_NAME, "HelpInfo.html");
                    }
                });
                this.clipboard = new Clipboard(this.dialogShell.getDisplay());
                this.tabFolder = new Composite((Composite)this.dialogShell, 0);
                this.tabFolder.setLayout((Layout)new FillLayout(512));
                this.tabFolder.setSize(this.dialogShell.getClientArea().width, this.chargeSelectHeight);
                this.tabFolder.layout();
                this.slotsViewGroup = new Group(this.tabFolder, 0);
                this.slotsViewGroup.setLayout((Layout)new FillLayout(512));
                for (int i = 0; i < 4; ++i) {
                    this.createSlotGroup(i);
                }
                this.saveButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData saveButtonLData = new FormData();
                saveButtonLData.width = 90;
                saveButtonLData.height = GDE.IS_MAC ? 33 : 30;
                saveButtonLData.bottom = new FormAttachment(1000, 1000, -10);
                saveButtonLData.left = new FormAttachment(0, 1000, 10);
                this.saveButton.setLayoutData((Object)saveButtonLData);
                this.saveButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.saveButton.setText(Messages.getString((String)"GDE_MSGT0486"));
                this.saveButton.setToolTipText(Messages.getString((String)"GDE_MSGT3655"));
                this.saveButton.setEnabled(false);
                this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "saveButton.widgetSelected, event=" + String.valueOf(evt));
                        MC3000Dialog.this.saveMc3000SetupData();
                    }
                });
                this.helpButton = new Button((Composite)this.dialogShell, 0x1000008);
                this.helpButton.setImage(SWTResourceManager.getImage((String)"gde/resource/QuestionHot.gif"));
                FormData LoadButtonLData = new FormData();
                LoadButtonLData.width = 40;
                LoadButtonLData.height = GDE.IS_MAC ? 33 : 30;
                LoadButtonLData.bottom = new FormAttachment(1000, 1000, -10);
                LoadButtonLData.left = new FormAttachment(0, 1000, 107);
                this.helpButton.setLayoutData((Object)LoadButtonLData);
                this.helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "helpButton.widgetSelected, event=" + String.valueOf(evt));
                        MC3000Dialog.this.application.openHelpDialog(MC3000Dialog.DEVICE_JAR_NAME, "HelpInfo.html");
                    }
                });
                this.resetAllButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData reloadButtonLData = new FormData();
                reloadButtonLData.width = 90;
                reloadButtonLData.height = GDE.IS_MAC ? 33 : 30;
                reloadButtonLData.right = new FormAttachment(1000, 1000, -110);
                reloadButtonLData.bottom = new FormAttachment(1000, 1000, -10);
                this.resetAllButton.setLayoutData((Object)reloadButtonLData);
                this.resetAllButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.resetAllButton.setText(Messages.getString((String)"GDE_MSGT3679"));
                this.resetAllButton.setToolTipText(Messages.getString((String)"GDE_MSGT3680"));
                this.resetAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void widgetSelected(SelectionEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "reloadButton.widgetSelected, event=" + String.valueOf(evt));
                        try {
                            if (!MC3000Dialog.this.usbPort.isConnected()) {
                                MC3000Dialog.this.usbPort.openUsbPort();
                                MC3000Dialog.this.isConnectedByButton = true;
                            }
                            int firmware = MC3000Dialog.this.systemSettings != null ? MC3000Dialog.this.systemSettings.getFirmwareVersionAsInt() : 0;
                            byte systemTemperatureUnit = MC3000Dialog.this.systemSettings != null ? MC3000Dialog.this.systemSettings.getTemperatureUnit() : (byte)0;
                            block17: for (int i = 0; i < 4; ++i) {
                                switch (i) {
                                    case 0: {
                                        if (MC3000Dialog.this.slotInitialSettings_0 == null) continue block17;
                                        byte[] tmpProgramBuffer = MC3000Dialog.this.slotInitialSettings_0.getBuffer((byte)0, firmware, systemTemperatureUnit);
                                        MC3000Dialog.this.usbPort.setSlotProgram(tmpProgramBuffer);
                                        MC3000 mC3000 = MC3000Dialog.this.device;
                                        Objects.requireNonNull(mC3000);
                                        MC3000Dialog.this.slotSettings_0 = new MC3000.SlotSettings(mC3000, MC3000Dialog.this.usbPort.getSlotData(MC3000UsbPort.QuerySlotData.SLOT_0.value()), firmware);
                                        MC3000Dialog.this.programLables[i].setText(MC3000Dialog.this.slotSettings_0 != null ? MC3000Dialog.this.slotSettings_0.toString4View() : Messages.getString((String)"GDE_MSGT3654"));
                                        MC3000Dialog.this.programLables[i].setToolTipText(MC3000Dialog.this.slotSettings_0 != null ? MC3000Dialog.this.slotSettings_0.toString4Tip(true, systemTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654"));
                                        continue block17;
                                    }
                                    case 1: {
                                        MC3000Dialog.this.programLables[i].setText(MC3000Dialog.this.slotInitialSettings_1 != null ? MC3000Dialog.this.slotInitialSettings_1.toString4View() : Messages.getString((String)"GDE_MSGT3654"));
                                        MC3000Dialog.this.programLables[i].setToolTipText(MC3000Dialog.this.slotInitialSettings_1 != null ? MC3000Dialog.this.slotInitialSettings_1.toString4Tip(true, systemTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654"));
                                        if (MC3000Dialog.this.slotInitialSettings_1 == null) continue block17;
                                        byte[] tmpProgramBuffer = MC3000Dialog.this.slotInitialSettings_1.getBuffer((byte)1, firmware, systemTemperatureUnit);
                                        MC3000Dialog.this.usbPort.setSlotProgram(tmpProgramBuffer);
                                        MC3000 mC3000 = MC3000Dialog.this.device;
                                        Objects.requireNonNull(mC3000);
                                        MC3000Dialog.this.slotSettings_1 = new MC3000.SlotSettings(mC3000, MC3000Dialog.this.usbPort.getSlotData(MC3000UsbPort.QuerySlotData.SLOT_1.value()), firmware);
                                        MC3000Dialog.this.programLables[i].setText(MC3000Dialog.this.slotSettings_1 != null ? MC3000Dialog.this.slotSettings_1.toString4View() : Messages.getString((String)"GDE_MSGT3654"));
                                        MC3000Dialog.this.programLables[i].setToolTipText(MC3000Dialog.this.slotSettings_1 != null ? MC3000Dialog.this.slotSettings_1.toString4Tip(true, systemTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654"));
                                        continue block17;
                                    }
                                    case 2: {
                                        MC3000Dialog.this.programLables[i].setText(MC3000Dialog.this.slotInitialSettings_2 != null ? MC3000Dialog.this.slotInitialSettings_2.toString4View() : Messages.getString((String)"GDE_MSGT3654"));
                                        MC3000Dialog.this.programLables[i].setToolTipText(MC3000Dialog.this.slotInitialSettings_2 != null ? MC3000Dialog.this.slotInitialSettings_2.toString4Tip(true, systemTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654"));
                                        if (MC3000Dialog.this.slotInitialSettings_2 == null) continue block17;
                                        byte[] tmpProgramBuffer = MC3000Dialog.this.slotInitialSettings_2.getBuffer((byte)2, firmware, systemTemperatureUnit);
                                        MC3000Dialog.this.usbPort.setSlotProgram(tmpProgramBuffer);
                                        MC3000 mC3000 = MC3000Dialog.this.device;
                                        Objects.requireNonNull(mC3000);
                                        MC3000Dialog.this.slotSettings_2 = new MC3000.SlotSettings(mC3000, MC3000Dialog.this.usbPort.getSlotData(MC3000UsbPort.QuerySlotData.SLOT_2.value()), firmware);
                                        MC3000Dialog.this.programLables[i].setText(MC3000Dialog.this.slotSettings_2 != null ? MC3000Dialog.this.slotSettings_2.toString4View() : Messages.getString((String)"GDE_MSGT3654"));
                                        MC3000Dialog.this.programLables[i].setToolTipText(MC3000Dialog.this.slotSettings_2 != null ? MC3000Dialog.this.slotSettings_2.toString4Tip(true, systemTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654"));
                                        continue block17;
                                    }
                                    case 3: {
                                        MC3000Dialog.this.programLables[i].setText(MC3000Dialog.this.slotInitialSettings_3 != null ? MC3000Dialog.this.slotInitialSettings_3.toString4View() : Messages.getString((String)"GDE_MSGT3654"));
                                        MC3000Dialog.this.programLables[i].setToolTipText(MC3000Dialog.this.slotInitialSettings_3 != null ? MC3000Dialog.this.slotInitialSettings_3.toString4Tip(true, systemTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654"));
                                        if (MC3000Dialog.this.slotInitialSettings_3 == null) continue block17;
                                        byte[] tmpProgramBuffer = MC3000Dialog.this.slotInitialSettings_3.getBuffer((byte)3, firmware, systemTemperatureUnit);
                                        MC3000Dialog.this.usbPort.setSlotProgram(tmpProgramBuffer);
                                        MC3000 mC3000 = MC3000Dialog.this.device;
                                        Objects.requireNonNull(mC3000);
                                        MC3000Dialog.this.slotSettings_3 = new MC3000.SlotSettings(mC3000, MC3000Dialog.this.usbPort.getSlotData(MC3000UsbPort.QuerySlotData.SLOT_3.value()), firmware);
                                        MC3000Dialog.this.programLables[i].setText(MC3000Dialog.this.slotSettings_3 != null ? MC3000Dialog.this.slotSettings_3.toString4View() : Messages.getString((String)"GDE_MSGT3654"));
                                        MC3000Dialog.this.programLables[i].setToolTipText(MC3000Dialog.this.slotSettings_3 != null ? MC3000Dialog.this.slotSettings_3.toString4Tip(true, systemTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654"));
                                        continue block17;
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            log.log(java.util.logging.Level.WARNING, e.getMessage(), e);
                            MC3000Dialog.this.application.openMessageDialogAsync(e.getMessage());
                        }
                        finally {
                            if (MC3000Dialog.this.isConnectedByButton && MC3000Dialog.this.usbPort != null && MC3000Dialog.this.usbPort.isConnected()) {
                                try {
                                    MC3000Dialog.this.usbPort.closeUsbPort(false);
                                }
                                catch (UsbException e) {
                                    log.log(java.util.logging.Level.WARNING, e.getMessage(), e);
                                }
                            }
                        }
                    }
                });
                this.closeButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData closeButtonLData = new FormData();
                closeButtonLData.width = 90;
                closeButtonLData.height = GDE.IS_MAC ? 33 : 30;
                closeButtonLData.right = new FormAttachment(1000, 1000, -10);
                closeButtonLData.bottom = new FormAttachment(1000, 1000, -10);
                this.closeButton.setLayoutData((Object)closeButtonLData);
                this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.closeButton.setText(Messages.getString((String)"GDE_MSGT0485"));
                this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "closeButton.widgetSelected, event=" + String.valueOf(evt));
                        if (!MC3000Dialog.this.saveButton.isEnabled() || MC3000Dialog.this.saveButton.isEnabled() && 32 == MC3000Dialog.this.application.openOkCancelMessageDialog(MC3000Dialog.this.dialogShell, Messages.getString((String)"GDE_MSGT3681"))) {
                            MC3000Dialog.this.dialogShell.dispose();
                        }
                    }
                });
                FormData tabFolderLData = new FormData();
                tabFolderLData.top = new FormAttachment(0, 1000, 0);
                tabFolderLData.left = new FormAttachment(0, 1000, 0);
                tabFolderLData.right = new FormAttachment(1000, 1000, 0);
                tabFolderLData.bottom = new FormAttachment(1000, 1000, -50);
                this.tabFolder.setLayoutData((Object)tabFolderLData);
                this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 175, 100));
                this.dialogShell.open();
            } else {
                this.dialogShell.setVisible(true);
                this.dialogShell.setActive();
            }
            this.updateSystemParameter(this.systemSettings);
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
    }

    private String readInitialSlotPrograms() {
        boolean isBusy = false;
        String isBusyString = null;
        try {
            if (!this.usbPort.isConnected()) {
                this.usbPort.openUsbPort();
                this.isConnectedByDialog = true;
            }
            if (this.usbPort.isConnected()) {
                MC3000 mC3000 = this.device;
                Objects.requireNonNull(mC3000);
                this.systemSettings = new MC3000.SystemSettings(mC3000, this.usbPort.getSystemSettings());
            }
            WaitTimer.delay((long)USB_QUERY_DELAY);
            if (this.usbPort.isConnected()) {
                MC3000 mC3000 = this.device;
                Objects.requireNonNull(mC3000);
                this.slotSettings_0 = new MC3000.SlotSettings(mC3000, this.usbPort.getSlotData(MC3000UsbPort.QuerySlotData.SLOT_0.value()), this.systemSettings.getFirmwareVersionAsInt());
                MC3000 mC30002 = this.device;
                Objects.requireNonNull(mC30002);
                this.slotInitialSettings_0 = new MC3000.SlotSettings(mC30002, this.slotSettings_0);
                WaitTimer.delay((long)USB_QUERY_DELAY);
                isBusy = this.slotInitialSettings_0.isBusy();
                String string = isBusyString = isBusy ? Messages.getString((String)"GDE_MSGW3601") : null;
            }
            if (this.usbPort.isConnected() && !isBusy) {
                MC3000 mC3000 = this.device;
                Objects.requireNonNull(mC3000);
                this.slotSettings_1 = new MC3000.SlotSettings(mC3000, this.usbPort.getSlotData(MC3000UsbPort.QuerySlotData.SLOT_1.value()), this.systemSettings.getFirmwareVersionAsInt());
                MC3000 mC30003 = this.device;
                Objects.requireNonNull(mC30003);
                this.slotInitialSettings_1 = new MC3000.SlotSettings(mC30003, this.slotSettings_1);
                WaitTimer.delay((long)USB_QUERY_DELAY);
                isBusy = this.slotInitialSettings_0.isBusy();
                String string = isBusyString = isBusy ? Messages.getString((String)"GDE_MSGW3601") : null;
            }
            if (this.usbPort.isConnected() && !isBusy) {
                MC3000 mC3000 = this.device;
                Objects.requireNonNull(mC3000);
                this.slotSettings_2 = new MC3000.SlotSettings(mC3000, this.usbPort.getSlotData(MC3000UsbPort.QuerySlotData.SLOT_2.value()), this.systemSettings.getFirmwareVersionAsInt());
                MC3000 mC30004 = this.device;
                Objects.requireNonNull(mC30004);
                this.slotInitialSettings_2 = new MC3000.SlotSettings(mC30004, this.slotSettings_2);
                WaitTimer.delay((long)USB_QUERY_DELAY);
                isBusy = this.slotInitialSettings_0.isBusy();
                String string = isBusyString = isBusy ? Messages.getString((String)"GDE_MSGW3601") : null;
            }
            if (this.usbPort.isConnected() && !isBusy) {
                MC3000 mC3000 = this.device;
                Objects.requireNonNull(mC3000);
                this.slotSettings_3 = new MC3000.SlotSettings(mC3000, this.usbPort.getSlotData(MC3000UsbPort.QuerySlotData.SLOT_3.value()), this.systemSettings.getFirmwareVersionAsInt());
                MC3000 mC30005 = this.device;
                Objects.requireNonNull(mC30005);
                this.slotInitialSettings_3 = new MC3000.SlotSettings(mC30005, this.slotSettings_3);
                isBusy = this.slotInitialSettings_0.isBusy();
                isBusyString = isBusy ? Messages.getString((String)"GDE_MSGW3601") : null;
            }
        }
        catch (Exception e) {
            log.log(java.util.logging.Level.WARNING, e.getMessage(), e);
            isBusyString = e instanceof UsbException ? e.getMessage() : Messages.getString((String)"GDE_MSGW3601");
        }
        return isBusyString;
    }

    private void createSlotGroup(final int index) {
        CCombo programmNameCombo;
        Group slot = new Group((Composite)this.slotsViewGroup, 0);
        slot.setLayout((Layout)new RowLayout(256));
        slot.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        slot.setText(Messages.getString((String)"GDE_MSGT3651", (Object[])new Object[]{index + 1}));
        CLabel nameLabel = new CLabel((Composite)slot, 0);
        nameLabel.setLayoutData((Object)new RowData(GDE.IS_WINDOWS ? 115 : 120, 20));
        nameLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        nameLabel.setText(Messages.getString((String)"GDE_MSGT3652"));
        this.programmNameCombos[index] = programmNameCombo = new CCombo((Composite)slot, 2048);
        final CLabel label0 = new CLabel((Composite)slot, 0);
        final Button writeButton = new Button((Composite)slot, 0x1000008);
        this.programLables[index] = label0;
        programmNameCombo.setItems(this.programmNames);
        programmNameCombo.setVisibleItemCount(20);
        programmNameCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        programmNameCombo.setTextLimit(40);
        programmNameCombo.setLayoutData((Object)new RowData(187, GDE.IS_WINDOWS ? 16 : 18));
        programmNameCombo.setToolTipText(Messages.getString((String)"GDE_MSGT3653"));
        programmNameCombo.select(0);
        programmNameCombo.setBackground(SWTResourceManager.getColor((int)1));
        programmNameCombo.setEditable(true);
        programmNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                List<ProgramType> devicePrograms;
                log.log(java.util.logging.Level.FINEST, "programmNameCombo.widgetSelected, event=" + String.valueOf(evt));
                MC3000Dialog.this.lastSelectionIndex[index] = programmNameCombo.getSelectionIndex();
                if (MC3000Dialog.this.mc3000Setup == null) {
                    MC3000Dialog.this.createMC3000Setup();
                }
                if (!(devicePrograms = MC3000Dialog.this.mc3000Setup.getProgram()).get(programmNameCombo.getSelectionIndex()).getName().contains(MC3000Dialog.NEW_PROG_NAME)) {
                    try {
                        byte systemTemperatureUnit = MC3000Dialog.this.systemSettings != null ? MC3000Dialog.this.systemSettings.getTemperatureUnit() : (byte)0;
                        switch (index) {
                            case 0: {
                                MC3000 mC3000 = MC3000Dialog.this.device;
                                Objects.requireNonNull(mC3000);
                                MC3000Dialog.this.slotSettings_0 = new MC3000.SlotSettings(mC3000, devicePrograms.get(programmNameCombo.getSelectionIndex()).getSetupData().getValue(), MC3000Dialog.this.systemSettings.getFirmwareVersionAsInt());
                                MC3000Dialog.this.slotSettings_0.setSlotNumber((byte)index);
                                label0.setText(MC3000Dialog.this.slotSettings_0.toString4View());
                                label0.setToolTipText(MC3000Dialog.this.slotSettings_0.toString4Tip(true, systemTemperatureUnit));
                                break;
                            }
                            case 1: {
                                MC3000 mC3000 = MC3000Dialog.this.device;
                                Objects.requireNonNull(mC3000);
                                MC3000Dialog.this.slotSettings_1 = new MC3000.SlotSettings(mC3000, devicePrograms.get(programmNameCombo.getSelectionIndex()).getSetupData().getValue(), MC3000Dialog.this.systemSettings.getFirmwareVersionAsInt());
                                MC3000Dialog.this.slotSettings_1.setSlotNumber((byte)index);
                                label0.setText(MC3000Dialog.this.slotSettings_1.toString4View());
                                label0.setToolTipText(MC3000Dialog.this.slotSettings_1.toString4Tip(true, systemTemperatureUnit));
                                break;
                            }
                            case 2: {
                                MC3000 mC3000 = MC3000Dialog.this.device;
                                Objects.requireNonNull(mC3000);
                                MC3000Dialog.this.slotSettings_2 = new MC3000.SlotSettings(mC3000, devicePrograms.get(programmNameCombo.getSelectionIndex()).getSetupData().getValue(), MC3000Dialog.this.systemSettings.getFirmwareVersionAsInt());
                                MC3000Dialog.this.slotSettings_2.setSlotNumber((byte)index);
                                label0.setText(MC3000Dialog.this.slotSettings_2.toString4View());
                                label0.setToolTipText(MC3000Dialog.this.slotSettings_2.toString4Tip(true, systemTemperatureUnit));
                                break;
                            }
                            case 3: {
                                MC3000 mC3000 = MC3000Dialog.this.device;
                                Objects.requireNonNull(mC3000);
                                MC3000Dialog.this.slotSettings_3 = new MC3000.SlotSettings(mC3000, devicePrograms.get(programmNameCombo.getSelectionIndex()).getSetupData().getValue(), MC3000Dialog.this.systemSettings.getFirmwareVersionAsInt());
                                MC3000Dialog.this.slotSettings_3.setSlotNumber((byte)index);
                                label0.setText(MC3000Dialog.this.slotSettings_3.toString4View());
                                label0.setToolTipText(MC3000Dialog.this.slotSettings_3.toString4Tip(true, systemTemperatureUnit));
                                break;
                            }
                        }
                        if (programmNameCombo.getText().contains(MC3000Dialog.NEW_PROG_NAME)) {
                            writeButton.setEnabled(false);
                        } else {
                            writeButton.setEnabled(true);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        programmNameCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                log.log(java.util.logging.Level.FINEST, "memoryCombo.keyReleased, event=" + String.valueOf(evt));
            }

            public void keyPressed(KeyEvent evt) {
                log.log(java.util.logging.Level.FINEST, "memoryCombo.keyPressed, event=" + String.valueOf(evt));
                if (evt.character == '\r') {
                    try {
                        String newSlotProgramName;
                        if (MC3000Dialog.this.mc3000Setup == null) {
                            MC3000Dialog.this.createMC3000Setup();
                        }
                        log.log(java.util.logging.Level.FINE, String.format("slot # %d selection index = %d", index, MC3000Dialog.this.lastSelectionIndex[index]));
                        String nameLeader = String.format(MC3000Dialog.STRING_FORMAT_02d, MC3000Dialog.this.lastSelectionIndex[index] + 1);
                        String tmpName = programmNameCombo.getText() + MC3000Dialog.STRING_35_BLANK;
                        tmpName = tmpName.startsWith(nameLeader) ? tmpName : nameLeader + tmpName;
                        MC3000Dialog.this.programmNames[MC3000Dialog.this.lastSelectionIndex[index]] = newSlotProgramName = String.format(MC3000Dialog.STRING_FORMAT_02d_s, MC3000Dialog.this.lastSelectionIndex[index] + 1, tmpName.substring(7, 40).trim());
                        programmNameCombo.setText(newSlotProgramName);
                        programmNameCombo.setItem(MC3000Dialog.this.lastSelectionIndex[index], newSlotProgramName);
                        MC3000Dialog.this.mc3000Setup.getProgram().get(MC3000Dialog.this.lastSelectionIndex[index]).setName(MC3000Dialog.this.programmNames[MC3000Dialog.this.lastSelectionIndex[index]].substring(7).trim());
                        switch (index) {
                            case 0: {
                                MC3000Dialog.this.mc3000Setup.getProgram().get(MC3000Dialog.this.lastSelectionIndex[index]).getSetupData().setValue(MC3000Dialog.this.slotSettings_0.getBuffer());
                                break;
                            }
                            case 1: {
                                MC3000Dialog.this.mc3000Setup.getProgram().get(MC3000Dialog.this.lastSelectionIndex[index]).getSetupData().setValue(MC3000Dialog.this.slotSettings_1.getBuffer());
                                break;
                            }
                            case 2: {
                                MC3000Dialog.this.mc3000Setup.getProgram().get(MC3000Dialog.this.lastSelectionIndex[index]).getSetupData().setValue(MC3000Dialog.this.slotSettings_2.getBuffer());
                                break;
                            }
                            case 3: {
                                MC3000Dialog.this.mc3000Setup.getProgram().get(MC3000Dialog.this.lastSelectionIndex[index]).getSetupData().setValue(MC3000Dialog.this.slotSettings_3.getBuffer());
                                break;
                            }
                        }
                        for (CCombo combo : MC3000Dialog.this.programmNameCombos) {
                            combo.setItem(MC3000Dialog.this.lastSelectionIndex[index], newSlotProgramName);
                            if (combo.getSelectionIndex() != MC3000Dialog.this.lastSelectionIndex[index]) continue;
                            combo.setText(newSlotProgramName);
                        }
                        MC3000Dialog.this.saveButton.setEnabled(true);
                    }
                    catch (Exception e) {
                        MC3000Dialog.this.application.openMessageDialog(MC3000Dialog.this.dialogShell, Messages.getString((String)"GDE_MSGE0007", (Object[])new String[]{e.getMessage()}));
                    }
                }
            }
        });
        label0.setLayoutData((Object)new RowData(350, 25));
        label0.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        byte sysTemperatureUnit = this.systemSettings != null ? this.systemSettings.getTemperatureUnit() : (byte)0;
        switch (index) {
            case 0: {
                label0.setText(this.slotSettings_0 != null ? this.slotSettings_0.toString4View() : Messages.getString((String)"GDE_MSGT3654"));
                label0.setToolTipText(this.slotSettings_0 != null ? this.slotSettings_0.toString4Tip(true, sysTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654"));
                break;
            }
            case 1: {
                label0.setText(this.slotSettings_1 != null ? this.slotSettings_1.toString4View() : Messages.getString((String)"GDE_MSGT3654"));
                label0.setToolTipText(this.slotSettings_1 != null ? this.slotSettings_1.toString4Tip(true, sysTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654"));
                break;
            }
            case 2: {
                label0.setText(this.slotSettings_2 != null ? this.slotSettings_2.toString4View() : Messages.getString((String)"GDE_MSGT3654"));
                label0.setToolTipText(this.slotSettings_2 != null ? this.slotSettings_2.toString4Tip(true, sysTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654"));
                break;
            }
            case 3: {
                label0.setText(this.slotSettings_3 != null ? this.slotSettings_3.toString4View() : Messages.getString((String)"GDE_MSGT3654"));
                label0.setToolTipText(this.slotSettings_3 != null ? this.slotSettings_3.toString4Tip(true, sysTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654"));
                break;
            }
        }
        writeButton.setLayoutData((Object)new RowData(110, 22));
        writeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        writeButton.setText(Messages.getString((String)"GDE_MSGT3656"));
        writeButton.setEnabled(false);
        writeButton.setToolTipText(Messages.getString((String)"GDE_MSGT3657"));
        writeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(java.util.logging.Level.FINEST, "writeButton.widgetSelected, event=" + String.valueOf(evt));
                try {
                    if (!MC3000Dialog.this.usbPort.isConnected()) {
                        MC3000Dialog.this.usbPort.openUsbPort();
                        MC3000Dialog.this.isConnectedByButton = true;
                    }
                    int firmware = MC3000Dialog.this.systemSettings.getFirmwareVersionAsInt();
                    byte systemTemperatureUnit = MC3000Dialog.this.systemSettings != null ? MC3000Dialog.this.systemSettings.getTemperatureUnit() : (byte)0;
                    switch (index) {
                        case 0: {
                            byte[] newProgramBuffer = MC3000Dialog.this.slotSettings_0.getBuffer((byte)0, firmware, systemTemperatureUnit);
                            MC3000Dialog.this.usbPort.setSlotProgram(newProgramBuffer);
                            MC3000 mC3000 = MC3000Dialog.this.device;
                            Objects.requireNonNull(mC3000);
                            MC3000Dialog.this.slotSettings_0 = new MC3000.SlotSettings(mC3000, MC3000Dialog.this.usbPort.getSlotData(MC3000UsbPort.QuerySlotData.SLOT_0.value()), firmware);
                            MC3000Dialog.this.programLables[index].setText(MC3000Dialog.this.slotSettings_0 != null ? MC3000Dialog.this.slotSettings_0.toString4View() : Messages.getString((String)"GDE_MSGT3654"));
                            MC3000Dialog.this.programLables[index].setToolTipText(MC3000Dialog.this.slotSettings_0 != null ? MC3000Dialog.this.slotSettings_0.toString4Tip(true, systemTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654"));
                            break;
                        }
                        case 1: {
                            byte[] newProgramBuffer = MC3000Dialog.this.slotSettings_1.getBuffer((byte)1, firmware, systemTemperatureUnit);
                            MC3000Dialog.this.usbPort.setSlotProgram(newProgramBuffer);
                            MC3000 mC3000 = MC3000Dialog.this.device;
                            Objects.requireNonNull(mC3000);
                            MC3000Dialog.this.slotSettings_1 = new MC3000.SlotSettings(mC3000, MC3000Dialog.this.usbPort.getSlotData(MC3000UsbPort.QuerySlotData.SLOT_1.value()), firmware);
                            MC3000Dialog.this.programLables[index].setText(MC3000Dialog.this.slotSettings_1 != null ? MC3000Dialog.this.slotSettings_1.toString4View() : Messages.getString((String)"GDE_MSGT3654"));
                            MC3000Dialog.this.programLables[index].setToolTipText(MC3000Dialog.this.slotSettings_1 != null ? MC3000Dialog.this.slotSettings_1.toString4Tip(true, systemTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654"));
                            break;
                        }
                        case 2: {
                            byte[] newProgramBuffer = MC3000Dialog.this.slotSettings_2.getBuffer((byte)2, firmware, systemTemperatureUnit);
                            MC3000Dialog.this.usbPort.setSlotProgram(newProgramBuffer);
                            MC3000 mC3000 = MC3000Dialog.this.device;
                            Objects.requireNonNull(mC3000);
                            MC3000Dialog.this.slotSettings_2 = new MC3000.SlotSettings(mC3000, MC3000Dialog.this.usbPort.getSlotData(MC3000UsbPort.QuerySlotData.SLOT_2.value()), firmware);
                            MC3000Dialog.this.programLables[index].setText(MC3000Dialog.this.slotSettings_2 != null ? MC3000Dialog.this.slotSettings_2.toString4View() : Messages.getString((String)"GDE_MSGT3654"));
                            MC3000Dialog.this.programLables[index].setToolTipText(MC3000Dialog.this.slotSettings_2 != null ? MC3000Dialog.this.slotSettings_2.toString4Tip(true, systemTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654"));
                            break;
                        }
                        case 3: {
                            byte[] newProgramBuffer = MC3000Dialog.this.slotSettings_3.getBuffer((byte)3, firmware, systemTemperatureUnit);
                            MC3000Dialog.this.usbPort.setSlotProgram(newProgramBuffer);
                            MC3000 mC3000 = MC3000Dialog.this.device;
                            Objects.requireNonNull(mC3000);
                            MC3000Dialog.this.slotSettings_3 = new MC3000.SlotSettings(mC3000, MC3000Dialog.this.usbPort.getSlotData(MC3000UsbPort.QuerySlotData.SLOT_3.value()), firmware);
                            MC3000Dialog.this.programLables[index].setText(MC3000Dialog.this.slotSettings_3 != null ? MC3000Dialog.this.slotSettings_3.toString4View() : Messages.getString((String)"GDE_MSGT3654"));
                            MC3000Dialog.this.programLables[index].setToolTipText(MC3000Dialog.this.slotSettings_3 != null ? MC3000Dialog.this.slotSettings_3.toString4Tip(true, systemTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654"));
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    log.log(java.util.logging.Level.WARNING, e.getMessage(), e);
                    MC3000Dialog.this.application.openMessageDialogAsync(e.getMessage());
                }
            }
        });
        Button copyClipBoardButton = new Button((Composite)slot, 0x1000008);
        copyClipBoardButton.setLayoutData((Object)new RowData(90, 22));
        copyClipBoardButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        copyClipBoardButton.setText(Messages.getString((String)"GDE_MSGT3677"));
        copyClipBoardButton.setToolTipText(Messages.getString((String)"GDE_MSGT3678"));
        copyClipBoardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                byte systemTemperatureUnit = MC3000Dialog.this.systemSettings != null ? MC3000Dialog.this.systemSettings.getTemperatureUnit() : (byte)0;
                String data = new String();
                switch (index) {
                    case 0: {
                        data = MC3000Dialog.this.slotSettings_0 != null ? MC3000Dialog.this.slotSettings_0.toString4Tip(false, systemTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654");
                        break;
                    }
                    case 1: {
                        data = MC3000Dialog.this.slotSettings_1 != null ? MC3000Dialog.this.slotSettings_1.toString4Tip(false, systemTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654");
                        break;
                    }
                    case 2: {
                        data = MC3000Dialog.this.slotSettings_2 != null ? MC3000Dialog.this.slotSettings_2.toString4Tip(false, systemTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654");
                        break;
                    }
                    case 3: {
                        data = MC3000Dialog.this.slotSettings_3 != null ? MC3000Dialog.this.slotSettings_3.toString4Tip(false, systemTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654");
                        break;
                    }
                }
                if (data.length() > 0) {
                    MC3000Dialog.this.clipboard.setContents(new Object[]{data}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        });
        Button loadButton = new Button((Composite)slot, 0x1000008);
        loadButton.setLayoutData((Object)new RowData(110, 22));
        loadButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        loadButton.setText(Messages.getString((String)"GDE_MSGT3658"));
        loadButton.setToolTipText(Messages.getString((String)"GDE_MSGT3659"));
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(java.util.logging.Level.FINEST, "loadButton.widgetSelected, event=" + String.valueOf(evt));
                try {
                    if (!MC3000Dialog.this.usbPort.isConnected()) {
                        MC3000Dialog.this.usbPort.openUsbPort();
                        MC3000Dialog.this.isConnectedByButton = true;
                    }
                    byte systemTemperatureUnit = MC3000Dialog.this.systemSettings != null ? MC3000Dialog.this.systemSettings.getTemperatureUnit() : (byte)0;
                    switch (index) {
                        case 0: {
                            if (MC3000Dialog.this.usbPort.isConnected()) {
                                MC3000 mC3000 = MC3000Dialog.this.device;
                                Objects.requireNonNull(mC3000);
                                MC3000Dialog.this.slotSettings_0 = new MC3000.SlotSettings(mC3000, MC3000Dialog.this.usbPort.getSlotData(MC3000UsbPort.QuerySlotData.SLOT_0.value()), MC3000Dialog.this.systemSettings.getFirmwareVersionAsInt());
                            }
                            label0.setText(MC3000Dialog.this.slotSettings_0 != null ? MC3000Dialog.this.slotSettings_0.toString4View() : Messages.getString((String)"GDE_MSGT3654"));
                            label0.setToolTipText(MC3000Dialog.this.slotSettings_0 != null ? MC3000Dialog.this.slotSettings_0.toString4Tip(true, systemTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654"));
                            break;
                        }
                        case 1: {
                            if (MC3000Dialog.this.usbPort.isConnected()) {
                                MC3000 mC3000 = MC3000Dialog.this.device;
                                Objects.requireNonNull(mC3000);
                                MC3000Dialog.this.slotSettings_1 = new MC3000.SlotSettings(mC3000, MC3000Dialog.this.usbPort.getSlotData(MC3000UsbPort.QuerySlotData.SLOT_1.value()), MC3000Dialog.this.systemSettings.getFirmwareVersionAsInt());
                            }
                            label0.setText(MC3000Dialog.this.slotSettings_1 != null ? MC3000Dialog.this.slotSettings_1.toString4View() : Messages.getString((String)"GDE_MSGT3654"));
                            label0.setToolTipText(MC3000Dialog.this.slotSettings_1 != null ? MC3000Dialog.this.slotSettings_1.toString4Tip(true, systemTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654"));
                            break;
                        }
                        case 2: {
                            if (MC3000Dialog.this.usbPort.isConnected()) {
                                MC3000 mC3000 = MC3000Dialog.this.device;
                                Objects.requireNonNull(mC3000);
                                MC3000Dialog.this.slotSettings_2 = new MC3000.SlotSettings(mC3000, MC3000Dialog.this.usbPort.getSlotData(MC3000UsbPort.QuerySlotData.SLOT_2.value()), MC3000Dialog.this.systemSettings.getFirmwareVersionAsInt());
                            }
                            label0.setText(MC3000Dialog.this.slotSettings_2 != null ? MC3000Dialog.this.slotSettings_2.toString4View() : Messages.getString((String)"GDE_MSGT3654"));
                            label0.setToolTipText(MC3000Dialog.this.slotSettings_2 != null ? MC3000Dialog.this.slotSettings_2.toString4Tip(true, systemTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654"));
                            break;
                        }
                        case 3: {
                            if (MC3000Dialog.this.usbPort.isConnected()) {
                                MC3000 mC3000 = MC3000Dialog.this.device;
                                Objects.requireNonNull(mC3000);
                                MC3000Dialog.this.slotSettings_3 = new MC3000.SlotSettings(mC3000, MC3000Dialog.this.usbPort.getSlotData(MC3000UsbPort.QuerySlotData.SLOT_3.value()), MC3000Dialog.this.systemSettings.getFirmwareVersionAsInt());
                            }
                            label0.setText(MC3000Dialog.this.slotSettings_3 != null ? MC3000Dialog.this.slotSettings_3.toString4View() : Messages.getString((String)"GDE_MSGT3654"));
                            label0.setToolTipText(MC3000Dialog.this.slotSettings_3 != null ? MC3000Dialog.this.slotSettings_3.toString4Tip(true, systemTemperatureUnit) : Messages.getString((String)"GDE_MSGT3654"));
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    log.log(java.util.logging.Level.WARNING, e.getMessage(), e);
                    MC3000Dialog.this.application.openMessageDialogAsync(e.getMessage());
                }
            }
        });
    }

    public void enableSaveButton(boolean enable) {
        this.saveButton.setEnabled(enable);
    }

    public Integer getTabFolderSelectionIndex() {
        return this.tabFolderSelectionIndex;
    }

    private void createMC3000Setup() {
        this.mc3000Setup = new ObjectFactory().createMC3000Type();
        List<ProgramType> devicePrograms = this.mc3000Setup.getProgram();
        if (devicePrograms.size() < 30) {
            for (int i = 0; i < 30; ++i) {
                ProgramType program = new ObjectFactory().createProgramType();
                ProgramType.SetupData setupData = new ObjectFactory().createProgramTypeSetupData();
                setupData.setValue(new byte[64]);
                program.setSetupData(setupData);
                program.setName(this.programmNames[i]);
                devicePrograms.add(program);
            }
        }
        this.saveMc3000SetupData();
    }

    private void saveMc3000SetupData() {
        try {
            long startTime = new Date().getTime();
            Marshaller marshaller = this.jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.noNamespaceSchemaLocation", (Object)MC3000_XSD);
            marshaller.marshal((Object)this.mc3000Setup, (OutputStream)new FileOutputStream(new File(Settings.getApplHomePath() + "/MC3000_Slot_Programs.xml")));
            log.log(Level.TIME, "write program setup XML time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - startTime)));
            if (this.saveButton != null && !this.saveButton.isDisposed()) {
                this.saveButton.setEnabled(false);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

