/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.config.Settings;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.InputTypes;
import gde.device.graupner.UltraTrioPlus14;
import gde.device.graupner.Ultramat;
import gde.exception.DataInconsitsentException;
import gde.log.Level;
import gde.messages.Messages;
import java.io.FileNotFoundException;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

public class UltraTrioPlus16S
extends UltraTrioPlus14 {
    static final Logger logg = Logger.getLogger(UltraTrioPlus16S.class.getName());

    public UltraTrioPlus16S(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.graupner.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.USAGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2200"), Messages.getString((String)"GDE_MSGT2201"), Messages.getString((String)"GDE_MSGT2202"), Messages.getString((String)"GDE_MSGT2203"), Messages.getString((String)"GDE_MSGI2206"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2207"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2222"), Messages.getString((String)"GDE_MSGT2222")};
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
        this.dialog = null;
    }

    public UltraTrioPlus16S(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.graupner.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.USAGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2200"), Messages.getString((String)"GDE_MSGT2201"), Messages.getString((String)"GDE_MSGT2202"), Messages.getString((String)"GDE_MSGT2203"), Messages.getString((String)"GDE_MSGI2206"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2207"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2222"), Messages.getString((String)"GDE_MSGT2222")};
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
        this.dialog = null;
    }

    @Override
    public int getLovDataByteSize() {
        return 126;
    }

    @Override
    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int deviceDataBufferSize = Math.abs(this.getDataBlockSize(InputTypes.SERIAL_IO));
        int[] points = new int[this.getNumberOfMeasurements(recordSet.getChannelConfigNumber())];
        int offset = 4;
        int progressCycle = 0;
        int lovDataSize = this.getLovDataByteSize();
        int outputChannel = recordSet.getChannelConfigNumber();
        if (dataBuffer[offset] == 12) {
            byte[] convertBuffer = new byte[deviceDataBufferSize];
            if (doUpdateProgressBar) {
                this.application.setProgress(progressCycle, sThreadId);
            }
            for (int i = 0; i < recordDataSize; ++i) {
                if (outputChannel == 1) {
                    System.arraycopy(dataBuffer, offset + i * lovDataSize, convertBuffer, 0, deviceDataBufferSize);
                } else if (outputChannel == 2) {
                    System.arraycopy(dataBuffer, offset + i * lovDataSize, convertBuffer, 0, 9);
                    System.arraycopy(dataBuffer, 57 + offset + i * lovDataSize, convertBuffer, 9, 2);
                    convertBuffer[12] = 48;
                    convertBuffer[11] = 48;
                    System.arraycopy(dataBuffer, 59 + offset + i * lovDataSize, convertBuffer, 13, 24);
                } else if (outputChannel == 3) {
                    System.arraycopy(dataBuffer, offset + i * lovDataSize, convertBuffer, 0, 9);
                    System.arraycopy(dataBuffer, 83 + offset + i * lovDataSize, convertBuffer, 9, 2);
                    convertBuffer[12] = 48;
                    convertBuffer[11] = 48;
                    System.arraycopy(dataBuffer, 85 + offset + i * lovDataSize, convertBuffer, 13, 24);
                }
                if (doUpdateProgressBar && i % 50 == 0) {
                    this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
                }
                recordSet.addPoints(this.convertDataBytes(points, convertBuffer));
            }
            recordSet.setTimeStep_ms(this.getAverageTimeStep_ms() != null ? this.getAverageTimeStep_ms() : 1000.0);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        this.updateVisibilityStatus(recordSet, true);
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        if (recordSet.getChannelConfigNumber() == 1) {
            for (int i = 0; i < recordDataSize; ++i) {
                int maxVotage = Integer.MIN_VALUE;
                int minVotage = Integer.MAX_VALUE;
                logg.log(java.util.logging.Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
                System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
                points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
                points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
                points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
                points[3] = Double.valueOf((double)points[0] / 1000.0 * (double)points[1]).intValue();
                points[4] = Double.valueOf((double)points[0] / 1000.0 * (double)points[2]).intValue();
                points[5] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
                points[6] = 0;
                int j = 0;
                int k = 0;
                while (j < 6) {
                    points[j + 7] = ((convertBuffer[k + 16] & 0xFF) << 24) + ((convertBuffer[k + 17] & 0xFF) << 16) + ((convertBuffer[k + 18] & 0xFF) << 8) + ((convertBuffer[k + 19] & 0xFF) << 0);
                    if (points[j + 7] > 0) {
                        maxVotage = points[j + 7] > maxVotage ? points[j + 7] : maxVotage;
                        minVotage = points[j + 7] < minVotage ? points[j + 7] : minVotage;
                    }
                    ++j;
                    k += 4;
                }
                points[6] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                recordSet.addPoints(points);
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
            }
        } else {
            for (int i = 0; i < recordDataSize; ++i) {
                int maxVotage = Integer.MIN_VALUE;
                int minVotage = Integer.MAX_VALUE;
                logg.log(java.util.logging.Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
                System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
                points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
                points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
                points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
                points[3] = Double.valueOf((double)points[0] / 1000.0 * (double)points[1]).intValue();
                points[4] = Double.valueOf((double)points[0] / 1000.0 * (double)points[2]).intValue();
                points[5] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
                points[6] = 0;
                int j = 0;
                int k = 0;
                while (j < 3) {
                    points[j + 7] = ((convertBuffer[k + 16] & 0xFF) << 24) + ((convertBuffer[k + 17] & 0xFF) << 16) + ((convertBuffer[k + 18] & 0xFF) << 8) + ((convertBuffer[k + 19] & 0xFF) << 0);
                    if (points[j + 7] > 0) {
                        maxVotage = points[j + 7] > maxVotage ? points[j + 7] : maxVotage;
                        minVotage = points[j + 7] < minVotage ? points[j + 7] : minVotage;
                    }
                    ++j;
                    k += 4;
                }
                points[6] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                recordSet.addPoints(points);
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
            }
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public Ultramat.GraupnerDeviceType getDeviceTypeIdentifier() {
        return Ultramat.GraupnerDeviceType.UltraTrioPlus16S;
    }

    @Override
    public void matchBatteryMemory2ObjectKey(String batteryMemoryName) {
    }

    @Override
    public boolean isProcessing(int outletNum, byte[] dataBuffer) {
        if (outletNum == 1) {
            try {
                int operationMode1 = this.getProcessingMode(dataBuffer);
                if (log.isLoggable(java.util.logging.Level.FINE)) {
                    log.log(java.util.logging.Level.FINE, "operationMode1 = " + operationMode1);
                }
                return operationMode1 > 0 && operationMode1 < 4;
            }
            catch (NumberFormatException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
        }
        if (outletNum == 2) {
            try {
                int operationMode2 = Integer.parseInt(String.format("%c%c", Character.valueOf((char)dataBuffer[57]), Character.valueOf((char)dataBuffer[58])), 16);
                if (log.isLoggable(java.util.logging.Level.FINE)) {
                    log.log(java.util.logging.Level.FINE, "operationMode1 = " + operationMode2);
                }
                return operationMode2 > 0 && operationMode2 < 4;
            }
            catch (NumberFormatException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
        }
        if (outletNum == 3) {
            try {
                int operationMode3 = Integer.parseInt(String.format("%c%c", Character.valueOf((char)dataBuffer[83]), Character.valueOf((char)dataBuffer[84])), 16);
                if (log.isLoggable(java.util.logging.Level.FINE)) {
                    log.log(java.util.logging.Level.FINE, "operationMode1 = " + operationMode3);
                }
                return operationMode3 > 0 && operationMode3 < 4;
            }
            catch (NumberFormatException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
        }
        return false;
    }
}

