/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.MeasurementPropertyTypes;
import gde.device.MeasurementType;
import gde.device.PropertyType;
import gde.device.smmodellbau.UniLog2;
import gde.device.smmodellbau.UniLog2Dialog;
import gde.device.smmodellbau.UniLog2LiveGatherer;
import gde.device.smmodellbau.UniLog2SerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.io.LogViewReader;
import gde.io.NMEAParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

public class UniSensE
extends UniLog2
implements IDevice {
    static final Logger log = Logger.getLogger(UniSensE.class.getName());
    static final String SM_UNILOG_2_INI = "SM UniLog 2.ini";
    static final String SM_UNILOG_2_INI_PATH = "SM UniLog 2 setup";
    static final String SM_UNILOG_2_DIR_STUB = "UniLog";
    static String selectedSetupFilePath;
    final DataExplorer application;
    final Channels channels;
    final UniLog2Dialog dialog;
    final UniLog2SerialPort serialPort;
    UniLog2LiveGatherer gathererThread;

    public UniSensE(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.smmodellbau.unilog2.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.serialPort = this.application != null ? new UniLog2SerialPort(this, this.application) : new UniLog2SerialPort(this, null);
        this.channels = Channels.getInstance();
        this.dialog = new UniLog2Dialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
        UniLog2SerialPort.TIME_OUT_MS = this.getReadTimeOut();
    }

    public UniSensE(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.smmodellbau.unilog2.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.serialPort = this.application != null ? new UniLog2SerialPort(this, this.application) : new UniLog2SerialPort(this, null);
        this.channels = Channels.getInstance();
        this.dialog = new UniLog2Dialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
        UniLog2SerialPort.TIME_OUT_MS = this.getReadTimeOut();
    }

    @Override
    public UniLog2SerialPort getCommunicationPort() {
        return this.serialPort;
    }

    @Override
    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    @Override
    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    @Override
    public int getLovDataByteSize() {
        return 0;
    }

    @Override
    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        block6: {
            NMEAParser data = new NMEAParser(this.getDataBlockLeader(), this.getDataBlockSeparator().value(), this.getDataBlockCheckSumType(), Math.abs(this.getDataBlockSize(InputTypes.FILE_IO)), (IDevice)this, this.channels.getActiveChannelNumber(), this.getUTCdelta());
            String sThreadId = String.format("%06d", Thread.currentThread().threadId());
            int progressCycle = 0;
            if (doUpdateProgressBar) {
                this.application.setProgress(progressCycle, sThreadId);
            }
            try {
                int lastLength = 0;
                for (int i = 0; i < recordDataSize; ++i) {
                    byte[] subLengthBytes = new byte[4];
                    System.arraycopy(dataBuffer, lastLength, subLengthBytes, 0, 4);
                    int subLenght = LogViewReader.parse2Int((byte[])subLengthBytes) - 8;
                    byte[] lineBuffer = new byte[subLenght];
                    System.arraycopy(dataBuffer, 4 + lastLength, lineBuffer, 0, subLenght);
                    String textInput = new String(lineBuffer, "ISO-8859-1");
                    StringTokenizer st = new StringTokenizer(textInput);
                    Vector<String> vec = new Vector<String>();
                    while (st.hasMoreTokens()) {
                        vec.add(st.nextToken("\r\n"));
                    }
                    data.parse(vec, vec.size());
                    lastLength += subLenght + 12;
                    recordSet.addNoneCalculationRecordsPoints(data.getValues(), (double)data.getTime_ms());
                    if (!doUpdateProgressBar || i % 50 != 0) continue;
                    this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
                }
                this.updateVisibilityStatus(recordSet, true);
                if (doUpdateProgressBar) {
                    this.application.setProgress(100, sThreadId);
                }
            }
            catch (Exception e) {
                String msg = e.getMessage() + Messages.getString((String)"GDE_MSGW0543");
                log.log(Level.WARNING, msg, e);
                this.application.openMessageDialog(msg);
                if (!doUpdateProgressBar) break block6;
                this.application.setProgress(0, sThreadId);
            }
        }
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        return points;
    }

    @Override
    public int[] convertLiveData(int[] points, String stringBuffer) {
        String[] dataArray = StringHelper.splitString((String)stringBuffer, (String)"\r", (String)"\n");
        for (int i = 2; i < dataArray.length; ++i) {
            try {
                switch (i) {
                    case 2: {
                        points[2] = (int)(Double.parseDouble(dataArray[i].split("A")[0].trim()) * 1000.0);
                        points[15] = (int)(Double.parseDouble(dataArray[i].split("A")[1].split("m")[0].trim()) * 1000.0);
                        break;
                    }
                    case 3: {
                        points[1] = (int)(Double.parseDouble(dataArray[i].split("V")[0].trim()) * 1000.0);
                        points[16] = (int)(Double.parseDouble(dataArray[i].split("V")[1].split("m")[0].trim()) * 1000.0);
                        break;
                    }
                    case 4: {
                        points[4] = (int)(Double.parseDouble(dataArray[i].split("W")[0].trim()) * 1000.0);
                        points[13] = (int)(Double.parseDouble(dataArray[i].split("W")[1].split("r")[0].trim()) * 1000.0);
                        break;
                    }
                    case 5: {
                        points[3] = (int)(Double.parseDouble(dataArray[i].split("m")[0].trim()) * 1000.0);
                        points[0] = (int)(Double.parseDouble(dataArray[i].split("h")[1].split("V")[0].trim()) * 1000.0);
                        break;
                    }
                    case 6: {
                        points[5] = (int)(Double.parseDouble(dataArray[i].split("W")[0].trim()) * 1000.0);
                        break;
                    }
                    case 7: {
                        points[22] = (int)(Double.parseDouble(dataArray[i].split("us")[0].trim()) * 1000.0);
                        points[23] = (int)(Double.parseDouble(dataArray[i].split("us")[1].replace("|", "").substring(3).trim()) * 1000.0);
                        break;
                    }
                    case 10: {
                        points[7] = (int)(Double.parseDouble(dataArray[i].split("V1")[0].trim()) * 1000.0);
                        points[8] = (int)(Double.parseDouble(dataArray[i].split("V1")[1].split("V")[0].trim()) * 1000.0);
                        break;
                    }
                    case 11: {
                        points[9] = (int)(Double.parseDouble(dataArray[i].split("V3")[0].trim()) * 1000.0);
                        points[10] = (int)(Double.parseDouble(dataArray[i].split("V3")[1].split("V")[0].trim()) * 1000.0);
                        break;
                    }
                    case 12: {
                        points[11] = (int)(Double.parseDouble(dataArray[i].split("V5")[0].trim()) * 1000.0);
                        points[12] = (int)(Double.parseDouble(dataArray[i].split("V5")[1].split("V")[0].trim()) * 1000.0);
                        break;
                    }
                    case 13: {
                        String tmpValueA1 = dataArray[i].substring(2).trim();
                        String string = tmpValueA1 = tmpValueA1.contains("|") ? tmpValueA1.substring(0, tmpValueA1.indexOf(124)) + tmpValueA1.substring(tmpValueA1.indexOf(124) + 1) : tmpValueA1;
                        if (tmpValueA1.contains("mV")) {
                            points[17] = (int)(Double.parseDouble(tmpValueA1.split("mV")[0].trim()) * 1000.0);
                            break;
                        }
                        if (tmpValueA1.contains("`C")) {
                            points[17] = (int)(Double.parseDouble(tmpValueA1.split("`C")[0].trim()) * 1000.0);
                            break;
                        }
                        if (!tmpValueA1.contains("km/h")) break;
                        points[17] = (int)(Double.parseDouble(tmpValueA1.split("km/h")[0].trim()) * 1000.0);
                        break;
                    }
                    case 14: {
                        String tmpValueA2 = dataArray[i].substring(2).trim();
                        String string = tmpValueA2 = tmpValueA2.contains("|") ? tmpValueA2.substring(0, tmpValueA2.indexOf(124)) + tmpValueA2.substring(tmpValueA2.indexOf(124) + 1) : tmpValueA2;
                        if (tmpValueA2.contains("mV")) {
                            points[18] = (int)(Double.parseDouble(tmpValueA2.split("mV")[0].trim()) * 1000.0);
                            break;
                        }
                        if (tmpValueA2.contains("`C")) {
                            points[18] = (int)(Double.parseDouble(tmpValueA2.split("`C")[0].trim()) * 1000.0);
                            break;
                        }
                        if (!tmpValueA2.contains("km/h")) break;
                        points[18] = (int)(Double.parseDouble(tmpValueA2.split("km/h")[0].trim()) * 1000.0);
                        break;
                    }
                    case 15: {
                        String tmpValueA3 = dataArray[i].substring(2).trim();
                        String string = tmpValueA3 = tmpValueA3.contains("|") ? tmpValueA3.substring(0, tmpValueA3.indexOf(124)) + tmpValueA3.substring(tmpValueA3.indexOf(124) + 1) : tmpValueA3;
                        if (tmpValueA3.contains("mV")) {
                            points[19] = (int)(Double.parseDouble(tmpValueA3.split("mV")[0].trim()) * 1000.0);
                            break;
                        }
                        if (tmpValueA3.contains("`C")) {
                            points[19] = (int)(Double.parseDouble(tmpValueA3.split("`C")[0].trim()) * 1000.0);
                            break;
                        }
                        if (!tmpValueA3.contains("km/h")) break;
                        points[19] = (int)(Double.parseDouble(tmpValueA3.split("km/h")[0].trim()) * 1000.0);
                        break;
                    }
                    case 18: {
                        points[20] = (int)(Double.parseDouble(dataArray[i].substring(dataArray[i].lastIndexOf(" "), dataArray[i].length() - 3).trim()) * 1000.0);
                        break;
                    }
                    case 19: {
                        points[21] = (int)(Double.parseDouble(dataArray[i].substring(dataArray[i].lastIndexOf(" "), dataArray[i].length() - 2).trim()) * 1000.0);
                    }
                }
                continue;
            }
            catch (RuntimeException tmpValueA1) {
                // empty catch block
            }
        }
        int maxVotage = Integer.MIN_VALUE;
        int minVotage = Integer.MAX_VALUE;
        for (int i = 7; i <= 12; ++i) {
            if (points[i] <= 0) continue;
            maxVotage = points[i] > maxVotage ? points[i] : maxVotage;
            minVotage = points[i] < minVotage ? points[i] : minVotage;
        }
        points[6] = (maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0) * 1000;
        return points;
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int i;
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.getNoneCalculationRecordNames().length];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 4 * recordDataSize;
        byte[] timeStampBuffer = new byte[timeStampBufferSize];
        if (!recordSet.isTimeStepConstant()) {
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
            }
        }
        log.log(Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
        for (i = 0; i < recordDataSize; ++i) {
            log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((convertBuffer[0 + j * 4] & 0xFF) << 24) + ((convertBuffer[1 + j * 4] & 0xFF) << 16) + ((convertBuffer[2 + j * 4] & 0xFF) << 8) + ((convertBuffer[3 + j * 4] & 0xFF) << 0);
            }
            if (recordSet.isTimeStepConstant()) {
                recordSet.addNoneCalculationRecordsPoints(points);
            } else {
                recordSet.addNoneCalculationRecordsPoints(points, (double)((Integer)timeStamps.get(i)).intValue() / 10.0);
            }
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double offset = record.getOffset();
                double reduction = record.getReduction();
                double factor = record.getFactor();
                if (record.getOrdinal() == 15) {
                    PropertyType property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
                    boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
                    property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
                    boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
                    try {
                        if (subtractFirst) {
                            reduction = (double)record.getFirst().intValue() / 1000.0;
                        } else if (subtractLast) {
                            reduction = (double)record.getLast().intValue() / 1000.0;
                        }
                    }
                    catch (Throwable e) {
                        log.log(Level.SEVERE, record.getParent().getName() + " " + record.getName() + " " + e.getMessage());
                    }
                }
                dataTableRow[index + 1] = record.getDecimalFormat().format(offset + ((double)record.realGet(rowIndex).intValue() / 1000.0 - reduction) * factor);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    @Override
    public double translateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        if (record.getOrdinal() == 15) {
            PropertyType property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
            boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
            property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
            boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
            try {
                if (subtractFirst) {
                    reduction = (double)record.getFirst().intValue() / 1000.0;
                } else if (subtractLast) {
                    reduction = (double)record.getLast().intValue() / 1000.0;
                }
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, record.getAbstractParent().getName() + " " + record.getName() + " " + e.getMessage());
            }
        }
        double newValue = (value - reduction) * factor + offset;
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    @Override
    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        if (record.getOrdinal() == 15) {
            PropertyType property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
            boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
            property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
            boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
            try {
                if (subtractFirst) {
                    reduction = (double)record.getFirst().intValue() / 1000.0;
                } else if (subtractLast) {
                    reduction = (double)record.getLast().intValue() / 1000.0;
                }
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, record.getAbstractParent().getName() + " " + record.getName() + " " + e.getMessage());
            }
        }
        double newValue = (value - offset) / factor + reduction;
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    @Override
    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int channelConfigNumber = recordSet.getChannelConfigNumber();
        int displayableCounter = 0;
        String[] measurementNames = this.getMeasurementNames(channelConfigNumber);
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            MeasurementType measurement = this.getMeasurement(channelConfigNumber, i);
            log.log(Level.FINE, record.getName() + " = " + measurementNames[i]);
            if (record.isActive() != measurement.isActive()) {
                record.setActive(Boolean.valueOf(measurement.isActive()));
                record.setVisible(measurement.isActive());
                record.setDisplayable(measurement.isActive());
                log.log(Level.FINE, "switch " + record.getName() + " to " + measurement.isActive());
            }
            if (includeReasonableDataCheck) {
                record.setDisplayable(record.hasReasonableData() && measurement.isActive());
                log.log(Level.FINE, record.getName() + " ! hasReasonableData ");
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            log.log(Level.FINE, "add to displayable counter: " + record.getName());
            ++displayableCounter;
        }
        log.log(Level.FINER, "displayableCounter = " + displayableCounter);
        recordSet.setConfiguredDisplayable(displayableCounter);
    }

    @Override
    public void makeInActiveDisplayable(RecordSet recordSet) {
        Record record = recordSet.get(14);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "start data calculation for record = " + record.getName());
        }
        Record recordRevolution = recordSet.get(13);
        Record recordPower = recordSet.get(4);
        PropertyType property = record.getProperty(MeasurementPropertyTypes.PROP_N_100_W.value());
        int prop_n100W = property != null ? Integer.valueOf(property.getValue()) : 10000;
        property = recordRevolution.getProperty(MeasurementPropertyTypes.NUMBER_MOTOR.value());
        double numberMotor = property != null ? Double.valueOf(property.getValue()) : 1.0;
        Record recordCurrent = recordSet.get(2);
        for (int i = 0; i < recordRevolution.size(); ++i) {
            if (i > 1 && recordRevolution.get(i) > 100000 && recordCurrent.get(i) > 3000) {
                double motorPower = Math.pow((double)recordRevolution.get(i).intValue() / numberMotor / 1000.0 * 4.64 / (double)prop_n100W, 3.0) * 1000.0;
                double eta = motorPower * 100.0 / (double)recordPower.get(i).intValue();
                double d = eta > 100.0 && i > 1 ? (double)record.get(i - 1).intValue() / 1000.0 : (eta = eta < 0.0 ? 0.0 : eta);
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, String.format("current=%5.1f; recordRevolution=%5.0f; recordPower=%6.2f; motorPower=%6.2f eta=%5.1f", (double)recordCurrent.get(i).intValue() / 1000.0, (double)recordRevolution.get(i).intValue() / 1000.0, (double)recordPower.get(i).intValue() / 1000.0, motorPower / 1000.0, eta));
                }
                record.set(i, Integer.valueOf(Double.valueOf(eta * 1000.0).intValue()));
                record.setDisplayable(true);
            } else {
                record.set(i, Integer.valueOf(0));
            }
            if (!log.isLoggable(Level.FINEST)) continue;
            log.log(Level.FINEST, "adding value = " + record.get(i));
        }
        this.application.updateStatisticsData();
    }

    @Override
    public UniLog2Dialog getDialog() {
        return null;
    }

    @Override
    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION};
    }

    @Override
    public void open_closeCommPort() {
        if (this.serialPort != null) {
            if (!this.serialPort.isConnected()) {
                try {
                    Channel activChannel = Channels.getInstance().getActiveChannel();
                    if (activChannel != null) {
                        this.gathererThread = new UniLog2LiveGatherer(this.application, this, this.serialPort, this.dialog);
                        this.gathererThread.start();
                    }
                }
                catch (SerialPortException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                }
                catch (ApplicationConfigurationException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0010"));
                    this.application.getDeviceSelectionDialog().open();
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            } else {
                if (this.gathererThread != null && this.gathererThread.isAlive()) {
                    this.gathererThread.stopDataGathering();
                    this.gathererThread.interrupt();
                }
                WaitTimer.delay((long)1000L);
                this.serialPort.close();
            }
        }
    }
}

