/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.ui;

import gde.GDE;
import gde.histo.ui.AbstractChartComposite;
import gde.histo.ui.AbstractChartWindow;
import gde.histo.ui.GraphicsComposite;
import gde.histo.ui.SelectorComposite;
import gde.histo.ui.SummaryComposite;
import gde.log.Level;
import gde.log.Logger;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import java.util.Arrays;
import java.util.Optional;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public final class HistoSummaryWindow
extends AbstractChartWindow {
    private static final String $CLASS_NAME = HistoSummaryWindow.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    public static final int[] DEFAULT_CHART_WEIGHTS = new int[]{0, 1000};
    protected SashForm compositeSashForm;

    protected HistoSummaryWindow(CTabFolder currentDisplayTab, int style, int index) {
        super(currentDisplayTab, style, index);
    }

    public static AbstractChartWindow create(CTabFolder dataTab, int style, int position) {
        final HistoSummaryWindow window = new HistoSummaryWindow(dataTab, style, position);
        window.graphicSashForm = new SashForm((Composite)window.tabFolder, 256);
        window.setControl((Control)window.graphicSashForm);
        window.curveSelectorComposite = new SelectorComposite(window.graphicSashForm, window);
        window.compositeSashForm = new SashForm((Composite)window.graphicSashForm, 512);
        try {
            if (GDE.shell.getClientArea().width > 117) {
                window.graphicSashForm.setWeights(new int[]{117, GDE.shell.getClientArea().width - 117});
            }
        }
        catch (IllegalArgumentException e) {
            log.log(java.util.logging.Level.WARNING, "graphicSashForm.setWeights(this.sashFormWeights) failed!", e);
        }
        final SummaryComposite summaryComposite = new SummaryComposite(window.compositeSashForm, window);
        new GraphicsComposite(window.compositeSashForm, window);
        window.compositeSashForm.setWeights((int[])DEFAULT_CHART_WEIGHTS.clone());
        summaryComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                log.log(Level.FINEST, "height=", summaryComposite.getBounds().height);
                window.curveSelectorComposite.setVerticalBarVisible(window.compositeSashForm.getWeights()[0] == 0);
            }
        });
        window.setFont(SWTResourceManager.getFont((Control)DataExplorer.getInstance(), GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 3 : 1), 0));
        window.setText(Messages.getString("GDE_MSGT0792"));
        return window;
    }

    @Override
    protected GraphicsComposite getGraphicsComposite() {
        return Arrays.stream(this.compositeSashForm.getChildren()).filter(c -> c instanceof GraphicsComposite).map(c -> (GraphicsComposite)((Object)c)).findFirst().orElseThrow(UnsupportedOperationException::new);
    }

    protected Optional<SummaryComposite> getSummaryComposite() {
        return Arrays.stream(this.compositeSashForm.getChildren()).filter(c -> c instanceof SummaryComposite).map(c -> (SummaryComposite)((Object)c)).findFirst();
    }

    @Override
    public void scrollSummaryComposite() {
        if (this.windowActor.getTrailRecordSet() == null) {
            return;
        }
        if (this.windowActor.getTrailRecordSet().isSmartStatistics()) {
            int actualHeight;
            int summaryWeight;
            int fixedTotalHeight = this.getSummaryComposite().orElseGet(null).getFixedTotalHeight();
            int n = summaryWeight = fixedTotalHeight < (actualHeight = Arrays.stream(this.compositeSashForm.getChildren()).filter(c -> c instanceof AbstractChartComposite).mapToInt(c -> c.getBounds().height).sum()) ? fixedTotalHeight * 1000 / actualHeight : 1000;
            if (this.compositeSashForm.getWeights()[0] == summaryWeight) {
                this.resizeCompositeSashForm(new int[]{0, 1000});
            } else if (this.compositeSashForm.getWeights()[0] == 0) {
                this.resizeCompositeSashForm(new int[]{1000, 0});
            } else {
                this.resizeCompositeSashForm(new int[]{summaryWeight, 1000 - summaryWeight});
            }
        } else {
            this.setTemplateChart();
        }
    }

    @Override
    protected void setTemplateChart() {
        if (this.windowActor.getTrailRecordSet() == null) {
            return;
        }
        this.resizeCompositeSashForm(this.windowActor.getTrailRecordSet().getChartWeights());
    }

    public int[] getChartWeights() {
        return this.compositeSashForm.getWeights();
    }

    public void setChartWeights(final int[] chartWeights) {
        if (Thread.currentThread().threadId() == DataExplorer.getInstance().getThreadId()) {
            this.resizeCompositeSashForm(chartWeights);
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    HistoSummaryWindow.this.resizeCompositeSashForm(chartWeights);
                }
            });
        }
    }

    private void resizeCompositeSashForm(int[] chartWeights) {
        this.compositeSashForm.setWeights(chartWeights);
        this.curveSelectorComposite.setVerticalBarVisible(chartWeights[0] == 0);
    }

    @Override
    public void redrawGraphics(final boolean redrawCurveSelector) {
        if (Thread.currentThread().threadId() == DataExplorer.getInstance().getThreadId()) {
            if (redrawCurveSelector) {
                this.curveSelectorComposite.doUpdateCurveSelectorTable();
            }
            if (this.windowActor.getTrailRecordSet() == null) {
                return;
            }
            if (!this.windowActor.getTrailRecordSet().isSmartStatistics()) {
                this.setTemplateChart();
            }
            for (AbstractChartComposite c : this.getCharts()) {
                c.setFixedGraphicCanvas(this.curveSelectorComposite.getRealBounds());
                c.doRedrawGraphics();
                c.updateCaptions();
            }
            DataExplorer.getInstance().getPresentHistoExplorer().paintVolatileStatusMessage();
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (redrawCurveSelector) {
                        HistoSummaryWindow.this.curveSelectorComposite.doUpdateCurveSelectorTable();
                    }
                    if (HistoSummaryWindow.this.windowActor.getTrailRecordSet() == null) {
                        return;
                    }
                    if (!HistoSummaryWindow.this.windowActor.getTrailRecordSet().isSmartStatistics()) {
                        HistoSummaryWindow.this.setTemplateChart();
                    }
                    for (AbstractChartComposite c : HistoSummaryWindow.this.getCharts()) {
                        c.setFixedGraphicCanvas(HistoSummaryWindow.this.curveSelectorComposite.getRealBounds());
                        c.doRedrawGraphics();
                        c.updateCaptions();
                    }
                    DataExplorer.getInstance().getPresentHistoExplorer().paintVolatileStatusMessage();
                }
            });
        }
    }

    @Override
    public void enableGraphicsHeader(boolean enabled) {
        for (AbstractChartComposite c : this.getCharts()) {
            c.enableGraphicsHeader(enabled);
        }
    }

    @Override
    public void enableRecordSetComment(boolean enabled) {
        for (AbstractChartComposite c : this.getCharts()) {
            c.enableRecordSetComment(enabled);
        }
    }

    @Override
    public void clearHeaderAndComment() {
        for (AbstractChartComposite c : this.getCharts()) {
            c.clearHeaderAndComment();
        }
    }

    @Override
    public void enableGraphicsScale(boolean enabled) {
        for (AbstractChartComposite c : this.getCharts()) {
            c.enableGraphicsScale(enabled);
        }
    }

    @Override
    public void setCurveAreaBackground(Color curveAreaBackground) {
        for (AbstractChartComposite c : this.getCharts()) {
            c.curveAreaBackground = curveAreaBackground;
            c.doRedrawGraphics();
        }
    }

    @Override
    public void setCurveAreaBorderColor(Color borderColor) {
        for (AbstractChartComposite c : this.getCharts()) {
            c.curveAreaBorderColor = borderColor;
            c.graphicCanvas.redraw();
        }
    }

    @Override
    public void setTimeLineColor(Color timeLineColor) {
        for (AbstractChartComposite c : this.getCharts()) {
            c.graphicCanvas.redraw();
        }
    }

    @Override
    public void setHeaderCommentColor(Color headerCommentColor) {
        for (AbstractChartComposite c : this.getCharts()) {
            c.headerCommentColor = headerCommentColor;
            c.graphicsHeader.setForeground(headerCommentColor);
            c.graphicsHeader.redraw();
            c.recordSetComment.setForeground(headerCommentColor);
            c.recordSetComment.redraw();
        }
    }

    @Override
    public void setSurroundingBackground(Color surroundingBackground) {
        for (AbstractChartComposite c : this.getCharts()) {
            c.surroundingBackground = surroundingBackground;
            c.setBackground(surroundingBackground);
            c.graphicsHeader.setBackground(surroundingBackground);
            c.recordSetComment.setBackground(surroundingBackground);
            c.doRedrawGraphics();
        }
    }

    @Override
    public void enableCurveSelector(boolean enabled) {
        this.isCurveSelectorEnabled = enabled;
        if (enabled) {
            this.setSashFormWeights(this.curveSelectorComposite.getCompositeWidth());
        } else {
            this.setSashFormWeights(0);
        }
    }

    @Override
    public AbstractChartComposite[] getCharts() {
        return (AbstractChartComposite[])Arrays.stream(this.compositeSashForm.getChildren()).filter(c -> c instanceof AbstractChartComposite).map(c -> (AbstractChartComposite)((Object)c)).toArray(AbstractChartComposite[]::new);
    }

    @Override
    @Deprecated
    public void updateCaptions() {
        if (Thread.currentThread().threadId() == DataExplorer.getInstance().getThreadId()) {
            for (AbstractChartComposite c : this.getCharts()) {
                c.updateCaptions();
            }
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (AbstractChartComposite c : HistoSummaryWindow.this.getCharts()) {
                        c.updateCaptions();
                    }
                }
            });
        }
    }

    @Override
    public Image getContentAsImage() {
        Rectangle bounds = this.graphicSashForm.getClientArea();
        Image tabContentImage = new Image((Device)GDE.display, bounds.width, bounds.height);
        GC imageGC = new GC((Drawable)tabContentImage);
        this.graphicSashForm.print(imageGC);
        if (GDE.IS_MAC) {
            this.graphicSashForm.print(imageGC);
            Image graphics = this.getGraphicsComposite().getGraphicsPrintImage();
            if (graphics != null) {
                imageGC.drawImage(graphics, bounds.width - graphics.getBounds().width, 0);
                graphics.dispose();
            }
        }
        imageGC.dispose();
        return tabContentImage;
    }
}

