/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.recordings;

import gde.data.Record;
import gde.device.IChannelItem;
import gde.device.SettlementType;
import gde.histo.cache.DataTypes;
import gde.histo.cache.ExtendedVault;
import gde.histo.cache.HistoVault;
import gde.histo.datasources.HistoSet;
import gde.histo.recordings.SettlementTrailSelector;
import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailRecordSet;
import java.util.stream.DoubleStream;

public final class SettlementTrail
extends TrailRecord {
    private static final long serialVersionUID = 110124007964748556L;

    public SettlementTrail(int newOrdinal, IChannelItem settlementType, TrailRecordSet parent, int initialCapacity) {
        super(settlementType, newOrdinal, parent, initialCapacity);
        this.setTrailSelector();
    }

    @Override
    public void setTrailSelector() {
        this.trailSelector = new SettlementTrailSelector(this);
    }

    @Override
    protected boolean isAllowedBySetting() {
        return this.getParent().getAnalyzer().getSettings().isDisplaySettlements();
    }

    @Override
    public boolean isScaleVisible() {
        return this.getParent().getAnalyzer().getSettings().isDisplaySettlements() && super.isScaleVisible();
    }

    @Override
    public Integer getVaultPoint(ExtendedVault vault, int trailOrdinal) {
        return vault.getSettlementPoint(((SettlementType)this.channelItem).getSettlementId(), trailOrdinal);
    }

    @Override
    public boolean hasVaultOutliers(ExtendedVault vault) {
        return vault.hasSettlementOutliers(((SettlementType)this.channelItem).getSettlementId());
    }

    @Override
    public boolean hasVaultScraps(ExtendedVault vault) {
        return vault.hasSettlementScraps(((SettlementType)this.channelItem).getSettlementId());
    }

    @Override
    public DoubleStream getVaultOutliers(ExtendedVault vault) {
        return vault.getSettlementOutliers(((SettlementType)this.channelItem).getSettlementId()).mapToDouble(p -> HistoSet.decodeVaultValue(this.getChannelItem(), (double)p / 1000.0));
    }

    @Override
    public DoubleStream getVaultScraps(ExtendedVault vault) {
        return vault.getSettlementScraps(((SettlementType)this.channelItem).getSettlementId()).mapToDouble(p -> HistoSet.decodeVaultValue(this.getChannelItem(), (double)p / 1000.0));
    }

    @Override
    public Record.DataType getVaultDataType(HistoVault vault) {
        DataTypes dataType = vault.getSettlementDataType(((SettlementType)this.channelItem).getSettlementId());
        return dataType != null ? DataTypes.toDataType(dataType) : null;
    }
}

