/*
 * Decompiled with CFR 0.152.
 */
package gde.device.junsi;

import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.InputTypes;
import gde.device.junsi.iCharger;
import gde.exception.DataInconsitsentException;
import gde.io.DataParser;
import gde.log.Level;
import java.io.FileNotFoundException;
import javax.xml.bind.JAXBException;

public class CellLog8S
extends iCharger {
    public CellLog8S(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
    }

    public CellLog8S(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
    }

    @Override
    public int getLovDataByteSize() {
        return 78;
    }

    @Override
    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int deviceDataBufferSize = this.getLovDataByteSize();
        int[] points = new int[this.getNumberOfMeasurements(1)];
        int offset = 0;
        int progressCycle = 0;
        int lovDataSize = this.getLovDataByteSize();
        byte[] convertBuffer = new byte[deviceDataBufferSize];
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            lovDataSize = deviceDataBufferSize / 3;
            System.arraycopy(dataBuffer, offset, convertBuffer, 0, deviceDataBufferSize / 3);
            for (int j = deviceDataBufferSize / 3; j < deviceDataBufferSize && offset + j < dataBuffer.length; ++j) {
                convertBuffer[j] = dataBuffer[offset + j];
                ++lovDataSize;
                if (dataBuffer[offset + j] == 10 && dataBuffer[offset + j - 1] == 13) break;
            }
            if (i > 1) {
                recordSet.addPoints(this.convertDataBytes(points, convertBuffer));
            }
            offset += lovDataSize + 8;
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int maxVotage = Integer.MIN_VALUE;
        int minVotage = Integer.MAX_VALUE;
        DataParser data = new DataParser(this.getDataBlockTimeUnitFactor(), this.getDataBlockLeader(), this.getDataBlockSeparator().value(), null, null, Math.abs(this.getDataBlockSize(InputTypes.FILE_IO)), this.getDataBlockFormat(InputTypes.SERIAL_IO), false);
        int[] startLength = new int[]{0, 0};
        byte[] lineBuffer = null;
        try {
            this.setDataLineStartAndLength(dataBuffer, startLength);
            if (startLength[1] < 18) {
                return points;
            }
            lineBuffer = new byte[startLength[1]];
            System.arraycopy(dataBuffer, startLength[0], lineBuffer, 0, startLength[1]);
            data.parse(new String(lineBuffer), 1);
            int[] values = data.getValues();
            points[0] = values[8];
            for (int i = 0; i < 8; ++i) {
                points[i + 2] = values[i];
                if (points[i + 2] <= 0) continue;
                maxVotage = points[i + 2] > maxVotage ? points[i + 2] : maxVotage;
                minVotage = points[i + 2] < minVotage ? points[i + 2] : minVotage;
            }
            points[1] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage());
        }
        return points;
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
            points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
            int maxVotage = Integer.MIN_VALUE;
            int minVotage = Integer.MAX_VALUE;
            int j = 0;
            int k = 0;
            while (j < 8) {
                points[j + 2] = ((convertBuffer[k + 4] & 0xFF) << 24) + ((convertBuffer[k + 5] & 0xFF) << 16) + ((convertBuffer[k + 6] & 0xFF) << 8) + ((convertBuffer[k + 7] & 0xFF) << 0);
                if (points[j + 2] > 0) {
                    maxVotage = points[j + 2] > maxVotage ? points[j + 2] : maxVotage;
                    minVotage = points[j + 2] < minVotage ? points[j + 2] : minVotage;
                }
                ++j;
                k += 4;
            }
            points[1] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
            recordSet.addPoints(points);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        Record record;
        int i;
        recordSet.setAllDisplayable();
        for (i = 2; i < recordSet.size(); ++i) {
            record = recordSet.get(i);
            record.setDisplayable(record.hasReasonableData());
            if (!log.isLoggable(Level.FINER)) continue;
            log.log(Level.FINER, record.getName() + " setDisplayable=" + record.hasReasonableData());
        }
        if (log.isLoggable(Level.FINE)) {
            for (i = 0; i < recordSet.size(); ++i) {
                record = recordSet.get(i);
                log.log(Level.FINE, record.getName() + " isActive=" + record.isActive() + " isVisible=" + record.isVisible() + " isDisplayable=" + record.isDisplayable());
            }
        }
    }

    @Override
    public int getNumberOfLithiumCells() {
        return 8;
    }

    @Override
    public int[] getCellVoltageOrdinals() {
        return new int[]{0, -1};
    }
}

