/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Listener;

public class StyledTextDropTargetEffect
extends DropTargetEffect {
    static final int CARET_WIDTH = 2;
    static final int SCROLL_HYSTERESIS = 100;
    static final int SCROLL_TOLERANCE = 20;
    int currentOffset = -1;
    long scrollBeginTime;
    int scrollX = -1;
    int scrollY = -1;
    Listener paintListener = event -> {
        if (this.currentOffset != -1) {
            StyledText text2 = (StyledText)this.getControl();
            Point position = text2.getLocationAtOffset(this.currentOffset);
            int height = text2.getLineHeight(this.currentOffset);
            event.gc.setBackground(event.display.getSystemColor(2));
            event.gc.fillRectangle(position.x, position.y, 2, height);
        }
    };

    public StyledTextDropTargetEffect(StyledText styledText) {
        super(styledText);
    }

    @Override
    public void dragEnter(DropTargetEvent event) {
        this.currentOffset = -1;
        this.scrollBeginTime = 0L;
        this.scrollX = -1;
        this.scrollY = -1;
        this.getControl().removeListener(9, this.paintListener);
        this.getControl().addListener(9, this.paintListener);
    }

    @Override
    public void dragLeave(DropTargetEvent event) {
        StyledText text2 = (StyledText)this.getControl();
        if (this.currentOffset != -1) {
            this.refreshCaret(text2, this.currentOffset, -1);
        }
        text2.removeListener(9, this.paintListener);
        this.scrollBeginTime = 0L;
        this.scrollX = -1;
        this.scrollY = -1;
    }

    @Override
    public void dragOver(DropTargetEvent event) {
        int effect = event.feedback;
        StyledText text2 = (StyledText)this.getControl();
        Point pt = text2.getDisplay().map(null, text2, event.x, event.y);
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollY = -1;
            this.scrollX = -1;
        } else if (text2.getCharCount() == 0) {
            this.scrollBeginTime = 0L;
            this.scrollY = -1;
            this.scrollX = -1;
        } else if (this.scrollX != -1 && this.scrollY != -1 && this.scrollBeginTime != 0L && (pt.x >= this.scrollX && pt.x <= this.scrollX + 20 || pt.y >= this.scrollY && pt.y <= this.scrollY + 20)) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                int topPixel;
                int lineHeight;
                int leftPixel;
                Rectangle area = text2.getClientArea();
                GC gc = new GC(text2);
                FontMetrics fm = gc.getFontMetrics();
                gc.dispose();
                double charWidth = fm.getAverageCharacterWidth();
                int scrollAmount = (int)(10.0 * charWidth);
                if ((double)pt.x < (double)area.x + 3.0 * charWidth) {
                    leftPixel = text2.getHorizontalPixel();
                    text2.setHorizontalPixel(leftPixel - scrollAmount);
                }
                if ((double)pt.x > (double)area.width - 3.0 * charWidth) {
                    leftPixel = text2.getHorizontalPixel();
                    text2.setHorizontalPixel(leftPixel + scrollAmount);
                }
                if (pt.y < area.y + (lineHeight = text2.getLineHeight())) {
                    topPixel = text2.getTopPixel();
                    text2.setTopPixel(topPixel - lineHeight);
                }
                if (pt.y > area.height - lineHeight) {
                    topPixel = text2.getTopPixel();
                    text2.setTopPixel(topPixel + lineHeight);
                }
                this.scrollBeginTime = 0L;
                this.scrollY = -1;
                this.scrollX = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 100L;
            this.scrollX = pt.x;
            this.scrollY = pt.y;
        }
        if ((effect & 1) != 0) {
            int[] trailing = new int[1];
            int newOffset = text2.getOffsetAtPoint(pt.x, pt.y, trailing, false);
            if ((newOffset += trailing[0]) != this.currentOffset) {
                this.refreshCaret(text2, this.currentOffset, newOffset);
                this.currentOffset = newOffset;
            }
        }
    }

    void refreshCaret(StyledText text2, int oldOffset, int newOffset) {
        if (oldOffset != newOffset) {
            if (oldOffset != -1) {
                Point oldPos = text2.getLocationAtOffset(oldOffset);
                int oldHeight = text2.getLineHeight(oldOffset);
                text2.redraw(oldPos.x, oldPos.y, 2, oldHeight, false);
            }
            if (newOffset != -1) {
                Point newPos = text2.getLocationAtOffset(newOffset);
                int newHeight = text2.getLineHeight(newOffset);
                text2.redraw(newPos.x, newPos.y, 2, newHeight, false);
            }
        }
    }

    @Override
    public void dropAccept(DropTargetEvent event) {
        if (this.currentOffset != -1) {
            StyledText text2 = (StyledText)this.getControl();
            text2.setSelection(this.currentOffset);
            this.currentOffset = -1;
        }
    }
}

