/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.SashFormData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;

class SashFormLayout
extends Layout {
    SashFormLayout() {
    }

    @Override
    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        SashForm sashForm = (SashForm)composite;
        Control[] cArray = sashForm.getControls(true);
        int width = 0;
        int height = 0;
        if (cArray.length == 0) {
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            return new Point(width, height);
        }
        boolean vertical = sashForm.getOrientation() == 512;
        int maxIndex = 0;
        int maxValue = 0;
        int i2 = 0;
        while (i2 < cArray.length) {
            Point size;
            if (vertical) {
                size = cArray[i2].computeSize(wHint, -1, flushCache);
                if (size.y > maxValue) {
                    maxIndex = i2;
                    maxValue = size.y;
                }
                width = Math.max(width, size.x);
            } else {
                size = cArray[i2].computeSize(-1, hHint, flushCache);
                if (size.x > maxValue) {
                    maxIndex = i2;
                    maxValue = size.x;
                }
                height = Math.max(height, size.y);
            }
            ++i2;
        }
        long[] ratios = new long[cArray.length];
        long total = 0L;
        int i3 = 0;
        while (i3 < cArray.length) {
            Object data2 = cArray[i3].getLayoutData();
            if (data2 != null && data2 instanceof SashFormData) {
                ratios[i3] = ((SashFormData)data2).weight;
            } else {
                data2 = new SashFormData();
                cArray[i3].setLayoutData(data2);
                ratios[i3] = 13108L;
                ((SashFormData)data2).weight = 13108L;
            }
            total += ratios[i3];
            ++i3;
        }
        if (ratios[maxIndex] > 0L) {
            int sashwidth;
            int n2 = sashwidth = sashForm.sashes.length > 0 ? sashForm.SASH_WIDTH + sashForm.sashes[0].getBorderWidth() * 2 : sashForm.SASH_WIDTH;
            if (vertical) {
                height += (int)(total * (long)maxValue / ratios[maxIndex]) + (cArray.length - 1) * sashwidth;
            } else {
                width += (int)(total * (long)maxValue / ratios[maxIndex]) + (cArray.length - 1) * sashwidth;
            }
        }
        width += sashForm.getBorderWidth() * 2;
        height += sashForm.getBorderWidth() * 2;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    @Override
    protected boolean flushCache(Control control) {
        return true;
    }

    @Override
    protected void layout(Composite composite, boolean flushCache) {
        int sashwidth;
        int i2;
        Sash[] newSashes;
        SashForm sashForm = (SashForm)composite;
        Rectangle area = sashForm.getClientArea();
        if (area.width <= 1 || area.height <= 1) {
            return;
        }
        Control[] newControls = sashForm.getControls(true);
        if (sashForm.controls.length == 0 && newControls.length == 0) {
            return;
        }
        Control[] controls = sashForm.controls = newControls;
        if (sashForm.maxControl != null && !sashForm.maxControl.isDisposed()) {
            int i3 = 0;
            while (i3 < controls.length) {
                if (controls[i3] != sashForm.maxControl) {
                    controls[i3].setBounds(-200, -200, 0, 0);
                } else {
                    controls[i3].setBounds(area);
                }
                ++i3;
            }
            return;
        }
        if (sashForm.sashes.length < controls.length - 1) {
            newSashes = new Sash[controls.length - 1];
            System.arraycopy(sashForm.sashes, 0, newSashes, 0, sashForm.sashes.length);
            i2 = sashForm.sashes.length;
            while (i2 < newSashes.length) {
                newSashes[i2] = sashForm.createSash();
                ++i2;
            }
            sashForm.sashes = newSashes;
        }
        if (sashForm.sashes.length > controls.length - 1) {
            if (controls.length == 0) {
                int i4 = 0;
                while (i4 < sashForm.sashes.length) {
                    sashForm.sashes[i4].dispose();
                    ++i4;
                }
                sashForm.sashes = new Sash[0];
            } else {
                newSashes = new Sash[controls.length - 1];
                System.arraycopy(sashForm.sashes, 0, newSashes, 0, newSashes.length);
                i2 = controls.length - 1;
                while (i2 < sashForm.sashes.length) {
                    sashForm.sashes[i2].dispose();
                    ++i2;
                }
                sashForm.sashes = newSashes;
            }
        }
        if (controls.length == 0) {
            return;
        }
        Sash[] sashes = sashForm.sashes;
        long[] ratios = new long[controls.length];
        long total = 0L;
        int i5 = 0;
        while (i5 < controls.length) {
            Object data2 = controls[i5].getLayoutData();
            if (data2 != null && data2 instanceof SashFormData) {
                ratios[i5] = ((SashFormData)data2).weight;
            } else {
                data2 = new SashFormData();
                controls[i5].setLayoutData(data2);
                ratios[i5] = 13108L;
                ((SashFormData)data2).weight = 13108L;
            }
            total += ratios[i5];
            ++i5;
        }
        int n2 = sashwidth = sashes.length > 0 ? sashForm.SASH_WIDTH + sashes[0].getBorderWidth() * 2 : sashForm.SASH_WIDTH;
        if (sashForm.getOrientation() == 256) {
            int width = (int)(ratios[0] * (long)(area.width - sashes.length * sashwidth) / total);
            int x2 = area.x;
            controls[0].setBounds(x2, area.y, width, area.height);
            x2 += width;
            int i6 = 1;
            while (i6 < controls.length - 1) {
                sashes[i6 - 1].setBounds(x2, area.y, sashwidth, area.height);
                width = (int)(ratios[i6] * (long)(area.width - sashes.length * sashwidth) / total);
                controls[i6].setBounds(x2 += sashwidth, area.y, width, area.height);
                x2 += width;
                ++i6;
            }
            if (controls.length > 1) {
                sashes[sashes.length - 1].setBounds(x2, area.y, sashwidth, area.height);
                width = area.width - (x2 += sashwidth);
                controls[controls.length - 1].setBounds(x2, area.y, width, area.height);
            }
        } else {
            int height = (int)(ratios[0] * (long)(area.height - sashes.length * sashwidth) / total);
            int y2 = area.y;
            controls[0].setBounds(area.x, y2, area.width, height);
            y2 += height;
            int i7 = 1;
            while (i7 < controls.length - 1) {
                sashes[i7 - 1].setBounds(area.x, y2, area.width, sashwidth);
                height = (int)(ratios[i7] * (long)(area.height - sashes.length * sashwidth) / total);
                controls[i7].setBounds(area.x, y2 += sashwidth, area.width, height);
                y2 += height;
                ++i7;
            }
            if (controls.length > 1) {
                sashes[sashes.length - 1].setBounds(area.x, y2, area.width, sashwidth);
                height = area.height - (y2 += sashwidth);
                controls[controls.length - 1].setBounds(area.x, y2, area.width, height);
            }
        }
    }
}

