/*
 * Decompiled with CFR 0.152.
 */
package gde.comm;

import java.io.UnsupportedEncodingException;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbServices;

public class DumpNames {
    private static void dumpName(UsbDevice device) throws UnsupportedEncodingException, UsbException {
        UsbDeviceDescriptor desc = device.getUsbDeviceDescriptor();
        byte iManufacturer = desc.iManufacturer();
        byte iProduct = desc.iProduct();
        if (iManufacturer == 0 || iProduct == 0) {
            return;
        }
        System.out.println(device.getString(iManufacturer) + " " + device.getString(iProduct));
    }

    private static void processDevice(UsbDevice device) {
        if (device.isUsbHub()) {
            UsbHub hub = (UsbHub)device;
            for (UsbDevice child : hub.getAttachedUsbDevices()) {
                DumpNames.processDevice(child);
            }
        } else {
            try {
                DumpNames.dumpName(device);
            }
            catch (Exception e) {
                System.err.println("Ignoring problematic device: " + String.valueOf(e));
            }
        }
    }

    public static void main(String[] args) throws UsbException {
        UsbServices services = UsbHostManager.getUsbServices();
        DumpNames.processDevice((UsbDevice)services.getRootUsbHub());
    }
}

