/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.graupner.HoTTAdapter;
import gde.log.Level;
import java.io.FileNotFoundException;
import javax.xml.bind.JAXBException;

public class HoTTAdapterM
extends HoTTAdapter {
    public HoTTAdapterM(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
    }

    public HoTTAdapterM(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
    }

    @Override
    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double offset = record.getOffset();
                double reduction = record.getReduction();
                double factor = record.getFactor();
                int ordinal = record.getOrdinal();
                dataTableRow[index + 1] = (ordinal == 1 || ordinal == 2) && record.getParent().getChannelConfigNumber() == 3 ? String.format("%02.7f", (double)record.realGet(rowIndex).intValue() / 1000000.0) : (ordinal >= 0 && ordinal <= 5 && record.getParent().getChannelConfigNumber() == 1 ? String.format("%.0f", (double)record.realGet(rowIndex).intValue() / 1000.0) : record.getDecimalFormat().format(offset + ((double)record.realGet(rowIndex).intValue() / 1000.0 - reduction) * factor));
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    @Override
    public double translateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double newValue = 0.0;
        if (record.getAbstractParent().getChannelConfigNumber() == 3 && (record.getOrdinal() == 1 || record.getOrdinal() == 2)) {
            newValue = value / 1000.0;
        } else if (record.getAbstractParent().getChannelConfigNumber() == 6 && record.getOrdinal() >= 3 && record.getOrdinal() <= 18) {
            if (this.pickerParameters.isChannelPercentEnabled) {
                if (!record.getUnit().equals("%")) {
                    record.setUnit("%");
                }
                factor = 0.25;
                reduction = 1500.0;
                newValue = (value - reduction) * factor;
            } else {
                if (!record.getUnit().equals("\u00b5sec")) {
                    record.setUnit("\u00b5sec");
                }
                newValue = (value - reduction) * factor + offset;
            }
        } else {
            newValue = (value - reduction) * factor + offset;
        }
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    @Override
    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double newValue = 0.0;
        if ((record.getOrdinal() == 1 || record.getOrdinal() == 2) && record.getAbstractParent().getChannelConfigNumber() == 3) {
            newValue = value * 1000.0;
        } else if (record.getAbstractParent().getChannelConfigNumber() == 6 && record.getOrdinal() >= 3 && record.getOrdinal() <= 18) {
            if (this.pickerParameters.isChannelPercentEnabled) {
                if (!record.getUnit().equals("%")) {
                    record.setUnit("%");
                }
                factor = 0.25;
                reduction = 1500.0;
                newValue = value / factor + reduction;
            } else {
                if (!record.getUnit().equals("\u00b5sec")) {
                    record.setUnit("\u00b5sec");
                }
                newValue = (value - reduction) * factor;
            }
        } else {
            newValue = (value - offset) / factor + reduction;
        }
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }
}

