/*
 * Decompiled with CFR 0.152.
 */
package gde.device.powerbox;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.device.powerbox.CoreAdapter;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.MeasurementControlConfigurable;
import gde.ui.SWTResourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class CoreAdapterDialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(CoreAdapterDialog.class.getName());
    CTabFolder tabFolder;
    CTabFolder subTabFolder1;
    CTabFolder subTabFolder2;
    CTabItem visualizationTabItem;
    Composite visualizationMainComposite;
    Composite uniLogVisualization;
    Composite mLinkVisualization;
    Composite configurationMainComposite;
    Label tabItemLabel;
    Button inputFileButton;
    Button helpButton;
    Button closeButton;
    CTabItem gpsLoggerTabItem;
    CTabItem telemetryTabItem;
    final CoreAdapter device;
    final Settings settings;
    RecordSet lastActiveRecordSet = null;
    boolean isVisibilityChanged = false;
    int measurementItemRows = 0;
    final List<CTabItem> configurations = new ArrayList<CTabItem>();
    final List<Composite> measurementControls = new ArrayList<Composite>();

    public CoreAdapterDialog(Shell parent, CoreAdapter useDevice) {
        super(parent);
        this.device = useDevice;
        this.settings = Settings.getInstance();
        this.measurementItemRows = (this.device.getNumberOfMeasurements(1) + 1) / 2;
    }

    public void open() {
        try {
            this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
            this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
            log.log(java.util.logging.Level.FINE, "dialogShell.isDisposed() " + String.valueOf(this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
            if (this.dialogShell == null || this.dialogShell.isDisposed()) {
                this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
                SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
                FormLayout dialogShellLayout = new FormLayout();
                this.dialogShell.setLayout((Layout)dialogShellLayout);
                this.dialogShell.layout();
                this.dialogShell.pack();
                this.dialogShell.setSize(GDE.IS_MAC ? 675 : 740, 500);
                this.dialogShell.setText(this.device.getName() + Messages.getString((String)"GDE_MSGT0273"));
                this.dialogShell.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
                this.dialogShell.addListener(31, new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.detail) {
                            case 2: {
                                CoreAdapterDialog.this.dialogShell.close();
                                event.detail = 0;
                                event.doit = false;
                            }
                        }
                    }
                });
                this.dialogShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "dialogShell.widgetDisposed, event=" + String.valueOf(evt));
                        CoreAdapterDialog.this.dispose();
                    }
                });
                this.dialogShell.addHelpListener(new HelpListener(){

                    public void helpRequested(HelpEvent evt) {
                        log.log(java.util.logging.Level.FINER, "dialogShell.helpRequested, event=" + String.valueOf(evt));
                        CoreAdapterDialog.this.application.openHelpDialog(CoreAdapterDialog.this.device.getName(), "HelpInfo.html");
                    }
                });
                this.dialogShell.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent paintevent) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "dialogShell.paintControl, event=" + String.valueOf(paintevent));
                        }
                        RecordSet activeRecordSet = CoreAdapterDialog.this.application.getActiveRecordSet();
                        if (CoreAdapterDialog.this.lastActiveRecordSet == null && activeRecordSet != null || activeRecordSet != null && !CoreAdapterDialog.this.lastActiveRecordSet.getName().equals(activeRecordSet.getName())) {
                            CoreAdapterDialog.this.tabFolder.setSelection(Channels.getInstance().getActiveChannelNumber() - 1);
                        }
                        CoreAdapterDialog.this.lastActiveRecordSet = CoreAdapterDialog.this.application.getActiveRecordSet();
                    }
                });
                this.tabFolder = new CTabFolder((Composite)this.dialogShell, 0);
                this.tabFolder.setSimple(false);
                for (int i = 1; i <= this.device.getChannelCount(); ++i) {
                    this.createVisualizationTabItems(i);
                }
                FormData tabFolderLData = new FormData();
                tabFolderLData.top = new FormAttachment(0, 1000, 0);
                tabFolderLData.left = new FormAttachment(0, 1000, 0);
                tabFolderLData.right = new FormAttachment(1000, 1000, 0);
                tabFolderLData.bottom = new FormAttachment(1000, 1000, -50);
                this.tabFolder.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.tabFolder.setLayoutData((Object)tabFolderLData);
                this.tabFolder.setSelection(0);
                this.inputFileButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData inputFileButtonLData = new FormData();
                inputFileButtonLData.width = 130;
                inputFileButtonLData.height = GDE.IS_MAC ? 33 : 30;
                inputFileButtonLData.left = new FormAttachment(0, 1000, 15);
                inputFileButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.inputFileButton.setLayoutData((Object)inputFileButtonLData);
                this.inputFileButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.inputFileButton.setText(Messages.getString((String)"GDE_MSGT2962"));
                this.inputFileButton.setToolTipText(Messages.getString((String)"GDE_MSGT2963"));
                this.inputFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "inputFileButton.widgetSelected, event=" + String.valueOf(evt));
                        if (CoreAdapterDialog.this.isVisibilityChanged) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{CoreAdapterDialog.this.device.getPropertiesFileName()});
                            if (CoreAdapterDialog.this.application.openYesNoMessageDialog(CoreAdapterDialog.this.dialogShell, msg) == 64) {
                                log.log(java.util.logging.Level.FINE, "SWT.YES");
                                CoreAdapterDialog.this.device.storeDeviceProperties();
                            }
                        }
                        CoreAdapterDialog.this.dispose();
                        CoreAdapterDialog.this.device.open_closeCommPort();
                    }
                });
                this.helpButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData helpButtonLData = new FormData();
                helpButtonLData.width = GDE.IS_MAC ? 50 : 40;
                helpButtonLData.height = GDE.IS_MAC ? 33 : 30;
                helpButtonLData.left = new FormAttachment(0, 1000, 302);
                helpButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.helpButton.setLayoutData((Object)helpButtonLData);
                this.helpButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.helpButton.setImage(SWTResourceManager.getImage((String)"gde/resource/QuestionHot.gif"));
                this.helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "helpButton.widgetSelected, event=" + String.valueOf(evt));
                        CoreAdapterDialog.this.application.openHelpDialog(CoreAdapterDialog.this.device.getName(), "HelpInfo.html");
                    }
                });
                this.closeButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData closeButtonLData = new FormData();
                closeButtonLData.width = 130;
                closeButtonLData.height = GDE.IS_MAC ? 33 : 30;
                closeButtonLData.right = new FormAttachment(1000, 1000, -10);
                closeButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.closeButton.setLayoutData((Object)closeButtonLData);
                this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.closeButton.setText(Messages.getString((String)"GDE_MSGT0485"));
                this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "closeButton.widgetSelected, event=" + String.valueOf(evt));
                        CoreAdapterDialog.this.dispose();
                    }
                });
                try {
                    this.tabFolder.setSelection(Channels.getInstance().getActiveChannelNumber() - 1);
                }
                catch (RuntimeException e) {
                    this.tabFolder.setSelection(0);
                }
                this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 375, 10));
                this.dialogShell.open();
            } else {
                this.dialogShell.setVisible(true);
                this.dialogShell.setActive();
            }
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
    }

    private void createVisualizationTabItems(int channelNumber) {
        this.visualizationTabItem = new CTabItem(this.tabFolder, 0);
        this.visualizationTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 1 : 0)), (int)0));
        this.visualizationTabItem.setText(Messages.getString((String)"GDE_MSGT2959") + " - " + this.device.getChannelNameReplacement(channelNumber));
        final ScrolledComposite scolledComposite = new ScrolledComposite((Composite)this.tabFolder, 512);
        scolledComposite.setLayout((Layout)new FillLayout());
        this.visualizationTabItem.setControl((Control)scolledComposite);
        final Composite mainTabComposite = new Composite((Composite)scolledComposite, 0);
        GridLayout mainTabCompositeLayout = new GridLayout();
        mainTabCompositeLayout.makeColumnsEqualWidth = true;
        mainTabCompositeLayout.numColumns = 2;
        mainTabComposite.setLayout((Layout)mainTabCompositeLayout);
        mainTabComposite.setSize(610, 350);
        scolledComposite.setContent((Control)mainTabComposite);
        this.tabItemLabel = new Label(mainTabComposite, 0x1000000);
        GridData tabItemLabelLData = new GridData();
        tabItemLabelLData.grabExcessHorizontalSpace = true;
        tabItemLabelLData.horizontalAlignment = 2;
        tabItemLabelLData.verticalAlignment = 1;
        tabItemLabelLData.heightHint = 18;
        tabItemLabelLData.widthHint = 600;
        tabItemLabelLData.horizontalSpan = 2;
        this.tabItemLabel.setLayoutData((Object)tabItemLabelLData);
        this.tabItemLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + 2), (int)1));
        this.tabItemLabel.setText(Messages.getString((String)"GDE_MSGT2959"));
        List measurementTypes = this.device.getChannelMeasuremtsReplacedNames(channelNumber);
        for (int i = 0; i < measurementTypes.size(); ++i) {
            this.measurementControls.add((Composite)new MeasurementControlConfigurable(mainTabComposite, (DeviceDialog)this, channelNumber, i, (MeasurementType)measurementTypes.get(i), (IDevice)this.device, 1, " " + i, ""));
        }
        scolledComposite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent evt) {
                log.log(java.util.logging.Level.FINEST, "scolledComposite.controlResized, event=" + String.valueOf(evt));
                int height = 35 + CoreAdapterDialog.this.device.getChannelMeasuremtsReplacedNames(CoreAdapterDialog.this.tabFolder.getSelectionIndex() + 1).size() * 28 / 2;
                Channel channel = (Channel)Channels.getInstance().get((Object)(CoreAdapterDialog.this.tabFolder.getSelectionIndex() + 1));
                if (channel != null && channel.getActiveRecordSet() != null) {
                    height = 35 + (channel.getActiveRecordSet().size() + 1) * 28 / 2;
                }
                mainTabComposite.setSize(scolledComposite.getClientArea().width, height);
            }

            public void controlMoved(ControlEvent evt) {
                log.log(java.util.logging.Level.FINEST, "scolledComposite.controlMoved, event=" + String.valueOf(evt));
                int height = 35 + CoreAdapterDialog.this.device.getChannelMeasuremtsReplacedNames(CoreAdapterDialog.this.tabFolder.getSelectionIndex() + 1).size() * 28 / 2;
                Channel channel = (Channel)Channels.getInstance().get((Object)(CoreAdapterDialog.this.tabFolder.getSelectionIndex() + 1));
                if (channel != null && channel.getActiveRecordSet() != null) {
                    height = 35 + (channel.getActiveRecordSet().size() + 1) * 28 / 2;
                }
                mainTabComposite.setSize(scolledComposite.getClientArea().width, height);
            }
        });
    }

    public void enableSaveButton(boolean enable) {
        this.application.updateAllTabs(true);
    }

    public Integer getTabFolderSelectionIndex() {
        return this.tabFolder.getSelectionIndex();
    }
}

