/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend.form;

import org.w3c.dom.Element;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.XhtmlForm;
import org.xhtmlrenderer.simple.extend.form.ButtonField;
import org.xhtmlrenderer.simple.extend.form.CheckboxField;
import org.xhtmlrenderer.simple.extend.form.FileField;
import org.xhtmlrenderer.simple.extend.form.FormField;
import org.xhtmlrenderer.simple.extend.form.HiddenField;
import org.xhtmlrenderer.simple.extend.form.ImageField;
import org.xhtmlrenderer.simple.extend.form.PasswordField;
import org.xhtmlrenderer.simple.extend.form.RadioButtonField;
import org.xhtmlrenderer.simple.extend.form.ResetField;
import org.xhtmlrenderer.simple.extend.form.SelectField;
import org.xhtmlrenderer.simple.extend.form.SubmitField;
import org.xhtmlrenderer.simple.extend.form.TextAreaField;
import org.xhtmlrenderer.simple.extend.form.TextField;

public class FormFieldFactory {
    private FormFieldFactory() {
    }

    public static FormField create(XhtmlForm form2, LayoutContext context, BlockBox box) {
        String typeKey = null;
        Element e2 = box.getElement();
        if (e2.getNodeName().equals("input")) {
            typeKey = e2.getAttribute("type");
        } else if (e2.getNodeName().equals("textarea")) {
            typeKey = "textarea";
        } else if (e2.getNodeName().equals("select")) {
            typeKey = "select";
        } else {
            return null;
        }
        if (typeKey.equals("submit")) {
            return new SubmitField(e2, form2, context, box);
        }
        if (typeKey.equals("reset")) {
            return new ResetField(e2, form2, context, box);
        }
        if (typeKey.equals("button")) {
            return new ButtonField(e2, form2, context, box);
        }
        if (typeKey.equals("image")) {
            return new ImageField(e2, form2, context, box);
        }
        if (typeKey.equals("hidden")) {
            return new HiddenField(e2, form2, context, box);
        }
        if (typeKey.equals("password")) {
            return new PasswordField(e2, form2, context, box);
        }
        if (typeKey.equals("checkbox")) {
            return new CheckboxField(e2, form2, context, box);
        }
        if (typeKey.equals("radio")) {
            return new RadioButtonField(e2, form2, context, box);
        }
        if (typeKey.equals("file")) {
            return new FileField(e2, form2, context, box);
        }
        if (typeKey.equals("textarea")) {
            return new TextAreaField(e2, form2, context, box);
        }
        if (typeKey.equals("select")) {
            return new SelectField(e2, form2, context, box);
        }
        return new TextField(e2, form2, context, box);
    }
}

