/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.UnivariateInterpolator;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;

public class UnivariatePeriodicInterpolator
implements UnivariateInterpolator {
    public static final int DEFAULT_EXTEND = 5;
    private final UnivariateInterpolator interpolator;
    private final double period;
    private final int extend;

    public UnivariatePeriodicInterpolator(UnivariateInterpolator interpolator, double period, int extend) {
        this.interpolator = interpolator;
        this.period = period;
        this.extend = extend;
    }

    public UnivariatePeriodicInterpolator(UnivariateInterpolator interpolator, double period) {
        this(interpolator, period, 5);
    }

    public UnivariateFunction interpolate(double[] xval, double[] yval) throws NumberIsTooSmallException, NonMonotonicSequenceException {
        int index;
        int i2;
        if (xval.length < this.extend) {
            throw new NumberIsTooSmallException(xval.length, (Number)this.extend, true);
        }
        MathArrays.checkOrder(xval);
        final double offset = xval[0];
        int len = xval.length + this.extend * 2;
        double[] x2 = new double[len];
        double[] y2 = new double[len];
        for (i2 = 0; i2 < xval.length; ++i2) {
            index = i2 + this.extend;
            x2[index] = MathUtils.reduce(xval[i2], this.period, offset);
            y2[index] = yval[i2];
        }
        for (i2 = 0; i2 < this.extend; ++i2) {
            index = xval.length - this.extend + i2;
            x2[i2] = MathUtils.reduce(xval[index], this.period, offset) - this.period;
            y2[i2] = yval[index];
            index = len - this.extend + i2;
            x2[index] = MathUtils.reduce(xval[i2], this.period, offset) + this.period;
            y2[index] = yval[i2];
        }
        MathArrays.sortInPlace(x2, new double[][]{y2});
        final UnivariateFunction f2 = this.interpolator.interpolate(x2, y2);
        return new UnivariateFunction(){

            public double value(double x2) throws MathIllegalArgumentException {
                return f2.value(MathUtils.reduce(x2, UnivariatePeriodicInterpolator.this.period, offset));
            }
        };
    }
}

