/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.voice;

import de.treichels.hott.voice.DecodingInputStream;
import de.treichels.hott.voice.EncodingInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.BitSet;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/treichels/hott/voice/ADPCMCodec;", "", "()V", "index", "", "last", "decode", "", "adpcm", "", "encode", "pcm", "Companion", "HoTT-Voice"})
public final class ADPCMCodec {
    private int index;
    private int last;
    private static final int[] QUANTIZER;
    private static final int[] STEP_SIZES;
    private static final int MIN_PCM = -2048;
    private static final int MAX_PCM = 2047;
    private static final int MIN_INDEX = 0;
    private static final int MAX_INDEX;
    @NotNull
    public static final Companion Companion;

    public final short decode(byte adpcm) {
        BitSet bits = BitSet.valueOf(new byte[]{adpcm});
        int stepSize = STEP_SIZES[this.index];
        int diff = stepSize >> 3;
        if (bits.get(2)) {
            diff += stepSize;
        }
        if (bits.get(1)) {
            diff += stepSize >> 1;
        }
        if (bits.get(0)) {
            diff += stepSize >> 2;
        }
        if (bits.get(3)) {
            diff = -diff;
        }
        this.last += diff;
        if (this.last > 2047) {
            this.last = 2047;
        }
        if (this.last < -2048) {
            this.last = -2048;
        }
        this.index += QUANTIZER[adpcm & 7];
        if (this.index < 0) {
            this.index = 0;
        }
        if (this.index > MAX_INDEX) {
            this.index = MAX_INDEX;
        }
        return (short)this.last;
    }

    public final byte encode(short pcm) {
        int stepSize = STEP_SIZES[this.index];
        int diff = pcm - this.last;
        BitSet bits = new BitSet(4);
        if (diff < 0) {
            bits.set(3, true);
            diff = -diff;
        }
        if (diff >= stepSize) {
            bits.set(2, true);
            diff -= stepSize;
        }
        if (diff >= (stepSize >>= 1)) {
            bits.set(1, true);
            diff -= stepSize;
        }
        if (diff >= (stepSize >>= 1)) {
            bits.set(0, true);
        }
        byte adpcm = bits.isEmpty() ? (byte)0 : bits.toByteArray()[0];
        this.last = this.decode(adpcm);
        return adpcm;
    }

    static {
        Companion = new Companion(null);
        QUANTIZER = new int[]{-1, -1, -1, -1, 2, 4, 6, 8};
        STEP_SIZES = new int[]{7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45, 50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143, 157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449, 494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899, 15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, Short.MAX_VALUE};
        MAX_INDEX = STEP_SIZES.length - 1;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u001a\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/treichels/hott/voice/ADPCMCodec$Companion;", "", "()V", "MAX_INDEX", "", "MAX_PCM", "MIN_INDEX", "MIN_PCM", "QUANTIZER", "", "STEP_SIZES", "decode", "Ljava/io/InputStream;", "source", "", "data", "encode", "volume", "", "HoTT-Voice"})
    public static final class Companion {
        @NotNull
        public final byte[] decode(@NotNull byte[] data2) {
            Intrinsics.checkNotNullParameter(data2, "data");
            byte[] byArray = IOUtils.toByteArray(this.decode(new ByteArrayInputStream(data2)));
            Intrinsics.checkNotNullExpressionValue(byArray, "IOUtils.toByteArray(deco\u2026eArrayInputStream(data)))");
            return byArray;
        }

        @NotNull
        public final InputStream decode(@NotNull InputStream source) {
            Intrinsics.checkNotNullParameter(source, "source");
            return new DecodingInputStream(source);
        }

        @NotNull
        public final byte[] encode(@NotNull byte[] data2) {
            Intrinsics.checkNotNullParameter(data2, "data");
            byte[] byArray = IOUtils.toByteArray(de.treichels.hott.voice.ADPCMCodec$Companion.encode$default(this, new ByteArrayInputStream(data2), 0.0, 2, null));
            Intrinsics.checkNotNullExpressionValue(byArray, "IOUtils.toByteArray(enco\u2026eArrayInputStream(data)))");
            return byArray;
        }

        @JvmOverloads
        @NotNull
        public final InputStream encode(@NotNull InputStream source, double volume) {
            Intrinsics.checkNotNullParameter(source, "source");
            return new EncodingInputStream(source, volume);
        }

        public static /* synthetic */ InputStream encode$default(Companion companion, InputStream inputStream2, double d2, int n2, Object object) {
            if ((n2 & 2) != 0) {
                d2 = 1.0;
            }
            return companion.encode(inputStream2, d2);
        }

        @JvmOverloads
        @NotNull
        public final InputStream encode(@NotNull InputStream source) {
            return de.treichels.hott.voice.ADPCMCodec$Companion.encode$default(this, source, 0.0, 2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

