/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.LogManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntRange;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J\u001a\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\bJ\u0012\u0010\u0019\u001a\u00020\b2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bJ\u0014\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002J\u0012\u0010\u001e\u001a\u00020\b2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lde/treichels/hott/util/Util;", "", "()V", "DEBUG", "", "getDEBUG", "()Z", "LATEST_VERSIONS_URL", "", "OFFLINE", "getOFFLINE", "PARAM_DEBUG", "PARAM_OFFLINE", "latestVersions", "Ljava/util/Properties;", "dumpData", "data", "", "baseAddress", "", "", "enableLogging", "", "getLatestVersion", "key", "programDir", "clazz", "Lkotlin/reflect/KClass;", "sourceLocation", "Ljava/io/File;", "sourceVersion", "HoTT-Util"})
public final class Util {
    private static final String PARAM_OFFLINE = "offline";
    private static final String PARAM_DEBUG = "debug";
    private static final String LATEST_VERSIONS_URL = "https://drive.google.com/uc?export=download&id=0B_uPguA0xiT4SUl1V1VKYXFjWHc";
    private static final Properties latestVersions;
    private static final boolean OFFLINE;
    private static final boolean DEBUG;
    @NotNull
    public static final Util INSTANCE;

    public final boolean getOFFLINE() {
        return OFFLINE;
    }

    public final boolean getDEBUG() {
        return DEBUG;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final String dumpData(@Nullable byte[] data2, int baseAddress) {
        StringBuilder sb = new StringBuilder();
        if (data2 != null) {
            void addr;
            int len = data2.length;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            while (addr.element < len) {
                int i2;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "0x%04x: ";
                Object object = new Object[]{baseAddress + addr.element};
                boolean bl = false;
                String string3 = String.format(string2, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue(string3, "java.lang.String.format(format, *args)");
                sb.append(string3);
                int n2 = 0;
                int n3 = 15;
                while (n2 <= n3) {
                    if (addr.element + i2 < len) {
                        switch (i2) {
                            case 4: 
                            case 12: {
                                sb.append(':');
                                break;
                            }
                            case 0: 
                            case 8: {
                                sb.append('|');
                                break;
                            }
                            default: {
                                sb.append(' ');
                            }
                        }
                        object = StringCompanionObject.INSTANCE;
                        String string4 = "%02x";
                        Object[] objectArray = new Object[]{data2[addr.element + i2]};
                        boolean bl2 = false;
                        String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue(string5, "java.lang.String.format(format, *args)");
                        sb.append(string5);
                    } else {
                        sb.append("   ");
                    }
                    ++i2;
                }
                sb.append("| ");
                i2 = 0;
                Sequence $this$forEach$iv = SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence(new IntRange(i2, 15)), (Function1)new Function1<Integer, Boolean>(len, (Ref.IntRef)addr){
                    final /* synthetic */ int $len;
                    final /* synthetic */ Ref.IntRef $addr;

                    public final boolean invoke(int it) {
                        return this.$addr.element + it < this.$len;
                    }
                    {
                        this.$len = n2;
                        this.$addr = intRef;
                        super(1);
                    }
                }), (Function1)new Function1<Integer, Character>(data2, (Ref.IntRef)addr){
                    final /* synthetic */ byte[] $data;
                    final /* synthetic */ Ref.IntRef $addr;

                    public final char invoke(int it) {
                        return (char)(this.$data[this.$addr.element + it] & 0xFF);
                    }
                    {
                        this.$data = byArray;
                        this.$addr = intRef;
                        super(1);
                    }
                });
                boolean $i$f$forEach = false;
                object = $this$forEach$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv = object.next();
                    char it = ((Character)element$iv).charValue();
                    boolean bl3 = false;
                    char c2 = it;
                    if (' ' <= c2 && '~' >= c2) {
                        sb.append(it);
                        continue;
                    }
                    sb.append('.');
                }
                sb.append('\n');
                addr.element += 16;
            }
        }
        String string6 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string6, "sb.toString()");
        return string6;
    }

    public static /* synthetic */ String dumpData$default(Util util, byte[] byArray, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return util.dumpData(byArray, n2);
    }

    @JvmOverloads
    @NotNull
    public final String dumpData(@Nullable byte[] data2) {
        return Util.dumpData$default(this, data2, 0, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dumpData(@Nullable short[] data2, int baseAddress) {
        StringBuilder sb = new StringBuilder();
        if (data2 != null) {
            void addr;
            int len = data2.length;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            while (addr.element < len) {
                int i2;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "0x%04x: ";
                Object object = new Object[]{baseAddress + addr.element * 2};
                boolean bl = false;
                String string3 = String.format(string2, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue(string3, "java.lang.String.format(format, *args)");
                sb.append(string3);
                int n2 = 0;
                int n3 = 7;
                while (n2 <= n3) {
                    if (addr.element + i2 < len) {
                        switch (i2) {
                            case 2: 
                            case 6: {
                                sb.append(':');
                                break;
                            }
                            case 0: 
                            case 4: {
                                sb.append('|');
                                break;
                            }
                            default: {
                                sb.append(' ');
                            }
                        }
                        object = StringCompanionObject.INSTANCE;
                        String string4 = "%04x";
                        Object[] objectArray = new Object[]{data2[addr.element + i2]};
                        boolean bl2 = false;
                        String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue(string5, "java.lang.String.format(format, *args)");
                        sb.append(string5);
                    } else {
                        sb.append("     ");
                    }
                    ++i2;
                }
                sb.append("| ");
                i2 = 0;
                Sequence $this$forEach$iv = SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence(new IntRange(i2, 7)), (Function1)new Function1<Integer, Boolean>(len, (Ref.IntRef)addr){
                    final /* synthetic */ int $len;
                    final /* synthetic */ Ref.IntRef $addr;

                    public final boolean invoke(int it) {
                        return this.$addr.element + it < this.$len;
                    }
                    {
                        this.$len = n2;
                        this.$addr = intRef;
                        super(1);
                    }
                }), (Function1)new Function1<Integer, Integer>(data2, (Ref.IntRef)addr){
                    final /* synthetic */ short[] $data;
                    final /* synthetic */ Ref.IntRef $addr;

                    public final int invoke(int it) {
                        return this.$data[this.$addr.element + it] & 0xFFFF;
                    }
                    {
                        this.$data = sArray;
                        this.$addr = intRef;
                        super(1);
                    }
                });
                boolean $i$f$forEach = false;
                object = $this$forEach$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv = object.next();
                    int it = ((Number)element$iv).intValue();
                    boolean bl3 = false;
                    int lb = it >>> 8 & 0xFF;
                    int hb = it & 0xFF;
                    int n4 = lb;
                    if (32 <= n4 && 126 >= n4) {
                        sb.append((char)lb);
                    } else {
                        sb.append('.');
                    }
                    n4 = hb;
                    if (32 <= n4 && 126 >= n4) {
                        sb.append((char)hb);
                        continue;
                    }
                    sb.append('.');
                }
                sb.append('\n');
                addr.element += 8;
            }
        }
        String string6 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string6, "sb.toString()");
        return string6;
    }

    public static /* synthetic */ String dumpData$default(Util util, short[] sArray, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return util.dumpData(sArray, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getLatestVersion(@NotNull String key2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        if (latestVersions.isEmpty()) {
            try {
                Closeable closeable = new URL(LATEST_VERSIONS_URL).openStream();
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    Object object;
                    InputStream is = (InputStream)closeable;
                    boolean bl3 = false;
                    Closeable closeable2 = new InputStreamReader(is);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Throwable throwable2 = null;
                    try {
                        InputStreamReader reader = (InputStreamReader)closeable2;
                        boolean bl6 = false;
                        latestVersions.load(reader);
                        object = latestVersions.setProperty(PARAM_OFFLINE, String.valueOf(Boolean.FALSE));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable2, throwable2);
                    }
                    Object object2 = object;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            catch (IOException e2) {
                latestVersions.setProperty(PARAM_OFFLINE, String.valueOf(Boolean.TRUE));
            }
        }
        return latestVersions.getProperty(key2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final String sourceVersion(@NotNull KClass<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        File file = this.sourceLocation(clazz);
        boolean bl = false;
        boolean bl2 = false;
        File source = file;
        boolean bl3 = false;
        String string2 = source.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "source.name");
        if (!StringsKt.endsWith$default(string2, ".jar", false, 2, null)) {
            String string3 = source.getName();
            Intrinsics.checkNotNullExpressionValue(string3, "source.name");
            if (!StringsKt.endsWith$default(string3, ".exe", false, 2, null)) return "Unknown";
        }
        Closeable closeable = new JarFile(source);
        boolean bl4 = false;
        boolean bl5 = false;
        Throwable throwable = null;
        try {
            JarFile jarFile = (JarFile)closeable;
            boolean bl6 = false;
            Manifest manifest = jarFile.getManifest();
            Intrinsics.checkNotNullExpressionValue(manifest, "jarFile.manifest");
            Attributes attributes = manifest.getMainAttributes();
            String version = attributes.getValue("Implementation-Version");
            String build = attributes.getValue("Implementation-Build");
            String string4 = 'v' + version + '.' + build;
            String string5 = string4;
            return string5;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @NotNull
    public final String programDir(@NotNull KClass<?> clazz) {
        String string2;
        File programDir;
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        File file = programDir = this.sourceLocation(clazz).getParentFile();
        Intrinsics.checkNotNullExpressionValue(file, "programDir");
        if (Intrinsics.areEqual(file.getName(), "target")) {
            File file2 = programDir.getParentFile();
            Intrinsics.checkNotNullExpressionValue(file2, "programDir.parentFile");
            string2 = file2.getAbsolutePath();
        } else {
            string2 = programDir.getAbsolutePath();
        }
        String result2 = string2;
        System.setProperty("program.dir", result2);
        String string3 = result2;
        Intrinsics.checkNotNullExpressionValue(string3, "result");
        return string3;
    }

    private final File sourceLocation(KClass<?> clazz) {
        ProtectionDomain protectionDomain = JvmClassMappingKt.getJavaClass(clazz).getProtectionDomain();
        Intrinsics.checkNotNullExpressionValue(protectionDomain, "clazz.java.protectionDomain");
        CodeSource codeSource = protectionDomain.getCodeSource();
        Intrinsics.checkNotNullExpressionValue(codeSource, "clazz.java.protectionDomain.codeSource");
        return new File(codeSource.getLocation().toURI());
    }

    public final void enableLogging() {
        if (DEBUG) {
            LogManager.getLogManager().readConfiguration(ClassLoader.getSystemResourceAsStream("logging.properties"));
        }
    }

    private Util() {
    }

    static {
        Util util;
        INSTANCE = util = new Util();
        latestVersions = new Properties();
        OFFLINE = Boolean.getBoolean(PARAM_OFFLINE);
        DEBUG = Boolean.getBoolean(PARAM_DEBUG);
    }
}

