/*
 * Decompiled with CFR 0.152.
 */
package gde.device.schulze;

import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DataBlockType;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.MeasurementPropertyTypes;
import gde.device.MeasurementType;
import gde.device.PropertyType;
import gde.device.schulze.DataParserNext;
import gde.device.schulze.GathererThread;
import gde.device.schulze.NextGenSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

public class NextGen8
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(NextGen8.class.getName());
    final DataExplorer application;
    protected final NextGenSerialPort serialPort;
    protected final Channels channels;
    protected GathererThread gathererThread;
    protected boolean isFileIO = false;
    protected boolean isSerialIO = false;
    protected static double capacity = 0.0;
    protected static DataParserNext convertData;

    public NextGen8(String xmlFileName) throws FileNotFoundException, JAXBException {
        super(xmlFileName);
        Messages.setDeviceResourceBundle((String)"gde.device.schulze.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.serialPort = new NextGenSerialPort(this, this.application);
        this.channels = Channels.getInstance();
        if (this.application.getMenuToolBar() != null) {
            for (DataBlockType.Format format : this.getDataBlockType().getFormat()) {
                if (!this.isSerialIO) {
                    boolean bl = this.isSerialIO = format.getInputType() == InputTypes.SERIAL_IO;
                }
                if (this.isFileIO) continue;
                this.isFileIO = format.getInputType() == InputTypes.FILE_IO;
            }
            if (this.isSerialIO) {
                this.configureSerialPortMenu(1, Messages.getString((String)"GDE_MSGT1706"), Messages.getString((String)"GDE_MSGT1705"));
            } else {
                this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT1703"), Messages.getString((String)"GDE_MSGT1703"));
            }
        }
    }

    public NextGen8(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.schulze.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.serialPort = new NextGenSerialPort(this, this.application);
        this.channels = Channels.getInstance();
        if (this.application.getMenuToolBar() != null) {
            for (DataBlockType.Format format : this.getDataBlockType().getFormat()) {
                if (!this.isSerialIO) {
                    boolean bl = this.isSerialIO = format.getInputType() == InputTypes.SERIAL_IO;
                }
                if (this.isFileIO) continue;
                this.isFileIO = format.getInputType() == InputTypes.FILE_IO;
            }
            if (this.isSerialIO) {
                this.configureSerialPortMenu(1, Messages.getString((String)"GDE_MSGT1706"), Messages.getString((String)"GDE_MSGT1705"));
            } else {
                this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT1703"), Messages.getString((String)"GDE_MSGT1703"));
            }
        }
    }

    public int getNumberOfLithiumCells() {
        return 8;
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    public int getLovDataByteSize() {
        return 85;
    }

    protected void setDataLineStartAndLength(byte[] dataBuffer, int[] refStartLength) {
        int crlfPos;
        int startPos;
        int startByte1 = 49;
        int startByte2 = 50;
        int startByteTrailer = 58;
        byte[] lineSep = this.getDataBlockEnding();
        for (startPos = refStartLength[0] + refStartLength[1]; startPos < dataBuffer.length - 1 && (dataBuffer[startPos] != 49 || dataBuffer[startPos] != 50) && dataBuffer[startPos + 1] != 58; ++startPos) {
        }
        for (crlfPos = refStartLength[0] = startPos; crlfPos < dataBuffer.length && dataBuffer[crlfPos] != lineSep[0] && dataBuffer[crlfPos + 1] != lineSep[1]; ++crlfPos) {
        }
        refStartLength[1] = crlfPos - startPos;
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int[] startLength = new int[]{0, 0};
        byte[] lineBuffer = null;
        try {
            this.setDataLineStartAndLength(dataBuffer, startLength);
            lineBuffer = new byte[startLength[1]];
            System.arraycopy(dataBuffer, startLength[0], lineBuffer, 0, startLength[1]);
            convertData.parse(new String(lineBuffer), 1);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage());
        }
        return convertData.getValues();
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        double capacity = 0.0;
        double timeStep_h = 2.777777777777778E-4;
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
            points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
            points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
            if (points[1] != 0) {
                points[2] = Double.valueOf(capacity += (double)points[1] * timeStep_h).intValue();
            } else {
                points[2] = 0;
                capacity = 0.0;
            }
            points[3] = Double.valueOf((double)(points[1] * points[2]) / 100.0).intValue();
            points[4] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
            if (recordSet.getChannelConfigNumber() == 1) {
                int maxVotage = Integer.MIN_VALUE;
                int minVotage = Integer.MAX_VALUE;
                int j = 0;
                int k = 0;
                while (j < this.getNumberOfLithiumCells()) {
                    points[j + 6] = ((convertBuffer[k + 12] & 0xFF) << 24) + ((convertBuffer[k + 13] & 0xFF) << 16) + ((convertBuffer[k + 14] & 0xFF) << 8) + ((convertBuffer[k + 15] & 0xFF) << 0);
                    if (points[j + 6] > 0) {
                        maxVotage = points[j + 6] > maxVotage ? points[j + 6] : maxVotage;
                        minVotage = points[j + 6] < minVotage ? points[j + 6] : minVotage;
                    }
                    ++j;
                    k += 4;
                }
                points[5] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
            }
            recordSet.addPoints(points);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int deviceDataBufferSize = this.getLovDataByteSize();
        int[] points = new int[this.getNumberOfMeasurements(1)];
        int offset = 0;
        int progressCycle = 0;
        int lovDataSize = this.getLovDataByteSize();
        convertData = new DataParserNext(this, this.getDataBlockTimeUnitFactor(), this.getDataBlockLeader(), this.getDataBlockSeparator().value(), this.getDataBlockCheckSumType(), 14, 0);
        byte[] convertBuffer = new byte[deviceDataBufferSize];
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            lovDataSize = deviceDataBufferSize / 3;
            System.arraycopy(dataBuffer, offset, convertBuffer, 0, deviceDataBufferSize / 3);
            for (int j = deviceDataBufferSize / 3; j < deviceDataBufferSize; ++j) {
                convertBuffer[j] = dataBuffer[offset + j];
                ++lovDataSize;
                if (dataBuffer[offset + j] == 10 && dataBuffer[offset + j - 1] == 13) break;
            }
            recordSet.addPoints(this.convertDataBytes(points, convertBuffer));
            offset += lovDataSize + 8;
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                switch (record.getDataType()) {
                    case DATE_TIME: {
                        dataTableRow[index + 1] = StringHelper.getFormatedTime((String)record.getUnit(), (long)record.realGet(rowIndex).intValue());
                        dataTableRow[index + 1] = dataTableRow[index + 1].substring(0, dataTableRow[index + 1].indexOf(44) + 2);
                        break;
                    }
                    default: {
                        dataTableRow[index + 1] = record.getFormattedTableValue(rowIndex);
                    }
                }
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        PropertyType property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
        boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
        property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
        boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
        try {
            if (subtractFirst) {
                reduction = (double)record.getFirst().intValue() / 1000.0;
            }
            if (subtractLast) {
                reduction = (double)record.getLast().intValue() / 1000.0;
            }
        }
        finally {
            double newValue = 0.0;
        }
        {
        }
    }

    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        PropertyType property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
        boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
        property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
        boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
        try {
            if (subtractFirst) {
                reduction = (double)record.getFirst().intValue() / 1000.0;
            }
            if (subtractLast) {
                reduction = (double)record.getLast().intValue() / 1000.0;
            }
        }
        finally {
            double newValue = 0.0;
        }
        {
        }
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        String[] recordNames = recordSet.getRecordNames();
        block3: for (int i = 0; i < recordNames.length; ++i) {
            MeasurementType measurement = this.getMeasurement(recordSet.getChannelConfigNumber(), i);
            PropertyType dataTypeProperty = measurement.getProperty(MeasurementPropertyTypes.DATA_TYPE.value());
            if (dataTypeProperty == null) continue;
            switch (Record.DataType.fromValue((String)dataTypeProperty.getValue())) {
                case DATE_TIME: 
                case GPS_LATITUDE: 
                case GPS_LONGITUDE: 
                case GPS_ALTITUDE: {
                    recordSet.get((Object)recordNames[i]).setDataType(Record.DataType.fromValue((String)dataTypeProperty.getValue()));
                    continue block3;
                }
            }
        }
        this.application.updateStatisticsData();
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        Record record;
        int i;
        recordSet.setAllDisplayable();
        for (i = 0; i < recordSet.size(); ++i) {
            record = recordSet.get(i);
            record.setDisplayable(record.hasReasonableData());
            if (!log.isLoggable(Level.FINER)) continue;
            log.log(Level.FINER, record.getName() + " setDisplayable=" + record.hasReasonableData());
        }
        if (log.isLoggable(Level.FINE)) {
            for (i = 0; i < recordSet.size(); ++i) {
                record = recordSet.get(i);
                log.log(Level.FINE, record.getName() + " isActive=" + record.isActive() + " isVisible=" + record.isVisible() + " isDisplayable=" + record.isDisplayable());
            }
        }
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION};
    }

    public void open_closeCommPort() {
        block12: {
            if (this.isSerialIO && this.serialPort != null) {
                if (!this.serialPort.isConnected()) {
                    try {
                        Channel activChannel = Channels.getInstance().getActiveChannel();
                        if (activChannel == null) break block12;
                        this.gathererThread = new GathererThread(this.application, this, this.serialPort);
                        try {
                            if (this.serialPort.isConnected()) {
                                this.gathererThread.start();
                            }
                        }
                        catch (RuntimeException e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                        }
                        catch (Throwable e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    catch (SerialPortException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                    }
                    catch (ApplicationConfigurationException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0010"));
                        this.application.getDeviceSelectionDialog().open();
                    }
                    catch (Throwable e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    if (this.gathererThread != null) {
                        this.gathererThread.stopDataGatheringThread(false, null);
                    }
                    this.serialPort.close();
                }
            }
        }
    }

    protected static enum States {
        unknown("?"),
        l("l"),
        L("L"),
        p("p"),
        P("P"),
        e("e"),
        E("E"),
        r("r"),
        R("R"),
        o("o"),
        O("O"),
        v("v"),
        V("V");

        String value;
        public static String[] VALUES;

        private States(String setValue) {
            this.value = setValue;
        }

        private static String[] getValues() {
            ArrayList<String> list = new ArrayList<String>();
            for (States element : States.values()) {
                list.add(element.value);
            }
            return list.toArray(new String[0]);
        }

        public int getOrdinal() {
            log.log(Level.INFO, "state = " + this.value);
            int result = super.ordinal();
            return result == -1 ? 0 : result;
        }

        static {
            VALUES = States.getValues();
        }
    }
}

