/*
 * Decompiled with CFR 0.152.
 */
package gde.device.junsi;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.junsi.iCharger;
import gde.device.junsi.iChargerSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import java.util.logging.Logger;

public class GathererThread
extends Thread {
    static final String $CLASS_NAME = GathererThread.class.getName();
    static final Logger log = Logger.getLogger(GathererThread.class.getName());
    static final int WAIT_TIME_RETRYS = 120;
    final DataExplorer application;
    final iChargerSerialPort serialPort;
    final iCharger device;
    final Channels channels;
    final Channel channel;
    final int channelNumber;
    String recordSetKey = Messages.getString((String)"GDE_MSGT0272");
    boolean isPortOpenedByLiveGatherer = false;
    int numberBatteryCells = 0;
    int retryCounter = 120;
    boolean isCollectDataStopped = false;
    int lastNumberDisplayableRecords = 0;

    public GathererThread(DataExplorer currentApplication, iCharger useDevice, iChargerSerialPort useSerialPort, int channelConfigNumber) throws ApplicationConfigurationException, SerialPortException {
        super("dataGatherer");
        this.application = currentApplication;
        this.device = useDevice;
        this.serialPort = useSerialPort;
        this.channels = Channels.getInstance();
        this.channelNumber = channelConfigNumber;
        this.channel = (Channel)this.channels.get((Object)this.channelNumber);
        if (!this.serialPort.isConnected()) {
            this.serialPort.open();
            this.isPortOpenedByLiveGatherer = true;
        }
        this.setPriority(10);
    }

    @Override
    public void run() {
        String $METHOD_NAME = "run";
        RecordSet recordSet = null;
        int[] points = new int[this.device.getNumberOfMeasurements(this.channelNumber)];
        boolean isProgrammExecuting = false;
        long measurementCount = 0L;
        byte[] dataBuffer = null;
        String processName = "";
        this.isCollectDataStopped = false;
        log.logp(Level.FINE, $CLASS_NAME, "run", "====> entry initial time step ms = " + this.device.getTimeStep_ms());
        int numCells = this.device.getNumberOfLithiumCells();
        boolean isCellLog = this.device.getName().contains("CellLog");
        while (!this.isCollectDataStopped) {
            try {
                block31: {
                    if (this.application != null) {
                        this.application.setPortConnected(true);
                    }
                    dataBuffer = this.serialPort.getData();
                    try {
                        if (isCellLog) {
                            if (new String(dataBuffer).startsWith("$ENDBULK")) {
                                this.stopDataGatheringThread(false, null);
                            }
                            processName = "Monitoring";
                            isProgrammExecuting = true;
                        } else {
                            try {
                                processName = this.device.getProcessName(dataBuffer);
                                isProgrammExecuting = true;
                            }
                            catch (Exception e) {
                                log.log(Level.WARNING, String.format("Error in getProcessName evaluating '%s'", StringHelper.byte2CharString((byte[])dataBuffer, (int)dataBuffer.length)));
                                continue;
                            }
                        }
                        if (!log.isLoggable(Level.FINE)) break block31;
                        log.logp(Level.FINE, $CLASS_NAME, "run", "processing mode = " + processName);
                    }
                    catch (Exception e) {
                        StringBuilder sb = new StringBuilder();
                        for (byte b : dataBuffer) {
                            sb.append((char)b);
                        }
                        while (sb.length() > 5 && (sb.charAt(sb.length() - 1) == '\n' || sb.charAt(sb.length() - 1) == '\r')) {
                            sb.deleteCharAt(sb.length() - 1);
                        }
                        log.log(Level.WARNING, sb.toString());
                        log.log(Level.WARNING, e.getMessage(), e);
                        continue;
                    }
                }
                if (isProgrammExecuting) {
                    RecordSet activeRecordSet;
                    if (this.channel.size() == 0 || recordSet == null || processName.length() > 3 && !this.recordSetKey.endsWith(" " + processName)) {
                        this.application.setStatusMessage("");
                        this.setRetryCounter(120);
                        this.recordSetKey = this.channel.getNextRecordSetNumber() + ") " + processName;
                        this.channel.put((Object)this.recordSetKey, (Object)RecordSet.createRecordSet((String)this.recordSetKey, (IDevice)this.application.getActiveDevice(), (int)this.channel.getNumber(), (boolean)true, (boolean)false, (boolean)true));
                        if (log.isLoggable(Level.FINE)) {
                            log.logp(Level.FINE, $CLASS_NAME, "run", this.recordSetKey + " created for channel " + this.channel.getName());
                        }
                        if (this.channel.getActiveRecordSet() == null) {
                            this.channel.setActiveRecordSet(this.recordSetKey);
                        }
                        recordSet = (RecordSet)this.channel.get((Object)this.recordSetKey);
                        this.channel.applyTemplateBasics(this.recordSetKey);
                        if (this.channel.getName().equals(this.channels.getActiveChannel().getName())) {
                            this.channels.getActiveChannel().switchRecordSet(this.recordSetKey);
                        }
                        measurementCount = 0L;
                    }
                    if (measurementCount > 0L) {
                        recordSet.addPoints(this.device.convertDataBytes(points, dataBuffer));
                    }
                    ++measurementCount;
                    if (recordSet == null) continue;
                    if (measurementCount > 0L && measurementCount % 5L == 0L) {
                        this.numberBatteryCells = 0;
                        for (int i = numCells; i < recordSet.size(); ++i) {
                            Record record = recordSet.get(i);
                            if (!record.hasReasonableData()) continue;
                            ++this.numberBatteryCells;
                        }
                        this.device.updateVisibilityStatus(recordSet, true);
                    }
                    if ((activeRecordSet = this.channels.getActiveChannel().getActiveRecordSet()) == null || recordSet.size() <= 0 || !recordSet.isChildOfActiveChannel() || !recordSet.equals((Object)activeRecordSet)) continue;
                    this.application.updateAllTabs(false, this.lastNumberDisplayableRecords != recordSet.getConfiguredDisplayable());
                    this.lastNumberDisplayableRecords = recordSet.getConfiguredDisplayable();
                    continue;
                }
                this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI2600"));
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, $CLASS_NAME, "run", "wait for iCharge activation");
                }
                if (recordSet != null && recordSet.getRecordDataSize(true) > 5) {
                    this.finalizeRecordSet(false);
                    isProgrammExecuting = false;
                    recordSet = null;
                    this.setRetryCounter(120);
                    this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGT2608"));
                    continue;
                }
                if (0 != this.setRetryCounter(this.getRetryCounter() - 1)) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "iCharge activation timeout");
                }
                this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW2600"));
                this.stopDataGatheringThread(false, null);
            }
            catch (DataInconsitsentException e) {
                String message = Messages.getString((String)"GDE_MSGE0036", (Object[])new Object[]{this.getClass().getSimpleName(), "run"});
                this.cleanup(message);
            }
            catch (Throwable e) {
                if (e instanceof TimeOutException && isProgrammExecuting) {
                    this.application.setStatusMessage(">>>> serial port Timeout <<<<");
                    continue;
                }
                if (e instanceof TimeOutException && !isProgrammExecuting) {
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI2600"));
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, $CLASS_NAME, "run", "wait for iCharge activation ...");
                    }
                    if (0 != this.setRetryCounter(this.getRetryCounter() - 1)) continue;
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "iCharge activation timeout");
                    }
                    this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW2600"));
                    this.stopDataGatheringThread(false, null);
                    continue;
                }
                log.log(Level.SEVERE, e.getMessage(), e);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "iCharger program end detected");
                }
                this.stopDataGatheringThread(true, e);
            }
        }
        this.application.setStatusMessage("");
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, $CLASS_NAME, "run", "======> exit");
        }
    }

    void stopDataGatheringThread(boolean enableEndMessage, Throwable throwable) {
        String $METHOD_NAME = "stopDataGatheringThread";
        if (throwable != null) {
            log.logp(Level.WARNING, $CLASS_NAME, "stopDataGatheringThread", throwable.getMessage(), throwable);
        }
        this.isCollectDataStopped = true;
        if (this.serialPort != null && this.serialPort.getXferErrors() > 0) {
            log.log(Level.WARNING, "During complete data transfer " + this.serialPort.getXferErrors() + " number of errors occured!");
        }
        if (this.serialPort != null && this.serialPort.isConnected() && this.isPortOpenedByLiveGatherer && this.serialPort.isConnected()) {
            this.serialPort.close();
        }
        log.log(Level.INFO, "stopDataGatheringThread - this.isCollectDataStopped=" + this.isCollectDataStopped);
        log.log(Level.INFO, "stopDataGatheringThread - this.serialPortisConnected=" + this.serialPort.isConnected());
        RecordSet recordSet = (RecordSet)this.channel.get((Object)this.recordSetKey);
        log.log(Level.INFO, "stopDataGatheringThread - " + (recordSet != null && recordSet.getRecordDataSize(true) > 5));
        if (recordSet != null && recordSet.getRecordDataSize(true) > 5) {
            this.finalizeRecordSet(false);
            if (enableEndMessage) {
                this.application.openMessageDialog(Messages.getString((String)"GDE_MSGT2609"));
            }
        } else if (throwable != null) {
            this.cleanup(Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{throwable.getClass().getSimpleName(), throwable.getMessage()}) + Messages.getString((String)"GDE_MSGT2608"));
        } else if (enableEndMessage) {
            this.cleanup(Messages.getString((String)"GDE_MSGE0026") + Messages.getString((String)"GDE_MSGT2608"));
        }
    }

    void finalizeRecordSet(boolean doClosePort) {
        RecordSet tmpRecordSet;
        if (doClosePort && this.isPortOpenedByLiveGatherer && this.serialPort.isConnected()) {
            this.serialPort.close();
        }
        if ((tmpRecordSet = (RecordSet)this.channel.get((Object)this.recordSetKey)) != null) {
            this.device.updateVisibilityStatus(tmpRecordSet, true);
            this.device.makeInActiveDisplayable(tmpRecordSet);
            this.application.updateStatisticsData();
            this.application.updateDataTable(this.recordSetKey, false);
            this.device.setAverageTimeStep_ms(tmpRecordSet.getAverageTimeStep_ms());
            log.log(Level.TIME, "set average time step msec = " + this.device.getAverageTimeStep_ms());
        }
    }

    void cleanup(final String message) {
        if (this.channel.get((Object)this.recordSetKey) != null) {
            ((RecordSet)this.channel.get((Object)this.recordSetKey)).clear();
            this.channel.remove(this.recordSetKey);
            if (Thread.currentThread().threadId() == this.application.getThreadId()) {
                this.application.getMenuToolBar().updateRecordSetSelectCombo();
                this.application.updateStatisticsData();
                this.application.updateDataTable(this.recordSetKey, true);
                this.application.openMessageDialog(message);
            } else {
                final String useRecordSetKey = this.recordSetKey;
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GathererThread.this.application.getMenuToolBar().updateRecordSetSelectCombo();
                        GathererThread.this.application.updateStatisticsData();
                        GathererThread.this.application.updateDataTable(useRecordSetKey, true);
                        GathererThread.this.application.openMessageDialog(message);
                    }
                });
            }
        } else {
            this.application.openMessageDialog(message);
        }
    }

    void setCollectDataStopped(boolean enabled) {
        this.isCollectDataStopped = enabled;
    }

    boolean isCollectDataStopped() {
        return this.isCollectDataStopped;
    }

    int getRetryCounter() {
        return this.retryCounter;
    }

    int setRetryCounter(int newRetryCounter) {
        this.retryCounter = newRetryCounter;
        return this.retryCounter;
    }
}

