/*
 * Decompiled with CFR 0.152.
 */
package gde.device.junsi;

import gde.device.CheckSumTypes;
import gde.device.FormatTypes;
import gde.device.InputTypes;
import gde.device.junsi.iChargerUsb;
import gde.exception.DevicePropertiesInconsistenceException;
import gde.io.DataParser;
import gde.messages.Messages;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataParserDuo
extends DataParser {
    static Logger log = Logger.getLogger(DataParser.class.getName());
    protected final int offset;

    public DataParserDuo(int useTimeFactor, String useLeaderChar, String useSeparator, CheckSumTypes useCheckSumType, int useDataSize, int offset) {
        super(useTimeFactor, useLeaderChar, useSeparator, useCheckSumType, useDataSize);
        this.offset = offset;
    }

    public DataParserDuo(int useTimeFactor, String useLeaderChar, String useSeparator, CheckSumTypes useCheckSumType, FormatTypes useCheckSumFormatType, int useDataSize, FormatTypes useDataFormatType, boolean doMultiply1000, int offset) {
        super(useTimeFactor, useLeaderChar, useSeparator, useCheckSumType, useCheckSumFormatType, useDataSize, useDataFormatType, doMultiply1000);
        this.offset = offset;
    }

    public void parse(String inputLine, String[] strValues) throws DevicePropertiesInconsistenceException {
        String strValue = strValues[0].trim().substring(1);
        this.channelConfigNumber = Integer.parseInt(strValue);
        strValue = strValues[1].trim();
        this.state = Integer.parseInt(strValue);
        switch (this.state) {
            default: {
                strValue = strValues[2].trim().replace(',', '.');
                String string = strValue = strValue.length() > 0 ? strValue : "0";
                if (this.start_time_ms == Integer.MIN_VALUE) {
                    this.start_time_ms = (int)(Double.parseDouble(strValue) * (double)this.timeFactor);
                } else {
                    this.time_ms = (int)(Double.parseDouble(strValue) * (double)this.timeFactor) - this.start_time_ms;
                }
                for (int i = this.offset; i < Math.abs(this.device.getDataBlockSize(InputTypes.FILE_IO)) + this.offset; ++i) {
                    strValue = strValues[i + 3].trim();
                    try {
                        double tmpValue;
                        double d = tmpValue = strValue.length() > 0 ? Double.parseDouble(strValue.trim()) : 0.0;
                        if (this.isMultiply1000 && tmpValue < 2147483.0 && tmpValue > -2147483.0) {
                            this.values[i - this.offset] = (int)(tmpValue * 1000.0);
                            continue;
                        }
                        if (tmpValue < 2.147483647E9 || tmpValue > -2.147483648E9) {
                            this.values[i - this.offset] = (int)tmpValue;
                            continue;
                        }
                        this.values[i - this.offset] = (int)(tmpValue / 1000.0);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.values[i - this.offset] = 0;
                    }
                }
                break;
            }
            case 128: {
                int valueOffset = ((iChargerUsb)this.device).getNoneCalculationMeasurementNames(1, ((iChargerUsb)this.device).getMeasurementNames(1)).length - ((iChargerUsb)this.device).getNumberOfLithiumCells() - 2;
                strValue = strValues[2].trim().replace(',', '.');
                String string = strValue = strValue.length() > 0 ? strValue : "0";
                if (this.start_time_ms == Integer.MIN_VALUE) {
                    this.start_time_ms = (int)(Double.parseDouble(strValue) * (double)this.timeFactor);
                } else {
                    this.time_ms = (int)(Double.parseDouble(strValue) * (double)this.timeFactor) - this.start_time_ms;
                }
                for (int i = 0; i < this.valueSize - valueOffset; ++i) {
                    strValue = strValues[i + 1 + this.offset].trim();
                    try {
                        double tmpValue = strValue.length() > 0 ? Double.parseDouble(strValue.trim()) : 0.0;
                        this.values[i + valueOffset] = (int)tmpValue;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.values[i + valueOffset] = 0;
                    }
                }
                break;
            }
            case 130: 
        }
        if (this.device.getTimeStep_ms() < 0.0 && this.time_ms <= 0 && this.isTimeResetEnabled) {
            this.recordSetNumberOffset += ++this.timeResetCounter;
            this.isTimeResetEnabled = false;
        }
        if (this.checkSumType != null && !this.isChecksumOK(inputLine, Integer.parseInt(strValues[strValues.length - 1].trim(), 16))) {
            DevicePropertiesInconsistenceException e = new DevicePropertiesInconsistenceException(Messages.getString((String)"GDE_MSGE0049", (Object[])new Object[]{strValues[strValues.length - 1].trim(), String.format("%X", this.calcChecksum(inputLine))}));
            log.log(Level.WARNING, e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

