/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import com.sun.istack.Nullable;
import gde.Analyzer;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.ScoreLabelTypes;
import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTbinReader;
import gde.device.graupner.HoTTlogReader;
import gde.device.graupner.PackageLoss;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.exception.ThrowableUtils;
import gde.histo.cache.ExtendedVault;
import gde.histo.cache.VaultCollector;
import gde.histo.device.UniversalSampler;
import gde.log.Level;
import gde.utils.StringHelper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class HoTTlogHistoReader {
    private static final String $CLASS_NAME = HoTTlogHistoReader.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    protected static final int RECORD_TIMESPAN_MS = 50;
    protected final HoTTAdapter.PickerParameters pickerParameters;
    protected final Analyzer analyzer;
    protected final boolean isChannelsChannelEnabled;
    protected final int initializeSamplingFactor;
    protected final boolean isFilterEnabled;
    protected final boolean isFilterTextModus;
    protected final int altitudeClimbSensorSelection;
    protected final Procedure initTimer;
    protected final Procedure readTimer;
    protected final Procedure reviewTimer;
    protected final Procedure addTimer;
    protected final Procedure pickTimer;
    protected final Procedure finishTimer;
    protected final int dataBlockSize;
    protected final int rawDataBlockSize;
    protected final int logDataOffset;
    protected final long logEntryCount;
    protected final int numberUsedChannels;
    protected final boolean isASCII;
    protected long nanoTime;
    protected long currentTime;
    protected long initiateTime;
    protected long readTime;
    protected long reviewTime;
    protected long addTime;
    protected long pickTime;
    protected long finishTime;
    protected long lastTime;
    protected EnumSet<HoTTAdapter.Sensor> detectedSensors;
    protected RecordSet tmpRecordSet;
    protected VaultCollector truss;
    protected HashMap<String, String> infoHeader;

    public HoTTlogHistoReader(HoTTAdapter.PickerParameters pickerParameters, HashMap<String, String> newInfoHeader) {
        this(pickerParameters, pickerParameters.analyzer.getActiveChannel().getNumber() == HoTTAdapter.Sensor.CHANNEL.getChannelNumber(), 1, newInfoHeader);
    }

    public HoTTlogHistoReader(HoTTAdapter.PickerParameters pickerParameters, int initializeSamplingFactor, HashMap<String, String> newInfoHeader) {
        this(pickerParameters, pickerParameters.analyzer.getActiveChannel().getNumber() == HoTTAdapter.Sensor.CHANNEL.getChannelNumber(), initializeSamplingFactor, newInfoHeader);
    }

    protected HoTTlogHistoReader(HoTTAdapter.PickerParameters pickerParameters, boolean isChannelsChannelEnabled, int initializeSamplingFactor, HashMap<String, String> newInfoHeader) {
        this.pickerParameters = new HoTTAdapter.PickerParameters(pickerParameters);
        this.pickerParameters.isFilterEnabled = true;
        this.analyzer = pickerParameters.analyzer;
        this.isChannelsChannelEnabled = isChannelsChannelEnabled;
        this.initializeSamplingFactor = initializeSamplingFactor;
        this.isFilterEnabled = true;
        this.isFilterTextModus = true;
        this.altitudeClimbSensorSelection = 0;
        this.infoHeader = newInfoHeader;
        this.isASCII = this.infoHeader.get("LOG TYPE").contains("ASCII");
        this.detectedSensors = HoTTAdapter.Sensor.getSetFromDetected(this.infoHeader.get("DETECTED SENSOR"));
        this.dataBlockSize = Integer.parseInt(this.infoHeader.get("DATA_BLOCK_SIZE"));
        this.rawDataBlockSize = Integer.parseInt(this.infoHeader.get("RAW_LOG_SIZE"));
        this.logDataOffset = Integer.parseInt(this.infoHeader.get("LOG DATA OFFSET"));
        this.logEntryCount = Long.parseLong(this.infoHeader.get("LogCount"));
        this.numberUsedChannels = Integer.parseInt(this.infoHeader.get("LOG NOB CHANNEL"));
        if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, String.format("%s isASCII = %b dataBlockSize = %d rawDataBlockSize = %d logDataOffset =  %d", this.infoHeader.get("FilePath").substring(this.infoHeader.get("FilePath").lastIndexOf("/")), this.isASCII, this.dataBlockSize, this.rawDataBlockSize, this.logDataOffset));
        }
        if (log.isLoggable(Level.TIME)) {
            this.initTimer = () -> {
                this.currentTime = System.nanoTime();
                this.initiateTime += this.currentTime - this.lastTime;
                this.lastTime = this.currentTime;
            };
            this.readTimer = () -> {
                this.currentTime = System.nanoTime();
                this.readTime += this.currentTime - this.lastTime;
                this.lastTime = this.currentTime;
            };
            this.reviewTimer = () -> {
                this.currentTime = System.nanoTime();
                this.reviewTime += this.currentTime - this.lastTime;
                this.lastTime = this.currentTime;
            };
            this.addTimer = () -> {
                this.currentTime = System.nanoTime();
                this.addTime += this.currentTime - this.lastTime;
                this.lastTime = this.currentTime;
            };
            this.pickTimer = () -> {
                this.currentTime = System.nanoTime();
                this.pickTime += this.currentTime - this.lastTime;
                this.lastTime = this.currentTime;
            };
            this.finishTimer = () -> {
                this.currentTime = System.nanoTime();
                this.finishTime += this.currentTime - this.lastTime;
                this.lastTime = this.currentTime;
            };
        } else {
            this.pickTimer = this.finishTimer = () -> {};
            this.addTimer = this.finishTimer;
            this.reviewTimer = this.finishTimer;
            this.readTimer = this.finishTimer;
            this.initTimer = this.finishTimer;
        }
    }

    public void read(Supplier<InputStream> inputStream, VaultCollector newTruss) throws IOException, DataTypeException, DataInconsitsentException {
        this.nanoTime = System.nanoTime();
        this.finishTime = 0L;
        this.pickTime = 0L;
        this.addTime = 0L;
        this.reviewTime = 0L;
        this.readTime = 0L;
        this.initiateTime = 0L;
        this.lastTime = System.nanoTime();
        this.truss = newTruss;
        IDevice device = this.analyzer.getActiveDevice();
        ExtendedVault vault = this.truss.getVault();
        long numberDatablocks = Long.parseLong(this.infoHeader.get("LogCount"));
        this.tmpRecordSet = RecordSet.createRecordSet((String)vault.getLogRecordsetBaseName(), (Analyzer)this.analyzer, (int)this.analyzer.getActiveChannel().getNumber(), (boolean)true, (boolean)true, (boolean)false);
        this.tmpRecordSet.setStartTimeStamp(HoTTbinReader.getStartTimeStamp(this.infoHeader.get("LOG START TIME"), HoTTbinReader.getStartTimeStamp(vault.getLoadFileAsPath().getFileName().toString(), vault.getLogFileLastModified(), numberDatablocks)));
        this.tmpRecordSet.setRecordSetDescription(device.getName() + " - " + StringHelper.getFormatedTime((String)"yyyy-MM-dd HH:mm:ss.SSS", (long)this.tmpRecordSet.getStartTimeStamp()));
        this.tmpRecordSet.descriptionAppendFilename(vault.getLoadFileAsPath().getFileName().toString());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, " recordSetBaseName=" + vault.getLogRecordsetBaseName());
        }
        try {
            this.read(inputStream);
        }
        catch (DataTypeException e) {
            log.log(Level.WARNING, String.format("%s  %s", e.getMessage(), vault.getLoadFilePath()));
        }
        catch (InvalidObjectException invalidObjectException) {
            // empty catch block
        }
    }

    protected void read(Supplier<InputStream> inputStream) throws IOException, DataTypeException, DataInconsitsentException {
        try (BufferedInputStream in = new BufferedInputStream(inputStream.get());
             BufferedInputStream data_in = in;){
            if ((long)this.logDataOffset != ((InputStream)data_in).skip(this.logDataOffset)) {
                log.log(Level.WARNING, "skipping logDataOffset failed");
            }
            int initializeBlockLimit = this.initializeSamplingFactor * 1500 / 5;
            int readLimitMark = (initializeBlockLimit + 1) * this.dataBlockSize + 1;
            ((InputStream)data_in).mark(readLimitMark);
            int activeChannelNumber = this.analyzer.getActiveChannel().getNumber();
            int[] points = new int[this.analyzer.getActiveDevice().getNumberOfMeasurements(activeChannelNumber)];
            UniversalSampler initSampler = UniversalSampler.createSampler((int)activeChannelNumber, (int[])points, (int)50, (Analyzer)this.analyzer);
            this.read(data_in, initializeBlockLimit, initSampler);
            ((InputStream)data_in).reset();
            UniversalSampler sampler = UniversalSampler.createSampler((int)activeChannelNumber, (int[])initSampler.getMaxPoints(), (int[])initSampler.getMinPoints(), (int)50, (Analyzer)this.analyzer);
            this.read(data_in, -1, sampler);
        }
    }

    protected void read(InputStream data_in, int initializeBlocks, UniversalSampler histoRandomSample) throws DataInconsitsentException, IOException {
        int i;
        HoTTlogReader.LogParser logParser;
        int[] points = histoRandomSample.getPoints();
        byte[] buf = new byte[this.dataBlockSize];
        long[] timeSteps_ms = new long[]{0L};
        boolean isTextModusSignaled = false;
        int activeChannelNumber = this.analyzer.getActiveChannel().getNumber();
        if (activeChannelNumber == HoTTAdapter.Sensor.RECEIVER.getChannelNumber()) {
            logParser = HoTTAdapter.Sensor.RECEIVER.createLogParser(this.pickerParameters, points, timeSteps_ms, buf, this.numberUsedChannels);
        } else if (activeChannelNumber == HoTTAdapter.Sensor.CHANNEL.getChannelNumber()) {
            logParser = HoTTAdapter.Sensor.CHANNEL.createLogParser(this.pickerParameters, points, timeSteps_ms, buf, this.numberUsedChannels);
        } else if (activeChannelNumber == HoTTAdapter.Sensor.VARIO.getChannelNumber()) {
            logParser = HoTTAdapter.Sensor.VARIO.createLogParser(this.pickerParameters, points, timeSteps_ms, buf, this.numberUsedChannels);
        } else if (activeChannelNumber == HoTTAdapter.Sensor.GPS.getChannelNumber()) {
            logParser = HoTTAdapter.Sensor.GPS.createLogParser(this.pickerParameters, points, timeSteps_ms, buf, this.numberUsedChannels);
        } else if (activeChannelNumber == HoTTAdapter.Sensor.GAM.getChannelNumber()) {
            logParser = HoTTAdapter.Sensor.GAM.createLogParser(this.pickerParameters, points, timeSteps_ms, buf, this.numberUsedChannels);
        } else if (activeChannelNumber == HoTTAdapter.Sensor.EAM.getChannelNumber()) {
            logParser = HoTTAdapter.Sensor.EAM.createLogParser(this.pickerParameters, points, timeSteps_ms, buf, this.numberUsedChannels);
        } else if (activeChannelNumber == HoTTAdapter.Sensor.ESC.getChannelNumber()) {
            logParser = HoTTAdapter.Sensor.ESC.createLogParser(this.pickerParameters, points, timeSteps_ms, buf, this.numberUsedChannels);
        } else {
            throw new UnsupportedOperationException();
        }
        Procedure pointsAdder = initializeBlocks <= 0 ? () -> {
            this.readTimer.invoke();
            boolean isValidSample = histoRandomSample.capturePoints(timeSteps_ms[0]);
            this.reviewTimer.invoke();
            if (isValidSample) {
                try {
                    this.tmpRecordSet.addPoints(histoRandomSample.getSamplePoints(), (double)histoRandomSample.getSampleTimeStep_ms());
                }
                catch (DataInconsitsentException e) {
                    throw ThrowableUtils.rethrow((Throwable)e);
                }
                this.addTimer.invoke();
                this.pickTimer.invoke();
            }
        } : () -> histoRandomSample.capturePoints(timeSteps_ms[0]);
        this.initTimer.invoke();
        boolean doFullRead = initializeBlocks <= 0;
        int datablocksLimit = doFullRead ? (int)this.logEntryCount : initializeBlocks;
        for (i = 0; i < datablocksLimit; ++i) {
            if (buf.length != data_in.read(buf)) {
                log.log(Level.WARNING, "reading buf failed 1");
            }
            if (this.isASCII) {
                HoTTlogReader.convertAscii2Raw(this.rawDataBlockSize, buf);
            }
            if (buf[8] != 0 && buf[9] != 0 && buf[24] != 31) break;
        }
        while (i < datablocksLimit) {
            if (buf.length != data_in.read(buf)) {
                log.log(Level.WARNING, "reading buf failed 2");
            }
            if (i % 10 == 0 && log.isLoggable(Level.FINE)) {
                if (this.isASCII) {
                    log.log(Level.FINE, new String(buf));
                } else {
                    log.log(Level.FINE, StringHelper.byte2Hex4CharString((byte[])buf, (int)buf.length));
                }
            }
            if (this.isASCII) {
                HoTTlogReader.convertAscii2Raw(this.rawDataBlockSize, buf);
            }
            if (buf[8] != 0 && buf[9] != 0) {
                if (buf[24] != 31) {
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, String.format("Sensor %02X", buf[26]));
                    }
                    if (logParser instanceof HoTTlogReader.RcvLogParser) {
                        ((HoTTlogReader.RcvLogParser)logParser).trackPackageLoss(true);
                        logParser.parse();
                        pointsAdder.invoke();
                        ((HoTTlogReader.RcvLogParser)logParser).updateLossStatistics();
                    } else if (logParser instanceof HoTTlogReader.ChnLogParser) {
                        logParser.parse();
                        pointsAdder.invoke();
                    } else if (logParser instanceof HoTTlogReader.VarLogParser && buf[26] == -112) {
                        logParser.parse();
                        pointsAdder.invoke();
                    } else if (logParser instanceof HoTTlogReader.GpsLogParser && buf[26] == -96) {
                        logParser.parse();
                        pointsAdder.invoke();
                    } else if (logParser instanceof HoTTlogReader.GamLogParser && buf[26] == -48) {
                        logParser.parse();
                        pointsAdder.invoke();
                    } else if (logParser instanceof HoTTlogReader.EamLogParser && buf[26] == -32) {
                        logParser.parse();
                        pointsAdder.invoke();
                    } else if (logParser instanceof HoTTlogReader.EscLogParser && buf[26] == -64) {
                        ((HoTTlogReader.EscLogParser)logParser).parse(this.tmpRecordSet, logParser.getTimeStep_ms());
                        pointsAdder.invoke();
                    }
                }
                timeSteps_ms[0] = timeSteps_ms[0] + 50L;
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "-->> Found tx=rx=0 dBm");
                }
                if (logParser instanceof HoTTlogReader.RcvLogParser) {
                    ((HoTTlogReader.RcvLogParser)logParser).trackPackageLoss(false);
                }
                if (logParser instanceof HoTTlogReader.ChnLogParser && logParser.parse()) {
                    pointsAdder.invoke();
                }
                timeSteps_ms[0] = timeSteps_ms[0] + 50L;
            }
            ++i;
        }
        if (doFullRead) {
            PackageLoss lostPackages = null;
            if (logParser instanceof HoTTlogReader.RcvLogParser) {
                ((HoTTlogReader.RcvLogParser)logParser).finalUpdateLossStatistics();
                lostPackages = ((HoTTlogReader.RcvLogParser)logParser).getLostPackages();
            }
            Integer[] scores = this.getScores(lostPackages, histoRandomSample, this.truss.getVault());
            HoTTAdapter device = (HoTTAdapter)this.analyzer.getActiveDevice();
            device.calculateInactiveRecords(this.tmpRecordSet);
            device.updateVisibilityStatus(this.tmpRecordSet, true);
            this.truss.promoteTruss(this.tmpRecordSet, scores);
            this.finishTimer.invoke();
            this.writeFinalLog(isTextModusSignaled, lostPackages, histoRandomSample, this.truss.getVault());
            this.tmpRecordSet.cleanup();
        }
        log.log(Level.FINER, " > ends <  doFullRead=", doFullRead);
    }

    protected Integer[] getScores(@Nullable PackageLoss lostPackages, UniversalSampler histoRandomSample, ExtendedVault vault) {
        int lossTotal = lostPackages == null ? 0 : lostPackages.lossTotal;
        Integer[] scores = new Integer[ScoreLabelTypes.VALUES.length];
        scores[ScoreLabelTypes.TOTAL_READINGS.ordinal()] = histoRandomSample.getReadingCount();
        scores[ScoreLabelTypes.TOTAL_PACKAGES.ordinal()] = (int)(lostPackages == null ? vault.getLogFileLength() / (long)this.dataBlockSize : (long)lostPackages.numberTrackedSamples) * 1000;
        scores[ScoreLabelTypes.LOST_PACKAGES.ordinal()] = lossTotal * 1000;
        if (lostPackages != null) {
            scores[ScoreLabelTypes.LOST_PACKAGES_PER_MILLE.ordinal()] = (int)(lostPackages.percentage * 10000.0);
            scores[ScoreLabelTypes.LOST_PACKAGES_AVG_MS.ordinal()] = (int)lostPackages.getAvgValue() * 50 * 1000;
            scores[ScoreLabelTypes.LOST_PACKAGES_MAX_MS.ordinal()] = lostPackages.getMaxValue() * 50 * 1000;
            scores[ScoreLabelTypes.LOST_PACKAGES_MIN_MS.ordinal()] = lostPackages.getMinValue() * 50 * 1000;
            scores[ScoreLabelTypes.LOST_PACKAGES_SIGMA_MS.ordinal()] = (int)lostPackages.getSigmaValue() * 50 * 1000;
        } else {
            scores[ScoreLabelTypes.LOST_PACKAGES_PER_MILLE.ordinal()] = 0;
            scores[ScoreLabelTypes.LOST_PACKAGES_AVG_MS.ordinal()] = 0;
            scores[ScoreLabelTypes.LOST_PACKAGES_MAX_MS.ordinal()] = 0;
            scores[ScoreLabelTypes.LOST_PACKAGES_MIN_MS.ordinal()] = 0;
            scores[ScoreLabelTypes.LOST_PACKAGES_SIGMA_MS.ordinal()] = 0;
        }
        BitSet activeSensors = HoTTAdapter.Sensor.getSensors(this.detectedSensors);
        scores[ScoreLabelTypes.SENSORS.ordinal()] = (int)activeSensors.toLongArray()[0];
        scores[ScoreLabelTypes.SENSOR_VARIO.ordinal()] = this.detectedSensors.contains((Object)HoTTAdapter.Sensor.VARIO) ? 1000 : 0;
        scores[ScoreLabelTypes.SENSOR_GPS.ordinal()] = this.detectedSensors.contains((Object)HoTTAdapter.Sensor.GPS) ? 1000 : 0;
        scores[ScoreLabelTypes.SENSOR_GAM.ordinal()] = this.detectedSensors.contains((Object)HoTTAdapter.Sensor.GAM) ? 1000 : 0;
        scores[ScoreLabelTypes.SENSOR_EAM.ordinal()] = this.detectedSensors.contains((Object)HoTTAdapter.Sensor.EAM) ? 1000 : 0;
        scores[ScoreLabelTypes.SENSOR_ESC.ordinal()] = this.detectedSensors.contains((Object)HoTTAdapter.Sensor.ESC) ? 1000 : 0;
        scores[ScoreLabelTypes.SENSOR_COUNT.ordinal()] = (this.detectedSensors.size() - 1) * 1000;
        scores[ScoreLabelTypes.LOG_DATA_VERSION.ordinal()] = 4000;
        scores[ScoreLabelTypes.LOG_DATA_EXPLORER_VERSION.ordinal()] = 0;
        scores[ScoreLabelTypes.LOG_FILE_VERSION.ordinal()] = 0;
        scores[ScoreLabelTypes.LOG_RECORD_SET_BYTES.ordinal()] = histoRandomSample.getReadingCount() * this.dataBlockSize;
        scores[ScoreLabelTypes.LOG_FILE_BYTES.ordinal()] = (int)vault.getLogFileLength();
        scores[ScoreLabelTypes.LOG_FILE_RECORD_SETS.ordinal()] = (this.detectedSensors.size() + 1) * 1000;
        scores[ScoreLabelTypes.ELAPSED_HISTO_RECORD_SET_MS.ordinal()] = (int)TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - this.nanoTime);
        return scores;
    }

    protected void writeFinalLog(boolean isTextModusSignaled, @Nullable PackageLoss lostPackages, UniversalSampler histoRandomSample, ExtendedVault vault) {
        int lossTotal;
        int n = lossTotal = lostPackages == null ? 0 : lostPackages.lossTotal;
        if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, String.format("%s > packages:%,9d  readings:%,9d  sampled:%,9d  overSampled:%4d", this.tmpRecordSet.getChannelConfigName(), vault.getLogFileLength() / (long)this.dataBlockSize, histoRandomSample.getReadingCount(), this.tmpRecordSet.getRecordDataSize(true), histoRandomSample.getOverSamplingCount()));
        }
        if (log.isLoggable(Level.TIME)) {
            log.log(Level.TIME, String.format("initiateTime: %,7d  readTime: %,7d  reviewTime: %,7d  addTime: %,7d  pickTime: %,7d  finishTime: %,7d", TimeUnit.NANOSECONDS.toMillis(this.initiateTime), TimeUnit.NANOSECONDS.toMillis(this.readTime), TimeUnit.NANOSECONDS.toMillis(this.reviewTime), TimeUnit.NANOSECONDS.toMillis(this.addTime), TimeUnit.NANOSECONDS.toMillis(this.pickTime), TimeUnit.NANOSECONDS.toMillis(this.finishTime)));
        }
        if (lostPackages != null) {
            if (this.tmpRecordSet.getMaxTime_ms() > 0.0) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, String.format("lost:%,9d perMille:%,4d total:%,9d   lostMax_ms:%,4d lostAvg_ms=%,4d", lossTotal, (int)((double)lossTotal / this.tmpRecordSet.getMaxTime_ms() * 1000.0 * 50.0), vault.getLogFileLength() / (long)this.dataBlockSize, lostPackages.getMaxValue() * 10, (int)lostPackages.getAvgValue() * 10));
                }
            } else {
                log.log(Level.WARNING, String.format("RecordSet with unidentified data.  fileLength=%,11d   isTextModusSignaled=%b   %s", vault.getLogFileLength(), isTextModusSignaled, vault.getLoadFilePath()));
            }
        }
    }

    @FunctionalInterface
    static interface Procedure {
        public void invoke();
    }
}

