/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.GDE;
import gde.data.Channel;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.graupner.BackChannelPackageLoss;
import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTAdapterX;
import gde.device.graupner.HoTTbinReader;
import gde.device.graupner.HoTTlogReader;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.io.DataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.menu.MenuToolBar;
import gde.utils.StringHelper;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.EnumSet;
import java.util.logging.Logger;

public class HoTTbinReaderX
extends HoTTbinReader {
    static final String $CLASS_NAMEX = HoTTbinReaderX.class.getName();
    static final Logger logx = Logger.getLogger($CLASS_NAMEX);
    static int[] points_1;
    static final int headerSize = 27;
    static final int footerSize = 323;

    static int convertRxDbm2Strength(int inValue) {
        if (inValue >= 40 && inValue < lookup.length + 40) {
            return lookup[inValue - 40];
        }
        if (inValue < 40) {
            return 100;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void read(String filePath, HoTTAdapter.PickerParameters newPickerParameters) throws Exception {
        block10: {
            HoTTbinReader.pickerParameters = newPickerParameters;
            boolean isHoTTV2 = true;
            File inputFile = new File(filePath);
            FileInputStream file_input = new FileInputStream(inputFile);
            try (DataInputStream data_in = new DataInputStream(file_input);){
                if (inputFile.exists()) {
                    byte[] buffer = new byte[27];
                    data_in.read(buffer);
                    if (new String(buffer).startsWith("GRAUPNER SD LOG")) {
                        buffer = new byte[23];
                        for (int i = 0; i < 4; ++i) {
                            data_in.read(buffer);
                            if (buffer[0] == i + 1) continue;
                            isHoTTV2 = false;
                        }
                        data_in.close();
                        data_in = null;
                        if (isHoTTV2) {
                            HoTTbinReaderX.readSingle(inputFile);
                            break block10;
                        }
                        HoTTbinReader.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW2408"));
                        throw new DataTypeException(Messages.getString((String)"GDE_MSGW2408"));
                    }
                    HoTTbinReader.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW2408"));
                    throw new DataTypeException(Messages.getString((String)"GDE_MSGW2408"));
                }
                throw new IOException(Messages.getString((String)"GDE_MSGW2409"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readSingle(File file) throws IOException, DataInconsitsentException {
        String $METHOD_NAME = "readSingle";
        long startTime = System.nanoTime() / 1000000L;
        FileInputStream file_input = new FileInputStream(file);
        DataInputStream data_in = new DataInputStream(file_input);
        long fileSize = file.length();
        HoTTAdapterX device = (HoTTAdapterX)application.getActiveDevice();
        int recordSetNumber = ((Channel)channels.get((Object)1)).maxSize() + 1;
        Object recordSetName = "";
        String recordSetNameExtend = HoTTbinReaderX.getRecordSetExtend(file);
        Channel channel = null;
        recordSetReceiver = null;
        recordSetChannel = null;
        points_1 = new int[device.getNumberOfMeasurements(1)];
        pointsChannel = new int[15];
        timeStep_ms = 0L;
        dataBlockSize = 23;
        buf = new byte[dataBlockSize];
        buf1 = null;
        buf2 = null;
        buf3 = null;
        buf4 = null;
        buf5 = null;
        buf6 = null;
        buf7 = null;
        buf8 = null;
        buf9 = null;
        bufA = null;
        bufB = null;
        bufC = null;
        bufD = null;
        BackChannelPackageLoss rcvBackChnPkgLoss = new BackChannelPackageLoss();
        detectedSensors = EnumSet.of(HoTTAdapter.Sensor.RECEIVER);
        HoTTbinReaderX.pickerParameters.isChannelsChannelEnabled = false;
        int lastCounter = 0;
        int lapTimes = 99;
        long numberDatablocks = (fileSize - 27L - 323L) / (long)dataBlockSize;
        long startTimeStamp_ms = HoTTbinReader.getStartTimeStamp(file.getName(), file.lastModified(), numberDatablocks);
        String date = new SimpleDateFormat("yyyy-MM-dd").format(startTimeStamp_ms);
        String dateTime = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp_ms);
        MenuToolBar menuToolBar = application.getMenuToolBar();
        int progressIndicator = (int)(numberDatablocks / 30L);
        GDE.getUiNotification().setProgress(0);
        try {
            HoTTbinReader.recordSets.clear();
            detectedSensors.add(HoTTAdapter.Sensor.CHANNEL);
            channel = (Channel)channels.get((Object)2);
            channel.setFileDescription((String)(application.isObjectoriented() ? date + " " + application.getObjectKey() : date));
            recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.CHANNEL.value() + recordSetNameExtend;
            recordSetChannel = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)2, (boolean)true, (boolean)true, (boolean)true);
            channel.put(recordSetName, (Object)recordSetChannel);
            HoTTbinReader.recordSets.put(HoTTAdapter.Sensor.CHANNEL.value(), recordSetChannel);
            RecordSet tmpRecordSet = (RecordSet)channel.get(recordSetName);
            tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
            tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
            if (application.getMenuToolBar() != null) {
                channel.applyTemplate((String)recordSetName, false);
            }
            channel = (Channel)channels.get((Object)1);
            channel.setFileDescription((String)(application.isObjectoriented() ? date + " " + application.getObjectKey() : date));
            recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.RECEIVER.value() + recordSetNameExtend;
            recordSetReceiver = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)1, (boolean)true, (boolean)true, (boolean)true);
            channel.put(recordSetName, (Object)recordSetReceiver);
            HoTTbinReader.recordSets.put(HoTTAdapter.Sensor.RECEIVER.value(), recordSetReceiver);
            tmpRecordSet = (RecordSet)channel.get(recordSetName);
            tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
            tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
            if (application.getMenuToolBar() != null) {
                channel.applyTemplate((String)recordSetName, false);
            }
            data_in.skip(27L);
            int i = 0;
            while ((long)i < numberDatablocks) {
                data_in.read(buf);
                if (logx.isLoggable(Level.FINE)) {
                    if (buf[6] == 65) {
                        logx.logp(Level.FINE, $CLASS_NAMEX, "readSingle", StringHelper.fourDigitsRunningNumber((int)buf.length));
                    }
                    logx.logp(Level.FINE, $CLASS_NAMEX, "readSingle", StringHelper.byte2Hex4CharString((byte[])buf, (int)buf.length));
                }
                if (lastCounter == 0 || lastCounter == (buf[0] & 0xFF) - 1 || lastCounter == 255 && buf[0] == 0) {
                    if (buf[3] != 0 && buf[4] != 0) {
                        rcvBackChnPkgLoss.trackPackageLoss(true, points_1);
                        if (logx.isLoggable(Level.FINER)) {
                            logx.logp(Level.FINER, $CLASS_NAMEX, "readSingle", StringHelper.byte2Hex2CharString((byte[])new byte[]{buf[7]}, (int)1) + " - " + StringHelper.printBinary((byte)buf[7], (boolean)false));
                        }
                        if (HoTTbinReaderX.pickerParameters.isChannelsChannelEnabled) {
                            HoTTbinReaderX.parseAddChannel(buf);
                        }
                        switch (buf[6]) {
                            case 65: {
                                buf1 = new byte[dataBlockSize];
                                System.arraycopy(buf, 0, buf1, 0, buf.length);
                                break;
                            }
                            case 66: {
                                buf2 = new byte[dataBlockSize];
                                System.arraycopy(buf, 0, buf2, 0, buf.length);
                                break;
                            }
                            case 67: {
                                buf3 = new byte[dataBlockSize];
                                System.arraycopy(buf, 0, buf3, 0, buf.length);
                                break;
                            }
                            case 68: {
                                buf4 = new byte[dataBlockSize];
                                System.arraycopy(buf, 0, buf4, 0, buf.length);
                                break;
                            }
                            case 69: {
                                buf5 = new byte[dataBlockSize];
                                System.arraycopy(buf, 0, buf5, 0, buf.length);
                                break;
                            }
                            case 70: {
                                buf6 = new byte[dataBlockSize];
                                System.arraycopy(buf, 0, buf6, 0, buf.length);
                                break;
                            }
                            case 71: {
                                buf7 = new byte[dataBlockSize];
                                System.arraycopy(buf, 0, buf7, 0, buf.length);
                                break;
                            }
                            case 72: {
                                buf8 = new byte[dataBlockSize];
                                System.arraycopy(buf, 0, buf8, 0, buf.length);
                                break;
                            }
                            case 73: {
                                buf9 = new byte[dataBlockSize];
                                System.arraycopy(buf, 0, buf9, 0, buf.length);
                                break;
                            }
                            case 74: {
                                bufA = new byte[dataBlockSize];
                                System.arraycopy(buf, 0, bufA, 0, buf.length);
                                break;
                            }
                            case 75: {
                                bufB = new byte[dataBlockSize];
                                System.arraycopy(buf, 0, bufB, 0, buf.length);
                                break;
                            }
                            case 76: {
                                bufC = new byte[dataBlockSize];
                                System.arraycopy(buf, 0, bufC, 0, buf.length);
                                break;
                            }
                            case 77: {
                                bufD = new byte[dataBlockSize];
                                System.arraycopy(buf, 0, bufD, 0, buf.length);
                                if (!HoTTbinReaderX.pickerParameters.isChannelsChannelEnabled) {
                                    bufD = null;
                                    bufC = null;
                                    bufB = null;
                                    bufA = null;
                                    buf9 = null;
                                    buf8 = null;
                                    buf7 = null;
                                    buf6 = null;
                                    buf5 = null;
                                    buf4 = null;
                                    buf3 = null;
                                    buf2 = null;
                                    buf1 = null;
                                }
                                HoTTbinReaderX.pickerParameters.isChannelsChannelEnabled = true;
                            }
                        }
                        if (buf1 != null && buf2 != null && buf3 != null && buf4 != null && buf5 != null && buf6 != null && buf7 != null && buf8 != null && buf9 != null && bufA != null && bufB != null && bufC != null && bufD != null) {
                            switch (buf[7]) {
                                case 0: {
                                    HoTTbinReaderX.parseAddReceiver(buf1, buf2, buf4, bufD);
                                    break;
                                }
                                case 2: {
                                    if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.ESC)) {
                                        detectedSensors.add(HoTTAdapter.Sensor.ESC);
                                    }
                                    HoTTbinReaderX.parseESC(buf3, buf4, buf5, buf6, buf7, buf8, buf9, bufA);
                                }
                            }
                            bufD = null;
                            bufC = null;
                            bufB = null;
                            bufA = null;
                            buf9 = null;
                            buf8 = null;
                            buf7 = null;
                            buf6 = null;
                            buf5 = null;
                            buf4 = null;
                            buf3 = null;
                            buf2 = null;
                            buf1 = null;
                        }
                        timeStep_ms += 3L;
                        if (i % progressIndicator == 0) {
                            GDE.getUiNotification().setProgress((int)((long)(i * 100) / numberDatablocks));
                        }
                        rcvBackChnPkgLoss.updateLossStatistics();
                    } else {
                        if (logx.isLoggable(Level.FINE)) {
                            logx.log(Level.FINE, "-->> Found tx=rx=0 dBm");
                        }
                        rcvBackChnPkgLoss.trackPackageLoss(false, points_1);
                        if (HoTTbinReaderX.pickerParameters.isChannelsChannelEnabled) {
                            HoTTbinReaderX.parseAddChannel(buf);
                        }
                        timeStep_ms += 3L;
                    }
                    lastCounter = buf[0] & 0xFF;
                } else {
                    logx.log(Level.WARNING, new String(buf));
                }
                ++i;
            }
            rcvBackChnPkgLoss.finalUpdateLossStatistics();
            String packageLossPercentage = recordSetReceiver.getRecordDataSize(true) > 0 ? String.format("%.1f", rcvBackChnPkgLoss.getLostPackages().percentage) : "100";
            recordSetReceiver.setRecordSetDescription(tmpRecordSet.getRecordSetDescription() + Messages.getString((String)"GDE_MSGI2404", (Object[])new Object[]{rcvBackChnPkgLoss.getLossTotal(), rcvBackChnPkgLoss.getLostPackages().lossTotal, packageLossPercentage, rcvBackChnPkgLoss.getLostPackages().getStatistics()}) + String.format(" - Sensor: %s \n", HoTTlogReader.detectedSensors.toString()));
            logx.logp(Level.WARNING, $CLASS_NAMEX, "readSingle", "skipped number receiver data due to package loss = " + rcvBackChnPkgLoss.getLostPackages().lossTotal);
            buf = new byte[323];
            buf0 = new byte[lapTimes];
            buf1 = new byte[lapTimes];
            buf2 = new byte[lapTimes];
            data_in.read(buf);
            System.arraycopy(buf, 19, buf0, 0, buf0.length);
            System.arraycopy(buf, 19 + lapTimes, buf1, 0, buf1.length);
            System.arraycopy(buf, 19 + 2 * lapTimes, buf2, 0, buf2.length);
            int numLaps = buf[buf.length - 1];
            StringBuilder sb = new StringBuilder().append(Messages.getString((String)"GDE_MSGI2406"));
            for (int j = 0; j < numLaps && (buf0[j] != 0 || buf1[j] != 0 || buf2[j] != 0); ++j) {
                sb.append(String.format("%2d: %2dm %02ds %03d\n", j + 1, buf0[j], buf1[j], buf2[j]));
            }
            if (numLaps >= 1) {
                recordSetReceiver.setRecordSetDescription(tmpRecordSet.getRecordSetDescription() + Messages.getString((String)"GDE_MSGI2405", (Object[])new Object[]{numLaps, String.format("%2dm %02ds %03d", buf[buf.length - 7], buf[buf.length - 6], buf[buf.length - 5]), String.format("%2dm %02ds %03d", buf[buf.length - 4], buf[buf.length - 3], buf[buf.length - 2])}) + sb.toString());
            }
            logx.logp(Level.TIME, $CLASS_NAMEX, "readSingle", "read time = " + StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)(System.nanoTime() / 1000000L - startTime)));
            if (menuToolBar != null) {
                for (RecordSet recordSet : HoTTbinReader.recordSets.values()) {
                    device.makeInActiveDisplayable(recordSet);
                    device.updateVisibilityStatus(recordSet, true);
                    recordSet.descriptionAppendFilename(file.getName());
                }
                menuToolBar.updateChannelSelector();
                menuToolBar.updateRecordSetSelectCombo();
                GDE.getUiNotification().setProgress(100);
            }
        }
        finally {
            data_in.close();
            data_in = null;
        }
    }

    protected static String getRecordSetExtend(File file) {
        Object recordSetNameExtend;
        block6: {
            recordSetNameExtend = "";
            if (file.getName().contains("_")) {
                try {
                    Integer.parseInt(file.getName().substring(0, file.getName().lastIndexOf(95)));
                    recordSetNameExtend = " [" + file.getName().substring(0, file.getName().lastIndexOf(95)) + "]";
                }
                catch (Exception e) {
                    if (file.getName().substring(0, file.getName().lastIndexOf(95)).length() <= 8) {
                        recordSetNameExtend = " [" + file.getName().substring(0, file.getName().lastIndexOf(95)) + "]";
                    }
                    break block6;
                }
            }
            try {
                Integer.parseInt(file.getName().substring(0, 4));
                recordSetNameExtend = " [" + file.getName().substring(0, 4) + "]";
            }
            catch (Exception e) {
                if (file.getName().substring(0, file.getName().length()).length() > 12) break block6;
                recordSetNameExtend = " [" + file.getName().substring(0, file.getName().length() - 4) + "]";
            }
        }
        return recordSetNameExtend;
    }

    protected static void parseAddReceiver(byte[] _buf1, byte[] _buf2, byte[] _buf4, byte[] _bufD) throws DataInconsitsentException {
        tmpVoltageRx = _buf2[18] & 0xFF;
        tmpTemperatureRx = _buf2[20] & 0xFF;
        HoTTbinReaderX.points_1[1] = (_buf2[17] & 0xFF) * 1000;
        HoTTbinReaderX.points_1[3] = DataParser.parse2Short((byte[])_buf1, (int)17) * 1000;
        if (!HoTTbinReaderX.pickerParameters.isFilterEnabled || tmpVoltageRx > -1 && tmpVoltageRx < 100 && tmpTemperatureRx < 120) {
            HoTTbinReaderX.points_1[2] = HoTTbinReaderX.convertRxDbm2Strength(_bufD[4] & 0xFF) * 1000;
            HoTTbinReaderX.points_1[4] = (_bufD[3] & 0xFF) * -1000;
            HoTTbinReaderX.points_1[5] = (_bufD[4] & 0xFF) * -1000;
            HoTTbinReaderX.points_1[6] = (_buf2[18] & 0xFF) * 1000;
            HoTTbinReaderX.points_1[7] = (_buf2[20] & 0xFF) * 1000;
            HoTTbinReaderX.points_1[8] = (_buf2[19] & 0xFF) * 1000;
            HoTTbinReaderX.points_1[23] = (_buf4[17] & 0xFF) * 1000;
            HoTTbinReaderX.points_1[24] = (_buf4[19] & 0xFF) * 1000;
            HoTTbinReaderX.points_1[25] = (_buf4[18] & 0xFF) * 1000;
            HoTTbinReaderX.points_1[26] = (_buf4[20] & 0xFF) * 1000;
        }
        recordSetReceiver.addPoints(points_1, (double)timeStep_ms);
    }

    protected static void parseAddChannel(byte[] _buf) throws DataInconsitsentException {
        HoTTbinReaderX.pointsChannel[0] = (_buf[1] & 0xFF) * 1000;
        HoTTbinReaderX.pointsChannel[1] = (_buf[3] & 0xFF) * -1000;
        HoTTbinReaderX.pointsChannel[2] = (_buf[4] & 0xFF) * -1000;
        HoTTbinReaderX.pointsChannel[3] = DataParser.parse2UnsignedShort((byte[])_buf, (int)8) / 2 * 1000;
        HoTTbinReaderX.pointsChannel[4] = DataParser.parse2UnsignedShort((byte[])_buf, (int)10) / 2 * 1000;
        HoTTbinReaderX.pointsChannel[5] = DataParser.parse2UnsignedShort((byte[])_buf, (int)12) / 2 * 1000;
        HoTTbinReaderX.pointsChannel[6] = DataParser.parse2UnsignedShort((byte[])_buf, (int)14) / 2 * 1000;
        recordSetChannel.addPoints(pointsChannel, (double)timeStep_ms);
    }

    private static void parseESC(byte[] _buf3, byte[] _buf4, byte[] _buf5, byte[] _buf6, byte[] _buf7, byte[] _buf8, byte[] _buf9, byte[] _bufA) throws DataInconsitsentException {
        HoTTbinReader.tmpVoltage = DataParser.parse2Short((byte[])_buf4, (int)20);
        HoTTbinReader.tmpCurrent = DataParser.parse2Short((byte[])_buf6, (int)20);
        HoTTbinReader.tmpCapacity = DataParser.parse2Short((byte[])_buf5, (int)20);
        HoTTbinReader.tmpRevolution = DataParser.parse2UnsignedShort((byte)_buf7[20], (byte)_buf8[17]);
        HoTTbinReader.tmpTemperatureFet = _buf8[20] - 20;
        if (!HoTTbinReaderX.pickerParameters.isFilterEnabled || HoTTbinReader.tmpVoltage > 0 && HoTTbinReader.tmpVoltage < 1000 && HoTTbinReader.tmpCurrent < 4000 && HoTTbinReader.tmpCurrent > -10 && HoTTbinReader.tmpRevolution > -1 && HoTTbinReader.tmpRevolution < 20000 && (points_1[19] == 0 || points_1[19] / 1000 - HoTTbinReader.tmpTemperatureFet <= 20)) {
            HoTTbinReaderX.points_1[9] = HoTTbinReader.tmpVoltage * 1000;
            HoTTbinReaderX.points_1[10] = DataParser.parse2Short((byte[])_buf5, (int)18) * 1000;
            HoTTbinReaderX.points_1[11] = HoTTbinReader.tmpCurrent * 1000;
            HoTTbinReaderX.points_1[12] = DataParser.parse2Short((byte[])_buf7, (int)18) * 1000;
            HoTTbinReaderX.points_1[14] = Double.valueOf((double)points_1[9] / 1000.0 * (double)points_1[11] / 100.0).intValue();
            if (!HoTTbinReaderX.pickerParameters.isFilterEnabled || HoTTbinReader.tmpCapacity != 0 && Math.abs(HoTTbinReader.tmpCapacity) <= points_1[13] / 1000 + HoTTbinReader.tmpVoltage * HoTTbinReader.tmpCurrent / 2500 + 2) {
                HoTTbinReaderX.points_1[13] = HoTTbinReader.tmpCapacity * 1000;
            } else if (HoTTbinReader.tmpCapacity != 0) {
                HoTTbinReader.log.log(Level.WARNING, StringHelper.getFormatedTime((String)"mm:ss.SSS", (long)HoTTbinReader.timeStep_ms) + " - " + HoTTbinReader.tmpCapacity + " - " + points_1[13] / 1000 + " + " + (HoTTbinReader.tmpVoltage * HoTTbinReader.tmpCurrent / 2500 + 2));
            }
            HoTTbinReaderX.points_1[15] = HoTTbinReader.tmpRevolution * 1000;
            HoTTbinReaderX.points_1[16] = DataParser.parse2UnsignedShort((byte[])_buf8, (int)18) * 1000;
            HoTTbinReaderX.points_1[17] = (_buf6[18] - 20) * 1000;
            HoTTbinReaderX.points_1[18] = (_buf6[19] - 20) * 1000;
            HoTTbinReaderX.points_1[19] = HoTTbinReader.tmpTemperatureFet * 1000;
            HoTTbinReaderX.points_1[20] = (_buf9[17] - 20) * 1000;
            HoTTbinReaderX.points_1[21] = _buf9[19] * 1000;
            HoTTbinReaderX.points_1[22] = _bufA[17] * 1000;
        }
    }

    static void printByteValues(long millisec, byte[] buffer) {
        StringBuilder sb = new StringBuilder().append(StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)millisec)).append(" : ");
        for (int i = 16; buffer != null && i < buffer.length; ++i) {
            sb.append("(").append(i).append(")").append(String.format("%3d", buffer[i] & 0xFF)).append(" ");
        }
        logx.log(Level.INFO, sb.toString());
    }

    static void printShortValues(long millisec, byte[] buffer) {
        StringBuilder sb = new StringBuilder().append(StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)millisec)).append(" : ");
        for (int i = 0; buffer != null && i < buffer.length - 1; ++i) {
            sb.append("(").append(i).append(")").append(DataParser.parse2Short((byte[])buffer, (int)i)).append(" ");
        }
        logx.log(Level.FINE, sb.toString());
    }
}

