/*
 * Decompiled with CFR 0.152.
 */
package gde.device.robbe;

import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DesktopPropertyType;
import gde.device.DesktopPropertyTypes;
import gde.device.DeviceConfiguration;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.robbe.PowerPeakCalculationThread;
import gde.device.robbe.PowerPeakGathererThread;
import gde.device.robbe.PowerPeakSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.validation.Schema;

public abstract class PowerPeak
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(PowerPeak.class.getName());
    protected String[] USAGE_MODE;
    protected String[] CHARGE_MODE;
    protected String[] DISCHARGE_MODE;
    protected String[] DELAY_MODE;
    protected String[] CURRENT_MODE;
    protected String[] ERROR_MODE;
    protected static final String OPERATIONS_MODE_LINK_DISCHARGE = "05";
    protected static final String OPERATIONS_MODE_LINK_CHARGE = "09";
    protected static final String OPERATIONS_MODE_ERROR = "06";
    protected static final String OPERATIONS_MODE_NONE = "00";
    protected Schema schema;
    protected JAXBContext jc;
    protected String firmware = "-";
    protected PowerPeakGathererThread dataGatherThread;
    protected HashMap<String, PowerPeakCalculationThread> powerPeakCalculationThreads = new HashMap();
    protected final Settings settings = Settings.getInstance();
    protected final DataExplorer application;
    protected final PowerPeakSerialPort serialPort;
    protected final Channels channels;
    public static final String[] cycleDataRecordNames = Messages.getString((String)"GDE_MSGT0398").split(",");
    public static final String[] cycleDataUnitNames = new String[]{"V", "V", "mAh", "mAh", "m\u2126", "m\u2126"};
    public static final String[] cycleDataTableNames = Messages.getString((String)"GDE_MSGT0399").split(",");
    public static final double[] cycleDataFactors = new double[]{1.0, 1.0, 1000.0, 1000.0, 100.0, 100.0};
    public static final int[] cycleDataSyncRefOrdinal = new int[]{-1, 0, -1, 2, -1, 4};
    public static final int[][] cycleDataColors = new int[][]{{0, 0, 255}, {12, 12, 255}, {128, 0, 0}, {128, 12, 12}, {255, 0, 0}, {255, 12, 12}};

    public PowerPeak(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.graupner.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.serialPort = new PowerPeakSerialPort(this, this.application);
        this.channels = Channels.getInstance();
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
    }

    public PowerPeak(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.graupner.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.serialPort = new PowerPeakSerialPort(this, this.application);
        this.channels = Channels.getInstance();
        this.configureSerialPortMenu(1, "", "");
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    public int getLovDataByteSize() {
        return 150;
    }

    public abstract void addConvertedLovDataBufferAsRawDataPoints(RecordSet var1, byte[] var2, int var3, boolean var4) throws DataInconsitsentException;

    public abstract int[] convertDataBytes(int[] var1, byte[] var2);

    public abstract void addDataBufferAsRawDataPoints(RecordSet var1, byte[] var2, int var3, boolean var4) throws DataInconsitsentException;

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double factor = record.getFactor();
                dataTableRow[index + 1] = record.getDecimalFormat().format((double)record.realGet(rowIndex).intValue() / 1000.0 * factor);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        double offset = record.getOffset();
        double factor = record.getFactor();
        double newValue = value * factor + offset;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        }
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        double offset = record.getOffset();
        double factor = record.getFactor();
        double newValue = value / factor - offset;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        }
        return newValue;
    }

    public abstract void updateVisibilityStatus(RecordSet var1, boolean var2);

    public void makeInActiveDisplayable(RecordSet recordSet) {
        if (recordSet.isRaw()) {
            try {
                int displayableCounter = 0;
                for (String measurementKey : recordSet.keySet()) {
                    Record record = recordSet.get((Object)measurementKey);
                    if (!record.isActive() || record.getOrdinal() > 5 && !record.hasReasonableData()) continue;
                    ++displayableCounter;
                }
                Record record = recordSet.get(3);
                if (!(record == null || record.size() != 0 && record.hasReasonableData())) {
                    this.powerPeakCalculationThreads.put(record.getName(), new PowerPeakCalculationThread(record.getName(), this.channels.getActiveChannel().getActiveRecordSet()));
                    try {
                        this.powerPeakCalculationThreads.get(record.getName()).start();
                    }
                    catch (RuntimeException e) {
                        log.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                ++displayableCounter;
                record = recordSet.get(4);
                if (!(record == null || record.size() != 0 && record.hasReasonableData())) {
                    this.powerPeakCalculationThreads.put(record.getName(), new PowerPeakCalculationThread(record.getName(), this.channels.getActiveChannel().getActiveRecordSet()));
                    try {
                        this.powerPeakCalculationThreads.get(record.getName()).start();
                    }
                    catch (RuntimeException e) {
                        log.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                log.log(Level.FINE, "displayableCounter = " + ++displayableCounter);
                recordSet.setConfiguredDisplayable(displayableCounter);
                if (recordSet.getName().equals(this.channels.getActiveChannel().getActiveRecordSet().getName())) {
                    this.application.updateGraphicsWindow();
                }
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public PowerPeakSerialPort getCommunicationPort() {
        return this.serialPort;
    }

    public DeviceDialog getDialog() {
        return null;
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR};
    }

    public void open_closeCommPort() {
        block14: {
            if (this.serialPort != null) {
                if (!this.serialPort.isConnected()) {
                    try {
                        this.serialPort.open();
                        Channel activChannel = Channels.getInstance().getActiveChannel();
                        if (activChannel == null) break block14;
                        this.dataGatherThread = new PowerPeakGathererThread();
                        try {
                            if (this.serialPort.isConnected()) {
                                this.dataGatherThread.start();
                            }
                        }
                        catch (RuntimeException e) {
                            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        }
                        catch (Throwable e) {
                            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    catch (SerialPortException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.serialPort.close();
                        this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                        this.application.getDeviceSelectionDialog().open();
                    }
                    catch (ApplicationConfigurationException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.serialPort.close();
                        this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0010"));
                        this.application.getDeviceSelectionDialog().open();
                    }
                    catch (Throwable e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.serialPort.close();
                    }
                } else {
                    if (this.dataGatherThread != null) {
                        try {
                            this.dataGatherThread.stopDataGatheringThread(false, null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.serialPort.close();
                }
            }
        }
    }

    public int[] getCellVoltageOrdinals() {
        return new int[]{0, 2};
    }

    public int getDesktopTargetReferenceOrdinal(DesktopPropertyTypes desktopPropertyType) {
        DesktopPropertyType property = this.getDesktopProperty(desktopPropertyType);
        return property != null ? property.getTargetReferenceOrdinal() : -1;
    }

    public abstract RobbeDeviceType getDeviceTypeIdentifier();

    public String getFirmwareVersion(byte[] dataBuffer) {
        return String.format("v%.2f", (double)Integer.parseInt(String.format("%c%c", Character.valueOf((char)dataBuffer[1]), Character.valueOf((char)dataBuffer[2])), 16) / 100.0);
    }

    public int getProductCode(byte[] dataBuffer) {
        return Integer.parseInt(String.format("%c%c", Character.valueOf((char)dataBuffer[3]), Character.valueOf((char)dataBuffer[4])), 16);
    }

    public abstract boolean isProcessing(int var1, byte[] var2);

    public abstract int getProcessingMode(byte[] var1);

    public String getProcessingType(byte[] dataBuffer) {
        return "";
    }

    public void matchBatteryMemory2ObjectKey(String batteryMemoryName) {
        Object[] tmpResult = null;
        for (String tmpObjectKey : this.application.getObjectKeys()) {
            if (tmpObjectKey.equals(batteryMemoryName)) {
                tmpResult = new Object[]{tmpObjectKey, 100};
                break;
            }
            String[] batteryNameParts = batteryMemoryName.split(" |-|_");
            int hitCount = 0;
            for (String namePart : batteryNameParts) {
                if (namePart.length() <= 1 || !tmpObjectKey.contains(namePart)) continue;
                ++hitCount;
            }
            if (hitCount <= 0 || tmpResult != null && hitCount <= (Integer)tmpResult[1]) continue;
            tmpResult = new Object[]{tmpObjectKey, hitCount};
            log.log(java.util.logging.Level.FINE, "result updated = " + tmpObjectKey + " hitCount = " + hitCount);
        }
        if (tmpResult != null) {
            this.application.selectObjectKey((String)tmpResult[0]);
        }
    }

    public int getBatteryMemoryNumber(int outletNum, byte[] dataBuffer) {
        return -1;
    }

    public abstract int getCycleNumber(int var1, byte[] var2);

    public boolean isLinkedMode(byte[] dataBuffer) {
        return false;
    }

    public void setTemperatureUnit(int channelNumber, RecordSet recordSet, byte[] dataBuffer) {
    }

    public synchronized int[] convert2IntArray(int[] values, String setupString) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf(setupString.charAt(i * 4)), Character.valueOf(setupString.charAt(i * 4 + 1)), Character.valueOf(setupString.charAt(i * 4 + 2)), Character.valueOf(setupString.charAt(i * 4 + 3))), 16);
        }
        return values;
    }

    public int getCurrentSmoothIndex() {
        return 2;
    }

    public static enum RobbeDeviceType {
        PowerPeakTwin1000W,
        PowerPeakIV;

    }
}

