/*
 * Decompiled with CFR 0.152.
 */
package gde.device.skyrc;

import gde.GDE;
import gde.config.ExportService;
import gde.config.GraphicsTemplate;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.skyrc.MC3000;
import gde.device.skyrc.MC3000Dialog;
import gde.device.skyrc.MC3000FmGathererThread;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.log.Level;
import gde.messages.Messages;
import gde.utils.FileUtils;
import gde.utils.WaitTimer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import javax.usb.UsbClaimException;
import javax.usb.UsbException;
import javax.xml.bind.JAXBException;

public class MC3000_FM_NiMH_LiIo
extends MC3000 {
    static final Logger log = Logger.getLogger(MC3000_FM_NiMH_LiIo.class.getName());
    MC3000FmGathererThread dataGatherThread;

    public MC3000_FM_NiMH_LiIo(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        try {
            this.extractDeviceBatteryTypeTemplates(((ExportService)this.settings.getDeviceServices().get(this.getName())).getJarFile(), this.getName(), Settings.getGraphicsTemplatePath());
        }
        catch (IOException e) {
            log.log(Level.WARNING, "graphics templates doesn't exist and failed to extract from jar");
        }
    }

    public MC3000_FM_NiMH_LiIo(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        try {
            this.extractDeviceBatteryTypeTemplates(((ExportService)this.settings.getDeviceServices().get(this.getName())).getJarFile(), this.getName(), Settings.getGraphicsTemplatePath());
        }
        catch (IOException e) {
            log.log(Level.WARNING, "graphics templates doesn't exist and failed to extract from jar");
        }
    }

    protected void extractDeviceBatteryTypeTemplates(JarFile jarFile, String serviceName, String templateDirectoryTargetPath) {
        String serviceName_ = serviceName.substring(0, serviceName.indexOf("_", 9) + 1);
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            String defaultTemplateName;
            String entryName = e.nextElement().getName();
            if (!entryName.startsWith("resource/template/") || !entryName.endsWith(".xml") || !entryName.contains(serviceName_ + "NiMH") && !entryName.contains(serviceName_ + "LiIo") || FileUtils.checkFileExist((String)(templateDirectoryTargetPath + GDE.FILE_SEPARATOR + (defaultTemplateName = entryName.substring("resource/template/".length()))))) continue;
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, String.format("jarFile = %s ; defaultTemplateName = %s", jarFile.getName(), entryName));
            }
            FileUtils.extract((JarFile)jarFile, (String)defaultTemplateName, (String)"resource/template/", (String)templateDirectoryTargetPath, (String)"555");
        }
    }

    @Override
    protected boolean isContinuousRecordSet() {
        return true;
    }

    @Override
    public int[] getCellVoltageOrdinals() {
        return new int[]{-1, -1};
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            MC3000.log.log(java.util.logging.Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
            int j = 0;
            int k = 0;
            while (j < points.length) {
                points[j] = ((convertBuffer[k] & 0xFF) << 24) + ((convertBuffer[k + 1] & 0xFF) << 16) + ((convertBuffer[k + 2] & 0xFF) << 8) + ((convertBuffer[k + 3] & 0xFF) << 0);
                ++j;
                k += 4;
            }
            recordSet.addPoints(points);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
        Object templateFileName = this.getName().substring(0, this.getName().indexOf("_", 9) + 1);
        templateFileName = recordSet.getDescription().endsWith("LiIo") ? (String)templateFileName + "LiIo" : (String)templateFileName + "NiMH";
        GraphicsTemplate graphicsTemplate = new GraphicsTemplate((String)templateFileName);
        graphicsTemplate.load();
        if (graphicsTemplate.isAvailable()) {
            this.application.getActiveChannel().setTemplate((String)templateFileName);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
    }

    @Override
    public void open_closeCommPort() {
        block22: {
            if (this.usbPort != null) {
                if (!this.usbPort.isConnected()) {
                    try {
                        Channel activChannel = Channels.getInstance().getActiveChannel();
                        if (activChannel == null) break block22;
                        this.dataGatherThread = new MC3000FmGathererThread(this.application, this, this.usbPort, activChannel.getNumber(), (MC3000Dialog)this.getDialog());
                        try {
                            if (this.dataGatherThread != null && this.usbPort.isConnected()) {
                                this.systemSettings = new MC3000.SystemSettings(this, this.usbPort.getSystemSettings());
                                WaitTimer.delay((long)100L);
                                this.dataGatherThread.start();
                            } else {
                                this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
                            }
                        }
                        catch (Throwable e) {
                            MC3000.log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    catch (UsbClaimException e) {
                        MC3000.log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0051", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                        try {
                            if (this.usbPort != null && this.usbPort.isConnected()) {
                                this.usbPort.closeUsbPort(null);
                            }
                        }
                        catch (UsbException ex) {
                            MC3000.log.log(java.util.logging.Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    catch (UsbException e) {
                        MC3000.log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0050"));
                        try {
                            if (this.usbPort != null && this.usbPort.isConnected()) {
                                this.usbPort.closeUsbPort(null);
                            }
                        }
                        catch (UsbException ex) {
                            MC3000.log.log(java.util.logging.Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    catch (ApplicationConfigurationException e) {
                        MC3000.log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
                        this.application.getDeviceSelectionDialog().open();
                    }
                    catch (Throwable e) {
                        MC3000.log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    if (this.dataGatherThread != null) {
                        this.dataGatherThread.stopDataGatheringThread(false, null);
                    }
                    try {
                        WaitTimer.delay((long)1000L);
                        if (this.usbPort != null && this.usbPort.isConnected()) {
                            this.usbPort.closeUsbPort(null);
                        }
                    }
                    catch (UsbException e) {
                        MC3000.log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }
    }
}

