/*
 * Decompiled with CFR 0.152.
 */
package gde.device.skyrc;

import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.device.skyrc.ChargerDialog;
import gde.device.skyrc.D100GathererThread;
import gde.device.skyrc.D100UsbPort;
import gde.device.skyrc.MC3000;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.io.DataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.utils.WaitTimer;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.usb.UsbClaimException;
import javax.usb.UsbException;
import javax.xml.bind.JAXBException;

public class D100
extends MC3000
implements IDevice {
    static final Logger log = Logger.getLogger(D100.class.getName());
    final ChargerDialog dialog;
    D100GathererThread dataGatherThread;
    D100UsbPort usbPort;
    int[] resetEnergy = new int[]{5, 5};
    double[] energy = new double[]{0.0, 0.0};
    SystemInfo[] systemInfo = new SystemInfo[2];
    SystemSetting[] systemSetting = new SystemSetting[2];

    public D100(String xmlFileName) throws FileNotFoundException, JAXBException {
        super(xmlFileName);
        this.USAGE_MODE_LI = new String[]{Messages.getString((String)"GDE_MSGT3617"), Messages.getString((String)"GDE_MSGT3615"), Messages.getString((String)"GDE_MSGT3612"), Messages.getString((String)"GDE_MSGT3613"), Messages.getString((String)"GDE_MSGT3616")};
        this.USAGE_MODE_NI = new String[]{Messages.getString((String)"GDE_MSGT3617"), Messages.getString((String)"GDE_MSGT3625"), Messages.getString((String)"GDE_MSGT3623"), Messages.getString((String)"GDE_MSGT3626"), Messages.getString((String)"GDE_MSGT3624")};
        this.USAGE_MODE_PB = new String[]{Messages.getString((String)"GDE_MSGT3620"), Messages.getString((String)"GDE_MSGT3623")};
        this.BATTERY_TYPE = new String[]{Messages.getString((String)"GDE_MSGT3649"), Messages.getString((String)"GDE_MSGT3641"), Messages.getString((String)"GDE_MSGT3640"), Messages.getString((String)"GDE_MSGT3642"), Messages.getString((String)"GDE_MSGT3643"), Messages.getString((String)"GDE_MSGT3644"), Messages.getString((String)"GDE_MSGT3648")};
        this.usbPort = new D100UsbPort(this, this.application);
        this.dialog = new ChargerDialog(this.application.getShell(), this);
    }

    public D100(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        this.USAGE_MODE_LI = new String[]{Messages.getString((String)"GDE_MSGT3617"), Messages.getString((String)"GDE_MSGT3615"), Messages.getString((String)"GDE_MSGT3612"), Messages.getString((String)"GDE_MSGT3613"), Messages.getString((String)"GDE_MSGT3616")};
        this.USAGE_MODE_NI = new String[]{Messages.getString((String)"GDE_MSGT3617"), Messages.getString((String)"GDE_MSGT3625"), Messages.getString((String)"GDE_MSGT3623"), Messages.getString((String)"GDE_MSGT3626"), Messages.getString((String)"GDE_MSGT3624")};
        this.USAGE_MODE_PB = new String[]{Messages.getString((String)"GDE_MSGT3620"), Messages.getString((String)"GDE_MSGT3623")};
        this.BATTERY_TYPE = new String[]{Messages.getString((String)"GDE_MSGT3649"), Messages.getString((String)"GDE_MSGT3641"), Messages.getString((String)"GDE_MSGT3640"), Messages.getString((String)"GDE_MSGT3642"), Messages.getString((String)"GDE_MSGT3643"), Messages.getString((String)"GDE_MSGT3644"), Messages.getString((String)"GDE_MSGT3648")};
        this.usbPort = new D100UsbPort(this, this.application);
        this.dialog = new ChargerDialog(this.application.getShell(), this);
    }

    @Override
    public DeviceDialog getDialog() {
        return this.dialog;
    }

    @Override
    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    @Override
    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    @Override
    public int getLovDataByteSize() {
        return 86;
    }

    @Override
    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int maxVoltage = Integer.MIN_VALUE;
        int minVoltage = Integer.MAX_VALUE;
        points[0] = DataParser.parse2Short((byte)dataBuffer[8], (byte)dataBuffer[7]);
        points[1] = DataParser.parse2Short((byte)dataBuffer[10], (byte)dataBuffer[9]);
        points[2] = DataParser.parse2Short((byte)dataBuffer[12], (byte)dataBuffer[11]) * 1000;
        points[3] = Double.valueOf((double)points[0] / 1000.0 * (double)points[1]).intValue();
        switch (dataBuffer[0]) {
            case 0: {
                switch (dataBuffer[1]) {
                    case 0: {
                        this.energy[0] = this.energy[0] + (double)points[0] / 1000.0 * (double)points[1] / 3600.0;
                        points[4] = Double.valueOf(this.energy[0]).intValue();
                        break;
                    }
                    case 1: {
                        this.energy[1] = this.energy[1] + (double)points[0] / 1000.0 * (double)points[1] / 3600.0;
                        points[4] = Double.valueOf(this.energy[1]).intValue();
                        break;
                    }
                }
                if (!log.isLoggable(java.util.logging.Level.FINE)) break;
                log.log(java.util.logging.Level.FINE, "add up Energy");
                break;
            }
            case 1: {
                switch (dataBuffer[1]) {
                    case 0: {
                        this.energy[0] = 0.0;
                        points[4] = 0;
                        break;
                    }
                    case 1: {
                        this.energy[1] = 0.0;
                        points[4] = 0;
                        break;
                    }
                }
                points[4] = 0;
                if (!log.isLoggable(java.util.logging.Level.FINE)) break;
                log.log(java.util.logging.Level.FINE, "reset Energy");
                break;
            }
            default: {
                points[4] = points[4];
                if (!log.isLoggable(java.util.logging.Level.FINE)) break;
                log.log(java.util.logging.Level.FINE, "untouche Energy");
            }
        }
        points[5] = dataBuffer[14] * 1000;
        points[6] = dataBuffer[13] * 1000;
        points[7] = DataParser.parse2Short((byte)dataBuffer[16], (byte)dataBuffer[15]) * 100;
        if (dataBuffer[0] <= 3) {
            int j = 0;
            int i = 9;
            while (i < points.length) {
                if (dataBuffer[j + 17] != 0) {
                    points[i] = DataParser.parse2Short((byte)dataBuffer[j + 18], (byte)dataBuffer[j + 17]);
                    maxVoltage = points[i] > maxVoltage ? points[i] : maxVoltage;
                    minVoltage = points[i] < minVoltage ? points[i] : minVoltage;
                } else {
                    points[i] = 0;
                }
                ++i;
                j += 2;
            }
            points[8] = 1000 * (maxVoltage != Integer.MIN_VALUE && minVoltage != Integer.MAX_VALUE ? maxVoltage - minVoltage : 0);
        }
        return points;
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            log.log(java.util.logging.Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
            int j = 0;
            int k = 0;
            while (j < points.length) {
                points[j] = ((convertBuffer[k] & 0xFF) << 24) + ((convertBuffer[k + 1] & 0xFF) << 16) + ((convertBuffer[k + 2] & 0xFF) << 8) + ((convertBuffer[k + 3] & 0xFF) << 0);
                ++j;
                k += 4;
            }
            recordSet.addPoints(points);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double offset = record.getOffset();
                double reduction = record.getReduction();
                double factor = record.getFactor();
                dataTableRow[index + 1] = record.getDecimalFormat().format(offset + ((double)record.realGet(rowIndex).intValue() / 1000.0 - reduction) * factor);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    @Override
    public double translateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double newValue = (value - reduction) * factor + offset;
        log.log(java.util.logging.Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    @Override
    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double newValue = (value - offset) / factor + reduction;
        log.log(java.util.logging.Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    @Override
    public int getCurrentSmoothIndex() {
        return 1;
    }

    public boolean isProcessing(int outletNum, byte[] channelBuffer, byte[] dataBuffer) {
        if (log.isLoggable(java.util.logging.Level.FINE)) {
            log.log(java.util.logging.Level.FINE, outletNum + " isProcessing = " + (dataBuffer == null ? channelBuffer[2] >= 1 && channelBuffer[2] <= 3 : dataBuffer[4] >= 1 && dataBuffer[4] <= 3));
        }
        if (dataBuffer == null) {
            return channelBuffer[2] >= 1 && channelBuffer[2] <= 3;
        }
        return dataBuffer[4] == 3 && !this.isContinuousRecordSet() && this.settings.isReduceChargeDischarge() ? false : dataBuffer[4] >= 1 && dataBuffer[4] <= 3;
    }

    @Override
    public String getProcessingStatusName(byte[] dataBuffer) {
        return this.isContinuousRecordSet() ? Messages.getString((String)"GDE_MSGT3606") : this.STATUS_MODE[dataBuffer[4]];
    }

    @Override
    public String getProcessingBatteryTypeName(byte[] channelBuffer) {
        return this.BATTERY_TYPE[channelBuffer[15]];
    }

    @Override
    public int getProcessingType(byte[] channelBuffer) {
        return channelBuffer[16];
    }

    @Override
    public int getBatteryType(byte[] channelBuffer) {
        return channelBuffer[15];
    }

    @Override
    public String getProcessingTypeName(byte[] channelBuffer) {
        String processTypeName = "";
        switch (this.getBatteryType(channelBuffer)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                processTypeName = this.USAGE_MODE_LI[channelBuffer[16]];
                break;
            }
            case 4: 
            case 5: {
                processTypeName = this.USAGE_MODE_NI[channelBuffer[16]];
                break;
            }
            case 6: {
                processTypeName = this.USAGE_MODE_PB[channelBuffer[16]];
            }
        }
        return this.isContinuousRecordSet() ? Messages.getString((String)"GDE_MSGT3606") : processTypeName;
    }

    public int getCycleNumber(byte[] dataBuffer) {
        return dataBuffer[17];
    }

    public int getProcessSubType(byte[] channelBuffer, byte[] dataBuffer) {
        if (channelBuffer[3] == 4 || channelBuffer[3] == 5) {
            return dataBuffer[15];
        }
        return this.getProcessingType(channelBuffer);
    }

    public String getProcessSubTypeName(byte[] channelBuffer, byte[] dataBuffer) {
        switch (this.getBatteryType(channelBuffer)) {
            default: {
                return "";
            }
            case 4: 
            case 5: 
        }
        if (this.isContinuousRecordSet() || this.getProcessingType(channelBuffer) != 4) {
            return "";
        }
        switch (dataBuffer[4]) {
            default: {
                return Messages.getString((String)"GDE_MSGT3620");
            }
            case 3: {
                return Messages.getString((String)"GDE_MSGT3627");
            }
            case 2: 
        }
        return Messages.getString((String)"GDE_MSGT3623");
    }

    @Override
    public int[] getCellVoltageOrdinals() {
        return new int[]{0, 2};
    }

    public String getHarwareString(int channelId) {
        return this.systemInfo[channelId - 1].getHardwareVersion();
    }

    public String getFirmwareString(int channelId) {
        return this.systemInfo[channelId - 1].getFirmwareVersion();
    }

    public String getMachineIdString(int channelId) {
        return this.systemInfo[channelId - 1].getMachineID();
    }

    public String getTemperatureUnit(int channelId) {
        return this.systemSetting[channelId - 1].getTempeartureUnit();
    }

    @Override
    public void makeInActiveDisplayable(RecordSet recordSet) {
    }

    @Override
    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int channelConfigNumber = recordSet.getChannelConfigNumber();
        int displayableCounter = 0;
        boolean configChanged = this.isChangePropery();
        String[] measurementNames = this.getMeasurementNames(channelConfigNumber);
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            MeasurementType measurement = this.getMeasurement(channelConfigNumber, i);
            if (log.isLoggable(java.util.logging.Level.FINE)) {
                log.log(java.util.logging.Level.FINE, record.getName() + " = " + measurementNames[i]);
            }
            if (record.isActive() && record.isActive() != measurement.isActive()) {
                record.setActive(Boolean.valueOf(measurement.isActive()));
                record.setVisible(measurement.isActive());
                record.setDisplayable(measurement.isActive());
                if (log.isLoggable(java.util.logging.Level.FINE)) {
                    log.log(java.util.logging.Level.FINE, "switch " + record.getName() + " to " + measurement.isActive());
                }
            }
            if (includeReasonableDataCheck) {
                record.setDisplayable(record.hasReasonableData() && measurement.isActive());
                if (log.isLoggable(java.util.logging.Level.FINE)) {
                    log.log(java.util.logging.Level.FINE, record.getName() + " hasReasonableData " + record.hasReasonableData());
                }
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            if (log.isLoggable(java.util.logging.Level.FINE)) {
                log.log(java.util.logging.Level.FINE, "add to displayable counter: " + record.getName());
            }
            ++displayableCounter;
        }
        if (log.isLoggable(java.util.logging.Level.FINE)) {
            log.log(java.util.logging.Level.FINE, "displayableCounter = " + displayableCounter);
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
        this.setChangePropery(configChanged);
    }

    @Override
    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION};
    }

    @Override
    public void open_closeCommPort() {
        block25: {
            if (this.usbPort != null) {
                if (!this.usbPort.isConnected()) {
                    try {
                        Channel activChannel = Channels.getInstance().getActiveChannel();
                        if (activChannel == null) break block25;
                        this.dataGatherThread = new D100GathererThread(this.application, this, this.usbPort, activChannel.getNumber(), this.getDialog());
                        try {
                            if (this.dataGatherThread != null && this.usbPort.isConnected()) {
                                block16: for (int i = 0; i < this.systemInfo.length; ++i) {
                                    switch (i) {
                                        default: {
                                            this.systemInfo[i] = new SystemInfo(this, this.usbPort.getSystemInfo(this.dataGatherThread.getUsbInterface(), D100UsbPort.QuerySystemInfo.CHANNEL_A.value()));
                                            this.systemSetting[i] = new SystemSetting(this, this.usbPort.getSystemSetting(this.dataGatherThread.getUsbInterface(), D100UsbPort.QuerySystemSetting.CHANNEL_A.value()));
                                            continue block16;
                                        }
                                        case 1: {
                                            this.systemInfo[i] = new SystemInfo(this, this.usbPort.getSystemInfo(this.dataGatherThread.getUsbInterface(), D100UsbPort.QuerySystemInfo.CHANNEL_B.value()));
                                            this.systemSetting[i] = new SystemSetting(this, this.usbPort.getSystemSetting(this.dataGatherThread.getUsbInterface(), D100UsbPort.QuerySystemSetting.CHANNEL_B.value()));
                                        }
                                    }
                                }
                                WaitTimer.delay((long)100L);
                                this.dataGatherThread.start();
                            }
                        }
                        catch (Throwable e) {
                            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    catch (UsbClaimException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0051", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                        try {
                            if (this.usbPort != null && this.usbPort.isConnected()) {
                                this.usbPort.closeUsbPort(null);
                            }
                        }
                        catch (UsbException ex) {
                            log.log(java.util.logging.Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    catch (UsbException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0050"));
                        try {
                            if (this.usbPort != null && this.usbPort.isConnected()) {
                                this.usbPort.closeUsbPort(null);
                            }
                        }
                        catch (UsbException ex) {
                            log.log(java.util.logging.Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    catch (ApplicationConfigurationException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
                        this.application.getDeviceSelectionDialog().open();
                    }
                    catch (Throwable e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    if (this.dataGatherThread != null) {
                        this.dataGatherThread.stopDataGatheringThread(false, null);
                    }
                    try {
                        WaitTimer.delay((long)1000L);
                        if (this.usbPort != null && this.usbPort.isConnected()) {
                            this.usbPort.closeUsbPort(null);
                        }
                    }
                    catch (UsbException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }
    }

    @Override
    public String getFileBaseDir() {
        return this.getName();
    }

    protected class SystemInfo {
        byte channelId;
        byte[] machineId = new byte[16];

        public SystemInfo(D100 this$0, byte[] buffer) {
            this.channelId = buffer[4];
            for (int i = 0; i < 15; ++i) {
                this.machineId[i] = buffer[i + 5];
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("%s %s %s", this.getMachineID(), this.getHardwareVersion(), this.getFirmwareVersion()));
            }
        }

        public byte getChannelId() {
            return this.channelId;
        }

        public String getMachineID() {
            byte[] tmpMachineID = new byte[6];
            System.arraycopy(this.machineId, 0, tmpMachineID, 0, 6);
            return String.format("ID: %s", new String(tmpMachineID));
        }

        public String getFirmwareVersion() {
            return String.format("Firmware: %d.%02d", this.machineId[11], this.machineId[12]);
        }

        public int getFirmwareVersionAsInt() {
            return Integer.valueOf(String.format("%d%02d", this.machineId[11], this.machineId[12]));
        }

        public String getHardwareVersion() {
            return String.format("Hardware: %d.%d", this.machineId[13] / 10, this.machineId[13] % 10);
        }

        public int getHardwareVersionAsInt() {
            return this.machineId[13];
        }
    }

    protected class SystemSetting {
        byte channelId;
        byte isKeySound;
        byte isSystemSound;
        byte isCapacityLimiting;
        byte isTimeLimiting;
        byte temperatureUnit;
        byte[] capacityLimit = new byte[2];
        byte[] timeLimit = new byte[2];
        byte maxTempearture;

        public SystemSetting(D100 this$0, byte[] buffer) {
            this.channelId = buffer[1];
            this.isKeySound = buffer[2];
            this.isSystemSound = buffer[3];
            this.isCapacityLimiting = buffer[4];
            this.isTimeLimiting = buffer[5];
            this.temperatureUnit = buffer[6];
            System.arraycopy(buffer, 7, this.capacityLimit, 0, 2);
            System.arraycopy(buffer, 9, this.timeLimit, 0, 2);
            this.maxTempearture = buffer[11];
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("channel=0x%02x KeyBuzzer %b SysBuzzer %b CapacityLimit %b %d  TimeLimit = %b %d TemperaturUnit %s TemperatureLimit %d \u00b0C", this.getChannelId(), this.isKeySound(), this.isSystemSound(), this.isCapacityLimiting(), this.getCapacityLimit(), this.isTimeLimiting(), this.getTimeLimit(), this.getTempeartureUnit(), this.getMaxTempearture()));
            }
        }

        public byte getChannelId() {
            return this.channelId;
        }

        public boolean isTimeLimiting() {
            return this.isTimeLimiting == 1;
        }

        public short getTimeLimit() {
            return DataParser.parse2Short((byte)this.timeLimit[1], (byte)this.timeLimit[0]);
        }

        public boolean isCapacityLimiting() {
            return this.isCapacityLimiting == 1;
        }

        public short getCapacityLimit() {
            return DataParser.parse2Short((byte)this.capacityLimit[1], (byte)this.capacityLimit[0]);
        }

        public boolean isKeySound() {
            return this.isKeySound == 1;
        }

        public boolean isSystemSound() {
            return this.isSystemSound == 1;
        }

        public String getTempeartureUnit() {
            return this.temperatureUnit == 0 ? "\u00b0C" : "\u00b0F";
        }

        public byte getMaxTempearture() {
            return this.maxTempearture;
        }
    }
}

