/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock.normalizer.processor;

import com.monstarmike.tlmreader.datablock.RxBlock;
import com.monstarmike.tlmreader.datablock.normalizer.processor.AbstractProcessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DiscountinuousBlocksProcessor
extends AbstractProcessor<RxBlock> {
    private static final int MAX_CHANGE_IN_ONE_HUNDERTH = 10;
    private Set<RxBlock> unclassifiedBlocks = new HashSet<RxBlock>();
    private DataState dataState = DataState.UNKNOWN;
    private RxBlock lastBlock = null;
    private List<RxBlock> badBlocks = new ArrayList<RxBlock>();

    @Override
    public boolean isBad(RxBlock block) {
        return this.badBlocks.contains(block);
    }

    @Override
    public void preprocessFinished() {
        if (DataState.BAD.equals((Object)this.dataState)) {
            this.badBlocks.add(this.lastBlock);
        }
    }

    @Override
    public void preprocess(RxBlock currentBlock) {
        if (currentBlock.hasValidDataLostPacketsReceiverA()) {
            if (this.lastBlock != null) {
                ChangeState currentChangeState = this.isContinuous(this.lastBlock, currentBlock);
                if (DataState.UNKNOWN.equals((Object)this.dataState)) {
                    if (ChangeState.CONTINUOUS.equals((Object)currentChangeState)) {
                        this.unclassifiedBlocks.add(this.lastBlock);
                    } else if (ChangeState.TOO_LOW.equals((Object)currentChangeState)) {
                        this.unclassifiedBlocks.add(this.lastBlock);
                        this.badBlocks.addAll(this.unclassifiedBlocks);
                        this.unclassifiedBlocks.clear();
                        this.dataState = DataState.OK;
                    } else {
                        this.dataState = DataState.BAD;
                    }
                } else if (DataState.BAD.equals((Object)this.dataState)) {
                    this.badBlocks.add(this.lastBlock);
                    if (ChangeState.TOO_LOW.equals((Object)currentChangeState)) {
                        this.dataState = DataState.UNKNOWN;
                    }
                } else if (ChangeState.TOO_HIGH.equals((Object)currentChangeState)) {
                    this.dataState = DataState.BAD;
                }
            }
            this.lastBlock = currentBlock;
        }
    }

    @Override
    public Class<RxBlock> getClassOfDataBlock() {
        return RxBlock.class;
    }

    private ChangeState isContinuous(RxBlock last, RxBlock current) {
        int timeDiff = current.getTimestamp() - last.getTimestamp();
        int valueDiff = current.getLostPacketsReceiverA() - last.getLostPacketsReceiverA();
        double change = (double)valueDiff / (double)timeDiff;
        if (change > 10.0) {
            return ChangeState.TOO_HIGH;
        }
        if (change < -10.0) {
            return ChangeState.TOO_LOW;
        }
        return ChangeState.CONTINUOUS;
    }

    private static enum ChangeState {
        TOO_HIGH,
        TOO_LOW,
        CONTINUOUS;

    }

    private static enum DataState {
        OK,
        UNKNOWN,
        BAD;

    }
}

