/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.primitives.Ints;

public class FlightPackBlock
extends DataBlock {
    private int currentAInTenthOfAmps;
    private int chargeUsedAInMilliAmpsHours;
    private int temperatureAInTenthOfDegreeCelsius;
    private int currentBInTenthOfAmps;
    private int chargeUsedBInMilliAmpsHours;
    private int temperatureBInTenthOfDegreeCelsius;

    public FlightPackBlock(byte[] rawData) {
        super(rawData);
        this.decode(rawData);
        this.measurementNames.add("Current FPA");
        this.measurementNames.add("Capacity FPA");
        this.measurementNames.add("Temperature FPA");
        this.measurementNames.add("Current FPB");
        this.measurementNames.add("Capacity FPB");
        this.measurementNames.add("Temperature FPB");
        this.measurementUnits.add("A");
        this.measurementUnits.add("mAh");
        this.measurementUnits.add("\u00b0C");
        this.measurementUnits.add("A");
        this.measurementUnits.add("mAh");
        this.measurementUnits.add("\u00b0C");
        this.measurementFactors.add(0.1);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(0.1);
        this.measurementFactors.add(0.1);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(0.1);
    }

    private void decode(byte[] rawData) {
        this.currentAInTenthOfAmps = Ints.fromBytes((byte)0, (byte)0, rawData[7], rawData[6]);
        this.chargeUsedAInMilliAmpsHours = Ints.fromBytes((byte)0, (byte)0, rawData[9], rawData[8]);
        this.temperatureAInTenthOfDegreeCelsius = Ints.fromBytes((byte)0, (byte)0, rawData[11], rawData[10]);
        this.currentBInTenthOfAmps = Ints.fromBytes((byte)0, (byte)0, rawData[13], rawData[12]);
        this.chargeUsedBInMilliAmpsHours = Ints.fromBytes((byte)0, (byte)0, rawData[15], rawData[14]);
        this.temperatureBInTenthOfDegreeCelsius = Ints.fromBytes((byte)0, (byte)0, rawData[17], rawData[16]);
        this.measurementValues.add(this.getCurrentAInTenthOfAmps());
        this.measurementValues.add(this.getChargeUsedAInMilliAmpsHours());
        this.measurementValues.add(this.getTemperatureAInTenthOfDegreeCelsius());
        this.measurementValues.add(this.getCurrentBInTenthOfAmps());
        this.measurementValues.add(this.getChargeUsedBInMilliAmpsHours());
        this.measurementValues.add(this.getTemperatureBInTenthOfDegreeCelsius());
    }

    @Override
    public boolean areValuesEquals(DataBlock block) {
        if (block instanceof FlightPackBlock) {
            FlightPackBlock fp = (FlightPackBlock)block;
            return fp.currentAInTenthOfAmps == this.currentAInTenthOfAmps && fp.chargeUsedAInMilliAmpsHours == this.chargeUsedAInMilliAmpsHours && fp.temperatureAInTenthOfDegreeCelsius == this.temperatureAInTenthOfDegreeCelsius && fp.currentBInTenthOfAmps == this.currentBInTenthOfAmps && fp.chargeUsedBInMilliAmpsHours == this.chargeUsedBInMilliAmpsHours && fp.temperatureBInTenthOfDegreeCelsius == this.temperatureBInTenthOfDegreeCelsius;
        }
        return false;
    }

    public int getCurrentAInTenthOfAmps() {
        return this.currentAInTenthOfAmps < 3000 ? this.currentAInTenthOfAmps : 0;
    }

    public int getChargeUsedAInMilliAmpsHours() {
        return this.chargeUsedAInMilliAmpsHours;
    }

    public int getTemperatureAInTenthOfDegreeCelsius() {
        return this.temperatureAInTenthOfDegreeCelsius != Short.MAX_VALUE ? this.temperatureAInTenthOfDegreeCelsius : 0;
    }

    public int getCurrentBInTenthOfAmps() {
        return this.currentBInTenthOfAmps < 3000 ? this.currentBInTenthOfAmps : 0;
    }

    public int getChargeUsedBInMilliAmpsHours() {
        return this.chargeUsedBInMilliAmpsHours != Short.MAX_VALUE ? this.chargeUsedBInMilliAmpsHours : 0;
    }

    public int getTemperatureBInTenthOfDegreeCelsius() {
        return this.temperatureBInTenthOfDegreeCelsius != Short.MAX_VALUE ? this.temperatureBInTenthOfDegreeCelsius : 0;
    }
}

