/*
 * Decompiled with CFR 0.152.
 */
package gde.device.renschler;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.DeviceDialog;
import gde.device.renschler.DataGathererThread;
import gde.device.renschler.Picolario;
import gde.device.renschler.PicolarioConfigTab;
import gde.device.renschler.PicolarioSerialPort;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.StringHelper;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class PicolarioDialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(PicolarioDialog.class.getName());
    private static final String DEVICE_NAME = "Picolario";
    Group numberAvailableRecorsSetsGroup1;
    Button queryAvailableRecordSetButton;
    CLabel numberAvailableRecordSetsLabel;
    String numberAvailable = "";
    CTabFolder configTabFolder;
    CTabItem configTabItem1;
    CTabItem configTabItem2;
    PicolarioConfigTab configTab1;
    PicolarioConfigTab configTab2;
    Group readDataGroup3;
    Button readSingle;
    Button closeButton;
    Button stopButton;
    CLabel alreadyRedLabel;
    CLabel alreadyRedDataSetsLabel;
    CLabel redDataSets;
    Button switchRecordSetButton;
    Button readAllRecords;
    CLabel numberRedTelegramLabel;
    CCombo recordSetSelectCombo;
    String redDatagrams = "0";
    String redDataSetsText = "0";
    boolean doSwtichRecordSet = false;
    final Settings settings;
    final Picolario device;
    final PicolarioSerialPort serialPort;
    DataGathererThread gatherThread;

    public PicolarioDialog(Shell parent, Picolario useDevice) {
        super(parent);
        this.device = useDevice;
        this.serialPort = useDevice.getCommunicationPort();
        this.settings = Settings.getInstance();
    }

    public void open() {
        this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
        this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
        log.log(Level.FINE, "dialogShell.isDisposed() " + String.valueOf(this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
        if (this.dialogShell == null || this.dialogShell.isDisposed()) {
            String[] stringArray;
            this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
            SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
            if (this.isAlphaEnabled) {
                this.dialogShell.setAlpha(254);
            }
            this.dialogShell.setLayout(null);
            this.dialogShell.layout();
            this.dialogShell.pack();
            this.dialogShell.setSize(345, 590);
            this.dialogShell.setText(DEVICE_NAME + Messages.getString((String)"GDE_MSGT0273"));
            this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
            this.dialogShell.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    switch (event.detail) {
                        case 2: {
                            PicolarioDialog.this.dialogShell.close();
                            event.detail = 0;
                            event.doit = false;
                        }
                    }
                }
            });
            this.dialogShell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent evt) {
                    log.log(Level.FINE, "dialogShell.widgetDisposed, event=" + String.valueOf(evt));
                    if (PicolarioDialog.this.gatherThread != null && PicolarioDialog.this.gatherThread.isAlive()) {
                        PicolarioDialog.this.gatherThread.setThreadStop(true);
                    }
                    PicolarioDialog.this.dispose();
                }
            });
            this.dialogShell.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent evt) {
                    log.log(Level.FINEST, "dialogShell.helpRequested, event=" + String.valueOf(evt));
                    PicolarioDialog.this.application.openHelpDialog(PicolarioDialog.DEVICE_NAME, "HelpInfo.html");
                }
            });
            this.dialogShell.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent evt) {
                    log.log(Level.FINER, "dialogShell.mouseEnter, event=" + String.valueOf(evt));
                    PicolarioDialog.this.fadeOutAplhaBlending(evt, PicolarioDialog.this.getDialogShell().getClientArea(), 10, 10, 10, 15);
                }

                public void mouseHover(MouseEvent evt) {
                    log.log(Level.FINEST, "dialogShell.mouseHover, event=" + String.valueOf(evt));
                }

                public void mouseExit(MouseEvent evt) {
                    log.log(Level.FINER, "dialogShell.mouseExit, event=" + String.valueOf(evt));
                    PicolarioDialog.this.fadeInAlpaBlending(evt, PicolarioDialog.this.getDialogShell().getClientArea(), 10, 10, -10, 15);
                }
            });
            this.numberAvailableRecorsSetsGroup1 = new Group((Composite)this.dialogShell, 0);
            this.numberAvailableRecorsSetsGroup1.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.numberAvailableRecorsSetsGroup1.setLayout((Layout)new GridLayout(2, false));
            this.numberAvailableRecorsSetsGroup1.setText(Messages.getString((String)"GDE_MSGT1200"));
            this.numberAvailableRecorsSetsGroup1.setBounds(10, 5, 320, 55);
            this.numberAvailableRecorsSetsGroup1.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
            this.queryAvailableRecordSetButton = new Button((Composite)this.numberAvailableRecorsSetsGroup1, 0x1000008);
            this.queryAvailableRecordSetButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.queryAvailableRecordSetButton.setText(Messages.getString((String)"GDE_MSGT1201"));
            this.queryAvailableRecordSetButton.setLayoutData((Object)new GridData(250, 25));
            this.queryAvailableRecordSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "anzahlAufzeichnungenButton.widgetSelected, event=" + String.valueOf(evt));
                    try {
                        if (PicolarioDialog.this.serialPort != null) {
                            PicolarioDialog.this.setClosePossible(false);
                            int availableRecords = PicolarioDialog.this.serialPort.readNumberAvailableRecordSets();
                            PicolarioDialog.this.numberAvailable = Integer.valueOf(availableRecords).toString();
                            PicolarioDialog.this.numberAvailableRecordSetsLabel.setText(PicolarioDialog.this.numberAvailable);
                            PicolarioDialog.this.setRecordSetSelection(availableRecords, 0);
                            PicolarioDialog.this.readSingle.setEnabled(true);
                            PicolarioDialog.this.readAllRecords.setEnabled(true);
                            PicolarioDialog.this.resetTelegramLabel();
                            PicolarioDialog.this.resetDataSetsLabel();
                            PicolarioDialog.this.setClosePossible(true);
                        }
                    }
                    catch (Exception e) {
                        PicolarioDialog.this.setClosePossible(true);
                        PicolarioDialog.this.serialPort.close();
                        PicolarioDialog.this.application.openMessageDialog(PicolarioDialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGE0024", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                        PicolarioDialog.this.application.getDeviceSelectionDialog().open();
                    }
                }
            });
            this.numberAvailableRecordSetsLabel = new CLabel((Composite)this.numberAvailableRecorsSetsGroup1, 133120);
            this.numberAvailableRecordSetsLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.numberAvailableRecordSetsLabel.setBackground(DataExplorer.getInstance().COLOR_WHITE);
            this.numberAvailableRecordSetsLabel.setLayoutData((Object)new GridData(30, 24));
            this.numberAvailableRecordSetsLabel.setText(this.numberAvailable);
            this.numberAvailableRecorsSetsGroup1.layout();
            this.configTabFolder = new CTabFolder((Composite)this.dialogShell, 2048);
            if (this.device.getChannelCount() > 0) {
                this.configTabItem1 = new CTabItem(this.configTabFolder, 0);
                this.configTabItem1.setText(this.device.getChannelNameReplacement(1));
                this.configTab1 = new PicolarioConfigTab(this.configTabFolder, this.device, this.device.getChannelNameReplacement(1));
                this.configTabItem1.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.configTabItem1.setControl((Control)this.configTab1);
            }
            if (this.device.getChannelCount() > 1) {
                this.configTabItem2 = new CTabItem(this.configTabFolder, 0);
                this.configTabItem2.setText(this.device.getChannelNameReplacement(2));
                this.configTab2 = new PicolarioConfigTab(this.configTabFolder, this.device, this.device.getChannelNameReplacement(2));
                this.configTabItem2.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.configTabItem2.setControl((Control)this.configTab2);
            }
            this.configTabFolder.setSelection(Channels.getInstance().getActiveChannelNumber() - 1);
            this.configTabFolder.setBounds(10, 65, 320, 240);
            this.configTabFolder.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
            this.configTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "configTabFolder.widgetSelected, event=" + String.valueOf(evt));
                    int channelNumber = PicolarioDialog.this.configTabFolder.getSelectionIndex() + 1;
                    String configKey = channelNumber + " : " + ((CTabItem)evt.item).getText();
                    Channels channels = Channels.getInstance();
                    Channel activeChannel = channels.getActiveChannel();
                    if (activeChannel != null) {
                        int answer;
                        log.log(Level.FINE, "activeChannel = " + activeChannel.getName() + " configKey = " + configKey);
                        RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
                        if (activeRecordSet != null && !activeChannel.getName().trim().equals(configKey) && (answer = PicolarioDialog.this.application.openYesNoMessageDialog(PicolarioDialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGT1202"))) == 64) {
                            String recordSetKey = activeRecordSet.getName();
                            log.log(Level.FINE, "move record set " + recordSetKey + " to configuration " + configKey);
                            ((Channel)channels.get((Object)channelNumber)).put((Object)recordSetKey, (Object)activeRecordSet.clone(channelNumber));
                            activeChannel.remove(recordSetKey);
                            channels.switchChannel(channelNumber, recordSetKey);
                            PicolarioDialog.this.getDialogShell().redraw();
                        }
                    }
                }
            });
            this.readDataGroup3 = new Group((Composite)this.dialogShell, 0);
            this.readDataGroup3.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.readDataGroup3.setLayout(null);
            this.readDataGroup3.setText(Messages.getString((String)"GDE_MSGT1203"));
            this.readDataGroup3.setBounds(10, 310, 320, 200);
            this.readDataGroup3.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
            this.switchRecordSetButton = new Button((Composite)this.readDataGroup3, 0x1000020);
            this.switchRecordSetButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.switchRecordSetButton.setBounds(15, GDE.IS_MAC_COCOA ? 5 : 20, 290, 17);
            this.switchRecordSetButton.setText(Messages.getString((String)"GDE_MSGT1204"));
            this.switchRecordSetButton.setSelection(this.doSwtichRecordSet);
            this.switchRecordSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "switchRecordSetButton.widgetSelected, event=" + String.valueOf(evt));
                    PicolarioDialog.this.doSwtichRecordSet = PicolarioDialog.this.switchRecordSetButton.getSelection();
                }
            });
            this.readSingle = new Button((Composite)this.readDataGroup3, 0x1000008);
            this.readSingle.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.readSingle.setText(Messages.getString((String)"GDE_MSGT1205"));
            this.readSingle.setBounds(10, GDE.IS_MAC_COCOA ? 30 : 45, 240, 25);
            this.readSingle.setEnabled(false);
            this.readSingle.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "ausleseButton.widgetSelected, event=" + String.valueOf(evt));
                    PicolarioDialog.this.setClosePossible(false);
                    PicolarioDialog.this.queryAvailableRecordSetButton.setEnabled(false);
                    PicolarioDialog.this.readSingle.setEnabled(false);
                    PicolarioDialog.this.readAllRecords.setEnabled(false);
                    PicolarioDialog.this.stopButton.setEnabled(true);
                    PicolarioDialog.this.gatherThread = new DataGathererThread(PicolarioDialog.this.application, PicolarioDialog.this.device, PicolarioDialog.this.serialPort, new String[]{PicolarioDialog.this.recordSetSelectCombo.getText()});
                    try {
                        PicolarioDialog.this.gatherThread.start();
                    }
                    catch (RuntimeException e) {
                        log.log(Level.WARNING, e.getMessage(), e);
                    }
                    log.log(Level.FINE, "gatherThread.run() - executing");
                }
            });
            this.recordSetSelectCombo = new CCombo((Composite)this.readDataGroup3, 133120);
            this.recordSetSelectCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            if (this.numberAvailable.length() >= 1) {
                stringArray = StringHelper.int2Array((int)Integer.parseInt(this.numberAvailable));
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "0";
            }
            this.recordSetSelectCombo.setItems(stringArray);
            this.recordSetSelectCombo.setBounds(260, GDE.IS_MAC_COCOA ? 32 : 47, 45, GDE.IS_LINUX ? 22 : 20);
            this.numberRedTelegramLabel = new CLabel((Composite)this.readDataGroup3, 131072);
            this.numberRedTelegramLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.numberRedTelegramLabel.setBounds(10, GDE.IS_MAC_COCOA ? 60 : 75, 234, 24);
            this.numberRedTelegramLabel.setText(Messages.getString((String)"GDE_MSGT1206"));
            this.numberRedTelegramLabel.setForeground(SWTResourceManager.getColor((int)64, (int)128, (int)128));
            this.alreadyRedLabel = new CLabel((Composite)this.readDataGroup3, 131072);
            this.alreadyRedLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alreadyRedLabel.setBounds(244, GDE.IS_MAC_COCOA ? 60 : 75, 56, 24);
            this.alreadyRedLabel.setText(this.redDatagrams);
            this.readAllRecords = new Button((Composite)this.readDataGroup3, 0x1000008);
            this.readAllRecords.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.readAllRecords.setBounds(8, GDE.IS_MAC_COCOA ? 85 : 100, 300, 25);
            this.readAllRecords.setText(Messages.getString((String)"GDE_MSGT1207"));
            this.readAllRecords.setEnabled(false);
            this.readAllRecords.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "readAllRecords.widgetSelected, event=" + String.valueOf(evt));
                    PicolarioDialog.this.setClosePossible(false);
                    PicolarioDialog.this.queryAvailableRecordSetButton.setEnabled(false);
                    PicolarioDialog.this.readAllRecords.setEnabled(false);
                    PicolarioDialog.this.readSingle.setEnabled(false);
                    PicolarioDialog.this.stopButton.setEnabled(true);
                    String[] itemNames = PicolarioDialog.this.recordSetSelectCombo.getItems();
                    PicolarioDialog.this.gatherThread = new DataGathererThread(PicolarioDialog.this.application, PicolarioDialog.this.device, PicolarioDialog.this.serialPort, itemNames);
                    try {
                        PicolarioDialog.this.gatherThread.start();
                        log.log(Level.FINE, "gatherThread.run() - executing");
                    }
                    catch (RuntimeException e) {
                        log.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            });
            this.alreadyRedDataSetsLabel = new CLabel((Composite)this.readDataGroup3, 131072);
            this.alreadyRedDataSetsLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alreadyRedDataSetsLabel.setBounds(10, GDE.IS_MAC_COCOA ? 110 : 125, 234, 24);
            this.alreadyRedDataSetsLabel.setForeground(SWTResourceManager.getColor((int)64, (int)128, (int)128));
            this.alreadyRedDataSetsLabel.setText(Messages.getString((String)"GDE_MSGT1208"));
            this.redDataSets = new CLabel((Composite)this.readDataGroup3, 131072);
            this.redDataSets.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.redDataSets.setBounds(244, GDE.IS_MAC_COCOA ? 110 : 125, 56, 24);
            this.redDataSets.setText(this.redDataSetsText);
            this.stopButton = new Button((Composite)this.readDataGroup3, 0x1000008);
            this.stopButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stopButton.setText(Messages.getString((String)"GDE_MSGT0278"));
            this.stopButton.setEnabled(false);
            this.stopButton.setBounds(80, GDE.IS_MAC_COCOA ? 140 : 155, 150, 25);
            this.stopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "stopButton.widgetSelected, event=" + String.valueOf(evt));
                    PicolarioDialog.this.gatherThread.setThreadStop(true);
                    PicolarioDialog.this.setClosePossible(true);
                }
            });
            this.closeButton = new Button((Composite)this.dialogShell, 0x1000008);
            this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.closeButton.setText(Messages.getString((String)"GDE_MSGT0188"));
            this.closeButton.setBounds(70, 520, 200, 25);
            this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINE, "closeButton.widgetSelected, event=" + String.valueOf(evt));
                    PicolarioDialog.this.dispose();
                }
            });
            this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 175, 100));
            this.dialogShell.open();
        } else {
            this.dialogShell.setVisible(true);
            this.dialogShell.setActive();
        }
        Display display = this.dialogShell.getDisplay();
        while (!this.dialogShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void setAvailableRecordSets(int number) {
        this.numberAvailableRecordSetsLabel.setText(Integer.valueOf(number).toString());
    }

    public void setRecordSetSelection(int items, int index) {
        this.recordSetSelectCombo.setItems(StringHelper.int2Array((int)items));
        this.recordSetSelectCombo.select(index);
        this.recordSetSelectCombo.setVisibleItemCount(items);
    }

    public void resetTelegramLabel() {
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PicolarioDialog.this.application.getDeviceDialog().isDisposed() && !PicolarioDialog.this.application.getDeviceDialog().isDisposed()) {
                    PicolarioDialog.this.redDatagrams = "0";
                    PicolarioDialog.this.alreadyRedLabel.setText(PicolarioDialog.this.redDatagrams);
                }
            }
        });
    }

    public void setAlreadyRedText(int newValue) {
        this.redDatagrams = Integer.valueOf(newValue).toString();
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PicolarioDialog.this.application.getDeviceDialog().isDisposed()) {
                    PicolarioDialog.this.alreadyRedLabel.setText(PicolarioDialog.this.redDatagrams);
                }
            }
        });
    }

    public void resetDataSetsLabel() {
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PicolarioDialog.this.application.getDeviceDialog().isDisposed()) {
                    PicolarioDialog.this.redDataSetsText = "0";
                    PicolarioDialog.this.redDataSets.setText(PicolarioDialog.this.redDataSetsText);
                }
            }
        });
    }

    public void setAlreadyRedDataSets(final String newValue) {
        this.redDataSetsText = newValue;
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PicolarioDialog.this.application.getDeviceDialog().isDisposed()) {
                    PicolarioDialog.this.redDataSets.setText(newValue);
                }
            }
        });
    }

    public void enableReadButtons() {
        if (Thread.currentThread().threadId() == this.application.getThreadId()) {
            this.queryAvailableRecordSetButton.setEnabled(true);
            this.readSingle.setEnabled(true);
            this.readAllRecords.setEnabled(true);
            this.stopButton.setEnabled(false);
            this.isClosePossible = true;
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!PicolarioDialog.this.application.getDeviceDialog().isDisposed()) {
                        PicolarioDialog.this.queryAvailableRecordSetButton.setEnabled(true);
                        PicolarioDialog.this.readSingle.setEnabled(true);
                        PicolarioDialog.this.readAllRecords.setEnabled(true);
                        PicolarioDialog.this.stopButton.setEnabled(false);
                        PicolarioDialog.this.setClosePossible(true);
                    }
                }
            });
        }
    }

    public boolean isDoSwtichRecordSet() {
        return this.doSwtichRecordSet;
    }

    public void resetButtons() {
        if (this.dialogShell != null && !this.dialogShell.isDisposed()) {
            if (Thread.currentThread().threadId() == this.application.getThreadId()) {
                this.setClosePossible(true);
                this.queryAvailableRecordSetButton.setEnabled(true);
                this.readSingle.setEnabled(true);
                this.readAllRecords.setEnabled(true);
                this.stopButton.setEnabled(false);
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PicolarioDialog.this.setClosePossible(true);
                        PicolarioDialog.this.queryAvailableRecordSetButton.setEnabled(true);
                        PicolarioDialog.this.readSingle.setEnabled(true);
                        PicolarioDialog.this.readAllRecords.setEnabled(true);
                        PicolarioDialog.this.stopButton.setEnabled(false);
                    }
                });
            }
        }
    }

    public synchronized Button getQueryAvailableRecordSetButton() {
        return this.queryAvailableRecordSetButton;
    }

    public synchronized Button getReadAllRecords() {
        return this.readAllRecords;
    }
}

