/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.comm.DeviceCommPort;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.ui.DataExplorer;
import java.util.logging.Logger;

public class JLog2SerialPort
extends DeviceCommPort {
    static final String $CLASS_NAME = JLog2SerialPort.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    boolean isInSync = false;

    public JLog2SerialPort(IDevice currentDevice, DataExplorer currentApplication) {
        super(currentDevice, currentApplication);
    }

    public synchronized byte[] getData() throws Exception {
        String $METHOD_NAME = "getData";
        byte[] data = new byte[]{0};
        byte[] tmpData = new byte[Math.abs(this.device.getDataBlockSize(InputTypes.SERIAL_IO))];
        byte[] answer = new byte[]{0};
        try {
            StringBuilder sb;
            answer = new byte[tmpData.length];
            answer = this.read(answer, 1000, 5, tmpData.length / 3);
            if (log.isLoggable(Level.FINE)) {
                sb = new StringBuilder();
                for (byte b : answer) {
                    sb.append((char)b);
                }
                log.logp(Level.FINE, $CLASS_NAME, "getData", sb.toString());
            }
            while (answer[0] != 36) {
                if (this.isInterruptedByUser) {
                    return tmpData;
                }
                this.cleanInputStream();
                tmpData = this.getData();
            }
            System.arraycopy(answer, 0, tmpData, 0, answer.length);
            data = new byte[this.getArrayLengthByCheckEnding(tmpData)];
            System.arraycopy(tmpData, 0, data, 0, data.length);
            if (log.isLoggable(Level.FINE)) {
                sb = new StringBuilder();
                for (byte b : data) {
                    sb.append((char)b);
                }
                log.logp(Level.FINE, $CLASS_NAME, "getData", sb.toString());
            }
        }
        catch (Exception e) {
            if (!(e instanceof TimeOutException)) {
                log.logp(Level.SEVERE, $CLASS_NAME, "getData", e.getMessage(), e);
            }
            throw e;
        }
        return data;
    }

    public int getArrayLengthByCheckEnding(byte[] tmpData) {
        int lenght;
        for (lenght = tmpData.length; lenght > 10 && (tmpData[lenght - 1] != 10 || tmpData[lenght - 2] != 13); --lenght) {
        }
        return lenght;
    }
}

