/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.tab;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.StatisticsType;
import gde.device.resource.DeviceXmlResource;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.menu.TabAreaContextMenu;
import gde.utils.TimeLine;
import java.text.DecimalFormat;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class StatisticsWindow
extends CTabItem {
    static final Logger log = Logger.getLogger(StatisticsWindow.class.getName());
    static final String DELIMITER = "!";
    static final String NO_VALUE = "    ---    ";
    Composite composite;
    Composite filler;
    Group descriptionGroup;
    Text descriptionTextLabel;
    CLabel minLabel;
    CLabel maxLabel;
    CLabel avgLabel;
    Table dataTable;
    TableColumn measurementTableColumn;
    TableColumn unitTableColumn;
    TableColumn sigmaTableColumn;
    TableColumn customTableColumn;
    int customTableColumnWidth = 0;
    CLabel sigmaLabel;
    CLabel extraLabel;
    TableColumn avgTableColumn;
    TableColumn maxTableColumn;
    TableColumn minTableColumn;
    TableColumn maxTimeTableColumn;
    TableColumn minTimeTableColumn;
    Menu popupmenu;
    TabAreaContextMenu contextMenu;
    Color innerAreaBackground;
    Color surroundingBackground;
    String descriptionText = "";
    Vector<String> tabelItemText = new Vector();
    final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    final int extentFactor = 8;
    RecordSet oldRecordSet = null;
    int oldNumberDisplayableRecords = 0;
    final DataExplorer application;
    final Channels channels;
    final Settings settings;
    final CTabFolder tabFolder;
    final DeviceXmlResource xmlResource = DeviceXmlResource.getInstance();

    public StatisticsWindow(CTabFolder currentDisplayTab, int style) {
        super(currentDisplayTab, style);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.application = DataExplorer.getInstance();
        this.tabFolder = currentDisplayTab;
        this.channels = Channels.getInstance();
        this.settings = Settings.getInstance();
        this.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 3 : 1), 0));
        this.setText(Messages.getString("GDE_MSGT0350"));
        this.popupmenu = new Menu((Decorations)this.application.getShell(), 8);
        this.contextMenu = new TabAreaContextMenu();
        this.innerAreaBackground = this.settings.getStatisticsInnerAreaBackground();
        this.surroundingBackground = this.settings.getStatisticsSurroundingAreaBackground();
    }

    public void create() {
        try {
            this.composite = new Composite((Composite)this.tabFolder, 0);
            this.setControl((Control)this.composite);
            this.composite.setLayout(null);
            this.composite.setBackground(this.surroundingBackground);
            this.composite.setMenu(this.popupmenu);
            this.composite.addHelpListener(new HelpListener(this){

                public void helpRequested(HelpEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "composite.helpRequested " + String.valueOf(evt));
                    }
                    DataExplorer.getInstance().openHelpDialog("", "HelpInfo_5.html");
                }
            });
            this.composite.addControlListener(new ControlListener(){

                public void controlResized(ControlEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "composite.controlResized evt=" + String.valueOf(evt));
                    }
                    StatisticsWindow.this.descriptionGroup.setSize(StatisticsWindow.this.composite.getClientArea().width - 20, 110);
                    StatisticsWindow.this.descriptionTextLabel.setSize(StatisticsWindow.this.descriptionGroup.getClientArea().width - 15, StatisticsWindow.this.descriptionGroup.getClientArea().height - 10);
                    StatisticsWindow.this.adaptTableSize();
                }

                public void controlMoved(ControlEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "composite.controlMoved evt=" + String.valueOf(evt));
                    }
                }
            });
            this.descriptionGroup = new Group(this.composite, 0);
            this.descriptionGroup.setLayout(null);
            this.descriptionGroup.setBounds(10, 10, 300, 110);
            this.descriptionGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.descriptionGroup.setText(Messages.getString("GDE_MSGT0351"));
            if (!GDE.IS_MAC) {
                this.descriptionGroup.setBackground(this.innerAreaBackground);
            }
            this.descriptionGroup.setMenu(this.popupmenu);
            this.descriptionGroup.addHelpListener(new HelpListener(this){

                public void helpRequested(HelpEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "descriptionGroup.helpRequested " + String.valueOf(evt));
                    }
                    DataExplorer.getInstance().openHelpDialog("", "HelpInfo_5.html");
                }
            });
            this.descriptionGroup.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "descriptionGroup.paintControl, event=" + String.valueOf(evt));
                    }
                    StatisticsWindow.this.contextMenu.createMenu(StatisticsWindow.this.popupmenu, TabAreaContextMenu.TabMenuType.SIMPLE);
                    Channel activeChannel = StatisticsWindow.this.channels.getActiveChannel();
                    if (activeChannel != null) {
                        RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
                        if (activeRecordSet != null) {
                            StatisticsWindow.this.descriptionText = activeChannel.getFileDescription() + "\n--------------------------\n" + activeRecordSet.getName() + " :  " + activeRecordSet.getRecordSetDescription();
                            String tmpDescriptionText = StatisticsWindow.this.descriptionText;
                            if (StatisticsWindow.this.descriptionTextLabel != null && !tmpDescriptionText.equals(StatisticsWindow.this.descriptionTextLabel.getText())) {
                                StatisticsWindow.this.descriptionText = tmpDescriptionText;
                                StatisticsWindow.this.descriptionTextLabel.setText((String)StatisticsWindow.this.descriptionText);
                            }
                        } else {
                            String tmpDescriptionText = "";
                            if (StatisticsWindow.this.descriptionTextLabel != null && !tmpDescriptionText.equals(StatisticsWindow.this.descriptionTextLabel.getText())) {
                                StatisticsWindow.this.descriptionText = tmpDescriptionText;
                                StatisticsWindow.this.descriptionTextLabel.setText(StatisticsWindow.this.descriptionText);
                            }
                        }
                    }
                }
            });
            this.descriptionTextLabel = new Text((Composite)this.descriptionGroup, 16962);
            this.descriptionTextLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.descriptionTextLabel.setText("recordSetName, (fileDescription), recordSetDescription");
            this.descriptionTextLabel.setBackground(this.innerAreaBackground);
            if (GDE.IS_WINDOWS) {
                this.descriptionTextLabel.setBounds(10, 20, this.descriptionGroup.getClientArea().width - 15, this.descriptionGroup.getClientArea().height - 10);
            } else {
                this.descriptionTextLabel.setBounds(5, 3, this.descriptionGroup.getClientArea().width - 10, this.descriptionGroup.getClientArea().height - 10);
            }
            this.descriptionTextLabel.setEditable(false);
            this.descriptionTextLabel.setMenu(this.popupmenu);
            this.dataTable = new Table(this.composite, 2050);
            this.dataTable.setLinesVisible(!this.isWindows);
            this.dataTable.setHeaderVisible(true);
            this.dataTable.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.dataTable.setBounds(10, 150, 300, 100);
            this.dataTable.setBackground(this.innerAreaBackground);
            this.dataTable.setMenu(this.popupmenu);
            this.dataTable.addHelpListener(new HelpListener(this){

                public void helpRequested(HelpEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "dataTable.helpRequested " + String.valueOf(evt));
                    }
                    DataExplorer.getInstance().openHelpDialog("", "HelpInfo_5.html");
                }
            });
            this.measurementTableColumn = new TableColumn(this.dataTable, 16384);
            this.measurementTableColumn.setWidth(180);
            this.measurementTableColumn.setText(Messages.getString("GDE_MSGT0352"));
            this.unitTableColumn = new TableColumn(this.dataTable, 16384);
            this.unitTableColumn.setWidth(120);
            this.unitTableColumn.setText(Messages.getString("GDE_MSGT0353"));
            this.unitTableColumn.setAlignment(16384);
            this.minTableColumn = new TableColumn(this.dataTable, 0x1000000);
            this.minTableColumn.setWidth(90);
            this.minTableColumn.setText(Messages.getString("GDE_MSGT0354"));
            this.minTimeTableColumn = new TableColumn(this.dataTable, 131072);
            this.minTimeTableColumn.setWidth(110);
            this.minTimeTableColumn.setText(Messages.getString("GDE_MSGT0359") + " ");
            this.avgTableColumn = new TableColumn(this.dataTable, 0x1000000);
            this.avgTableColumn.setWidth(90);
            this.avgTableColumn.setText(Messages.getString("GDE_MSGT0355"));
            this.maxTableColumn = new TableColumn(this.dataTable, 0x1000000);
            this.maxTableColumn.setWidth(90);
            this.maxTableColumn.setText(Messages.getString("GDE_MSGT0356"));
            this.maxTimeTableColumn = new TableColumn(this.dataTable, 131072);
            this.maxTimeTableColumn.setWidth(110);
            this.maxTimeTableColumn.setText(Messages.getString("GDE_MSGT0359") + " ");
            this.sigmaTableColumn = new TableColumn(this.dataTable, 0x1000000);
            String sigmaText = Messages.getString("GDE_MSGT0357");
            this.sigmaTableColumn.setText(sigmaText);
            this.sigmaTableColumn.setWidth(sigmaText.length() * this.extentFactor > 90 ? sigmaText.length() * this.extentFactor : 80);
            this.customTableColumn = new TableColumn(this.dataTable, 16384);
            this.customTableColumn.setWidth(300);
            this.customTableColumn.setText(Messages.getString("GDE_MSGT0358"));
            this.composite.layout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void updateStatisticsData(boolean forceUpdate) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "entry updateStatisticsData");
        }
        this.descriptionGroup.redraw();
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null) {
            RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
            if (activeRecordSet != null && activeRecordSet.getRecordDataSize(true) > 0 && (forceUpdate || !activeRecordSet.equals(this.oldRecordSet))) {
                this.dataTable.removeAll();
                this.customTableColumnWidth = 0;
                try {
                    String[] displayableRecords = activeRecordSet.getDisplayableRecordNames();
                    this.oldNumberDisplayableRecords = displayableRecords.length;
                    StringBuilder sb = new StringBuilder();
                    this.tabelItemText = new Vector();
                    String time = Messages.getString("GDE_MSGT0234");
                    sb.append(time.split(" ")[0]).append(DELIMITER);
                    sb.append(Messages.getString("GDE_MSGT0359")).append(DELIMITER);
                    sb.append("     0      ").append(DELIMITER);
                    sb.append(NO_VALUE).append(DELIMITER);
                    sb.append(NO_VALUE).append(DELIMITER);
                    sb.append(TimeLine.getFomatedTime(activeRecordSet.getMaxTime_ms())).append(" ").append(DELIMITER);
                    sb.append(TimeLine.getFomatedTime(activeRecordSet.getMaxTime_ms())).append(" ").append(DELIMITER);
                    sb.append(NO_VALUE).append(DELIMITER);
                    if (activeRecordSet.isTimeStepConstant()) {
                        sb.append(Messages.getString("GDE_MSGT0360")).append(String.format("%6.1f", activeRecordSet.getTime_ms(1))).append(Messages.getString("GDE_MSGT0361"));
                    }
                    this.tabelItemText.add(sb.toString());
                    for (String recordName : displayableRecords) {
                        DecimalFormat cdf;
                        Record record = activeRecordSet.get(recordName);
                        IDevice device = activeRecordSet.getDevice();
                        StatisticsType measurementStatistics = device.getMeasurementStatistic(activeChannel.getNumber(), activeRecordSet.get(recordName).getOrdinal());
                        if (measurementStatistics == null) continue;
                        sb = new StringBuilder();
                        int triggerRefOrdinal = this.getTriggerReferenceOrdinal(activeRecordSet, measurementStatistics);
                        int triggerSecondaryRefOrdinal = this.getTriggerSecondaryReferenceOrdinal(activeRecordSet, measurementStatistics);
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, String.format("updating record = %s trigger ref ordinal = %d trigger secondary ref ordinal = %d", recordName, triggerRefOrdinal, triggerSecondaryRefOrdinal));
                        }
                        sb.append(record.getName()).append(DELIMITER);
                        sb.append("[").append(record.getUnit()).append("]").append(DELIMITER);
                        if (measurementStatistics.isMin()) {
                            if (triggerRefOrdinal >= 0 && triggerSecondaryRefOrdinal >= 0) {
                                sb.append(this.formatOutput(record.getFormattedStatisticsValue((double)record.getMinValueTriggered(triggerRefOrdinal, triggerSecondaryRefOrdinal) / 1000.0)));
                            } else if (triggerRefOrdinal < 0 || record.getMinValueTriggered(triggerRefOrdinal) != Integer.MAX_VALUE) {
                                sb.append(this.formatOutput(record.getFormattedStatisticsValue((double)(triggerRefOrdinal < 0 ? record.getRealMinValue() : record.getMinValueTriggered(triggerRefOrdinal)) / 1000.0)));
                            } else {
                                sb.append(NO_VALUE).append(DELIMITER).append(NO_VALUE);
                            }
                            if (!sb.toString().endsWith(NO_VALUE)) {
                                sb.append(DELIMITER).append(TimeLine.getFomatedTime(record.getRealMinValueTime_ms())).append(" ");
                            }
                        } else {
                            sb.append(NO_VALUE).append(DELIMITER).append(NO_VALUE);
                        }
                        sb.append(DELIMITER);
                        if (measurementStatistics.isAvg()) {
                            if (triggerRefOrdinal >= 0 && triggerSecondaryRefOrdinal >= 0) {
                                sb.append(this.formatOutput(record.getFormattedStatisticsValue((double)record.getAvgValueTriggered(triggerRefOrdinal, triggerSecondaryRefOrdinal) / 1000.0)));
                            } else if (triggerRefOrdinal < 0 || record.getAvgValueTriggered(triggerRefOrdinal) != Integer.MIN_VALUE) {
                                sb.append(this.formatOutput(record.getFormattedStatisticsValue((double)(triggerRefOrdinal < 0 ? record.getAvgValue() : record.getAvgValueTriggered(triggerRefOrdinal)) / 1000.0)));
                            } else {
                                sb.append(NO_VALUE);
                            }
                        }
                        sb.append(DELIMITER);
                        if (measurementStatistics.isMax()) {
                            if (triggerRefOrdinal >= 0 && triggerSecondaryRefOrdinal >= 0) {
                                sb.append(this.formatOutput(record.getFormattedStatisticsValue((double)record.getMaxValueTriggered(triggerRefOrdinal, triggerSecondaryRefOrdinal) / 1000.0)));
                            } else if (triggerRefOrdinal < 0 || record.getMaxValueTriggered(triggerRefOrdinal) != Integer.MIN_VALUE) {
                                sb.append(this.formatOutput(record.getFormattedStatisticsValue((double)(triggerRefOrdinal < 0 ? record.getRealMaxValue() : record.getMaxValueTriggered(triggerRefOrdinal)) / 1000.0)));
                            } else {
                                sb.append(NO_VALUE).append(DELIMITER).append(NO_VALUE);
                            }
                            if (!sb.toString().endsWith(NO_VALUE)) {
                                sb.append(DELIMITER).append(TimeLine.getFomatedTime(record.getRealMaxValueTime_ms())).append(" ");
                            }
                        } else {
                            sb.append(NO_VALUE).append(DELIMITER).append(NO_VALUE);
                        }
                        sb.append(DELIMITER);
                        if (measurementStatistics.isSigma()) {
                            cdf = new DecimalFormat("0.000");
                            if (triggerRefOrdinal >= 0 && triggerSecondaryRefOrdinal >= 0) {
                                sb.append(this.formatOutput(record.getFormattedStatisticsValue((double)record.getSigmaValueTriggered(triggerRefOrdinal, triggerSecondaryRefOrdinal) / 1000.0)));
                            } else if (triggerRefOrdinal < 0 || record.getSigmaValueTriggered(triggerRefOrdinal) != Integer.MIN_VALUE) {
                                sb.append(this.formatOutput(cdf.format(device.translateValue(record, (double)(triggerRefOrdinal < 0 ? record.getSigmaValue() : record.getSigmaValueTriggered(triggerRefOrdinal)) / 1000.0))));
                            } else {
                                sb.append(NO_VALUE).append(DELIMITER).append(NO_VALUE);
                            }
                        } else {
                            sb.append(NO_VALUE);
                        }
                        sb.append(DELIMITER);
                        if (measurementStatistics.isCountByTrigger() != null) {
                            sb.append(this.xmlResource.getReplacement(measurementStatistics.getCountTriggerText())).append(" = ").append(record.getTriggerRanges() != null ? record.getTriggerRanges().size() : 0).append("; ");
                        }
                        if (measurementStatistics.getSumByTriggerRefOrdinal() != null) {
                            Record referencedRecord;
                            Integer ratioRefOrdinal;
                            if (measurementStatistics.getSumTriggerText() != null && measurementStatistics.getSumTriggerText().length() > 1) {
                                boolean isTriggerLevel;
                                sb.append(this.xmlResource.getReplacement(measurementStatistics.getSumTriggerText())).append(" = ");
                                boolean bl = isTriggerLevel = measurementStatistics.getTrigger() != null;
                                if (isTriggerLevel) {
                                    sb.append(String.format("%.1f", device.translateDeltaValue(record, (double)record.getSumTriggeredRange() / 1000.0)));
                                } else if (measurementStatistics.getSumBySecondaryTriggerRefOrdinal() != null) {
                                    sb.append(String.format("%.1f", device.translateDeltaValue(record, (double)record.getSumTriggeredRange(measurementStatistics.getSumByTriggerRefOrdinal(), measurementStatistics.getSumBySecondaryTriggerRefOrdinal()) / 1000.0)));
                                } else {
                                    sb.append(String.format("%.1f", device.translateDeltaValue(record, (double)record.getSumTriggeredRange(measurementStatistics.getSumByTriggerRefOrdinal()) / 1000.0)));
                                }
                                sb.append(" [").append(record.getUnit()).append("]; ");
                            }
                            if (measurementStatistics.getRatioText() != null && measurementStatistics.getRatioText().length() > 1 && measurementStatistics.getRatioRefOrdinal() != null && (ratioRefOrdinal = measurementStatistics.getRatioRefOrdinal()) != null && (referencedRecord = activeRecordSet.get(ratioRefOrdinal)) != null) {
                                sb.append(this.xmlResource.getReplacement(measurementStatistics.getRatioText())).append(" = ");
                                double summarizedValue = device.translateDeltaValue(record, (double)record.getSumTriggeredRange(ratioRefOrdinal) / 1000.0);
                                double summarizedValueReferenced = device.translateDeltaValue(referencedRecord, (double)referencedRecord.getSumTriggeredRange(measurementStatistics.getSumByTriggerRefOrdinal()) / 1000.0);
                                if (summarizedValueReferenced > 0.0 && summarizedValue > 0.0) {
                                    double ratio = summarizedValueReferenced / 1000.0 / summarizedValue;
                                    sb.append(String.format("%.2f", ratio < 1.0 ? ratio * 1000.0 : ratio));
                                    sb.append(" [").append(referencedRecord.getUnit()).append("/").append(record.getUnit()).append("]; ");
                                } else {
                                    sb.append("0 [").append(referencedRecord.getUnit()).append("/").append(record.getUnit()).append("]; ");
                                }
                            }
                        }
                        if (measurementStatistics.getComment() != null && measurementStatistics.getComment().length() > 1) {
                            if (triggerRefOrdinal >= 0 && triggerSecondaryRefOrdinal >= 0) {
                                sb.append(String.format("(%s %s+%s) ", this.xmlResource.getReplacement(measurementStatistics.getComment()), activeRecordSet.get(triggerRefOrdinal).getName(), activeRecordSet.get(triggerSecondaryRefOrdinal).getName()));
                            } else if (triggerRefOrdinal >= 0) {
                                sb.append(String.format("(%s %s) ", this.xmlResource.getReplacement(measurementStatistics.getComment()), activeRecordSet.get(triggerRefOrdinal).getName()));
                            } else {
                                sb.append(String.format("%s) ", this.xmlResource.getReplacement(measurementStatistics.getComment())));
                            }
                        }
                        if (triggerRefOrdinal >= 0 && measurementStatistics.isIntegrateByTrigger()) {
                            cdf = new DecimalFormat("0.00");
                            sb.append(String.format(Messages.getString("GDE_MSGT0958"), cdf.format(record.getIntegratedValue(triggerRefOrdinal)), record.getUnit() + "min"));
                        }
                        if (measurementStatistics.getTrigger() != null && measurementStatistics.getSumTriggerTimeText() != null && measurementStatistics.getSumTriggerTimeText().length() > 1) {
                            sb.append("(").append(String.format(this.xmlResource.getReplacement(measurementStatistics.getTrigger().getComment()), recordName, (double)measurementStatistics.getTrigger().getLevel().intValue() / 1000.0, activeRecordSet.get(recordName).getUnit(), measurementStatistics.getTrigger().getMinTimeSec())).append(") ");
                            if (!measurementStatistics.getTrigger().isSecondary()) {
                                this.tabelItemText.set(0, this.tabelItemText.get(0) + (activeRecordSet.isTimeStepConstant() ? ", " : "") + this.xmlResource.getReplacement(this.xmlResource.getReplacement(measurementStatistics.getSumTriggerTimeText())) + " = " + record.getTimeSumTriggeredRange());
                            }
                        } else if (measurementStatistics.getSumTriggerTimeText() == null && measurementStatistics.getTrigger() != null && measurementStatistics.getTrigger().getComment() != null && measurementStatistics.getTrigger().getComment().length() > 1) {
                            sb.append("(").append(String.format(this.xmlResource.getReplacement(measurementStatistics.getTrigger().getComment()), recordName, (double)measurementStatistics.getTrigger().getLevel().intValue() / 1000.0, activeRecordSet.get(recordName).getUnit(), measurementStatistics.getTrigger().getMinTimeSec())).append(") ");
                        }
                        GC displayGC = new GC((Drawable)this.dataTable.getDisplay());
                        int customColumnTextExtent = 15 + displayGC.textExtent((String)sb.substring((int)(sb.lastIndexOf((String)DELIMITER) + 1))).x;
                        displayGC.dispose();
                        int n = this.customTableColumnWidth = customColumnTextExtent > this.customTableColumnWidth ? customColumnTextExtent : this.customTableColumnWidth;
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, sb.toString());
                        }
                        this.tabelItemText.add(sb.toString());
                    }
                }
                catch (RuntimeException e) {
                    log.log(Level.WARNING, e.getMessage(), e);
                }
                if (!this.isWindows) {
                    this.dataTable.setItemCount(this.dataTable.getItemCount() + 1);
                }
                for (String itemsText : this.tabelItemText) {
                    if (this.isWindows) {
                        this.dataTable.setItemCount(this.dataTable.getItemCount() + 1);
                    }
                    TableItem row = new TableItem(this.dataTable, 0);
                    row.setText(itemsText.split(DELIMITER));
                }
                if (this.oldRecordSet != null && !activeRecordSet.getName().equals(this.oldRecordSet.getName())) {
                    this.descriptionGroup.redraw();
                }
                this.oldRecordSet = activeRecordSet;
            } else if (activeRecordSet == null) {
                if (this.oldRecordSet != null && this.tabelItemText.size() > 0) {
                    this.dataTable.removeAll();
                }
                this.tabelItemText = new Vector();
                this.oldRecordSet = null;
            }
        } else {
            if (this.oldRecordSet != null && this.tabelItemText.size() > 0) {
                this.dataTable.removeAll();
            }
            this.tabelItemText = new Vector();
            this.oldRecordSet = null;
        }
        this.adaptTableSize();
        this.dataTable.redraw();
    }

    int getTriggerReferenceOrdinal(RecordSet recordSet, StatisticsType measurementStatistics) {
        int tmpOrdinal;
        Record record;
        int triggerRefOrdinal = -1;
        if (measurementStatistics.getTriggerRefOrdinal() != null && recordSet != null && (record = recordSet.get(tmpOrdinal = measurementStatistics.getTriggerRefOrdinal().intValue())) != null && record.isDisplayable()) {
            triggerRefOrdinal = tmpOrdinal;
        }
        return triggerRefOrdinal;
    }

    int getTriggerSecondaryReferenceOrdinal(RecordSet recordSet, StatisticsType measurementStatistics) {
        int tmpOrdinal;
        Record record;
        int triggerSecondaryRefOrdinal = -1;
        if (measurementStatistics.getTriggerSecondaryRefOrdinal() != null && recordSet != null && (record = recordSet.get(tmpOrdinal = measurementStatistics.getTriggerSecondaryRefOrdinal().intValue())) != null && record.isDisplayable()) {
            triggerSecondaryRefOrdinal = tmpOrdinal;
        }
        return triggerSecondaryRefOrdinal;
    }

    String formatOutput(String inDecimalString) {
        String[] tmp = inDecimalString.replace('.', ';').replace(',', ';').split(";");
        return tmp.length > 1 ? String.format("%6s.%-5s", tmp[0], tmp[1]) : String.format("%6s%-6s", tmp[0], ".0");
    }

    void updateDataTable() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "entry data table update");
        }
        this.dataTable.removeAll();
        if (!this.isWindows) {
            this.dataTable.setItemCount(this.dataTable.getItemCount() + 1);
        }
        for (String itemsText : this.tabelItemText) {
            if (this.isWindows) {
                this.dataTable.setItemCount(this.dataTable.getItemCount() + 1);
            }
            TableItem row = new TableItem(this.dataTable, 0);
            row.setText(itemsText.split(DELIMITER));
        }
        this.dataTable.redraw();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "exit data table update");
        }
    }

    void adaptTableSize() {
        int columsWidth = 0;
        for (int i = 0; i < this.dataTable.getColumnCount() - 1; ++i) {
            columsWidth += this.dataTable.getColumn(i).getWidth();
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "ColumWidth = " + this.dataTable.getColumn(i).getWidth());
        }
        Point tableSize = this.dataTable.computeSize(this.composite.getClientArea().width - 20, -1, true);
        int tableHeight = tableSize.y + 150 < this.composite.getClientArea().height ? tableSize.y : this.composite.getClientArea().height - 150;
        tableHeight = tableHeight > 0 ? tableHeight : 0;
        this.dataTable.setSize(this.composite.getClientArea().width - 20, tableHeight);
        int customWidthFill = this.dataTable.getClientArea().width - columsWidth;
        this.customTableColumn.setWidth(this.customTableColumnWidth > customWidthFill ? this.customTableColumnWidth : customWidthFill);
    }

    public String getContentAsText() {
        StringBuilder sb = new StringBuilder();
        sb.append("DataExplorer").append(" - ").append(Messages.getString("GDE_MSGT0350")).append(GDE.LINE_SEPARATOR).append(GDE.LINE_SEPARATOR);
        sb.append(Messages.getString("GDE_MSGT0351")).append(GDE.LINE_SEPARATOR);
        Channel activeChannel = this.channels.getActiveChannel();
        this.descriptionText = activeChannel != null ? activeChannel.getFileDescription() + "\n--------------------------\n" : Messages.getString("GDE_MSGW0036") + "\n--------------------------\n";
        RecordSet activeRecordSet = Channels.getInstance().getActiveChannel().getActiveRecordSet();
        if (activeRecordSet != null) {
            this.descriptionText = this.descriptionText + activeRecordSet.getName() + " :  " + activeRecordSet.getRecordSetDescription();
        }
        sb.append(this.descriptionText).append(GDE.LINE_SEPARATOR).append(GDE.LINE_SEPARATOR);
        sb.append(String.format("%-18s %-15s %10s  %12s  %10s %-18s  %s", Messages.getString("GDE_MSGT0352"), Messages.getString("GDE_MSGT0353"), Messages.getString("GDE_MSGT0354"), Messages.getString("GDE_MSGT0355"), Messages.getString("GDE_MSGT0356"), Messages.getString("GDE_MSGT0357"), Messages.getString("GDE_MSGT0358"))).append(GDE.LINE_SEPARATOR);
        for (String tableText : this.tabelItemText) {
            String[] itemsText = tableText.split(DELIMITER);
            sb.append(String.format("%-18s %-15s %12s %12s %12s %12s      ", itemsText[0], itemsText[1], itemsText[2], itemsText[3], itemsText[4], itemsText[5]));
            if (itemsText.length > 6) {
                sb.append(itemsText[6]);
            }
            sb.append(GDE.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public Image getContentAsImage() {
        Rectangle bounds = this.tabFolder.getClientArea();
        Image objectImage = new Image((Device)GDE.display, bounds.width, bounds.height);
        GC imageGC = new GC((Drawable)objectImage);
        this.composite.print(imageGC);
        if (GDE.IS_MAC) {
            this.composite.print(imageGC);
        }
        imageGC.dispose();
        return objectImage;
    }

    public void setInnerAreaBackground(Color newInnerAreaBackground) {
        this.innerAreaBackground = newInnerAreaBackground;
        this.descriptionGroup.setBackground(newInnerAreaBackground);
        this.descriptionTextLabel.setBackground(newInnerAreaBackground);
        this.descriptionGroup.redraw();
        this.dataTable.setBackground(newInnerAreaBackground);
        this.dataTable.redraw();
    }

    public void setSurroundingAreaBackground(Color newSurroundingBackground) {
        this.composite.setBackground(newSurroundingBackground);
        this.surroundingBackground = newSurroundingBackground;
        this.composite.redraw();
    }
}

