/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.tab;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.menu.TabAreaContextMenu;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FileCommentWindow
extends CTabItem {
    static final Logger log = Logger.getLogger(FileCommentWindow.class.getName());
    Composite commentMainComposite;
    CLabel infoLabel;
    Text fileCommentText;
    boolean isFileCommentChanged = false;
    boolean isRecordCommentChanged = false;
    Table recordCommentTable;
    TableColumn recordCommentTableColumn1;
    TableColumn recordCommentTableColumn2;
    TableCursor cursor;
    ControlEditor editor;
    Color innerAreaBackground;
    Color surroundingBackground;
    Color headerTextColor;
    Vector<Integer> rowVector = new Vector(2);
    Vector<Integer> topindexVector = new Vector(2);
    int fileCommentCaretPosition = 0;
    boolean isFocusGained = false;
    boolean isTableUptaded = true;
    final DataExplorer application;
    final Channels channels;
    final CTabFolder displayTab;
    final Menu popupmenu;
    final TabAreaContextMenu contextMenu;
    final int TEXT_MARGIN = 2;

    public FileCommentWindow(CTabFolder currentDisplayTab, int style) {
        super(currentDisplayTab, style);
        this.displayTab = currentDisplayTab;
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        SWTResourceManager.registerResourceUser((Widget)this);
        this.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 3 : 1), 0));
        this.setText(Messages.getString("GDE_MSGT0239"));
        this.popupmenu = new Menu((Decorations)this.application.getShell(), 8);
        this.contextMenu = new TabAreaContextMenu();
        this.innerAreaBackground = Settings.getInstance().getFileCommentInnerAreaBackground();
        this.surroundingBackground = Settings.getInstance().getFileCommentSurroundingAreaBackground();
        this.headerTextColor = Settings.getInstance().getHeaderCommentColor();
    }

    public void create() {
        this.commentMainComposite = new Composite((Composite)this.displayTab, 0);
        this.setControl((Control)this.commentMainComposite);
        this.commentMainComposite.setLayout(null);
        this.commentMainComposite.setBackground(this.surroundingBackground);
        this.commentMainComposite.setMenu(this.popupmenu);
        this.commentMainComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "commentMainComposite.paintControl, event=" + String.valueOf(evt));
                }
                if (FileCommentWindow.this.isFileCommentChanged) {
                    FileCommentWindow.this.setFileComment();
                }
                if (FileCommentWindow.this.isRecordCommentChanged) {
                    FileCommentWindow.this.updateRecordSetTable();
                }
            }
        });
        this.commentMainComposite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "composite.controlResized evt=" + String.valueOf(evt));
                }
                FileCommentWindow.this.updateRecordSetTable();
            }

            public void controlMoved(ControlEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "composite.controlMoved evt=" + String.valueOf(evt));
                }
            }
        });
        this.commentMainComposite.addHelpListener(new HelpListener(this){

            public void helpRequested(HelpEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "commentMainComposite.helpRequested " + String.valueOf(evt));
                }
                DataExplorer.getInstance().openHelpDialog("", "HelpInfo_92.html");
            }
        });
        this.commentMainComposite.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "commentMainComposite.focusLost() , event=" + String.valueOf(evt));
                }
                FileCommentWindow.this.setFileComment();
            }

            public void focusGained(FocusEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "commentMainComposite.focusGained() , event=" + String.valueOf(evt));
                }
            }
        });
        this.infoLabel = new CLabel(this.commentMainComposite, 16384);
        this.infoLabel.setText(Messages.getString("GDE_MSGT0240"));
        this.infoLabel.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + 2, 1));
        this.infoLabel.setBackground(this.surroundingBackground);
        this.infoLabel.setForeground(this.headerTextColor);
        this.infoLabel.setMenu(this.popupmenu);
        this.infoLabel.setBounds(50, 10, 500, 26);
        this.infoLabel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "infoLabel.paintControl " + String.valueOf(evt));
                }
                FileCommentWindow.this.contextMenu.createMenu(FileCommentWindow.this.popupmenu, TabAreaContextMenu.TabMenuType.SIMPLE);
            }
        });
        this.fileCommentText = new Text(this.commentMainComposite, 2626);
        this.fileCommentText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.fileCommentText.setBackground(this.innerAreaBackground);
        this.fileCommentText.setText(Messages.getString("GDE_MSGT0241"));
        this.fileCommentText.setBounds(50, 40, 500, 100);
        this.fileCommentText.setText(this.channels.getActiveChannel() != null ? this.channels.getActiveChannel().getFileDescription() : "");
        this.fileCommentCaretPosition = this.fileCommentText.getText().length();
        this.fileCommentText.setMenu(this.popupmenu);
        this.fileCommentText.addHelpListener(new HelpListener(this){

            public void helpRequested(HelpEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "fileCommentText.helpRequested " + String.valueOf(evt));
                }
                DataExplorer.getInstance().openHelpDialog("", "HelpInfo_92.html");
            }
        });
        this.fileCommentText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "fileCommentText.verifyText , event=" + String.valueOf(e));
                }
                if (FileCommentWindow.this.isFocusGained) {
                    e.doit = false;
                    FileCommentWindow.this.isFocusGained = false;
                } else {
                    e.doit = true;
                }
            }
        });
        this.fileCommentText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "fileCommentText.keyPressed , event=" + String.valueOf(e));
                }
                if (e.character != '\u0000' && e.keyCode != 27) {
                    if ((e.stateMask & SWT.MOD1) != 0 && (char)e.keyCode == 'a') {
                        FileCommentWindow.this.fileCommentText.selectAll();
                    } else {
                        FileCommentWindow.this.isFileCommentChanged = true;
                    }
                }
            }
        });
        this.fileCommentText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "fileCommentText.focusLost() , event=" + String.valueOf(evt));
                }
                FileCommentWindow.this.setFileComment();
                FileCommentWindow.this.fileCommentCaretPosition = FileCommentWindow.this.fileCommentCaretPosition == 0 && FileCommentWindow.this.fileCommentText.getCaretPosition() == 0 ? FileCommentWindow.this.fileCommentText.getText().length() : FileCommentWindow.this.fileCommentText.getCaretPosition();
            }

            public void focusGained(FocusEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "fileCommentText.focusGained() , event=" + String.valueOf(evt));
                }
                FileCommentWindow.this.fileCommentText.setSelection(FileCommentWindow.this.fileCommentCaretPosition);
                FileCommentWindow.this.isFocusGained = true;
            }
        });
        this.recordCommentTable = new Table(this.commentMainComposite, 67584);
        this.recordCommentTableColumn1 = new TableColumn(this.recordCommentTable, 16384);
        this.recordCommentTableColumn1.setWidth(250);
        this.recordCommentTableColumn1.setText(Messages.getString("GDE_MSGT0242"));
        this.recordCommentTableColumn2 = new TableColumn(this.recordCommentTable, 16384);
        this.recordCommentTableColumn2.setWidth(250);
        this.recordCommentTableColumn2.setText(Messages.getString("GDE_MSGT0243"));
        this.recordCommentTable.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.recordCommentTable.setBounds(50, 200, 500, 100);
        this.recordCommentTable.setLinesVisible(true);
        this.recordCommentTable.setHeaderVisible(true);
        this.recordCommentTable.setBackground(this.innerAreaBackground);
        this.recordCommentTable.setMenu(this.popupmenu);
        Listener paintListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 41: {
                        TableItem item = (TableItem)event.item;
                        String text = item.getText(event.index);
                        Point size = event.gc.textExtent(text);
                        event.width = size.x;
                        event.height = size.y;
                        break;
                    }
                    case 42: {
                        TableItem item = (TableItem)event.item;
                        String text = item.getText(event.index);
                        Point size = event.gc.textExtent(text);
                        int offset2 = event.index == 0 ? Math.max(0, (event.height - size.y) / 2) : 0;
                        event.gc.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
                        event.gc.drawText(text, event.x, event.y + offset2, true);
                        break;
                    }
                    case 40: {
                        event.detail &= 0xFFFFFFEF;
                        break;
                    }
                    case 11: {
                        FileCommentWindow.this.recordCommentTable.redraw();
                    }
                }
            }
        };
        this.recordCommentTable.addListener(41, paintListener);
        this.recordCommentTable.addListener(42, paintListener);
        this.recordCommentTable.addListener(40, paintListener);
        this.recordCommentTable.addListener(11, paintListener);
        this.cursor = new TableCursor(this.recordCommentTable, 0);
        this.editor = new ControlEditor((Composite)this.cursor);
        this.editor.grabHorizontal = true;
        this.editor.grabVertical = true;
        this.cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileCommentWindow.this.recordCommentTable.setSelection(new TableItem[]{FileCommentWindow.this.cursor.getRow()});
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (FileCommentWindow.this.cursor.getColumn() == 1) {
                    final Text text = new Text((Composite)FileCommentWindow.this.cursor, 2);
                    text.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
                    final TableItem row = FileCommentWindow.this.cursor.getRow();
                    text.setText(row.getText(1));
                    text.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent evt) {
                            if (evt.character == '\r') {
                                FileCommentWindow.this.cursor.getRow().setText(1, text.getText());
                                if (FileCommentWindow.this.application.getActiveChannel() != null && FileCommentWindow.this.application.getActiveChannel().get(row.getText(0)) != null) {
                                    ((RecordSet)FileCommentWindow.this.application.getActiveChannel().get(row.getText(0))).setRecordSetDescription(text.getText());
                                }
                                text.dispose();
                            }
                            if (evt.character == '\u001b') {
                                text.dispose();
                            }
                        }
                    });
                    text.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusLost(FocusEvent evt) {
                            try {
                                FileCommentWindow.this.cursor.getRow().setText(1, text.getText());
                                if (FileCommentWindow.this.application.getActiveChannel() != null && FileCommentWindow.this.application.getActiveChannel().get(row.getText(0)) != null) {
                                    ((RecordSet)FileCommentWindow.this.application.getActiveChannel().get(row.getText(0))).setRecordSetDescription(text.getText());
                                }
                            }
                            catch (Exception e) {
                                log.log(Level.WARNING, e.getMessage());
                            }
                            text.dispose();
                        }
                    });
                    FileCommentWindow.this.editor.setEditor((Control)text);
                    text.setFocus();
                }
            }
        });
        this.cursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (FileCommentWindow.this.cursor.getColumn() == 1) {
                    final Text text = new Text((Composite)FileCommentWindow.this.cursor, 2);
                    text.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
                    final TableItem row = FileCommentWindow.this.cursor.getRow();
                    text.setText(row.getText(1));
                    text.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent evt) {
                            if (evt.character == '\r') {
                                FileCommentWindow.this.cursor.getRow().setText(1, text.getText());
                                if (FileCommentWindow.this.application.getActiveChannel() != null && FileCommentWindow.this.application.getActiveChannel().get(row.getText(0)) != null) {
                                    ((RecordSet)FileCommentWindow.this.application.getActiveChannel().get(row.getText(0))).setRecordSetDescription(text.getText());
                                }
                                text.dispose();
                            }
                            if (evt.character == '\u001b') {
                                text.dispose();
                            }
                        }
                    });
                    text.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusLost(FocusEvent evt) {
                            try {
                                FileCommentWindow.this.cursor.getRow().setText(1, text.getText());
                            }
                            catch (Exception e2) {
                                log.log(Level.WARNING, e2.getMessage());
                            }
                            text.dispose();
                        }
                    });
                    FileCommentWindow.this.editor.setEditor((Control)text);
                    text.setFocus();
                }
            }
        });
        this.recordCommentTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 262144 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                if (e.keyCode == 131072 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 262144 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 131072 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                TableItem[] selection = FileCommentWindow.this.recordCommentTable.getSelection();
                TableItem row = selection.length == 0 ? FileCommentWindow.this.recordCommentTable.getItem(FileCommentWindow.this.recordCommentTable.getTopIndex()) : selection[0];
                FileCommentWindow.this.recordCommentTable.showItem(row);
                FileCommentWindow.this.cursor.setSelection(row, FileCommentWindow.this.cursor.getColumn());
                FileCommentWindow.this.cursor.setVisible(true);
                FileCommentWindow.this.cursor.setFocus();
            }
        });
        this.recordCommentTable.addHelpListener(new HelpListener(this){

            public void helpRequested(HelpEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "recordCommentTable.helpRequested " + String.valueOf(evt));
                }
                DataExplorer.getInstance().openHelpDialog("", "HelpInfo_92.html");
            }
        });
    }

    public synchronized void update() {
        this.fileCommentText.redraw();
        this.updateRecordSetTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void updateRecordSetTable() {
        Point mainSize = this.getParent().getSize();
        Rectangle bounds = new Rectangle(mainSize.x * 5 / 100, mainSize.y * 10 / 100, mainSize.x * 90 / 100, mainSize.y * 40 / 100);
        this.infoLabel.setBounds(50, 10, bounds.width, bounds.y - 10);
        this.fileCommentText.setBounds(bounds);
        if (this.channels.getActiveChannel() != null) {
            this.fileCommentText.setText(this.channels.getActiveChannel().getFileDescription());
        }
        bounds = new Rectangle(mainSize.x * 5 / 100, mainSize.y * 50 / 100, mainSize.x * 90 / 100, mainSize.y * 40 / 100);
        this.recordCommentTable.removeAll();
        this.recordCommentTable.setBounds(bounds);
        this.recordCommentTableColumn2.setWidth(bounds.width - 255);
        Channel channel = Channels.getInstance().getActiveChannel();
        if (channel != null) {
            Channel channel2 = channel;
            synchronized (channel2) {
                HashMap<String, RecordSet> recordSets = channel.getRecordSets();
                if (recordSets.size() > 0) {
                    this.isTableUptaded = false;
                    for (String recordSetKey : channel.getRecordSetNames()) {
                        if (recordSetKey == null) continue;
                        TableItem item = new TableItem(this.recordCommentTable, 16384);
                        RecordSet tmpRecordSet = recordSets.get(recordSetKey);
                        if (tmpRecordSet == null) continue;
                        item.setText(new String[]{recordSetKey, tmpRecordSet.getRecordSetDescription()});
                    }
                } else if (!this.isTableUptaded) {
                    this.create();
                    this.isTableUptaded = true;
                }
            }
        }
        this.recordCommentTable.redraw();
        this.isRecordCommentChanged = false;
    }

    public void updateTopIndex() {
        int newTopIndex;
        int height = this.recordCommentTable.getClientArea().height;
        int visibleItemCount = height / this.recordCommentTable.getItemHeight() - 1;
        int topIndex = this.recordCommentTable.getTopIndex();
        int itemCount = this.recordCommentTable.getItemCount();
        if (itemCount > visibleItemCount && topIndex != (newTopIndex = itemCount - visibleItemCount)) {
            this.recordCommentTable.setTopIndex(newTopIndex);
        }
    }

    public boolean isFileCommentChanged() {
        return this.isFileCommentChanged;
    }

    public void setFileComment() {
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && this.isFileCommentChanged) {
            String updateFileDescription = this.fileCommentText.getText();
            activeChannel.setFileDescription(updateFileDescription);
            if (activeChannel.getActiveRecordSet() != null && activeChannel.getActiveRecordSet().getDevice().useChannelWithSyncedDescription()) {
                activeChannel.syncFileDescription(activeChannel, updateFileDescription);
            }
            this.isFileCommentChanged = false;
        }
    }

    public Image getContentAsImage() {
        Rectangle bounds = this.commentMainComposite.getClientArea();
        Image tabContentImage = new Image((Device)GDE.display, bounds.width, bounds.height);
        GC imageGC = new GC((Drawable)tabContentImage);
        this.commentMainComposite.print(imageGC);
        if (GDE.IS_MAC) {
            this.commentMainComposite.print(imageGC);
        }
        imageGC.dispose();
        return tabContentImage;
    }

    public void setInnerAreaBackground(Color newInnerAreaBackground) {
        this.innerAreaBackground = newInnerAreaBackground;
        this.fileCommentText.setBackground(newInnerAreaBackground);
        this.recordCommentTable.setBackground(newInnerAreaBackground);
        this.fileCommentText.redraw();
        this.recordCommentTable.redraw();
    }

    public void setSurroundingAreaBackground(Color newSurroundingBackground) {
        this.commentMainComposite.setBackground(newSurroundingBackground);
        this.infoLabel.setBackground(newSurroundingBackground);
        this.surroundingBackground = newSurroundingBackground;
        this.commentMainComposite.redraw();
    }
}

