/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.utils;

import gde.log.Logger;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import java.util.function.DoubleConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Quantile {
    private static final String $CLASS_NAME = Quantile.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    public static final double boxplotSigmaFactor = 0.674489694;
    public static final double boxplotOutlierFactor = 1.5;
    private final List<Integer> iPopulation;
    private final List<Double> dPopulation;
    private final EnumSet<Fixings> fixings;
    private final List<Integer> iOutliers;
    private final List<Double> dOutliers;
    private final List<Point2D.Double> d2Outliers;
    private double firstFigure;
    private double lastFigure;
    private Double maxFigure;
    private Double minFigure;
    private Double sumFigure;
    private Double avgFigure;
    private Double sigmaFigure;
    public static final Comparator<Point2D.Double> Y_ORDER = new YOrder();

    public Quantile(Vector<Integer> population, EnumSet<Fixings> fixings, double sigmaFactor, double outlierFactor) {
        if (population.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.dPopulation = null;
        this.fixings = fixings;
        this.iOutliers = new ArrayList<Integer>();
        this.dOutliers = null;
        this.d2Outliers = null;
        ArrayList<Integer> excludes = new ArrayList<Integer>();
        if (fixings.contains((Object)Fixings.REMOVE_NULLS)) {
            excludes.add(null);
        }
        if (fixings.contains((Object)Fixings.REMOVE_ZEROS)) {
            excludes.add(0);
        }
        if (fixings.contains((Object)Fixings.REMOVE_MAXMIN)) {
            excludes.add(Integer.MIN_VALUE);
            excludes.add(Integer.MAX_VALUE);
        }
        if (excludes.isEmpty()) {
            this.iPopulation = new ArrayList<Integer>(population);
        } else {
            this.iPopulation = new ArrayList<Integer>();
            for (Integer value : population) {
                if (excludes.contains(value)) continue;
                this.iPopulation.add(value);
            }
        }
        this.firstFigure = this.iPopulation.size() > 0 && this.iPopulation.get(0) != null ? (double)this.iPopulation.get(0).intValue() : -1.7976931348623157E308;
        this.lastFigure = this.iPopulation.size() > 0 && this.iPopulation.get(this.iPopulation.size() - 1) != null ? (double)this.iPopulation.get(this.iPopulation.size() - 1).intValue() : -1.7976931348623157E308;
        Collections.sort(this.iPopulation);
        if (this.iPopulation.size() > 0) {
            double outlierProbability = (1.0 - ErrorFunction.getProbability(sigmaFactor)) / 2.0;
            double extremumRange = this.getQuantile(1.0 - outlierProbability) - this.getQuantile(outlierProbability);
            while ((double)this.iPopulation.get(0).intValue() < this.getQuantile(outlierProbability) - extremumRange * outlierFactor) {
                this.iOutliers.add(this.iPopulation.get(0));
                this.iPopulation.remove(0);
            }
            while ((double)this.iPopulation.get(this.iPopulation.size() - 1).intValue() > this.getQuantile(1.0 - outlierProbability) + extremumRange * outlierFactor) {
                this.iOutliers.add(this.iPopulation.get(this.dPopulation.size() - 1));
                this.iPopulation.remove(this.iPopulation.size() - 1);
            }
        }
        log.finest(() -> population.size() + Arrays.toString(population.toArray()));
        log.finest(() -> this.iPopulation.size() + Arrays.toString(this.iPopulation.toArray()));
    }

    public Quantile(List<Point2D.Double> population, double sigmaFactor, double outlierFactor) {
        if (population.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.iPopulation = null;
        this.fixings = EnumSet.of(Fixings.IS_SAMPLE);
        this.iOutliers = null;
        this.dOutliers = null;
        this.d2Outliers = new ArrayList<Point2D.Double>();
        this.firstFigure = population.get(0).getY();
        this.lastFigure = population.get(population.size() - 1).getY();
        ArrayList<Point2D.Double> d2Population = new ArrayList<Point2D.Double>(population);
        Collections.sort(d2Population, Y_ORDER);
        this.dPopulation = d2Population.stream().map(p -> p.y).collect(Collectors.toList());
        double outlierProbability = (1.0 - ErrorFunction.getProbability(sigmaFactor)) / 2.0;
        double extremumRange = this.getQuantile(1.0 - outlierProbability) - this.getQuantile(outlierProbability);
        while (this.dPopulation.get(0) < this.getQuantile(outlierProbability) - extremumRange * outlierFactor) {
            this.dPopulation.remove(0);
            this.d2Outliers.add(d2Population.get(0));
            d2Population.remove(0);
        }
        while (this.dPopulation.get(this.dPopulation.size() - 1) > this.getQuantile(1.0 - outlierProbability) + extremumRange * outlierFactor) {
            this.dPopulation.remove(this.dPopulation.size() - 1);
            this.d2Outliers.add(d2Population.get(d2Population.size() - 1));
            d2Population.remove(d2Population.size() - 1);
        }
        log.finest(() -> population.size() + Arrays.toString(population.toArray()));
        log.finest(() -> this.dPopulation.size() + Arrays.toString(this.dPopulation.toArray()));
        log.finest(() -> String.format("lWhisker=%f q1=%f q2=%f q3=%f uWhisker=%f", this.getQuantileLowerWhisker(), this.getQuartile1(), this.getQuartile2(), this.getQuartile3(), this.getQuantileUpperWhisker()));
    }

    public Quantile(Collection<Double> population, EnumSet<Fixings> fixings, double sigmaFactor, double outlierFactor) {
        if (population.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.iPopulation = null;
        this.fixings = fixings;
        this.iOutliers = null;
        this.dOutliers = new ArrayList<Double>();
        this.d2Outliers = null;
        ArrayList<Double> excludes = new ArrayList<Double>();
        if (fixings.contains((Object)Fixings.REMOVE_NULLS)) {
            excludes.add(null);
        }
        if (fixings.contains((Object)Fixings.REMOVE_ZEROS)) {
            excludes.add(0.0);
        }
        if (fixings.contains((Object)Fixings.REMOVE_MAXMIN)) {
            excludes.add(-1.7976931348623157E308);
            excludes.add((Double)Double.MAX_VALUE);
        }
        if (excludes.isEmpty()) {
            this.dPopulation = new ArrayList<Double>(population);
        } else {
            this.dPopulation = new ArrayList<Double>();
            for (Double value : population) {
                if (excludes.contains(value)) continue;
                this.dPopulation.add(value);
            }
        }
        this.firstFigure = this.dPopulation.get(0) != null ? this.dPopulation.get(0) : -1.7976931348623157E308;
        this.lastFigure = this.dPopulation.get(this.dPopulation.size() - 1) != null ? this.dPopulation.get(this.dPopulation.size() - 1) : -1.7976931348623157E308;
        Collections.sort(this.dPopulation);
        double outlierProbability = (1.0 - ErrorFunction.getProbability(sigmaFactor)) / 2.0;
        double extremumRange = this.getQuantile(1.0 - outlierProbability) - this.getQuantile(outlierProbability);
        while (this.dPopulation.get(0) < this.getQuantile(outlierProbability) - extremumRange * outlierFactor) {
            this.dOutliers.add(this.dPopulation.get(0));
            this.dPopulation.remove(0);
        }
        while (this.dPopulation.get(this.dPopulation.size() - 1) > this.getQuantile(1.0 - outlierProbability) + extremumRange * outlierFactor) {
            this.dOutliers.add(this.dPopulation.get(this.dPopulation.size() - 1));
            this.dPopulation.remove(this.dPopulation.size() - 1);
        }
        log.finest(() -> population.size() + Arrays.toString(population.toArray()));
        log.finest(() -> this.dPopulation.size() + Arrays.toString(this.dPopulation.toArray()));
        log.finest(() -> String.format("lWhisker=%f q1=%f q2=%f q3=%f uWhisker=%f", this.getQuantileLowerWhisker(), this.getQuartile1(), this.getQuartile2(), this.getQuartile3(), this.getQuantileUpperWhisker()));
    }

    public Quantile(Vector<Integer> iPopulation, EnumSet<Fixings> fixings) {
        this.dPopulation = null;
        if (iPopulation.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        this.fixings = fixings;
        this.iOutliers = null;
        this.dOutliers = new ArrayList<Double>();
        this.d2Outliers = null;
        Stream<Object> stream = iPopulation.parallelStream();
        if (fixings.contains((Object)Fixings.REMOVE_NULLS)) {
            stream = stream.filter(Objects::nonNull);
        }
        if (fixings.contains((Object)Fixings.REMOVE_ZEROS)) {
            stream = stream.filter(x -> x != 0);
        }
        if (fixings.contains((Object)Fixings.REMOVE_MAXMIN)) {
            Integer[] excludes = new Integer[]{Integer.MIN_VALUE, Integer.MAX_VALUE};
            stream = stream.filter(x -> Arrays.asList(excludes).contains(x));
        }
        this.iPopulation = stream.sorted().collect(Collectors.toList());
        log.fine(() -> "i " + iPopulation.size() + " " + this.iPopulation.size());
        log.finest(() -> Arrays.toString(iPopulation.toArray()));
        log.finest(() -> Arrays.toString(this.iPopulation.toArray()));
    }

    public Quantile(Collection<Double> dPopulation, EnumSet<Fixings> fixings) {
        this.iPopulation = null;
        if (dPopulation.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        this.fixings = fixings;
        this.iOutliers = null;
        this.dOutliers = new ArrayList<Double>();
        this.d2Outliers = null;
        Stream<Double> stream = dPopulation.parallelStream();
        if (fixings.contains((Object)Fixings.REMOVE_NULLS)) {
            stream = stream.filter(Objects::nonNull);
        }
        if (fixings.contains((Object)Fixings.REMOVE_ZEROS)) {
            stream = stream.filter(x -> x != 0.0);
        }
        if (fixings.contains((Object)Fixings.REMOVE_MAXMIN)) {
            Double[] excludes = new Double[]{-1.7976931348623157E308, Double.MAX_VALUE};
            stream = stream.filter(x -> Arrays.asList(excludes).contains(x));
        }
        this.dPopulation = stream.sorted().collect(Collectors.toList());
        log.fine(() -> "d " + dPopulation.size() + " " + this.dPopulation.size());
        log.finest(() -> Arrays.toString(dPopulation.toArray()));
        log.finest(() -> Arrays.toString(this.dPopulation.toArray()));
    }

    public double getMaxFigure() {
        if (this.maxFigure == null) {
            this.maxFigure = this.dPopulation == null ? Double.valueOf(this.iPopulation.parallelStream().mapToInt(x -> x).max().getAsInt()) : Double.valueOf(this.dPopulation.parallelStream().mapToDouble(x -> x).max().getAsDouble());
        }
        return this.maxFigure;
    }

    public double getMinFigure() {
        if (this.minFigure == null) {
            this.minFigure = this.dPopulation == null ? Double.valueOf(this.iPopulation.parallelStream().mapToInt(x -> x).min().getAsInt()) : Double.valueOf(this.dPopulation.parallelStream().mapToDouble(x -> x).min().getAsDouble());
        }
        return this.minFigure;
    }

    public double getSumFigure() {
        if (this.sumFigure == null) {
            this.sumFigure = this.dPopulation == null ? Double.valueOf(this.iPopulation.parallelStream().mapToInt(x -> x).sum()) : Double.valueOf(this.dPopulation.parallelStream().mapToDouble(x -> x).sum());
        }
        return this.sumFigure;
    }

    public double getAvgFigure() {
        if (this.avgFigure == null) {
            this.avgFigure = this.dPopulation == null ? Double.valueOf(this.iPopulation.parallelStream().mapToInt(x -> x).average().getAsDouble()) : Double.valueOf(this.dPopulation.parallelStream().mapToDouble(x -> x).average().getAsDouble());
        }
        return this.avgFigure;
    }

    public double getAvgOBS() {
        if (this.dPopulation == null) {
            double avg = 0.0;
            for (int i = 0; i < this.iPopulation.size(); ++i) {
                double value = this.iPopulation.get(i).doubleValue();
                avg += (value - avg) / (double)(i + 1);
            }
            return avg;
        }
        double avg = 0.0;
        for (int i = 0; i < this.dPopulation.size(); ++i) {
            double value = this.dPopulation.get(i);
            avg += (value - avg) / (double)(i + 1);
        }
        return avg;
    }

    public double getAvgSlow() {
        if (this.dPopulation == null) {
            return this.iPopulation.parallelStream().collect(() -> new StatsHelper(this), StatsHelper::accept, StatsHelper::combine).getAvg();
        }
        return this.dPopulation.parallelStream().collect(() -> new StatsHelper(this), StatsHelper::accept, StatsHelper::combine).getAvg();
    }

    public double getSigmaOBS() {
        if (this.dPopulation == null) {
            double avg = this.getAvgOBS();
            double varTimesN = 0.0;
            for (int i = 0; i < this.iPopulation.size(); ++i) {
                double value = this.iPopulation.get(i).doubleValue();
                varTimesN += (value - avg) * (value - avg);
            }
            return this.iPopulation.size() > 0 ? Math.sqrt(varTimesN / (double)(this.fixings.contains((Object)Fixings.IS_SAMPLE) ? this.iPopulation.size() - 1 : this.iPopulation.size())) : 0.0;
        }
        double avg = this.getAvgOBS();
        double varTimesN = 0.0;
        for (int i = 0; i < this.dPopulation.size(); ++i) {
            double value = this.dPopulation.get(i);
            varTimesN += (value - avg) * (value - avg);
        }
        return this.dPopulation.size() > 0 ? Math.sqrt(varTimesN / (double)(this.fixings.contains((Object)Fixings.IS_SAMPLE) ? this.dPopulation.size() - 1 : this.dPopulation.size())) : 0.0;
    }

    public double getSigmaRunningOBS() {
        if (this.dPopulation == null) {
            double avg = 0.0;
            double varTimesN = 0.0;
            int count = 0;
            for (int i = 0; i < this.iPopulation.size(); ++i) {
                double value = this.iPopulation.get(i).doubleValue();
                varTimesN += (value - avg) * (value - avg) * (double)count / (double)(++count);
                avg += (value - avg) / (double)count;
            }
            return this.iPopulation.size() > 0 ? Math.sqrt(varTimesN / (double)(this.fixings.contains((Object)Fixings.IS_SAMPLE) ? this.iPopulation.size() - 1 : this.iPopulation.size())) : 0.0;
        }
        double avg = 0.0;
        double varTimesN = 0.0;
        double count = 0.0;
        for (int i = 0; i < this.dPopulation.size(); ++i) {
            double value = this.dPopulation.get(i);
            varTimesN += (value - avg) * (value - avg) * count / (count += 1.0);
            avg += (value - avg) / count;
        }
        return this.dPopulation.size() > 0 ? Math.sqrt(varTimesN / (double)(this.fixings.contains((Object)Fixings.IS_SAMPLE) ? this.dPopulation.size() - 1 : this.dPopulation.size())) : 0.0;
    }

    public double getSigmaFigure() {
        if (this.sigmaFigure == null) {
            this.sigmaFigure = this.dPopulation == null ? Double.valueOf(this.iPopulation.parallelStream().collect(() -> new StatsHelper(this), StatsHelper::accept, StatsHelper::combine).getSigma(this.fixings.contains((Object)Fixings.IS_SAMPLE))) : Double.valueOf(this.dPopulation.parallelStream().collect(() -> new StatsHelper(this), StatsHelper::accept, StatsHelper::combine).getSigma(this.fixings.contains((Object)Fixings.IS_SAMPLE)));
        }
        return this.sigmaFigure;
    }

    public double getQuantile(double probabilityCutPoint) {
        if (this.dPopulation == null) {
            int pSize = this.iPopulation.size();
            if (this.fixings.contains((Object)Fixings.IS_SAMPLE)) {
                if (probabilityCutPoint >= 1.0 / (double)(pSize + 1) && probabilityCutPoint < (double)pSize / (double)(pSize + 1)) {
                    double position = (double)(pSize + 1) * probabilityCutPoint;
                    return (double)this.iPopulation.get((int)position - 1).intValue() + (position - (double)((int)position)) * (double)(this.iPopulation.get((int)position) - this.iPopulation.get((int)position - 1));
                }
                if (probabilityCutPoint < 1.0 / (double)(pSize + 1)) {
                    return this.iPopulation.get(0).intValue();
                }
                return this.iPopulation.get(pSize - 1).intValue();
            }
            if (probabilityCutPoint > 0.0 && probabilityCutPoint < 1.0) {
                double position = (double)pSize * probabilityCutPoint;
                if (position % 2.0 == 0.0) {
                    return (double)(this.iPopulation.get((int)position) + this.iPopulation.get((int)(position + 1.0))) / 2.0;
                }
                return this.iPopulation.get((int)position).intValue();
            }
            if (probabilityCutPoint == 0.0) {
                return this.iPopulation.get(0).intValue();
            }
            return this.iPopulation.get(pSize - 1).intValue();
        }
        int pSize = this.dPopulation.size();
        if (this.fixings.contains((Object)Fixings.IS_SAMPLE)) {
            if (probabilityCutPoint >= 1.0 / (double)(pSize + 1) && probabilityCutPoint < (double)pSize / (double)(pSize + 1)) {
                double position = (double)(pSize + 1) * probabilityCutPoint;
                return this.dPopulation.get((int)position - 1) + (position - (double)((int)position)) * (this.dPopulation.get((int)position) - this.dPopulation.get((int)position - 1));
            }
            if (probabilityCutPoint < 1.0 / (double)(pSize + 1)) {
                return this.dPopulation.get(0);
            }
            return this.dPopulation.get(pSize - 1);
        }
        if (probabilityCutPoint > 0.0 && probabilityCutPoint < 1.0) {
            double position = (double)pSize * probabilityCutPoint;
            if (position % 2.0 == 0.0) {
                return (this.dPopulation.get((int)position) + this.dPopulation.get((int)(position + 1.0))) / 2.0;
            }
            return this.dPopulation.get((int)position);
        }
        if (probabilityCutPoint == 0.0) {
            return this.dPopulation.get(0);
        }
        return this.dPopulation.get(pSize - 1);
    }

    public double getQuartile0() {
        return this.dPopulation == null ? (double)this.iPopulation.get(0).intValue() : this.dPopulation.get(0);
    }

    public double getQuartile1() {
        return this.getQuantile(0.25);
    }

    public double getQuartile2() {
        return this.getQuantile(0.5);
    }

    public double getQuartile3() {
        return this.getQuantile(0.75);
    }

    public double getQuartile4() {
        return this.dPopulation == null ? (double)this.iPopulation.get(this.iPopulation.size() - 1).intValue() : this.dPopulation.get(this.dPopulation.size() - 1);
    }

    public double getInterQuartileRange() {
        return this.getQuantile(0.75) - this.getQuantile(0.25);
    }

    public double getQuantileLowerWhisker() {
        double probabilityCutPoint = 0.25;
        double whiskerStartValue = this.getQuantile(0.25);
        double whiskerLimitValue = whiskerStartValue - this.getInterQuartileRange() * 1.5;
        double value = whiskerStartValue;
        if (this.dPopulation == null) {
            int i = 0;
            while ((double)i < (double)this.iPopulation.size() * 0.25) {
                if ((double)this.iPopulation.get(i).intValue() >= whiskerLimitValue) {
                    value = this.getQuantile((0.5 + (double)i) / (double)this.iPopulation.size());
                    value = value < whiskerLimitValue ? whiskerLimitValue : value;
                    break;
                }
                ++i;
            }
        } else {
            int i = 0;
            while ((double)i < (double)this.dPopulation.size() * 0.25) {
                if (this.dPopulation.get(i) >= whiskerLimitValue) {
                    value = this.getQuantile((0.5 + (double)i) / (double)this.dPopulation.size());
                    value = value < whiskerLimitValue ? whiskerLimitValue : value;
                    break;
                }
                ++i;
            }
        }
        return value;
    }

    public double getQuantileUpperWhisker() {
        double probabilityCutPoint = 0.75;
        double whiskerStartValue = this.getQuantile(0.75);
        double whiskerLimitValue = whiskerStartValue + this.getInterQuartileRange() * 1.5;
        double value = whiskerStartValue;
        if (this.dPopulation == null) {
            int i = this.iPopulation.size() - 1;
            while ((double)i > (double)this.iPopulation.size() * 0.75) {
                if ((double)this.iPopulation.get(i).intValue() <= whiskerLimitValue) {
                    value = this.getQuantile((0.5 + (double)i) / (double)this.iPopulation.size());
                    value = value > whiskerLimitValue ? whiskerLimitValue : value;
                    break;
                }
                --i;
            }
        } else {
            int i = this.dPopulation.size() - 1;
            while ((double)i > (double)this.dPopulation.size() * 0.75) {
                if (this.dPopulation.get(i) <= whiskerLimitValue) {
                    value = this.getQuantile((0.5 + (double)i) / (double)this.dPopulation.size());
                    value = value > whiskerLimitValue ? whiskerLimitValue : value;
                    break;
                }
                --i;
            }
        }
        return value;
    }

    public double getFirstFigure() {
        return this.firstFigure;
    }

    public double getLastFigure() {
        return this.lastFigure;
    }

    public int getSize() {
        return this.dPopulation == null ? this.iPopulation.size() : this.dPopulation.size();
    }

    public static enum Fixings {
        REMOVE_NULLS,
        REMOVE_ZEROS,
        REMOVE_MAXMIN,
        IS_SAMPLE;

    }

    private static class ErrorFunction {
        private ErrorFunction() {
        }

        public static double erf(double z) {
            double t = 1.0 / (1.0 + 0.5 * Math.abs(z));
            double ans = 1.0 - t * Math.exp(-z * z - 1.26551223 + t * (1.00002368 + t * (0.37409196 + t * (0.09678418 + t * (-0.18628806 + t * (0.27886807 + t * (-1.13520398 + t * (1.48851587 + t * (-0.82215223 + t * 0.17087277)))))))));
            if (z >= 0.0) {
                return ans;
            }
            return -ans;
        }

        public static double getProbability(double sigmaFactor) {
            return ErrorFunction.erf(sigmaFactor / Math.sqrt(2.0));
        }
    }

    class StatsHelper
    implements DoubleConsumer {
        private double avg = 0.0;
        private double varTimesN = 0.0;
        private int count = 0;

        StatsHelper(Quantile this$0) {
        }

        public double getAvg() {
            return this.count > 0 ? this.avg : 0.0;
        }

        public double getSigma(boolean isSample) {
            return this.count > 0 ? Math.sqrt(this.varTimesN / (double)(isSample ? this.count - 1 : this.count)) : 0.0;
        }

        public double getCount() {
            return this.count;
        }

        @Override
        public void accept(double value) {
            this.varTimesN += (value - this.avg) * (value - this.avg) * (double)this.count / (double)(++this.count);
            this.avg += (value - this.avg) / (double)this.count;
        }

        public void combine(StatsHelper other) {
            double tmpAvg = this.avg * (double)this.count / (double)(this.count + other.count) + other.avg * (double)other.count / (double)(this.count + other.count);
            this.varTimesN += other.varTimesN + (double)this.count * (this.avg - tmpAvg) * (this.avg - tmpAvg) + (double)other.count * (other.avg - tmpAvg) * (other.avg - tmpAvg);
            this.avg = tmpAvg;
            this.count += other.count;
        }
    }

    private static class YOrder
    implements Comparator<Point2D.Double> {
        private YOrder() {
        }

        @Override
        public int compare(Point2D.Double p, Point2D.Double q) {
            if (p.y < q.y) {
                return -1;
            }
            if (p.y > q.y) {
                return 1;
            }
            if (p.x < q.x) {
                return -1;
            }
            if (p.x > q.x) {
                return 1;
            }
            return 0;
        }
    }
}

