/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.ui;

import gde.GDE;
import gde.histo.ui.AbstractChartComposite;
import gde.histo.ui.AbstractChartWindow;
import gde.histo.ui.GraphicsComposite;
import gde.histo.ui.SelectorComposite;
import gde.histo.ui.SummaryComposite;
import gde.log.Logger;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import java.util.Optional;
import java.util.logging.Level;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class HistoGraphicsWindow
extends AbstractChartWindow {
    private static final String $CLASS_NAME = HistoGraphicsWindow.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    protected AbstractChartComposite graphicsComposite;

    private HistoGraphicsWindow(CTabFolder currentDisplayTab, int style, int index) {
        super(currentDisplayTab, style, index);
    }

    public static HistoGraphicsWindow create(CTabFolder dataTab, int style, int position) {
        HistoGraphicsWindow window = new HistoGraphicsWindow(dataTab, style, position);
        window.graphicSashForm = new SashForm((Composite)window.tabFolder, 256);
        window.setControl((Control)window.graphicSashForm);
        window.curveSelectorComposite = new SelectorComposite(window.graphicSashForm, window);
        window.graphicsComposite = new GraphicsComposite(window.graphicSashForm, window);
        try {
            if (GDE.shell.getClientArea().width > 117) {
                window.graphicSashForm.setWeights(new int[]{117, GDE.shell.getClientArea().width - 117});
            }
        }
        catch (IllegalArgumentException e) {
            log.log(Level.WARNING, "graphicSashForm.setWeights(this.sashFormWeights) failed!", e);
        }
        window.setFont(SWTResourceManager.getFont((Control)DataExplorer.getInstance(), GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 3 : 1), 0));
        window.setText(Messages.getString("GDE_MSGT0883"));
        return window;
    }

    @Override
    protected GraphicsComposite getGraphicsComposite() {
        return (GraphicsComposite)this.graphicsComposite;
    }

    protected SelectorComposite getSelectorComposite() {
        return this.curveSelectorComposite;
    }

    protected Optional<SummaryComposite> getSummaryComposite() {
        return Optional.empty();
    }

    @Override
    public void scrollSummaryComposite() {
    }

    @Override
    public void redrawGraphics(final boolean redrawCurveSelector) {
        if (this.windowActor.getTrailRecordSet() == null) {
            return;
        }
        if (Thread.currentThread().threadId() == DataExplorer.getInstance().getThreadId()) {
            if (redrawCurveSelector) {
                this.curveSelectorComposite.doUpdateCurveSelectorTable();
            }
            this.graphicsComposite.doRedrawGraphics();
            this.graphicsComposite.updateCaptions();
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (redrawCurveSelector) {
                        HistoGraphicsWindow.this.curveSelectorComposite.doUpdateCurveSelectorTable();
                    }
                    HistoGraphicsWindow.this.graphicsComposite.doRedrawGraphics();
                    HistoGraphicsWindow.this.graphicsComposite.updateCaptions();
                }
            });
        }
    }

    @Override
    @Deprecated
    public void updateCaptions() {
        if (Thread.currentThread().threadId() == DataExplorer.getInstance().getThreadId()) {
            this.graphicsComposite.updateCaptions();
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    HistoGraphicsWindow.this.graphicsComposite.updateCaptions();
                }
            });
        }
    }

    @Override
    public void enableRecordSetComment(boolean enabled) {
        this.graphicsComposite.enableRecordSetComment(enabled);
    }

    @Override
    public void clearHeaderAndComment() {
        this.graphicsComposite.clearHeaderAndComment();
    }

    @Override
    public Image getContentAsImage() {
        Rectangle bounds = this.graphicSashForm.getClientArea();
        Image tabContentImage = new Image((Device)GDE.display, bounds.width, bounds.height);
        GC imageGC = new GC((Drawable)tabContentImage);
        this.graphicSashForm.print(imageGC);
        if (GDE.IS_MAC) {
            this.graphicSashForm.print(imageGC);
            Image graphics = this.graphicsComposite.getGraphicsPrintImage();
            if (graphics != null) {
                imageGC.drawImage(graphics, bounds.width - graphics.getBounds().width, 0);
                graphics.dispose();
            }
        }
        imageGC.dispose();
        return tabContentImage;
    }

    @Override
    public void enableGraphicsHeader(boolean enabled) {
        this.graphicsComposite.enableGraphicsHeader(enabled);
    }

    @Override
    public void enableGraphicsScale(boolean enabled) {
        this.graphicsComposite.enableGraphicsScale(enabled);
    }

    @Override
    public void setCurveAreaBackground(Color curveAreaBackground) {
        this.graphicsComposite.curveAreaBackground = curveAreaBackground;
        this.graphicsComposite.doRedrawGraphics();
    }

    @Override
    public void setCurveAreaBorderColor(Color borderColor) {
        this.graphicsComposite.curveAreaBorderColor = borderColor;
        this.graphicsComposite.graphicCanvas.redraw();
    }

    @Override
    public void setHeaderCommentColor(Color headerCommentColor) {
        this.graphicsComposite.headerCommentColor = headerCommentColor;
        this.graphicsComposite.graphicsHeader.setForeground(headerCommentColor);
        this.graphicsComposite.graphicsHeader.redraw();
        this.graphicsComposite.recordSetComment.setForeground(headerCommentColor);
        this.graphicsComposite.recordSetComment.redraw();
    }

    @Override
    public void setTimeLineColor(Color timeLineColor) {
        this.graphicsComposite.graphicCanvas.redraw();
    }

    @Override
    public void setSurroundingBackground(Color surroundingBackground) {
        this.graphicsComposite.surroundingBackground = surroundingBackground;
        this.graphicsComposite.setBackground(surroundingBackground);
        this.graphicsComposite.graphicsHeader.setBackground(surroundingBackground);
        this.graphicsComposite.recordSetComment.setBackground(surroundingBackground);
        this.graphicsComposite.doRedrawGraphics();
    }

    @Override
    public AbstractChartComposite[] getCharts() {
        return new AbstractChartComposite[]{this.graphicsComposite};
    }
}

