/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.io;

import gde.Analyzer;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.ChannelTypes;
import gde.device.IDevice;
import gde.device.ScoreLabelTypes;
import gde.exception.DataInconsitsentException;
import gde.exception.NotSupportedFileFormatException;
import gde.histo.cache.ExtendedVault;
import gde.histo.cache.VaultCollector;
import gde.histo.device.IHistoDevice;
import gde.io.OsdReaderWriter;
import gde.log.Level;
import gde.log.Logger;
import gde.utils.FileUtils;
import gde.utils.StringHelper;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class HistoOsdReaderWriter
extends OsdReaderWriter {
    private static final String $CLASS_NAME = HistoOsdReaderWriter.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);

    public static List<VaultCollector> readTrusses(InputStream fileStream, Path sourcePath, String objectDirectory, Analyzer analyzer) throws IOException, NotSupportedFileFormatException {
        HeaderParser osdHeader;
        ArrayList<VaultCollector> trusses = new ArrayList<VaultCollector>();
        try (DataInputStream data_in = new DataInputStream(FileUtils.wrapIfZipStream(fileStream));){
            HashMap<String, String> header = HistoOsdReaderWriter.readHeader(sourcePath.toString(), data_in);
            osdHeader = new HeaderParser(new HistoOsdReaderWriter(), header);
        }
        List<RecordSetParser> osdRecordSets = osdHeader.getOsdRecordSets();
        for (int i = 0; i < osdRecordSets.size(); ++i) {
            RecordSetParser osdRecordSet = osdRecordSets.get(i);
            Channel channel = osdRecordSet.getChannel(analyzer.getChannels());
            if (channel == null) continue;
            VaultCollector vaultCollector = new VaultCollector(analyzer, objectDirectory, sourcePath, osdHeader.getFileVersion(), osdRecordSets.size(), i, osdRecordSet.getBaseName(), osdHeader.getDeviceName(), osdRecordSet.getEnhancedStartTimestamp_ms(), channel.getNumber(), osdHeader.getLogObjectKey());
            trusses.add(vaultCollector);
        }
        log.fine(() -> " " + trusses.size() + " identified in " + String.valueOf(sourcePath));
        return trusses;
    }

    public static List<ExtendedVault> readVaults(InputStream fileStream, List<VaultCollector> trusses, Analyzer analyzer) throws IOException, NotSupportedFileFormatException, DataInconsitsentException {
        if (trusses.isEmpty()) {
            throw new IllegalArgumentException("at least one trusses entry is required");
        }
        ArrayList<ExtendedVault> histoVaults = new ArrayList<ExtendedVault>();
        List recordSetOrdinals = trusses.stream().mapToInt(a -> a.getVault().getLogRecordSetOrdinal()).boxed().collect(Collectors.toList());
        InputStream inputStream = FileUtils.wrapIfZipStream(fileStream);
        try (DataInputStream data_in = new DataInputStream(inputStream);){
            HashMap<String, String> header = HistoOsdReaderWriter.readHeader(trusses.get(0).getVault().getLoadFilePath(), data_in);
            HeaderParser osdHeader = new HeaderParser(new HistoOsdReaderWriter(), header);
            long startTimeNs = System.nanoTime();
            long unreadDataPointer = -1L;
            for (int i = 0; i < osdHeader.getRecordSetSize(); ++i) {
                RecordSetParser osdRecordSet = osdHeader.getOsdRecordSets().get(i);
                int trussesIndex = recordSetOrdinals.indexOf(i);
                if (trussesIndex < 0) {
                    if (unreadDataPointer >= 0L) continue;
                    unreadDataPointer = osdRecordSet.getDataPointer();
                    continue;
                }
                long elapsedStart_ns = System.nanoTime();
                unreadDataPointer = HistoOsdReaderWriter.skipUnreadData(data_in, unreadDataPointer, osdRecordSet.getDataPointer());
                VaultCollector vaultCollector = trusses.get(trussesIndex);
                RecordSet histoRecordSet = HistoOsdReaderWriter.constructRecordSet(data_in, osdRecordSet, vaultCollector.getVault(), analyzer);
                Integer[] scores = HistoOsdReaderWriter.determineScores(osdRecordSet, elapsedStart_ns, histoRecordSet.getFileDataBytesSize(), vaultCollector.getVault().getLogFileLength(), analyzer.getActiveDevice());
                vaultCollector.promoteTruss(histoRecordSet, scores);
                histoVaults.add(vaultCollector.getVault());
                log.finer(() -> String.format("|%s|  startTimeStamp=%s    recordDataSize=%,d  recordSetDataPointer=%,d", osdRecordSet.getChannel(analyzer.getChannels()).getName(), vaultCollector.getVault().getStartTimeStampFormatted(), osdRecordSet.getRecordDataSize(), osdRecordSet.getDataPointer()));
            }
            log.fine(() -> String.format("%d of%3d recordsets in%,7d ms  recordSetOrdinals=%s from %s", histoVaults.size(), osdHeader.getRecordSetSize(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs), recordSetOrdinals.toString(), ((VaultCollector)trusses.get(0)).getVault().getLoadFilePath()));
        }
        return histoVaults;
    }

    private static long skipUnreadData(DataInputStream data_in, long unreadDataPointer, long recordSetDataPointer) throws IOException, EOFException {
        if (unreadDataPointer > -1L) {
            long toSkip = recordSetDataPointer - unreadDataPointer;
            while (toSkip > 0L) {
                if ((toSkip -= data_in.skip(toSkip)) <= 0L) continue;
                log.log(Level.INFO, String.format("recordSetDataPointer=%,9d toSkip=%,9d", recordSetDataPointer, toSkip));
                if (data_in.available() != 0) continue;
                throw new EOFException("recordDataSize / recordSetDataPointer do not match the actual file size");
            }
        }
        return -1L;
    }

    private static RecordSet constructRecordSet(DataInputStream data_in, RecordSetParser osdRecordSet, ExtendedVault truss, Analyzer analyzer) throws IOException, DataInconsitsentException {
        RecordSet histoRecordSet = HistoOsdReaderWriter.buildRecordSet(truss.getLogRecordsetBaseName(), truss.getLogChannelNumber(), osdRecordSet.recordSetInfo, false, analyzer);
        long enhancedStartTimestamp_ms = osdRecordSet.getEnhancedStartTimestamp_ms();
        if (histoRecordSet.getStartTimeStamp() != enhancedStartTimestamp_ms) {
            log.info(() -> String.format("startTimeStamp rectified %,d  %,d", enhancedStartTimestamp_ms, histoRecordSet.getStartTimeStamp()));
        }
        histoRecordSet.setStartTimeStamp(enhancedStartTimestamp_ms);
        String[] noneCalculationMeasurementNames = histoRecordSet.getNoneCalculationRecordNames();
        int numberRecordAndTimeStamp = noneCalculationMeasurementNames.length + (histoRecordSet.isTimeStepConstant() ? 0 : 1);
        int recordSetDataBytes = 4 * numberRecordAndTimeStamp * osdRecordSet.getRecordDataSize();
        int recordDataSize = osdRecordSet.getRecordDataSize();
        histoRecordSet.setFileDataPointerAndSize(osdRecordSet.getDataPointer(), recordDataSize, recordSetDataBytes);
        log.fine(() -> String.format("%s recordDataSize=%,d  recordSetDataPointer=%,d  numberRecordAndTimeStamp=%,d", osdRecordSet.getChannel(analyzer.getChannels()).getName(), recordDataSize, osdRecordSet.getDataPointer(), numberRecordAndTimeStamp));
        byte[] buffer = new byte[recordSetDataBytes];
        data_in.readFully(buffer);
        if (histoRecordSet.getDevice() instanceof IHistoDevice) {
            Map<PointsType, int[]> extrema = HistoOsdReaderWriter.getExtremumValues(osdRecordSet, noneCalculationMeasurementNames);
            ((IHistoDevice)((Object)histoRecordSet.getDevice())).addDataBufferAsRawDataPoints(histoRecordSet, buffer, recordDataSize, extrema.get((Object)PointsType.MAX), extrema.get((Object)PointsType.MIN), analyzer);
        } else {
            histoRecordSet.getDevice().addDataBufferAsRawDataPoints(histoRecordSet, buffer, recordDataSize, false);
        }
        return histoRecordSet;
    }

    private static Integer[] determineScores(RecordSetParser osdRecordSet, long elapsedStart_ns, int recordSetDataBytes, long fileLength, IDevice device) {
        HeaderParser osdHeader = osdRecordSet.getOsdHeader();
        Double logDataVersion = osdRecordSet.getFirmware();
        Integer[] scores = new Integer[ScoreLabelTypes.VALUES.length];
        scores[ScoreLabelTypes.TOTAL_READINGS.ordinal()] = osdRecordSet.getRecordDataSize();
        if (device instanceof IHistoDevice) {
            double[] packagesLost = new double[6];
            try {
                packagesLost = osdRecordSet.getPackageLoss();
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
            BitSet activeSensors = ((IHistoDevice)((Object)device)).getActiveSensors(osdRecordSet.getSensorSignature());
            scores[ScoreLabelTypes.TOTAL_PACKAGES.ordinal()] = packagesLost[1] != 0.0 ? (int)(packagesLost[0] * 100.0 / packagesLost[1]) : 0;
            scores[ScoreLabelTypes.LOST_PACKAGES.ordinal()] = (int)packagesLost[0];
            scores[ScoreLabelTypes.LOST_PACKAGES_PER_MILLE.ordinal()] = (int)(packagesLost[1] * 10.0 * 1000.0);
            scores[ScoreLabelTypes.LOST_PACKAGES_AVG_MS.ordinal()] = (int)(packagesLost[4] * 1000000.0);
            scores[ScoreLabelTypes.LOST_PACKAGES_MAX_MS.ordinal()] = (int)(packagesLost[3] * 1000000.0);
            scores[ScoreLabelTypes.LOST_PACKAGES_MIN_MS.ordinal()] = (int)(packagesLost[2] * 1000000.0);
            scores[ScoreLabelTypes.LOST_PACKAGES_SIGMA_MS.ordinal()] = (int)(packagesLost[5] * 1000000.0);
            scores[ScoreLabelTypes.SENSORS.ordinal()] = (int)activeSensors.toLongArray()[0];
            scores[ScoreLabelTypes.SENSOR_VARIO.ordinal()] = activeSensors.get(1) ? 1000 : 0;
            scores[ScoreLabelTypes.SENSOR_GPS.ordinal()] = activeSensors.get(2) ? 1000 : 0;
            scores[ScoreLabelTypes.SENSOR_GAM.ordinal()] = activeSensors.get(3) ? 1000 : 0;
            scores[ScoreLabelTypes.SENSOR_EAM.ordinal()] = activeSensors.get(4) ? 1000 : 0;
            scores[ScoreLabelTypes.SENSOR_ESC.ordinal()] = activeSensors.get(5) ? 1000 : 0;
            scores[ScoreLabelTypes.SENSOR_COUNT.ordinal()] = (activeSensors.cardinality() - 1) * 1000;
        } else {
            scores[ScoreLabelTypes.TOTAL_PACKAGES.ordinal()] = 0;
            scores[ScoreLabelTypes.LOST_PACKAGES.ordinal()] = 0;
            scores[ScoreLabelTypes.LOST_PACKAGES_PER_MILLE.ordinal()] = 0;
            scores[ScoreLabelTypes.LOST_PACKAGES_AVG_MS.ordinal()] = 0;
            scores[ScoreLabelTypes.LOST_PACKAGES_MAX_MS.ordinal()] = 0;
            scores[ScoreLabelTypes.LOST_PACKAGES_MIN_MS.ordinal()] = 0;
            scores[ScoreLabelTypes.LOST_PACKAGES_SIGMA_MS.ordinal()] = 0;
            scores[ScoreLabelTypes.SENSORS.ordinal()] = 0;
            scores[ScoreLabelTypes.SENSOR_VARIO.ordinal()] = 0;
            scores[ScoreLabelTypes.SENSOR_GPS.ordinal()] = 0;
            scores[ScoreLabelTypes.SENSOR_GAM.ordinal()] = 0;
            scores[ScoreLabelTypes.SENSOR_EAM.ordinal()] = 0;
            scores[ScoreLabelTypes.SENSOR_ESC.ordinal()] = 0;
            scores[ScoreLabelTypes.SENSOR_COUNT.ordinal()] = 0;
        }
        scores[ScoreLabelTypes.LOG_DATA_VERSION.ordinal()] = logDataVersion != null ? (int)(logDataVersion * 1000.0) : 0;
        scores[ScoreLabelTypes.LOG_DATA_EXPLORER_VERSION.ordinal()] = (int)(osdHeader.getDataExplorerVersion() * 1000.0);
        scores[ScoreLabelTypes.LOG_FILE_VERSION.ordinal()] = osdHeader.getFileVersion() * 1000;
        scores[ScoreLabelTypes.LOG_RECORD_SET_BYTES.ordinal()] = recordSetDataBytes;
        scores[ScoreLabelTypes.LOG_FILE_BYTES.ordinal()] = (int)fileLength;
        scores[ScoreLabelTypes.LOG_FILE_RECORD_SETS.ordinal()] = osdHeader.getRecordSetSize() * 1000;
        scores[ScoreLabelTypes.ELAPSED_HISTO_RECORD_SET_MS.ordinal()] = (int)TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - elapsedStart_ns);
        return scores;
    }

    private static Map<PointsType, int[]> getExtremumValues(RecordSetParser osdRecordSet, String[] noneCalculationMeasurementNames) {
        int[] maxPoints = new int[noneCalculationMeasurementNames.length];
        int[] minPoints = new int[noneCalculationMeasurementNames.length];
        List<RecordParser> osdRecords = osdRecordSet.getOsdRecords();
        String[] recordKeys = osdRecordSet.getRecordKeys();
        List<String> noneCalculationMeasurementNameList = Arrays.asList(noneCalculationMeasurementNames);
        for (int j = 0; j < recordKeys.length; ++j) {
            RecordParser osdRecord = osdRecords.get(j);
            int index = noneCalculationMeasurementNameList.indexOf(recordKeys[j]);
            if (index <= -1) continue;
            maxPoints[index] = osdRecord.getMaxValue();
            minPoints[index] = osdRecord.getMinValue();
        }
        HashMap<PointsType, int[]> extrema = new HashMap<PointsType, int[]>();
        extrema.put(PointsType.MAX, maxPoints);
        extrema.put(PointsType.MIN, minPoints);
        return extrema;
    }

    private class HeaderParser {
        private final HashMap<String, String> header;
        private List<RecordSetParser> osdRecordSets;

        HeaderParser(HistoOsdReaderWriter histoOsdReaderWriter, HashMap<String, String> header) throws FileNotFoundException, IOException, NotSupportedFileFormatException {
            this.header = header;
        }

        int getRecordSetSize() {
            return Integer.parseInt(this.header.get("NumberRecordSets : ").trim());
        }

        int getFileVersion() {
            return (int)this.getDataExplorerVersion();
        }

        double getDataExplorerVersion() {
            return this.header.containsKey("DataExplorer version : ") ? Double.parseDouble(this.header.get("DataExplorer version : ")) : 1.0;
        }

        String getLogObjectKey() {
            return this.header.containsKey("ObjectKey : ") ? this.header.get("ObjectKey : ") : "";
        }

        String getDeviceName() {
            return this.header.get("DeviceName : ");
        }

        ChannelTypes getChannelConfigType() {
            return ChannelTypes.valueOf(this.header.get("Channel/Configuration Type : ").trim());
        }

        HashMap<String, String> getHeader() {
            return this.header;
        }

        List<RecordSetParser> getOsdRecordSets() {
            if (this.osdRecordSets == null) {
                this.setOsdRecordSets();
            }
            return this.osdRecordSets;
        }

        private void setOsdRecordSets() {
            this.osdRecordSets = new ArrayList<RecordSetParser>();
            for (int i = 0; i < this.getRecordSetSize(); ++i) {
                String line = "RecordSetName : " + this.getHeader().get(i + 1 + " RecordSetName : ");
                RecordSetParser osdRecordSet = new RecordSetParser(this, OsdReaderWriter.getRecordSetProperties(line));
                this.osdRecordSets.add(osdRecordSet);
            }
        }

        long getCreationTimeStamp_ms() {
            if (this.header.containsKey("Created : ")) {
                try {
                    return Instant.parse(this.header.get("Created : ")).toEpochMilli();
                }
                catch (DateTimeParseException dateTimeParseException) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss");
                    try {
                        return simpleDateFormat.parse(this.header.get("Created : ")).getTime();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
            return 0L;
        }
    }

    private static class RecordSetParser {
        private final HeaderParser osdHeader;
        private final HashMap<String, String> recordSetInfo;
        private final HashMap<String, String> recordSetProps;
        private List<RecordParser> osdRecords;

        RecordSetParser(HeaderParser osdHeader, HashMap<String, String> recordSetInfo) {
            this.osdHeader = osdHeader;
            this.recordSetInfo = recordSetInfo;
            String recordSetProperties = recordSetInfo.get("RecordSetProperties : ");
            this.recordSetProps = StringHelper.splitString(recordSetProperties, "|-|", RecordSet.propertyKeys);
        }

        Channel getChannel(Channels channels) {
            Channel channel = null;
            String channelConfig = this.recordSetInfo.get("Channel/Configuration Name: ");
            try {
                channel = (Channel)channels.get(Integer.parseInt(channelConfig.substring(channelConfig.length() - 1)));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (channel == null) {
                try {
                    channel = (Channel)channels.get(Integer.parseInt(channelConfig.split(" ")[0]));
                }
                catch (NullPointerException | NumberFormatException runtimeException) {
                    // empty catch block
                }
            }
            if (channel == null) {
                String channelConfigKey = channelConfig.contains(":") ? channelConfig.split(":")[1].trim() : channelConfig.trim();
                channelConfigKey = channelConfigKey.contains(" ") ? channelConfigKey.split(" ")[0].trim() : channelConfigKey.trim();
                channel = (Channel)channels.get(channels.getChannelNumber(channelConfigKey));
            }
            return channel;
        }

        String getName() {
            return this.recordSetInfo.get("RecordSetName : ");
        }

        String getBaseName() {
            return this.recordSetInfo.get("RecordSetName : ") + " | " + this.recordSetInfo.get("Channel/Configuration Name: ");
        }

        long getDataPointer() {
            return Long.parseLong(this.recordSetInfo.get("RecordSetDataPointer : "));
        }

        int getRecordDataSize() {
            return Integer.parseInt(this.recordSetInfo.get("RecordDataSize : "));
        }

        String getComment() {
            return this.recordSetInfo.get("RecordSetComment : ");
        }

        Long getStartTimestamp_ms() {
            return this.recordSetProps.containsKey("startTimeStamp") && !this.recordSetProps.get("startTimeStamp").isEmpty() ? Long.valueOf(Long.parseLong(this.recordSetProps.get("startTimeStamp").trim())) : null;
        }

        String getSensorSignature() {
            String recordSetComment = this.getComment();
            int idx1 = recordSetComment.indexOf(91);
            int idx2 = recordSetComment.indexOf(93);
            if (idx1 > 0 && idx2 > idx1) {
                return recordSetComment.substring(idx1 + 1, idx2);
            }
            return "";
        }

        Double getFirmware() {
            String recordSetComment = this.getComment();
            String label = "Firmware";
            int idx1 = recordSetComment.indexOf("Firmware");
            if (idx1 > 0) {
                try {
                    String firmwareVersion = recordSetComment.substring(idx1 + "Firmware".length(), recordSetComment.length());
                    return Double.parseDouble(firmwareVersion.replace(',', '.').replaceAll("[^0-9.]", ""));
                }
                catch (Exception e) {
                    return null;
                }
            }
            return null;
        }

        double[] getPackageLoss() {
            String recordSetComment = this.getComment();
            NumberFormat doubleFormat = NumberFormat.getInstance(Locale.getDefault());
            double[] values = new double[6];
            int idx0 = recordSetComment.indexOf(10);
            int idx1 = recordSetComment.indexOf(61) + 1;
            try {
                boolean isNewFormat = recordSetComment.indexOf(40) == idx1 + 1;
                idx1 = isNewFormat ? recordSetComment.indexOf(32, idx1 + 2) : idx1;
                int idx2 = isNewFormat ? recordSetComment.indexOf("~", idx1) - 1 : recordSetComment.indexOf("~", idx1);
                int idx3 = recordSetComment.indexOf("%", idx2);
                String numLostPackages = recordSetComment.substring(idx1 + 1, idx2).trim();
                String percentLostPackages = recordSetComment.substring(idx2 + 2, idx3 - 1).trim();
                if (idx0 > 0 && idx1 > idx0 && idx2 > idx1 && idx3 > idx2) {
                    values[0] = Double.parseDouble(numLostPackages);
                    values[1] = doubleFormat.parse(percentLostPackages).doubleValue();
                    String[] times = recordSetComment.substring(idx3 + 1).split("=");
                    if (times.length > 1) {
                        values[2] = doubleFormat.parse(times[1].substring(0, times[1].indexOf(" "))).doubleValue();
                        values[3] = doubleFormat.parse(times[2].substring(0, times[2].indexOf(" "))).doubleValue();
                        values[4] = doubleFormat.parse(times[3].substring(0, times[3].indexOf(" "))).doubleValue();
                        values[5] = doubleFormat.parse(times[4].substring(0, times[4].indexOf(" "))).doubleValue();
                    }
                }
            }
            catch (RuntimeException | ParseException e) {
                log.log(Level.WARNING, recordSetComment + "\n" + recordSetComment.substring(idx1));
                log.log(Level.WARNING, e.getMessage());
            }
            return values;
        }

        long getEnhancedStartTimestamp_ms() {
            Long startTimestamp_ms = this.getStartTimestamp_ms();
            if (startTimestamp_ms == null) {
                try {
                    String[] parts = this.getComment().split(" ");
                    String date = "";
                    String time = "";
                    for (String stringPart : parts) {
                        Pattern datePattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
                        Matcher dateMatcher = datePattern.matcher(stringPart);
                        Pattern timePattern = Pattern.compile("\\d{2}:\\d{2}:\\d{2}");
                        Matcher timeMatcher = timePattern.matcher(stringPart);
                        if (dateMatcher.find()) {
                            date = dateMatcher.group();
                        }
                        if (!timeMatcher.find()) continue;
                        time = timeMatcher.group();
                    }
                    if (!date.isEmpty()) {
                        String[] strValueDate = date.split("-");
                        int year = Integer.parseInt(strValueDate[0]);
                        int month = Integer.parseInt(strValueDate[1]);
                        int day = Integer.parseInt(strValueDate[2]);
                        int hour = 0;
                        int minute = 0;
                        int second = 0;
                        if (!time.isEmpty()) {
                            String[] strValueTime = time.split(":");
                            hour = Integer.parseInt(strValueTime[0]);
                            minute = Integer.parseInt(strValueTime[1]);
                            second = Integer.parseInt(strValueTime[2]);
                        }
                        GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day, hour, minute, second);
                        startTimestamp_ms = calendar.getTimeInMillis();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (startTimestamp_ms == null || startTimestamp_ms == 0L) {
                startTimestamp_ms = this.osdHeader.getCreationTimeStamp_ms();
            }
            log.log(java.util.logging.Level.FINEST, "startTimestamp_ms=", startTimestamp_ms);
            return startTimestamp_ms;
        }

        String[] getRecordKeys() {
            List<RecordParser> records = this.getOsdRecords();
            String[] recordKeys = new String[records.size()];
            for (int i = 0; i < records.size(); ++i) {
                RecordParser osdRecord = records.get(i);
                recordKeys[i] = osdRecord.getName();
            }
            return recordKeys;
        }

        List<RecordParser> getOsdRecords() {
            if (this.osdRecords == null) {
                this.setOsdRecords();
            }
            return this.osdRecords;
        }

        private void setOsdRecords() {
            String[] recordsProperties;
            this.osdRecords = new ArrayList<RecordParser>();
            for (String recordPropertiesInfo : recordsProperties = StringHelper.splitString(this.recordSetInfo.get("RecordProperties : "), "|:-:|", "RecordProperties : ")) {
                RecordParser osdRecord = new RecordParser(recordPropertiesInfo);
                this.osdRecords.add(osdRecord);
            }
        }

        HeaderParser getOsdHeader() {
            return this.osdHeader;
        }
    }

    private static enum PointsType {
        MAX,
        MIN;

    }

    private static class RecordParser {
        private final HashMap<String, String> recordProperties;

        RecordParser(String recordPropertiesInfo) {
            this.recordProperties = StringHelper.splitString(recordPropertiesInfo, "|-|", Record.propertyKeys);
        }

        int getMinValue() {
            return Integer.parseInt(this.recordProperties.get("_minValue").trim());
        }

        int getMaxValue() {
            return Integer.parseInt(this.recordProperties.get("_maxValue").trim());
        }

        String getName() {
            return this.recordProperties.get("_name");
        }
    }
}

