/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.innercache;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class CacheLoader<K, V> {
    protected CacheLoader() {
    }

    public abstract V load(K var1) throws Exception;

    public CompletableFuture<V> reload(K key, V oldValue) throws Exception {
        Objects.requireNonNull(key);
        Objects.requireNonNull(oldValue);
        return CompletableFuture.completedFuture(this.load(key));
    }

    public Map<K, V> loadAll(Iterable<? extends K> keys) throws Exception {
        throw new UnsupportedLoadingOperationException();
    }

    public static <K, V> CacheLoader<K, V> from(Function<K, V> function) {
        return new FunctionToCacheLoader<K, V>(function);
    }

    public static <V> CacheLoader<Object, V> from(Supplier<V> supplier) {
        return new SupplierToCacheLoader<V>(supplier);
    }

    public static final class UnsupportedLoadingOperationException
    extends UnsupportedOperationException {
        UnsupportedLoadingOperationException() {
        }
    }

    private static final class FunctionToCacheLoader<K, V>
    extends CacheLoader<K, V>
    implements Serializable {
        private final Function<K, V> computingFunction;
        private static final long serialVersionUID = 0L;

        public FunctionToCacheLoader(Function<K, V> computingFunction) {
            this.computingFunction = Objects.requireNonNull(computingFunction);
        }

        @Override
        public V load(K key) {
            return this.computingFunction.apply(Objects.requireNonNull(key));
        }
    }

    private static final class SupplierToCacheLoader<V>
    extends CacheLoader<Object, V>
    implements Serializable {
        private final Supplier<V> computingSupplier;
        private static final long serialVersionUID = 0L;

        public SupplierToCacheLoader(Supplier<V> computingSupplier) {
            this.computingSupplier = Objects.requireNonNull(computingSupplier);
        }

        @Override
        public V load(Object key) {
            Objects.requireNonNull(key);
            return this.computingSupplier.get();
        }
    }

    public static final class InvalidCacheLoadException
    extends RuntimeException {
        public InvalidCacheLoadException(String message) {
            super(message);
        }
    }
}

