/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.cache;

import com.sun.istack.Nullable;
import gde.Analyzer;
import gde.histo.cache.ExtendedVault;
import gde.histo.cache.HistoVault;
import gde.histo.cache.VaultCollector;
import gde.histo.cache.VaultProxy;
import gde.histo.datasources.SourceDataSet;
import gde.histo.datasources.VaultPicker;
import gde.histo.device.IHistoDevice;
import gde.histo.guard.ObjectVaultIndex;
import gde.histo.innercache.Cache;
import gde.histo.innercache.CacheBuilder;
import gde.histo.innercache.CacheStats;
import gde.log.Level;
import gde.log.Logger;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class VaultReaderWriter {
    private static final String $CLASS_NAME = VaultReaderWriter.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final int MIN_FILE_LENGTH = 2048;
    private static final Cache<String, HistoVault> memoryCache = CacheBuilder.newBuilder().maximumSize(4444L).recordStats().build();
    private final Analyzer analyzer;
    private final Optional<VaultPicker.ProgressManager> progress;

    public VaultReaderWriter(Analyzer analyzer, Optional<VaultPicker.ProgressManager> progress) {
        this.analyzer = analyzer;
        this.progress = progress;
    }

    public void loadFromFile(Path filePath, List<VaultCollector> trusses) {
        SourceDataSet dataSet = SourceDataSet.createSourceDataSet(filePath, this.analyzer);
        if (dataSet != null) {
            dataSet.readVaults4Ui(filePath, trusses);
        }
    }

    public synchronized List<ExtendedVault> loadFromCaches(VaultPicker.TrussJobs trussJobs) throws IOException {
        String nativeReaderSettings;
        String osdReaderSettings = "";
        List<ExtendedVault> vaults = this.loadFromCachePath(trussJobs, ExtendedVault.getVaultDirectoryName(this.analyzer.getActiveDevice(), this.analyzer.getSettings(), this.analyzer.getActiveChannel().getNumber(), osdReaderSettings));
        if (this.analyzer.getActiveDevice() instanceof IHistoDevice && !(nativeReaderSettings = ((IHistoDevice)((Object)this.analyzer.getActiveDevice())).getReaderSettingsCsv()).equals(osdReaderSettings)) {
            List<ExtendedVault> nativeVaults = this.loadFromCachePath(trussJobs, ExtendedVault.getVaultDirectoryName(this.analyzer.getActiveDevice(), this.analyzer.getSettings(), this.analyzer.getActiveChannel().getNumber(), nativeReaderSettings));
            vaults.addAll(nativeVaults);
        }
        return vaults;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ExtendedVault> loadFromCachePath(VaultPicker.TrussJobs trussJobs, String vaultDirectoryName) throws IOException {
        Function<InputStream, HistoVault> storeKeeper;
        ArrayList<ExtendedVault> vaults = new ArrayList<ExtendedVault>();
        if (!this.analyzer.getDataAccess().existsCacheDirectory(vaultDirectoryName)) {
            return vaults;
        }
        Function<InputStream, HistoVault> function = storeKeeper = this.analyzer.getSettings().isXmlCache() ? stream -> VaultProxy.load(stream) : stream -> VaultProxy.loadJson(stream);
        if (this.analyzer.getSettings().isZippedCache()) {
            HashMap<String, VaultCollector> vaultNameMap = trussJobs.getAsVaultNameMap();
            try (CloseIgnoringInputStream stream2 = new CloseIgnoringInputStream(this.analyzer.getDataAccess().getCacheZipInputStream(vaultDirectoryName));){
                ZipEntry entry;
                while ((entry = stream2.getNextEntry()) != null) {
                    String vaultName = entry.getName();
                    if (!vaultNameMap.containsKey(vaultName)) continue;
                    this.progress.ifPresent(p -> p.countInLoop(1));
                    try {
                        HistoVault histoVault = memoryCache.get(vaultName, () -> (HistoVault)storeKeeper.apply(stream2));
                        VaultCollector truss = vaultNameMap.get(vaultName);
                        vaults.add(ExtendedVault.createExtendedVault(histoVault, truss));
                        trussJobs.remove(truss);
                    }
                    catch (Exception e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                    }
                }
                stream2.reallyClose();
            }
        } else {
            Iterator<Map.Entry<Path, List<VaultCollector>>> trussJobsIterator = trussJobs.entrySet().iterator();
            while (trussJobsIterator.hasNext()) {
                List<VaultCollector> map = trussJobsIterator.next().getValue();
                Iterator<VaultCollector> trussesIterator = map.iterator();
                while (trussesIterator.hasNext()) {
                    this.progress.ifPresent(p -> p.countInLoop(1));
                    VaultCollector truss = trussesIterator.next();
                    String vaultName = truss.getVault().vaultName;
                    if (!this.analyzer.getDataAccess().existsCacheVault(vaultDirectoryName, vaultName)) continue;
                    HistoVault histoVault = null;
                    try {
                        InputStream stream3 = this.analyzer.getDataAccess().getCacheInputStream(vaultDirectoryName, vaultName);
                        try {
                            histoVault = memoryCache.get(vaultName, () -> (HistoVault)storeKeeper.apply(stream3));
                            vaults.add(ExtendedVault.createExtendedVault(histoVault, truss));
                            trussesIterator.remove();
                        }
                        finally {
                            if (stream3 == null) continue;
                            stream3.close();
                        }
                    }
                    catch (Exception e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                    }
                }
                if (!map.isEmpty()) continue;
                trussJobsIterator.remove();
            }
        }
        log.fine(() -> {
            CacheStats stats = memoryCache.stats();
            return String.format("evictionCount=%d  hitCount=%d  missCount=%d hitRate=%f missRate=%f", stats.evictionCount(), stats.hitCount(), stats.missCount(), stats.hitRate(), stats.missRate());
        });
        return vaults;
    }

    public void storeInCaches(VaultPicker.TrussJobs trussJobs) throws IOException {
        Map<SourceDataSet, List<VaultCollector>> groupedJobs = trussJobs.values().parallelStream().flatMap(Collection::parallelStream).collect(Collectors.groupingBy(VaultCollector::getSourceDataSet));
        groupedJobs.entrySet().stream().forEach(e -> {
            boolean providesReaderSettings = ((SourceDataSet)e.getKey()).providesReaderSettings();
            String readerSettings = providesReaderSettings && this.analyzer.getActiveDevice() instanceof IHistoDevice ? ((IHistoDevice)((Object)this.analyzer.getActiveDevice())).getReaderSettingsCsv() : "";
            String vaultsDirectoryName = ExtendedVault.getVaultDirectoryName(this.analyzer.getActiveDevice(), this.analyzer.getSettings(), this.analyzer.getActiveChannel().getNumber(), readerSettings);
            try {
                this.storeInCachePath((List)e.getValue(), vaultsDirectoryName);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    private void storeInCachePath(List<VaultCollector> newVaults, String vaultDirectoryName) throws IOException {
        BiConsumer<HistoVault, OutputStream> storeKeeper;
        BiConsumer<HistoVault, OutputStream> biConsumer = storeKeeper = this.analyzer.getSettings().isXmlCache() ? (vault, stream) -> VaultProxy.store(vault, stream) : (vault, stream) -> VaultProxy.storeJson(vault, stream);
        if (this.analyzer.getSettings().isZippedCache()) {
            try (FileSystem zipFileSystem = this.analyzer.getDataAccess().getCacheZipFileSystem(vaultDirectoryName);){
                for (VaultCollector vaultCollector : newVaults) {
                    ExtendedVault vault2 = vaultCollector.getVault();
                    try (OutputStream cacheOutputStream = this.analyzer.getDataAccess().getCacheZipOutputStream(zipFileSystem, vault2.vaultName);
                         BufferedOutputStream outputStream = new BufferedOutputStream(cacheOutputStream);){
                        storeKeeper.accept(vault2, outputStream);
                    }
                    catch (Exception e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                    }
                    memoryCache.put(vault2.vaultName, vault2);
                }
            }
        }
        this.analyzer.getDataAccess().ensureCacheDirectory(vaultDirectoryName);
        for (VaultCollector vaultCollector : newVaults) {
            ExtendedVault vault3 = vaultCollector.getVault();
            try (OutputStream cacheOutputStream = this.analyzer.getDataAccess().getCacheOutputStream(vaultDirectoryName, vault3.vaultName);
                 BufferedOutputStream outputStream = new BufferedOutputStream(cacheOutputStream);){
                storeKeeper.accept(vault3, outputStream);
            }
            catch (Exception e) {
                log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
            }
            memoryCache.put(vault3.vaultName, vault3);
        }
    }

    public static long getInnerCacheHitCount() {
        return memoryCache.stats().hitCount();
    }

    @Nullable
    public List<HistoVault> loadFromCaches(List<ObjectVaultIndex.VaultKeyPair> keyPairs) {
        ArrayList<HistoVault> vaults = new ArrayList<HistoVault>();
        for (ObjectVaultIndex.VaultKeyPair p : keyPairs) {
            if (p == null) continue;
            String folderName = (String)p.getKey();
            String fileName = (String)p.getValue();
            HistoVault histoVault = memoryCache.getIfPresent(fileName);
            if (histoVault == null) {
                histoVault = this.analyzer.getSettings().isZippedCache() ? this.analyzer.getDataAccess().getCacheZipVault(folderName, fileName, 2048, this.analyzer.getSettings().isXmlCache()) : this.analyzer.getDataAccess().getCacheVault(folderName, fileName, 2048, this.analyzer.getSettings().isXmlCache());
            }
            vaults.add(histoVault);
        }
        log.fine(() -> {
            CacheStats stats = memoryCache.stats();
            return String.format("evictionCount=%d  hitCount=%d  missCount=%d hitRate=%f missRate=%f", stats.evictionCount(), stats.hitCount(), stats.missCount(), stats.hitRate(), stats.missRate());
        });
        log.log(Level.FINE, "vaults size=", vaults.size());
        return vaults;
    }

    public List<Map.Entry<String, String>> readVaultsIndices(String directoryName) throws IOException {
        Function<InputStream, HistoVault> storeKeeper;
        ArrayList<Map.Entry<String, String>> vaultExtract = new ArrayList<Map.Entry<String, String>>();
        Function<InputStream, HistoVault> function = storeKeeper = this.analyzer.getSettings().isXmlCache() ? stream -> VaultProxy.load(stream) : stream -> VaultProxy.loadJson(stream);
        if (this.analyzer.getSettings().isZippedCache()) {
            try (CloseIgnoringInputStream stream2 = new CloseIgnoringInputStream(this.analyzer.getDataAccess().getCacheZipInputStream(directoryName));){
                ZipEntry zipEntry;
                while ((zipEntry = stream2.getNextEntry()) != null) {
                    if (zipEntry.getSize() <= 2048L) continue;
                    try {
                        HistoVault histoVault = memoryCache.get(zipEntry.getName(), () -> (HistoVault)storeKeeper.apply(stream2));
                        vaultExtract.add(new AbstractMap.SimpleImmutableEntry<String, String>(histoVault.getVaultObjectKey(), VaultReaderWriter.toIndexEntry(histoVault)));
                    }
                    catch (Exception e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                    }
                }
                stream2.reallyClose();
            }
        }
        for (String vaultName : this.analyzer.getDataAccess().getCacheFolderList(directoryName, 2048)) {
            try (InputStream stream3 = this.analyzer.getDataAccess().getCacheInputStream(directoryName, vaultName);){
                HistoVault histoVault = memoryCache.get(vaultName, () -> (HistoVault)storeKeeper.apply(stream3));
                vaultExtract.add(new AbstractMap.SimpleImmutableEntry<String, String>(histoVault.getVaultObjectKey(), VaultReaderWriter.toIndexEntry(histoVault)));
            }
            catch (Exception e) {
                log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
            }
        }
        log.fine(() -> {
            CacheStats stats = memoryCache.stats();
            return String.format("evictionCount=%d  hitCount=%d  missCount=%d hitRate=%f missRate=%f", stats.evictionCount(), stats.hitCount(), stats.missCount(), stats.hitRate(), stats.missRate());
        });
        if (log.isLoggable(Level.FINER)) {
            for (Map.Entry entry : vaultExtract) {
                log.log(Level.FINER, (String)entry.getKey(), entry.getValue());
            }
        }
        log.fine(() -> String.format("%s : %s %d", vaultExtract.isEmpty() ? directoryName : ((Map.Entry)vaultExtract.get(0)).getKey(), directoryName, vaultExtract.size()));
        return vaultExtract;
    }

    private static String toIndexEntry(HistoVault h) {
        String d = ",";
        String readerSettings = h.vaultReaderSettings.replace(',', '_');
        String attributes = h.vaultName + "," + h.vaultDirectory + "," + readerSettings + "," + h.vaultCreated_ms + "," + h.vaultDataExplorerVersion + "," + h.vaultDeviceKey + "," + h.vaultDeviceName + "," + h.vaultChannelNumber + "," + h.vaultSamplingTimespan_ms + "," + h.logFileLastModified + "," + h.logFileLength + "," + h.logRecordSetOrdinal + "," + h.logRecordsetBaseName + "," + h.logChannelNumber + "," + h.logStartTimestamp_ms + "," + h.logFilePath;
        return attributes;
    }

    private static class CloseIgnoringInputStream
    extends InputStream {
        private ZipInputStream stream;

        public CloseIgnoringInputStream(ZipInputStream inStream) {
            this.stream = inStream;
        }

        public ZipEntry getNextEntry() throws IOException {
            return this.stream.getNextEntry();
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public void close() {
        }

        public void reallyClose() throws IOException {
            this.stream.close();
        }
    }
}

