/*
 * Decompiled with CFR 0.152.
 */
package gde.device.peaktech;

import gde.comm.DeviceCommPort;
import gde.comm.IDeviceCommPort;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.log.Level;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import java.util.logging.Logger;
import javax.usb.UsbClaimException;
import javax.usb.UsbException;
import javax.usb.UsbInterface;
import org.usb4java.DeviceHandle;

public class PeakTechUsbPort
extends DeviceCommPort
implements IDeviceCommPort {
    static final String $CLASS_NAME = PeakTechUsbPort.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    public static final long TIMEOUT_MS = 1200L;
    protected long timeout_ms = 1200L;
    protected DeviceHandle libUsbHandle;
    protected final byte interfaceId;
    protected final byte endpointIn;
    protected final byte endpointOut;
    final int dataSize = this.deviceConfig.getDataBlockSize(InputTypes.SERIAL_IO);

    public PeakTechUsbPort(IDevice currentDevice, DataExplorer currentApplication) {
        super(currentDevice, currentApplication);
        this.interfaceId = this.device.getUsbInterface();
        this.endpointIn = this.device.getUsbEndpointIn();
        this.endpointOut = this.device.getUsbEndpointOut();
    }

    public void openUsbPort() throws UsbClaimException, UsbException {
        this.libUsbHandle = this.openLibUsbPort(this.device);
    }

    public void closeUsbPort(boolean cacheSelectedUsbDevice) throws UsbClaimException, UsbException {
        if (this.libUsbHandle != null) {
            this.closeLibUsbPort(this.libUsbHandle, cacheSelectedUsbDevice);
            this.libUsbHandle = null;
        } else {
            this.closeLibUsbPort(null, false);
        }
    }

    public synchronized byte[] getData(UsbInterface iface) throws Exception {
        byte[] data;
        block3: {
            String $METHOD_NAME = "getData";
            data = new byte[Math.abs(this.dataSize)];
            try {
                this.read(iface, this.endpointOut, data, (int)this.timeout_ms);
                if (log.isLoggable(Level.OFF)) {
                    log.logp(Level.OFF, $CLASS_NAME, "getData", StringHelper.byte2Hex2CharString((byte[])data, (int)data.length));
                }
            }
            catch (Exception e) {
                log.logp(Level.WARNING, $CLASS_NAME, "getData", e.getMessage(), e);
                if (!(e instanceof RuntimeException)) break block3;
                throw e;
            }
        }
        return data;
    }

    public synchronized byte[] getData() throws Exception {
        String $METHOD_NAME = "getData";
        byte[] data = new byte[Math.abs(this.dataSize)];
        this.read(this.libUsbHandle, this.endpointOut, data, this.timeout_ms);
        if (log.isLoggable(Level.OFF)) {
            log.logp(Level.OFF, $CLASS_NAME, "getData", StringHelper.byte2Hex2CharString((byte[])data, (int)data.length));
        }
        return data;
    }

    public long getTimeOut_ms() {
        return this.timeout_ms;
    }

    public void setTimeOut_ms(long newTimeout_ms) {
        log.finer(() -> String.format("set new timeout_ms = %d", newTimeout_ms));
        this.timeout_ms = newTimeout_ms;
    }
}

