/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.qrcode;

import com.itextpdf.text.pdf.qrcode.ByteMatrix;
import com.itextpdf.text.pdf.qrcode.EncodeHintType;
import com.itextpdf.text.pdf.qrcode.Encoder;
import com.itextpdf.text.pdf.qrcode.ErrorCorrectionLevel;
import com.itextpdf.text.pdf.qrcode.QRCode;
import com.itextpdf.text.pdf.qrcode.WriterException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QRCodeWriter {
    private static final int QUIET_ZONE_SIZE = 4;

    public ByteMatrix encode(String contents, int width, int height) throws WriterException {
        return this.encode(contents, width, height, null);
    }

    public ByteMatrix encode(String contents, int width, int height, Map<EncodeHintType, Object> hints) throws WriterException {
        ErrorCorrectionLevel requestedECLevel;
        if (contents == null || contents.length() == 0) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Requested dimensions are too small: " + width + 'x' + height);
        }
        ErrorCorrectionLevel errorCorrectionLevel = ErrorCorrectionLevel.L;
        if (hints != null && (requestedECLevel = (ErrorCorrectionLevel)hints.get(EncodeHintType.ERROR_CORRECTION)) != null) {
            errorCorrectionLevel = requestedECLevel;
        }
        QRCode code = new QRCode();
        Encoder.encode(contents, errorCorrectionLevel, hints, code);
        return QRCodeWriter.renderResult(code, width, height);
    }

    private static ByteMatrix renderResult(QRCode code, int width, int height) {
        int offset;
        ByteMatrix input = code.getMatrix();
        int inputWidth = input.getWidth();
        int inputHeight = input.getHeight();
        int qrWidth = inputWidth + 8;
        int qrHeight = inputHeight + 8;
        int outputWidth = Math.max(width, qrWidth);
        int outputHeight = Math.max(height, qrHeight);
        int multiple = Math.min(outputWidth / qrWidth, outputHeight / qrHeight);
        int leftPadding = (outputWidth - inputWidth * multiple) / 2;
        int topPadding = (outputHeight - inputHeight * multiple) / 2;
        ByteMatrix output = new ByteMatrix(outputWidth, outputHeight);
        byte[][] outputArray = output.getArray();
        byte[] row2 = new byte[outputWidth];
        for (int y2 = 0; y2 < topPadding; ++y2) {
            QRCodeWriter.setRowColor(outputArray[y2], (byte)-1);
        }
        byte[][] inputArray = input.getArray();
        for (int y3 = 0; y3 < inputHeight; ++y3) {
            int x2;
            for (int x3 = 0; x3 < leftPadding; ++x3) {
                row2[x3] = -1;
            }
            int offset2 = leftPadding;
            for (x2 = 0; x2 < inputWidth; ++x2) {
                int value = inputArray[y3][x2] == 1 ? 0 : -1;
                for (int z2 = 0; z2 < multiple; ++z2) {
                    row2[offset2 + z2] = value;
                }
                offset2 += multiple;
            }
            for (x2 = offset2 = leftPadding + inputWidth * multiple; x2 < outputWidth; ++x2) {
                row2[x2] = -1;
            }
            offset2 = topPadding + y3 * multiple;
            for (int z3 = 0; z3 < multiple; ++z3) {
                System.arraycopy(row2, 0, outputArray[offset2 + z3], 0, outputWidth);
            }
        }
        for (int y4 = offset = topPadding + inputHeight * multiple; y4 < outputHeight; ++y4) {
            QRCodeWriter.setRowColor(outputArray[y4], (byte)-1);
        }
        return output;
    }

    private static void setRowColor(byte[] row2, byte value) {
        for (int x2 = 0; x2 < row2.length; ++x2) {
            row2[x2] = value;
        }
    }
}

