/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDate;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.security.PdfSignatureBuildProperties;

public class PdfSignature
extends PdfDictionary {
    public PdfSignature(PdfName filter2, PdfName subFilter) {
        super(PdfName.SIG);
        this.put(PdfName.FILTER, filter2);
        this.put(PdfName.SUBFILTER, subFilter);
    }

    public void setByteRange(int[] range) {
        PdfArray array = new PdfArray();
        for (int k2 = 0; k2 < range.length; ++k2) {
            array.add(new PdfNumber(range[k2]));
        }
        this.put(PdfName.BYTERANGE, array);
    }

    public void setContents(byte[] contents) {
        this.put(PdfName.CONTENTS, new PdfString(contents).setHexWriting(true));
    }

    public void setCert(byte[] cert) {
        this.put(PdfName.CERT, new PdfString(cert));
    }

    public void setName(String name) {
        this.put(PdfName.NAME, new PdfString(name, "UnicodeBig"));
    }

    public void setDate(PdfDate date) {
        this.put(PdfName.M, date);
    }

    public void setLocation(String name) {
        this.put(PdfName.LOCATION, new PdfString(name, "UnicodeBig"));
    }

    public void setReason(String name) {
        this.put(PdfName.REASON, new PdfString(name, "UnicodeBig"));
    }

    public void setSignatureCreator(String name) {
        if (name != null) {
            this.getPdfSignatureBuildProperties().setSignatureCreator(name);
        }
    }

    PdfSignatureBuildProperties getPdfSignatureBuildProperties() {
        PdfSignatureBuildProperties buildPropDic = (PdfSignatureBuildProperties)this.getAsDict(PdfName.PROP_BUILD);
        if (buildPropDic == null) {
            buildPropDic = new PdfSignatureBuildProperties();
            this.put(PdfName.PROP_BUILD, buildPropDic);
        }
        return buildPropDic;
    }

    public void setContact(String name) {
        this.put(PdfName.CONTACTINFO, new PdfString(name, "UnicodeBig"));
    }
}

