/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.awt.geom;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.awt.geom.FlatteningPathIterator;
import com.itextpdf.awt.geom.Line2D;
import com.itextpdf.awt.geom.PathIterator;
import com.itextpdf.awt.geom.Point2D;
import com.itextpdf.awt.geom.Rectangle;
import com.itextpdf.awt.geom.Rectangle2D;
import com.itextpdf.awt.geom.Shape;
import com.itextpdf.awt.geom.gl.Crossing;
import com.itextpdf.awt.geom.misc.Messages;
import java.util.NoSuchElementException;

public abstract class CubicCurve2D
implements Shape,
Cloneable {
    protected CubicCurve2D() {
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract Point2D getP1();

    public abstract double getCtrlX1();

    public abstract double getCtrlY1();

    public abstract Point2D getCtrlP1();

    public abstract double getCtrlX2();

    public abstract double getCtrlY2();

    public abstract Point2D getCtrlP2();

    public abstract double getX2();

    public abstract double getY2();

    public abstract Point2D getP2();

    public abstract void setCurve(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15);

    public void setCurve(Point2D p1, Point2D cp1, Point2D cp2, Point2D p2) {
        this.setCurve(p1.getX(), p1.getY(), cp1.getX(), cp1.getY(), cp2.getX(), cp2.getY(), p2.getX(), p2.getY());
    }

    public void setCurve(double[] coords, int offset) {
        this.setCurve(coords[offset + 0], coords[offset + 1], coords[offset + 2], coords[offset + 3], coords[offset + 4], coords[offset + 5], coords[offset + 6], coords[offset + 7]);
    }

    public void setCurve(Point2D[] points, int offset) {
        this.setCurve(points[offset + 0].getX(), points[offset + 0].getY(), points[offset + 1].getX(), points[offset + 1].getY(), points[offset + 2].getX(), points[offset + 2].getY(), points[offset + 3].getX(), points[offset + 3].getY());
    }

    public void setCurve(CubicCurve2D curve) {
        this.setCurve(curve.getX1(), curve.getY1(), curve.getCtrlX1(), curve.getCtrlY1(), curve.getCtrlX2(), curve.getCtrlY2(), curve.getX2(), curve.getY2());
    }

    public double getFlatnessSq() {
        return CubicCurve2D.getFlatnessSq(this.getX1(), this.getY1(), this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), this.getX2(), this.getY2());
    }

    public static double getFlatnessSq(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
        return Math.max(Line2D.ptSegDistSq(x1, y1, x2, y2, ctrlx1, ctrly1), Line2D.ptSegDistSq(x1, y1, x2, y2, ctrlx2, ctrly2));
    }

    public static double getFlatnessSq(double[] coords, int offset) {
        return CubicCurve2D.getFlatnessSq(coords[offset + 0], coords[offset + 1], coords[offset + 2], coords[offset + 3], coords[offset + 4], coords[offset + 5], coords[offset + 6], coords[offset + 7]);
    }

    public double getFlatness() {
        return CubicCurve2D.getFlatness(this.getX1(), this.getY1(), this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), this.getX2(), this.getY2());
    }

    public static double getFlatness(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
        return Math.sqrt(CubicCurve2D.getFlatnessSq(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2));
    }

    public static double getFlatness(double[] coords, int offset) {
        return CubicCurve2D.getFlatness(coords[offset + 0], coords[offset + 1], coords[offset + 2], coords[offset + 3], coords[offset + 4], coords[offset + 5], coords[offset + 6], coords[offset + 7]);
    }

    public void subdivide(CubicCurve2D left2, CubicCurve2D right2) {
        CubicCurve2D.subdivide(this, left2, right2);
    }

    public static void subdivide(CubicCurve2D src, CubicCurve2D left2, CubicCurve2D right2) {
        double x1 = src.getX1();
        double y1 = src.getY1();
        double cx1 = src.getCtrlX1();
        double cy1 = src.getCtrlY1();
        double cx2 = src.getCtrlX2();
        double cy2 = src.getCtrlY2();
        double x2 = src.getX2();
        double y2 = src.getY2();
        double cx = (cx1 + cx2) / 2.0;
        double cy = (cy1 + cy2) / 2.0;
        cx1 = (x1 + cx1) / 2.0;
        cy1 = (y1 + cy1) / 2.0;
        cx2 = (x2 + cx2) / 2.0;
        cy2 = (y2 + cy2) / 2.0;
        double ax = (cx1 + cx) / 2.0;
        double ay = (cy1 + cy) / 2.0;
        double bx = (cx2 + cx) / 2.0;
        double by = (cy2 + cy) / 2.0;
        cx = (ax + bx) / 2.0;
        cy = (ay + by) / 2.0;
        if (left2 != null) {
            left2.setCurve(x1, y1, cx1, cy1, ax, ay, cx, cy);
        }
        if (right2 != null) {
            right2.setCurve(cx, cy, bx, by, cx2, cy2, x2, y2);
        }
    }

    public static void subdivide(double[] src, int srcOff, double[] left2, int leftOff, double[] right2, int rightOff) {
        double x1 = src[srcOff + 0];
        double y1 = src[srcOff + 1];
        double cx1 = src[srcOff + 2];
        double cy1 = src[srcOff + 3];
        double cx2 = src[srcOff + 4];
        double cy2 = src[srcOff + 5];
        double x2 = src[srcOff + 6];
        double y2 = src[srcOff + 7];
        double cx = (cx1 + cx2) / 2.0;
        double cy = (cy1 + cy2) / 2.0;
        cx1 = (x1 + cx1) / 2.0;
        cy1 = (y1 + cy1) / 2.0;
        cx2 = (x2 + cx2) / 2.0;
        cy2 = (y2 + cy2) / 2.0;
        double ax = (cx1 + cx) / 2.0;
        double ay = (cy1 + cy) / 2.0;
        double bx = (cx2 + cx) / 2.0;
        double by = (cy2 + cy) / 2.0;
        cx = (ax + bx) / 2.0;
        cy = (ay + by) / 2.0;
        if (left2 != null) {
            left2[leftOff + 0] = x1;
            left2[leftOff + 1] = y1;
            left2[leftOff + 2] = cx1;
            left2[leftOff + 3] = cy1;
            left2[leftOff + 4] = ax;
            left2[leftOff + 5] = ay;
            left2[leftOff + 6] = cx;
            left2[leftOff + 7] = cy;
        }
        if (right2 != null) {
            right2[rightOff + 0] = cx;
            right2[rightOff + 1] = cy;
            right2[rightOff + 2] = bx;
            right2[rightOff + 3] = by;
            right2[rightOff + 4] = cx2;
            right2[rightOff + 5] = cy2;
            right2[rightOff + 6] = x2;
            right2[rightOff + 7] = y2;
        }
    }

    public static int solveCubic(double[] eqn) {
        return CubicCurve2D.solveCubic(eqn, eqn);
    }

    public static int solveCubic(double[] eqn, double[] res) {
        return Crossing.solveCubic(eqn, res);
    }

    public boolean contains(double px, double py) {
        return Crossing.isInsideEvenOdd(Crossing.crossShape(this, px, py));
    }

    public boolean contains(double rx, double ry, double rw, double rh) {
        int cross = Crossing.intersectShape(this, rx, ry, rw, rh);
        return cross != 255 && Crossing.isInsideEvenOdd(cross);
    }

    public boolean intersects(double rx, double ry, double rw, double rh) {
        int cross = Crossing.intersectShape(this, rx, ry, rw, rh);
        return cross == 255 || Crossing.isInsideEvenOdd(cross);
    }

    public boolean contains(Point2D p2) {
        return this.contains(p2.getX(), p2.getY());
    }

    public boolean intersects(Rectangle2D r2) {
        return this.intersects(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
    }

    public boolean contains(Rectangle2D r2) {
        return this.contains(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public PathIterator getPathIterator(AffineTransform t2) {
        return new Iterator(this, t2);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
    }

    class Iterator
    implements PathIterator {
        CubicCurve2D c;
        AffineTransform t;
        int index;

        Iterator(CubicCurve2D c2, AffineTransform t2) {
            this.c = c2;
            this.t = t2;
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            return this.index > 1;
        }

        public void next() {
            ++this.index;
        }

        public int currentSegment(double[] coords) {
            int count;
            int type2;
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.4B"));
            }
            if (this.index == 0) {
                type2 = 0;
                coords[0] = this.c.getX1();
                coords[1] = this.c.getY1();
                count = 1;
            } else {
                type2 = 3;
                coords[0] = this.c.getCtrlX1();
                coords[1] = this.c.getCtrlY1();
                coords[2] = this.c.getCtrlX2();
                coords[3] = this.c.getCtrlY2();
                coords[4] = this.c.getX2();
                coords[5] = this.c.getY2();
                count = 3;
            }
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, count);
            }
            return type2;
        }

        public int currentSegment(float[] coords) {
            int count;
            int type2;
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.4B"));
            }
            if (this.index == 0) {
                type2 = 0;
                coords[0] = (float)this.c.getX1();
                coords[1] = (float)this.c.getY1();
                count = 1;
            } else {
                type2 = 3;
                coords[0] = (float)this.c.getCtrlX1();
                coords[1] = (float)this.c.getCtrlY1();
                coords[2] = (float)this.c.getCtrlX2();
                coords[3] = (float)this.c.getCtrlY2();
                coords[4] = (float)this.c.getX2();
                coords[5] = (float)this.c.getY2();
                count = 3;
            }
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, count);
            }
            return type2;
        }
    }

    public static class Double
    extends CubicCurve2D {
        public double x1;
        public double y1;
        public double ctrlx1;
        public double ctrly1;
        public double ctrlx2;
        public double ctrly2;
        public double x2;
        public double y2;

        public Double() {
        }

        public Double(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
            this.setCurve(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2);
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public double getCtrlX1() {
            return this.ctrlx1;
        }

        public double getCtrlY1() {
            return this.ctrly1;
        }

        public double getCtrlX2() {
            return this.ctrlx2;
        }

        public double getCtrlY2() {
            return this.ctrly2;
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        public Point2D getCtrlP1() {
            return new Point2D.Double(this.ctrlx1, this.ctrly1);
        }

        public Point2D getCtrlP2() {
            return new Point2D.Double(this.ctrlx2, this.ctrly2);
        }

        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        public void setCurve(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.ctrlx1 = ctrlx1;
            this.ctrly1 = ctrly1;
            this.ctrlx2 = ctrlx2;
            this.ctrly2 = ctrly2;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Rectangle2D getBounds2D() {
            double rx1 = Math.min(Math.min(this.x1, this.x2), Math.min(this.ctrlx1, this.ctrlx2));
            double ry1 = Math.min(Math.min(this.y1, this.y2), Math.min(this.ctrly1, this.ctrly2));
            double rx2 = Math.max(Math.max(this.x1, this.x2), Math.max(this.ctrlx1, this.ctrlx2));
            double ry2 = Math.max(Math.max(this.y1, this.y2), Math.max(this.ctrly1, this.ctrly2));
            return new Rectangle2D.Double(rx1, ry1, rx2 - rx1, ry2 - ry1);
        }
    }

    public static class Float
    extends CubicCurve2D {
        public float x1;
        public float y1;
        public float ctrlx1;
        public float ctrly1;
        public float ctrlx2;
        public float ctrly2;
        public float x2;
        public float y2;

        public Float() {
        }

        public Float(float x1, float y1, float ctrlx1, float ctrly1, float ctrlx2, float ctrly2, float x2, float y2) {
            this.setCurve(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2);
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public double getCtrlX1() {
            return this.ctrlx1;
        }

        public double getCtrlY1() {
            return this.ctrly1;
        }

        public double getCtrlX2() {
            return this.ctrlx2;
        }

        public double getCtrlY2() {
            return this.ctrly2;
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        public Point2D getCtrlP1() {
            return new Point2D.Float(this.ctrlx1, this.ctrly1);
        }

        public Point2D getCtrlP2() {
            return new Point2D.Float(this.ctrlx2, this.ctrly2);
        }

        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        public void setCurve(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
            this.x1 = (float)x1;
            this.y1 = (float)y1;
            this.ctrlx1 = (float)ctrlx1;
            this.ctrly1 = (float)ctrly1;
            this.ctrlx2 = (float)ctrlx2;
            this.ctrly2 = (float)ctrly2;
            this.x2 = (float)x2;
            this.y2 = (float)y2;
        }

        public void setCurve(float x1, float y1, float ctrlx1, float ctrly1, float ctrlx2, float ctrly2, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.ctrlx1 = ctrlx1;
            this.ctrly1 = ctrly1;
            this.ctrlx2 = ctrlx2;
            this.ctrly2 = ctrly2;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Rectangle2D getBounds2D() {
            float rx1 = Math.min(Math.min(this.x1, this.x2), Math.min(this.ctrlx1, this.ctrlx2));
            float ry1 = Math.min(Math.min(this.y1, this.y2), Math.min(this.ctrly1, this.ctrly2));
            float rx2 = Math.max(Math.max(this.x1, this.x2), Math.max(this.ctrlx1, this.ctrlx2));
            float ry2 = Math.max(Math.max(this.y1, this.y2), Math.max(this.ctrly1, this.ctrly2));
            return new Rectangle2D.Float(rx1, ry1, rx2 - rx1, ry2 - ry1);
        }
    }
}

