/*
 * Decompiled with CFR 0.152.
 */
package gde.device.weatronic;

import gde.DataAccess;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.ChannelPropertyTypes;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.weatronic.LogReader;
import gde.device.weatronic.WeatronicAdapterDialog;
import gde.exception.DataInconsitsentException;
import gde.io.FileHandler;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import gde.utils.WaitTimer;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.widgets.FileDialog;

public class WeatronicAdapter
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(WeatronicAdapter.class.getName());
    static final Properties properties = new Properties();
    final DataExplorer application;
    final Channels channels;
    final Settings settings;
    final WeatronicAdapterDialog dialog;
    static boolean isChannelFilter = true;
    static boolean isUtcFilter = true;
    static boolean isStatusFilter = true;

    public WeatronicAdapter(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.weatronic.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.settings = Settings.getInstance();
        this.dialog = new WeatronicAdapterDialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, "", "");
        }
        isChannelFilter = this.getChannelProperty(ChannelPropertyTypes.ENABLE_CHANNEL) == null || this.getChannelProperty(ChannelPropertyTypes.ENABLE_CHANNEL).getValue().equals("") ? Boolean.parseBoolean(this.getChannelProperty(ChannelPropertyTypes.ENABLE_CHANNEL).getValue()) : true;
        isStatusFilter = this.getChannelProperty(ChannelPropertyTypes.ENABLE_FILTER) == null || this.getChannelProperty(ChannelPropertyTypes.ENABLE_FILTER).getValue().equals("") ? Boolean.parseBoolean(this.getChannelProperty(ChannelPropertyTypes.ENABLE_FILTER).getValue()) : true;
        isUtcFilter = this.getChannelProperty(ChannelPropertyTypes.TEXT_MODE) == null || this.getChannelProperty(ChannelPropertyTypes.TEXT_MODE).getValue().equals("") ? Boolean.parseBoolean(this.getChannelProperty(ChannelPropertyTypes.TEXT_MODE).getValue()) : true;
        this.readProperties();
    }

    public WeatronicAdapter(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.weatronic.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.settings = Settings.getInstance();
        this.dialog = new WeatronicAdapterDialog(this.application.getShell(), this);
        this.configureSerialPortMenu(2, "", "");
        isChannelFilter = this.getChannelProperty(ChannelPropertyTypes.ENABLE_CHANNEL) == null ? Boolean.parseBoolean(this.getChannelProperty(ChannelPropertyTypes.ENABLE_CHANNEL).getValue()) : true;
        isStatusFilter = this.getChannelProperty(ChannelPropertyTypes.ENABLE_FILTER) == null ? Boolean.parseBoolean(this.getChannelProperty(ChannelPropertyTypes.ENABLE_FILTER).getValue()) : true;
        isUtcFilter = this.getChannelProperty(ChannelPropertyTypes.TEXT_MODE) == null ? Boolean.parseBoolean(this.getChannelProperty(ChannelPropertyTypes.TEXT_MODE).getValue()) : true;
        this.readProperties();
    }

    private void readProperties() {
        DataAccess.getInstance().checkMappingFileAndCreate(((Object)((Object)this)).getClass(), "WeatronicSynchronizationMappings.xml");
        try (InputStream stream = DataAccess.getInstance().getMappingInputStream("WeatronicSynchronizationMappings.xml");){
            properties.loadFromXML(stream);
        }
        catch (Exception e) {
            String preopertyFilePath = "Mapping/WeatronicSynchronizationMappings.xml";
            this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE3700", (Object[])new String[]{preopertyFilePath}));
        }
    }

    public static synchronized void setUtcFilter(boolean isUtcFilterEnabled) {
        isUtcFilter = isUtcFilterEnabled;
    }

    public static synchronized void setStatusFilter(boolean isStatusFilterEnabled) {
        isStatusFilter = isStatusFilterEnabled;
    }

    public static synchronized void setChannelFilter(boolean isChannelFilterEnabled) {
        isChannelFilter = isChannelFilterEnabled;
    }

    public WeatronicAdapterDialog getDialog() {
        return this.dialog;
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        int[] points = new int[recordSet.getNoneCalculationRecordNames().length];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 1;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 4 * recordDataSize;
        int index = 0;
        for (int i = 0; i < recordDataSize; ++i) {
            index = i * dataBufferSize + timeStampBufferSize;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + index);
            }
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((dataBuffer[0 + j * 4 + index] & 0xFF) << 24) + ((dataBuffer[1 + j * 4 + index] & 0xFF) << 16) + ((dataBuffer[2 + j * 4 + index] & 0xFF) << 8) + ((dataBuffer[3 + j * 4 + index] & 0xFF) << 0);
            }
            recordSet.addPoints(points, (double)(((dataBuffer[0 + i * 4] & 0xFF) << 24) + ((dataBuffer[1 + i * 4] & 0xFF) << 16) + ((dataBuffer[2 + i * 4] & 0xFF) << 8) + ((dataBuffer[3 + i * 4] & 0xFF) << 0)) / 10.0);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public String[] crossCheckMeasurements(String[] fileRecordsProperties, RecordSet recordSet) {
        return recordSet.getRecordNames();
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double offset = record.getOffset();
                double factor = record.getFactor();
                Record.DataType dataType = record.getDataType();
                dataTableRow[index + 1] = dataType == Record.DataType.GPS_LATITUDE || dataType == Record.DataType.GPS_LONGITUDE ? String.format("%09.6f", (double)record.realGet(rowIndex).intValue() * factor) : record.getDecimalFormat().format(offset + (double)record.realGet(rowIndex).intValue() / 1000.0 * factor);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        double offset = record.getOffset();
        double factor = record.getFactor();
        Record.DataType dataType = record.getDataType();
        double newValue = dataType == Record.DataType.GPS_LATITUDE || dataType == Record.DataType.GPS_LONGITUDE ? 1000.0 * value * factor + offset : value * factor + offset;
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        double offset = record.getOffset();
        double factor = record.getFactor();
        Record.DataType dataType = record.getDataType();
        double newValue = dataType == Record.DataType.GPS_LATITUDE || dataType == Record.DataType.GPS_LONGITUDE ? 1000.0 * value / factor - offset : value / factor - offset;
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        Record record;
        int i;
        recordSet.setAllDisplayable();
        for (i = 0; i < recordSet.realSize(); ++i) {
            record = recordSet.get(i);
            record.setDisplayable(record.hasReasonableData());
            if (!log.isLoggable(Level.FINER)) continue;
            log.log(Level.FINER, record.getName() + " setDisplayable=" + record.hasReasonableData());
        }
        if (log.isLoggable(Level.FINE)) {
            for (i = 0; i < recordSet.size(); ++i) {
                record = recordSet.get(i);
                log.log(Level.FINE, record.getName() + " isActive=" + record.isActive() + " isVisible=" + record.isVisible() + " isDisplayable=" + record.isDisplayable());
            }
        }
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        if (recordSet.isRaw()) {
            try {
                int displayableCounter = 0;
                for (String measurementKey : recordSet.keySet()) {
                    Record record = recordSet.get((Object)measurementKey);
                    if (!record.isActive() || record.getOrdinal() > 6 && !record.hasReasonableData()) continue;
                    ++displayableCounter;
                }
                log.log(Level.FINE, "displayableCounter = " + displayableCounter);
                recordSet.setConfiguredDisplayable(displayableCounter);
                if (recordSet.getName().equals(this.channels.getActiveChannel().getActiveRecordSet().getName())) {
                    this.application.updateGraphicsWindow();
                }
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, Record.DataType.GPS_LATITUDE.value(), Record.DataType.GPS_LONGITUDE.value(), Record.DataType.GPS_ALTITUDE.value(), Record.DataType.GPS_AZIMUTH.value(), Record.DataType.GPS_SPEED.value(), "statistics"};
    }

    public boolean isVariableMeasurementSize() {
        return true;
    }

    public String[] getNoneCalculationMeasurementNames(int channelConfigNumber, String[] validMeasurementNames) {
        return validMeasurementNames;
    }

    public void open_closeCommPort() {
        this.importDeviceData();
    }

    protected void importDeviceData() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT3700"), (String)"LogData");
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    WeatronicAdapter.this.application.setPortConnected(true);
                    for (String tmpFileName : fd.getFileNames()) {
                        Object selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        if (!((String)selectedImportFile).toLowerCase().endsWith(".log")) {
                            if (((String)selectedImportFile).contains(".")) {
                                selectedImportFile = ((String)selectedImportFile).substring(0, ((String)selectedImportFile).indexOf(46));
                            }
                            selectedImportFile = (String)selectedImportFile + ".log";
                        }
                        log.log(Level.FINE, "selectedImportFile = " + (String)selectedImportFile);
                        if (fd.getFileName().length() <= 4) continue;
                        Integer channelConfigNumber = WeatronicAdapter.this.application.getActiveChannelNumber();
                        channelConfigNumber = channelConfigNumber == null ? 1 : channelConfigNumber;
                        try {
                            LogReader.read((String)selectedImportFile, channelConfigNumber);
                            WaitTimer.delay((long)500L);
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    WeatronicAdapter.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    public boolean isActualRecordSetWithGpsData() {
        boolean containsGPSdata = false;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null) {
            RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
            int latOrdinal = -1;
            int longOrdinal = -1;
            if (activeRecordSet != null) {
                block4: for (int i = 0; i < activeRecordSet.size(); ++i) {
                    Record record = activeRecordSet.get(i);
                    Record.DataType datatype = record.getDataType();
                    switch (datatype) {
                        case GPS_LATITUDE: {
                            if (!record.getName().startsWith("Rx")) continue block4;
                            latOrdinal = record.getOrdinal();
                            continue block4;
                        }
                        case GPS_LONGITUDE: {
                            if (!record.getName().startsWith("Rx")) continue block4;
                            longOrdinal = record.getOrdinal();
                            continue block4;
                        }
                    }
                }
                if (latOrdinal != -1 && longOrdinal != -1) {
                    containsGPSdata = activeRecordSet.get(latOrdinal).hasReasonableData() && activeRecordSet.get(longOrdinal).hasReasonableData();
                }
            }
        }
        return containsGPSdata;
    }

    public boolean isGPSCoordinates(Record record) {
        return (record.getDataType() == Record.DataType.GPS_LATITUDE || record.getDataType() == Record.DataType.GPS_LONGITUDE) && record.getName().startsWith("Rx");
    }

    public Integer getGPS2KMZMeasurementOrdinal() {
        RecordSet activeRecordSet;
        Channel activeChannel = this.channels.getActiveChannel();
        if (this.kmzMeasurementOrdinal == null && activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
            block3: for (int i = 0; i < activeRecordSet.size(); ++i) {
                Record record = activeRecordSet.get(i);
                Record.DataType datatype = record.getDataType();
                switch (datatype) {
                    case GPS_SPEED: {
                        if (!record.getName().startsWith("Rx")) continue block3;
                        return record.getOrdinal();
                    }
                }
            }
        }
        return this.kmzMeasurementOrdinal != null ? this.kmzMeasurementOrdinal : -1;
    }

    public void export2KMZ3D(int type) {
        RecordSet activeRecordSet;
        int latOrdinal = -1;
        int longOrdinal = -1;
        int altOrdinal = -1;
        int climbOrdinal = -1;
        int speedOrdinal = -1;
        int tripOrdinal = -1;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
            block6: for (int i = 0; i < activeRecordSet.size(); ++i) {
                Record record = activeRecordSet.get(i);
                Record.DataType datatype = record.getDataType();
                switch (datatype) {
                    case GPS_LATITUDE: {
                        if (!record.getName().startsWith("Rx")) continue block6;
                        latOrdinal = record.getOrdinal();
                        continue block6;
                    }
                    case GPS_LONGITUDE: {
                        if (!record.getName().startsWith("Rx")) continue block6;
                        longOrdinal = record.getOrdinal();
                        continue block6;
                    }
                    case GPS_ALTITUDE: {
                        if (!record.getName().startsWith("Rx")) continue block6;
                        altOrdinal = record.getOrdinal();
                        continue block6;
                    }
                    case GPS_SPEED: {
                        if (!record.getName().startsWith("Rx")) continue block6;
                        speedOrdinal = record.getOrdinal();
                        continue block6;
                    }
                }
            }
        }
        new FileHandler().exportFileKMZ(Messages.getString((String)"GDE_MSGT3703"), longOrdinal, latOrdinal, altOrdinal, speedOrdinal, climbOrdinal, tripOrdinal, -1, type == 0, type == 2);
    }

    public String exportFile(String fileEndingType, boolean isExport2TmpDir) {
        String exportFileName = "";
        int latOrdinal = -1;
        int longOrdinal = -1;
        int altOrdinal = -1;
        int climbOrdinal = -1;
        int tripOrdinal = -1;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null) {
            int additionalMeasurementOrdinal = this.getGPS2KMZMeasurementOrdinal();
            RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
            if (activeRecordSet != null && fileEndingType.contains("kmz")) {
                block5: for (int i = 0; i < activeRecordSet.size(); ++i) {
                    Record record = activeRecordSet.get(i);
                    Record.DataType datatype = record.getDataType();
                    switch (datatype) {
                        case GPS_LATITUDE: {
                            if (!record.getName().startsWith("Rx")) continue block5;
                            latOrdinal = record.getOrdinal();
                            continue block5;
                        }
                        case GPS_LONGITUDE: {
                            if (!record.getName().startsWith("Rx")) continue block5;
                            longOrdinal = record.getOrdinal();
                            continue block5;
                        }
                        case GPS_ALTITUDE: {
                            if (!record.getName().startsWith("Rx")) continue block5;
                            altOrdinal = record.getOrdinal();
                            continue block5;
                        }
                    }
                }
                exportFileName = new FileHandler().exportFileKMZ(longOrdinal, latOrdinal, altOrdinal, additionalMeasurementOrdinal, climbOrdinal, tripOrdinal, -1, true, isExport2TmpDir);
            }
        }
        return exportFileName;
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return null;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return null;
    }

    public int getLovDataByteSize() {
        return 0;
    }

    public void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
    }
}

