/*
 * Decompiled with CFR 0.152.
 */
package gde.device.powerbox;

import java.nio.charset.Charset;
import java.util.TreeSet;
import java.util.logging.Logger;

public class TelemetryData {
    static Logger log = Logger.getLogger(TelemetryData.class.getName());
    static final Charset WINDOWS_1250 = Charset.forName("Windows-1250");
    static final Charset UTF_8 = Charset.forName("UTF-8");
    static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final int T_DATA8 = 0;
    public static final int T_DATA16 = 1;
    public static final int T_DATA24 = 4;
    public static final int T_TIME = 5;
    public static final int T_DATA32 = 8;
    public static final int T_GPS = 9;
    public static final int T_DATA37 = 12;
    public static final int T_EVENT = 16;
    long startTimeStamp = 0L;

    public static class TelemetryVar
    implements Comparable<TelemetryVar> {
        int param;
        String name;
        String unit;
        int decimals;
        int dataType = 1;

        TelemetryVar(int _param, String _name, String _unit, int _decimals) {
            this.param = _param;
            this.name = _name;
            this.unit = _unit;
            this.decimals = _decimals;
        }

        public TelemetryVar(TelemetryVar e) {
            this.param = e.param;
            this.name = e.name;
            this.unit = e.unit;
            this.decimals = e.decimals;
            this.dataType = e.dataType;
        }

        public void setDataType(int _dataType) {
            this.dataType = _dataType;
        }

        public int getDataType() {
            return this.dataType;
        }

        public String getUnit() {
            return this.unit.trim();
        }

        public String getName() {
            return this.name.trim();
        }

        public void setName(String newRecordName) {
            this.name = newRecordName.trim();
        }

        public String toString() {
            return this.name + " \t[" + this.unit + "]";
        }

        public synchronized int getParam() {
            return this.param;
        }

        @Override
        public int compareTo(TelemetryVar o) {
            return this.param - o.param;
        }
    }

    public static class TelemetrySensor
    implements Comparable<TelemetrySensor> {
        long id;
        String name;
        TreeSet<TelemetryVar> variables = new TreeSet();

        public String getName() {
            return this.name;
        }

        public long getId() {
            return this.id;
        }

        public TelemetrySensor(long _id, String _name) {
            this.id = _id;
            this.name = _name;
        }

        public void addVariable(TelemetryVar v) {
            this.variables.add(new TelemetryVar(v));
        }

        public TreeSet<TelemetryVar> getVariables() {
            return this.variables;
        }

        public TelemetryVar getVar(int param) {
            for (TelemetryVar v : this.variables) {
                if (v.param != param) continue;
                return v;
            }
            return null;
        }

        @Override
        public int compareTo(TelemetrySensor o) {
            if (this.id > o.id) {
                return 1;
            }
            if (this.id == o.id) {
                return 0;
            }
            return -1;
        }
    }
}

